/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          GNU C Compiler - CodeSourcery Sourcery G++
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.8, 2015-02-19
**     Build:               b150612
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2015 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**     - rev. 2.6 (2014-08-28)
**         Update of system files - default clock configuration changed.
**         Update of startup files - possibility to override DefaultISR added.
**     - rev. 2.7 (2014-10-14)
**         Interrupt INT_LPTimer renamed to INT_LPTMR0, interrupt INT_Watchdog renamed to INT_WDOG_EWM.
**     - rev. 2.8 (2015-02-19)
**         Renamed interrupt vector LLW to LLWU.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __MK64F12_EXTENSION_H__
#define __MK64F12_EXTENSION_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

#if defined(__IAR_SYSTEMS_ICC__)
  /*
   * Suppress "Error[Pm008]: sections of code should not be 'commented out' (MISRA C 2004 rule 2.4)"
   * as some register descriptions contain code examples
   */
  #pragma diag_suppress=pm008
#endif

/*
 * MK64F12 ADC
 *
 * Analog-to-Digital Converter
 *
 * Registers defined in this header file:
 * - ADC_SC1 - ADC Status and Control Registers 1
 * - ADC_CFG1 - ADC Configuration Register 1
 * - ADC_CFG2 - ADC Configuration Register 2
 * - ADC_R - ADC Data Result Register
 * - ADC_CV1 - Compare Value Registers
 * - ADC_CV2 - Compare Value Registers
 * - ADC_SC2 - Status and Control Register 2
 * - ADC_SC3 - Status and Control Register 3
 * - ADC_OFS - ADC Offset Correction Register
 * - ADC_PG - ADC Plus-Side Gain Register
 * - ADC_MG - ADC Minus-Side Gain Register
 * - ADC_CLPD - ADC Plus-Side General Calibration Value Register
 * - ADC_CLPS - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP4 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP3 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP2 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP1 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLP0 - ADC Plus-Side General Calibration Value Register
 * - ADC_CLMD - ADC Minus-Side General Calibration Value Register
 * - ADC_CLMS - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM4 - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM3 - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM2 - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM1 - ADC Minus-Side General Calibration Value Register
 * - ADC_CLM0 - ADC Minus-Side General Calibration Value Register
 */

#define ADC_INSTANCE_COUNT (2U) /*!< Number of instances of the ADC module. */
#define ADC0_IDX (0U) /*!< Instance number for ADC0. */
#define ADC1_IDX (1U) /*!< Instance number for ADC1. */

/*******************************************************************************
 * ADC_SC1 - ADC Status and Control Registers 1
 ******************************************************************************/

/*!
 * @brief ADC_SC1 - ADC Status and Control Registers 1 (RW)
 *
 * Reset value: 0x0000001FU
 *
 * SC1A is used for both software and hardware trigger modes of operation. To
 * allow sequential conversions of the ADC to be triggered by internal peripherals,
 * the ADC can have more than one status and control register: one for each
 * conversion. The SC1B-SC1n registers indicate potentially multiple SC1 registers
 * for use only in hardware trigger mode. See the chip configuration information
 * about the number of SC1n registers specific to this device. The SC1n registers
 * have identical fields, and are used in a "ping-pong" approach to control ADC
 * operation. At any one point in time, only one of the SC1n registers is actively
 * controlling ADC conversions. Updating SC1A while SC1n is actively controlling
 * a conversion is allowed, and vice-versa for any of the SC1n registers specific
 * to this MCU. Writing SC1A while SC1A is actively controlling a conversion
 * aborts the current conversion. In Software Trigger mode, when SC2[ADTRG]=0,
 * writes to SC1A subsequently initiate a new conversion, if SC1[ADCH] contains a
 * value other than all 1s. Writing any of the SC1n registers while that specific
 * SC1n register is actively controlling a conversion aborts the current conversion.
 * None of the SC1B-SC1n registers are used for software trigger operation and
 * therefore writes to the SC1B-SC1n registers do not initiate a new conversion.
 */
/*!
 * @name Constants and macros for entire ADC_SC1 register
 */
/*@{*/
#define ADC_RD_SC1(base, index)  (ADC_SC1_REG(base, index))
#define ADC_WR_SC1(base, index, value) (ADC_SC1_REG(base, index) = (value))
#define ADC_RMW_SC1(base, index, mask, value) (ADC_WR_SC1(base, index, (ADC_RD_SC1(base, index) & ~(mask)) | (value)))
#define ADC_SET_SC1(base, index, value) (ADC_WR_SC1(base, index, ADC_RD_SC1(base, index) |  (value)))
#define ADC_CLR_SC1(base, index, value) (ADC_WR_SC1(base, index, ADC_RD_SC1(base, index) & ~(value)))
#define ADC_TOG_SC1(base, index, value) (ADC_WR_SC1(base, index, ADC_RD_SC1(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_SC1 bitfields
 */

/*!
 * @name Register ADC_SC1, field ADCH[4:0] (RW)
 *
 * Selects one of the input channels. The input channel decode depends on the
 * value of DIFF. DAD0-DAD3 are associated with the input pin pairs DADPx and
 * DADMx. Some of the input channel options in the bitfield-setting descriptions might
 * not be available for your device. For the actual ADC channel assignments for
 * your device, see the Chip Configuration details. The successive approximation
 * converter subsystem is turned off when the channel select bits are all set,
 * that is, ADCH = 11111. This feature allows explicit disabling of the ADC and
 * isolation of the input channel from all sources. Terminating continuous
 * conversions this way prevents an additional single conversion from being performed. It
 * is not necessary to set ADCH to all 1s to place the ADC in a low-power state
 * when continuous conversions are not enabled because the module automatically
 * enters a low-power state when a conversion completes.
 *
 * Values:
 * - 0b00000 - When DIFF=0, DADP0 is selected as input; when DIFF=1, DAD0 is
 *     selected as input.
 * - 0b00001 - When DIFF=0, DADP1 is selected as input; when DIFF=1, DAD1 is
 *     selected as input.
 * - 0b00010 - When DIFF=0, DADP2 is selected as input; when DIFF=1, DAD2 is
 *     selected as input.
 * - 0b00011 - When DIFF=0, DADP3 is selected as input; when DIFF=1, DAD3 is
 *     selected as input.
 * - 0b00100 - When DIFF=0, AD4 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b00101 - When DIFF=0, AD5 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b00110 - When DIFF=0, AD6 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b00111 - When DIFF=0, AD7 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b01000 - When DIFF=0, AD8 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b01001 - When DIFF=0, AD9 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b01010 - When DIFF=0, AD10 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b01011 - When DIFF=0, AD11 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b01100 - When DIFF=0, AD12 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b01101 - When DIFF=0, AD13 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b01110 - When DIFF=0, AD14 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b01111 - When DIFF=0, AD15 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b10000 - When DIFF=0, AD16 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b10001 - When DIFF=0, AD17 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b10010 - When DIFF=0, AD18 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b10011 - When DIFF=0, AD19 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b10100 - When DIFF=0, AD20 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b10101 - When DIFF=0, AD21 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b10110 - When DIFF=0, AD22 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b10111 - When DIFF=0, AD23 is selected as input; when DIFF=1, it is
 *     reserved.
 * - 0b11000 - Reserved.
 * - 0b11001 - Reserved.
 * - 0b11010 - When DIFF=0, Temp Sensor (single-ended) is selected as input;
 *     when DIFF=1, Temp Sensor (differential) is selected as input.
 * - 0b11011 - When DIFF=0, Bandgap (single-ended) is selected as input; when
 *     DIFF=1, Bandgap (differential) is selected as input.
 * - 0b11100 - Reserved.
 * - 0b11101 - When DIFF=0,VREFSH is selected as input; when DIFF=1, -VREFSH
 *     (differential) is selected as input. Voltage reference selected is determined
 *     by SC2[REFSEL].
 * - 0b11110 - When DIFF=0,VREFSL is selected as input; when DIFF=1, it is
 *     reserved. Voltage reference selected is determined by SC2[REFSEL].
 * - 0b11111 - Module is disabled.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC1_ADCH field. */
#define ADC_RD_SC1_ADCH(base, index) ((ADC_SC1_REG(base, index) & ADC_SC1_ADCH_MASK) >> ADC_SC1_ADCH_SHIFT)
#define ADC_BRD_SC1_ADCH(base, index) (ADC_RD_SC1_ADCH(base, index))

/*! @brief Set the ADCH field to a new value. */
#define ADC_WR_SC1_ADCH(base, index, value) (ADC_RMW_SC1(base, index, ADC_SC1_ADCH_MASK, ADC_SC1_ADCH(value)))
#define ADC_BWR_SC1_ADCH(base, index, value) (ADC_WR_SC1_ADCH(base, index, value))
/*@}*/

/*!
 * @name Register ADC_SC1, field DIFF[5] (RW)
 *
 * Configures the ADC to operate in differential mode. When enabled, this mode
 * automatically selects from the differential channels, and changes the
 * conversion algorithm and the number of cycles to complete a conversion.
 *
 * Values:
 * - 0b0 - Single-ended conversions and input channels are selected.
 * - 0b1 - Differential conversions and input channels are selected.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC1_DIFF field. */
#define ADC_RD_SC1_DIFF(base, index) ((ADC_SC1_REG(base, index) & ADC_SC1_DIFF_MASK) >> ADC_SC1_DIFF_SHIFT)
#define ADC_BRD_SC1_DIFF(base, index) (BITBAND_ACCESS32(&ADC_SC1_REG(base, index), ADC_SC1_DIFF_SHIFT))

/*! @brief Set the DIFF field to a new value. */
#define ADC_WR_SC1_DIFF(base, index, value) (ADC_RMW_SC1(base, index, ADC_SC1_DIFF_MASK, ADC_SC1_DIFF(value)))
#define ADC_BWR_SC1_DIFF(base, index, value) (BITBAND_ACCESS32(&ADC_SC1_REG(base, index), ADC_SC1_DIFF_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC1, field AIEN[6] (RW)
 *
 * Enables conversion complete interrupts. When COCO becomes set while the
 * respective AIEN is high, an interrupt is asserted.
 *
 * Values:
 * - 0b0 - Conversion complete interrupt is disabled.
 * - 0b1 - Conversion complete interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC1_AIEN field. */
#define ADC_RD_SC1_AIEN(base, index) ((ADC_SC1_REG(base, index) & ADC_SC1_AIEN_MASK) >> ADC_SC1_AIEN_SHIFT)
#define ADC_BRD_SC1_AIEN(base, index) (BITBAND_ACCESS32(&ADC_SC1_REG(base, index), ADC_SC1_AIEN_SHIFT))

/*! @brief Set the AIEN field to a new value. */
#define ADC_WR_SC1_AIEN(base, index, value) (ADC_RMW_SC1(base, index, ADC_SC1_AIEN_MASK, ADC_SC1_AIEN(value)))
#define ADC_BWR_SC1_AIEN(base, index, value) (BITBAND_ACCESS32(&ADC_SC1_REG(base, index), ADC_SC1_AIEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC1, field COCO[7] (RO)
 *
 * This is a read-only field that is set each time a conversion is completed
 * when the compare function is disabled, or SC2[ACFE]=0 and the hardware average
 * function is disabled, or SC3[AVGE]=0. When the compare function is enabled, or
 * SC2[ACFE]=1, COCO is set upon completion of a conversion only if the compare
 * result is true. When the hardware average function is enabled, or SC3[AVGE]=1,
 * COCO is set upon completion of the selected number of conversions (determined
 * by AVGS). COCO in SC1A is also set at the completion of a calibration sequence.
 * COCO is cleared when the respective SC1n register is written or when the
 * respective Rn register is read.
 *
 * Values:
 * - 0b0 - Conversion is not completed.
 * - 0b1 - Conversion is completed.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC1_COCO field. */
#define ADC_RD_SC1_COCO(base, index) ((ADC_SC1_REG(base, index) & ADC_SC1_COCO_MASK) >> ADC_SC1_COCO_SHIFT)
#define ADC_BRD_SC1_COCO(base, index) (BITBAND_ACCESS32(&ADC_SC1_REG(base, index), ADC_SC1_COCO_SHIFT))
/*@}*/

/*******************************************************************************
 * ADC_CFG1 - ADC Configuration Register 1
 ******************************************************************************/

/*!
 * @brief ADC_CFG1 - ADC Configuration Register 1 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The configuration Register 1 (CFG1) selects the mode of operation, clock
 * source, clock divide, and configuration for low power or long sample time.
 */
/*!
 * @name Constants and macros for entire ADC_CFG1 register
 */
/*@{*/
#define ADC_RD_CFG1(base)        (ADC_CFG1_REG(base))
#define ADC_WR_CFG1(base, value) (ADC_CFG1_REG(base) = (value))
#define ADC_RMW_CFG1(base, mask, value) (ADC_WR_CFG1(base, (ADC_RD_CFG1(base) & ~(mask)) | (value)))
#define ADC_SET_CFG1(base, value) (ADC_WR_CFG1(base, ADC_RD_CFG1(base) |  (value)))
#define ADC_CLR_CFG1(base, value) (ADC_WR_CFG1(base, ADC_RD_CFG1(base) & ~(value)))
#define ADC_TOG_CFG1(base, value) (ADC_WR_CFG1(base, ADC_RD_CFG1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CFG1 bitfields
 */

/*!
 * @name Register ADC_CFG1, field ADICLK[1:0] (RW)
 *
 * Selects the input clock source to generate the internal clock, ADCK. Note
 * that when the ADACK clock source is selected, it is not required to be active
 * prior to conversion start. When it is selected and it is not active prior to a
 * conversion start, when CFG2[ADACKEN]=0, the asynchronous clock is activated at
 * the start of a conversion and deactivated when conversions are terminated. In
 * this case, there is an associated clock startup delay each time the clock
 * source is re-activated.
 *
 * Values:
 * - 0b00 - Bus clock
 * - 0b01 - Alternate clock 2 (ALTCLK2)
 * - 0b10 - Alternate clock (ALTCLK)
 * - 0b11 - Asynchronous clock (ADACK)
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_ADICLK field. */
#define ADC_RD_CFG1_ADICLK(base) ((ADC_CFG1_REG(base) & ADC_CFG1_ADICLK_MASK) >> ADC_CFG1_ADICLK_SHIFT)
#define ADC_BRD_CFG1_ADICLK(base) (ADC_RD_CFG1_ADICLK(base))

/*! @brief Set the ADICLK field to a new value. */
#define ADC_WR_CFG1_ADICLK(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_ADICLK_MASK, ADC_CFG1_ADICLK(value)))
#define ADC_BWR_CFG1_ADICLK(base, value) (ADC_WR_CFG1_ADICLK(base, value))
/*@}*/

/*!
 * @name Register ADC_CFG1, field MODE[3:2] (RW)
 *
 * Selects the ADC resolution mode.
 *
 * Values:
 * - 0b00 - When DIFF=0:It is single-ended 8-bit conversion; when DIFF=1, it is
 *     differential 9-bit conversion with 2's complement output.
 * - 0b01 - When DIFF=0:It is single-ended 12-bit conversion ; when DIFF=1, it
 *     is differential 13-bit conversion with 2's complement output.
 * - 0b10 - When DIFF=0:It is single-ended 10-bit conversion. ; when DIFF=1, it
 *     is differential 11-bit conversion with 2's complement output
 * - 0b11 - When DIFF=0:It is single-ended 16-bit conversion..; when DIFF=1, it
 *     is differential 16-bit conversion with 2's complement output
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_MODE field. */
#define ADC_RD_CFG1_MODE(base) ((ADC_CFG1_REG(base) & ADC_CFG1_MODE_MASK) >> ADC_CFG1_MODE_SHIFT)
#define ADC_BRD_CFG1_MODE(base) (ADC_RD_CFG1_MODE(base))

/*! @brief Set the MODE field to a new value. */
#define ADC_WR_CFG1_MODE(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_MODE_MASK, ADC_CFG1_MODE(value)))
#define ADC_BWR_CFG1_MODE(base, value) (ADC_WR_CFG1_MODE(base, value))
/*@}*/

/*!
 * @name Register ADC_CFG1, field ADLSMP[4] (RW)
 *
 * Selects between different sample times based on the conversion mode selected.
 * This field adjusts the sample period to allow higher impedance inputs to be
 * accurately sampled or to maximize conversion speed for lower impedance inputs.
 * Longer sample times can also be used to lower overall power consumption if
 * continuous conversions are enabled and high conversion rates are not required.
 * When ADLSMP=1, the long sample time select bits, (ADLSTS[1:0]), can select the
 * extent of the long sample time.
 *
 * Values:
 * - 0b0 - Short sample time.
 * - 0b1 - Long sample time.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_ADLSMP field. */
#define ADC_RD_CFG1_ADLSMP(base) ((ADC_CFG1_REG(base) & ADC_CFG1_ADLSMP_MASK) >> ADC_CFG1_ADLSMP_SHIFT)
#define ADC_BRD_CFG1_ADLSMP(base) (BITBAND_ACCESS32(&ADC_CFG1_REG(base), ADC_CFG1_ADLSMP_SHIFT))

/*! @brief Set the ADLSMP field to a new value. */
#define ADC_WR_CFG1_ADLSMP(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_ADLSMP_MASK, ADC_CFG1_ADLSMP(value)))
#define ADC_BWR_CFG1_ADLSMP(base, value) (BITBAND_ACCESS32(&ADC_CFG1_REG(base), ADC_CFG1_ADLSMP_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_CFG1, field ADIV[6:5] (RW)
 *
 * Selects the divide ratio used by the ADC to generate the internal clock ADCK.
 *
 * Values:
 * - 0b00 - The divide ratio is 1 and the clock rate is input clock.
 * - 0b01 - The divide ratio is 2 and the clock rate is (input clock)/2.
 * - 0b10 - The divide ratio is 4 and the clock rate is (input clock)/4.
 * - 0b11 - The divide ratio is 8 and the clock rate is (input clock)/8.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_ADIV field. */
#define ADC_RD_CFG1_ADIV(base) ((ADC_CFG1_REG(base) & ADC_CFG1_ADIV_MASK) >> ADC_CFG1_ADIV_SHIFT)
#define ADC_BRD_CFG1_ADIV(base) (ADC_RD_CFG1_ADIV(base))

/*! @brief Set the ADIV field to a new value. */
#define ADC_WR_CFG1_ADIV(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_ADIV_MASK, ADC_CFG1_ADIV(value)))
#define ADC_BWR_CFG1_ADIV(base, value) (ADC_WR_CFG1_ADIV(base, value))
/*@}*/

/*!
 * @name Register ADC_CFG1, field ADLPC[7] (RW)
 *
 * Controls the power configuration of the successive approximation converter.
 * This optimizes power consumption when higher sample rates are not required.
 *
 * Values:
 * - 0b0 - Normal power configuration.
 * - 0b1 - Low-power configuration. The power is reduced at the expense of
 *     maximum clock speed.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG1_ADLPC field. */
#define ADC_RD_CFG1_ADLPC(base) ((ADC_CFG1_REG(base) & ADC_CFG1_ADLPC_MASK) >> ADC_CFG1_ADLPC_SHIFT)
#define ADC_BRD_CFG1_ADLPC(base) (BITBAND_ACCESS32(&ADC_CFG1_REG(base), ADC_CFG1_ADLPC_SHIFT))

/*! @brief Set the ADLPC field to a new value. */
#define ADC_WR_CFG1_ADLPC(base, value) (ADC_RMW_CFG1(base, ADC_CFG1_ADLPC_MASK, ADC_CFG1_ADLPC(value)))
#define ADC_BWR_CFG1_ADLPC(base, value) (BITBAND_ACCESS32(&ADC_CFG1_REG(base), ADC_CFG1_ADLPC_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * ADC_CFG2 - ADC Configuration Register 2
 ******************************************************************************/

/*!
 * @brief ADC_CFG2 - ADC Configuration Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * Configuration Register 2 (CFG2) selects the special high-speed configuration
 * for very high speed conversions and selects the long sample time duration
 * during long sample mode.
 */
/*!
 * @name Constants and macros for entire ADC_CFG2 register
 */
/*@{*/
#define ADC_RD_CFG2(base)        (ADC_CFG2_REG(base))
#define ADC_WR_CFG2(base, value) (ADC_CFG2_REG(base) = (value))
#define ADC_RMW_CFG2(base, mask, value) (ADC_WR_CFG2(base, (ADC_RD_CFG2(base) & ~(mask)) | (value)))
#define ADC_SET_CFG2(base, value) (ADC_WR_CFG2(base, ADC_RD_CFG2(base) |  (value)))
#define ADC_CLR_CFG2(base, value) (ADC_WR_CFG2(base, ADC_RD_CFG2(base) & ~(value)))
#define ADC_TOG_CFG2(base, value) (ADC_WR_CFG2(base, ADC_RD_CFG2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CFG2 bitfields
 */

/*!
 * @name Register ADC_CFG2, field ADLSTS[1:0] (RW)
 *
 * Selects between the extended sample times when long sample time is selected,
 * that is, when CFG1[ADLSMP]=1. This allows higher impedance inputs to be
 * accurately sampled or to maximize conversion speed for lower impedance inputs.
 * Longer sample times can also be used to lower overall power consumption when
 * continuous conversions are enabled if high conversion rates are not required.
 *
 * Values:
 * - 0b00 - Default longest sample time; 20 extra ADCK cycles; 24 ADCK cycles
 *     total.
 * - 0b01 - 12 extra ADCK cycles; 16 ADCK cycles total sample time.
 * - 0b10 - 6 extra ADCK cycles; 10 ADCK cycles total sample time.
 * - 0b11 - 2 extra ADCK cycles; 6 ADCK cycles total sample time.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG2_ADLSTS field. */
#define ADC_RD_CFG2_ADLSTS(base) ((ADC_CFG2_REG(base) & ADC_CFG2_ADLSTS_MASK) >> ADC_CFG2_ADLSTS_SHIFT)
#define ADC_BRD_CFG2_ADLSTS(base) (ADC_RD_CFG2_ADLSTS(base))

/*! @brief Set the ADLSTS field to a new value. */
#define ADC_WR_CFG2_ADLSTS(base, value) (ADC_RMW_CFG2(base, ADC_CFG2_ADLSTS_MASK, ADC_CFG2_ADLSTS(value)))
#define ADC_BWR_CFG2_ADLSTS(base, value) (ADC_WR_CFG2_ADLSTS(base, value))
/*@}*/

/*!
 * @name Register ADC_CFG2, field ADHSC[2] (RW)
 *
 * Configures the ADC for very high-speed operation. The conversion sequence is
 * altered with 2 ADCK cycles added to the conversion time to allow higher speed
 * conversion clocks.
 *
 * Values:
 * - 0b0 - Normal conversion sequence selected.
 * - 0b1 - High-speed conversion sequence selected with 2 additional ADCK cycles
 *     to total conversion time.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG2_ADHSC field. */
#define ADC_RD_CFG2_ADHSC(base) ((ADC_CFG2_REG(base) & ADC_CFG2_ADHSC_MASK) >> ADC_CFG2_ADHSC_SHIFT)
#define ADC_BRD_CFG2_ADHSC(base) (BITBAND_ACCESS32(&ADC_CFG2_REG(base), ADC_CFG2_ADHSC_SHIFT))

/*! @brief Set the ADHSC field to a new value. */
#define ADC_WR_CFG2_ADHSC(base, value) (ADC_RMW_CFG2(base, ADC_CFG2_ADHSC_MASK, ADC_CFG2_ADHSC(value)))
#define ADC_BWR_CFG2_ADHSC(base, value) (BITBAND_ACCESS32(&ADC_CFG2_REG(base), ADC_CFG2_ADHSC_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_CFG2, field ADACKEN[3] (RW)
 *
 * Enables the asynchronous clock source and the clock source output regardless
 * of the conversion and status of CFG1[ADICLK]. Based on MCU configuration, the
 * asynchronous clock may be used by other modules. See chip configuration
 * information. Setting this field allows the clock to be used even while the ADC is
 * idle or operating from a different clock source. Also, latency of initiating a
 * single or first-continuous conversion with the asynchronous clock selected is
 * reduced because the ADACK clock is already operational.
 *
 * Values:
 * - 0b0 - Asynchronous clock output disabled; Asynchronous clock is enabled
 *     only if selected by ADICLK and a conversion is active.
 * - 0b1 - Asynchronous clock and clock output is enabled regardless of the
 *     state of the ADC.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG2_ADACKEN field. */
#define ADC_RD_CFG2_ADACKEN(base) ((ADC_CFG2_REG(base) & ADC_CFG2_ADACKEN_MASK) >> ADC_CFG2_ADACKEN_SHIFT)
#define ADC_BRD_CFG2_ADACKEN(base) (BITBAND_ACCESS32(&ADC_CFG2_REG(base), ADC_CFG2_ADACKEN_SHIFT))

/*! @brief Set the ADACKEN field to a new value. */
#define ADC_WR_CFG2_ADACKEN(base, value) (ADC_RMW_CFG2(base, ADC_CFG2_ADACKEN_MASK, ADC_CFG2_ADACKEN(value)))
#define ADC_BWR_CFG2_ADACKEN(base, value) (BITBAND_ACCESS32(&ADC_CFG2_REG(base), ADC_CFG2_ADACKEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_CFG2, field MUXSEL[4] (RW)
 *
 * Changes the ADC mux setting to select between alternate sets of ADC channels.
 *
 * Values:
 * - 0b0 - ADxxa channels are selected.
 * - 0b1 - ADxxb channels are selected.
 */
/*@{*/
/*! @brief Read current value of the ADC_CFG2_MUXSEL field. */
#define ADC_RD_CFG2_MUXSEL(base) ((ADC_CFG2_REG(base) & ADC_CFG2_MUXSEL_MASK) >> ADC_CFG2_MUXSEL_SHIFT)
#define ADC_BRD_CFG2_MUXSEL(base) (BITBAND_ACCESS32(&ADC_CFG2_REG(base), ADC_CFG2_MUXSEL_SHIFT))

/*! @brief Set the MUXSEL field to a new value. */
#define ADC_WR_CFG2_MUXSEL(base, value) (ADC_RMW_CFG2(base, ADC_CFG2_MUXSEL_MASK, ADC_CFG2_MUXSEL(value)))
#define ADC_BWR_CFG2_MUXSEL(base, value) (BITBAND_ACCESS32(&ADC_CFG2_REG(base), ADC_CFG2_MUXSEL_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * ADC_R - ADC Data Result Register
 ******************************************************************************/

/*!
 * @brief ADC_R - ADC Data Result Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The data result registers (Rn) contain the result of an ADC conversion of the
 * channel selected by the corresponding status and channel control register
 * (SC1A:SC1n). For every status and channel control register, there is a
 * corresponding data result register. Unused bits in R n are cleared in unsigned
 * right-aligned modes and carry the sign bit (MSB) in sign-extended 2's complement modes.
 * For example, when configured for 10-bit single-ended mode, D[15:10] are
 * cleared. When configured for 11-bit differential mode, D[15:10] carry the sign bit,
 * that is, bit 10 extended through bit 15. The following table describes the
 * behavior of the data result registers in the different modes of operation. Data
 * result register description Conversion mode D15 D14 D13 D12 D11 D10 D9 D8 D7
 * D6 D5 D4 D3 D2 D1 D0 Format 16-bit differential S D D D D D D D D D D D D D D D
 * Signed 2's complement 16-bit single-ended D D D D D D D D D D D D D D D D
 * Unsigned right justified 13-bit differential S S S S D D D D D D D D D D D D
 * Sign-extended 2's complement 12-bit single-ended 0 0 0 0 D D D D D D D D D D D D
 * Unsigned right-justified 11-bit differential S S S S S S D D D D D D D D D D
 * Sign-extended 2's complement 10-bit single-ended 0 0 0 0 0 0 D D D D D D D D D D
 * Unsigned right-justified 9-bit differential S S S S S S S S D D D D D D D D
 * Sign-extended 2's complement 8-bit single-ended 0 0 0 0 0 0 0 0 D D D D D D D D
 * Unsigned right-justified S: Sign bit or sign bit extension; D: Data, which is
 * 2's complement data if indicated
 */
/*!
 * @name Constants and macros for entire ADC_R register
 */
/*@{*/
#define ADC_RD_R(base, index)    (ADC_R_REG(base, index))
/*@}*/

/*
 * Constants & macros for individual ADC_R bitfields
 */

/*!
 * @name Register ADC_R, field D[15:0] (RO)
 */
/*@{*/
/*! @brief Read current value of the ADC_R_D field. */
#define ADC_RD_R_D(base, index) ((ADC_R_REG(base, index) & ADC_R_D_MASK) >> ADC_R_D_SHIFT)
#define ADC_BRD_R_D(base, index) (ADC_RD_R_D(base, index))
/*@}*/

/*******************************************************************************
 * ADC_CV1 - Compare Value Registers
 ******************************************************************************/

/*!
 * @brief ADC_CV1 - Compare Value Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Compare Value Registers (CV1 and CV2) contain a compare value used to
 * compare the conversion result when the compare function is enabled, that is,
 * SC2[ACFE]=1. This register is formatted in the same way as the Rn registers in
 * different modes of operation for both bit position definition and value format
 * using unsigned or sign-extended 2's complement. Therefore, the compare function
 * uses only the CVn fields that are related to the ADC mode of operation. The
 * compare value 2 register (CV2) is used only when the compare range function is
 * enabled, that is, SC2[ACREN]=1.
 */
/*!
 * @name Constants and macros for entire ADC_CV1 register
 */
/*@{*/
#define ADC_RD_CV1(base)         (ADC_CV1_REG(base))
#define ADC_WR_CV1(base, value)  (ADC_CV1_REG(base) = (value))
#define ADC_RMW_CV1(base, mask, value) (ADC_WR_CV1(base, (ADC_RD_CV1(base) & ~(mask)) | (value)))
#define ADC_SET_CV1(base, value) (ADC_WR_CV1(base, ADC_RD_CV1(base) |  (value)))
#define ADC_CLR_CV1(base, value) (ADC_WR_CV1(base, ADC_RD_CV1(base) & ~(value)))
#define ADC_TOG_CV1(base, value) (ADC_WR_CV1(base, ADC_RD_CV1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CV1 bitfields
 */

/*!
 * @name Register ADC_CV1, field CV[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_CV1_CV field. */
#define ADC_RD_CV1_CV(base)  ((ADC_CV1_REG(base) & ADC_CV1_CV_MASK) >> ADC_CV1_CV_SHIFT)
#define ADC_BRD_CV1_CV(base) (ADC_RD_CV1_CV(base))

/*! @brief Set the CV field to a new value. */
#define ADC_WR_CV1_CV(base, value) (ADC_RMW_CV1(base, ADC_CV1_CV_MASK, ADC_CV1_CV(value)))
#define ADC_BWR_CV1_CV(base, value) (ADC_WR_CV1_CV(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CV2 - Compare Value Registers
 ******************************************************************************/

/*!
 * @brief ADC_CV2 - Compare Value Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Compare Value Registers (CV1 and CV2) contain a compare value used to
 * compare the conversion result when the compare function is enabled, that is,
 * SC2[ACFE]=1. This register is formatted in the same way as the Rn registers in
 * different modes of operation for both bit position definition and value format
 * using unsigned or sign-extended 2's complement. Therefore, the compare function
 * uses only the CVn fields that are related to the ADC mode of operation. The
 * compare value 2 register (CV2) is used only when the compare range function is
 * enabled, that is, SC2[ACREN]=1.
 */
/*!
 * @name Constants and macros for entire ADC_CV2 register
 */
/*@{*/
#define ADC_RD_CV2(base)         (ADC_CV2_REG(base))
#define ADC_WR_CV2(base, value)  (ADC_CV2_REG(base) = (value))
#define ADC_RMW_CV2(base, mask, value) (ADC_WR_CV2(base, (ADC_RD_CV2(base) & ~(mask)) | (value)))
#define ADC_SET_CV2(base, value) (ADC_WR_CV2(base, ADC_RD_CV2(base) |  (value)))
#define ADC_CLR_CV2(base, value) (ADC_WR_CV2(base, ADC_RD_CV2(base) & ~(value)))
#define ADC_TOG_CV2(base, value) (ADC_WR_CV2(base, ADC_RD_CV2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CV2 bitfields
 */

/*!
 * @name Register ADC_CV2, field CV[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_CV2_CV field. */
#define ADC_RD_CV2_CV(base)  ((ADC_CV2_REG(base) & ADC_CV2_CV_MASK) >> ADC_CV2_CV_SHIFT)
#define ADC_BRD_CV2_CV(base) (ADC_RD_CV2_CV(base))

/*! @brief Set the CV field to a new value. */
#define ADC_WR_CV2_CV(base, value) (ADC_RMW_CV2(base, ADC_CV2_CV_MASK, ADC_CV2_CV(value)))
#define ADC_BWR_CV2_CV(base, value) (ADC_WR_CV2_CV(base, value))
/*@}*/

/*******************************************************************************
 * ADC_SC2 - Status and Control Register 2
 ******************************************************************************/

/*!
 * @brief ADC_SC2 - Status and Control Register 2 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The status and control register 2 (SC2) contains the conversion active,
 * hardware/software trigger select, compare function, and voltage reference select of
 * the ADC module.
 */
/*!
 * @name Constants and macros for entire ADC_SC2 register
 */
/*@{*/
#define ADC_RD_SC2(base)         (ADC_SC2_REG(base))
#define ADC_WR_SC2(base, value)  (ADC_SC2_REG(base) = (value))
#define ADC_RMW_SC2(base, mask, value) (ADC_WR_SC2(base, (ADC_RD_SC2(base) & ~(mask)) | (value)))
#define ADC_SET_SC2(base, value) (ADC_WR_SC2(base, ADC_RD_SC2(base) |  (value)))
#define ADC_CLR_SC2(base, value) (ADC_WR_SC2(base, ADC_RD_SC2(base) & ~(value)))
#define ADC_TOG_SC2(base, value) (ADC_WR_SC2(base, ADC_RD_SC2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_SC2 bitfields
 */

/*!
 * @name Register ADC_SC2, field REFSEL[1:0] (RW)
 *
 * Selects the voltage reference source used for conversions.
 *
 * Values:
 * - 0b00 - Default voltage reference pin pair, that is, external pins VREFH and
 *     VREFL
 * - 0b01 - Alternate reference pair, that is, VALTH and VALTL . This pair may
 *     be additional external pins or internal sources depending on the MCU
 *     configuration. See the chip configuration information for details specific to
 *     this MCU
 * - 0b10 - Reserved
 * - 0b11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_REFSEL field. */
#define ADC_RD_SC2_REFSEL(base) ((ADC_SC2_REG(base) & ADC_SC2_REFSEL_MASK) >> ADC_SC2_REFSEL_SHIFT)
#define ADC_BRD_SC2_REFSEL(base) (ADC_RD_SC2_REFSEL(base))

/*! @brief Set the REFSEL field to a new value. */
#define ADC_WR_SC2_REFSEL(base, value) (ADC_RMW_SC2(base, ADC_SC2_REFSEL_MASK, ADC_SC2_REFSEL(value)))
#define ADC_BWR_SC2_REFSEL(base, value) (ADC_WR_SC2_REFSEL(base, value))
/*@}*/

/*!
 * @name Register ADC_SC2, field DMAEN[2] (RW)
 *
 * Values:
 * - 0b0 - DMA is disabled.
 * - 0b1 - DMA is enabled and will assert the ADC DMA request during an ADC
 *     conversion complete event noted when any of the SC1n[COCO] flags is asserted.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_DMAEN field. */
#define ADC_RD_SC2_DMAEN(base) ((ADC_SC2_REG(base) & ADC_SC2_DMAEN_MASK) >> ADC_SC2_DMAEN_SHIFT)
#define ADC_BRD_SC2_DMAEN(base) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_DMAEN_SHIFT))

/*! @brief Set the DMAEN field to a new value. */
#define ADC_WR_SC2_DMAEN(base, value) (ADC_RMW_SC2(base, ADC_SC2_DMAEN_MASK, ADC_SC2_DMAEN(value)))
#define ADC_BWR_SC2_DMAEN(base, value) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_DMAEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC2, field ACREN[3] (RW)
 *
 * Configures the compare function to check if the conversion result of the
 * input being monitored is either between or outside the range formed by CV1 and CV2
 * determined by the value of ACFGT. ACFE must be set for ACFGT to have any
 * effect.
 *
 * Values:
 * - 0b0 - Range function disabled. Only CV1 is compared.
 * - 0b1 - Range function enabled. Both CV1 and CV2 are compared.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ACREN field. */
#define ADC_RD_SC2_ACREN(base) ((ADC_SC2_REG(base) & ADC_SC2_ACREN_MASK) >> ADC_SC2_ACREN_SHIFT)
#define ADC_BRD_SC2_ACREN(base) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ACREN_SHIFT))

/*! @brief Set the ACREN field to a new value. */
#define ADC_WR_SC2_ACREN(base, value) (ADC_RMW_SC2(base, ADC_SC2_ACREN_MASK, ADC_SC2_ACREN(value)))
#define ADC_BWR_SC2_ACREN(base, value) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ACREN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC2, field ACFGT[4] (RW)
 *
 * Configures the compare function to check the conversion result relative to
 * the CV1 and CV2 based upon the value of ACREN. ACFE must be set for ACFGT to
 * have any effect.
 *
 * Values:
 * - 0b0 - Configures less than threshold, outside range not inclusive and
 *     inside range not inclusive; functionality based on the values placed in CV1 and
 *     CV2.
 * - 0b1 - Configures greater than or equal to threshold, outside and inside
 *     ranges inclusive; functionality based on the values placed in CV1 and CV2.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ACFGT field. */
#define ADC_RD_SC2_ACFGT(base) ((ADC_SC2_REG(base) & ADC_SC2_ACFGT_MASK) >> ADC_SC2_ACFGT_SHIFT)
#define ADC_BRD_SC2_ACFGT(base) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ACFGT_SHIFT))

/*! @brief Set the ACFGT field to a new value. */
#define ADC_WR_SC2_ACFGT(base, value) (ADC_RMW_SC2(base, ADC_SC2_ACFGT_MASK, ADC_SC2_ACFGT(value)))
#define ADC_BWR_SC2_ACFGT(base, value) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ACFGT_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC2, field ACFE[5] (RW)
 *
 * Enables the compare function.
 *
 * Values:
 * - 0b0 - Compare function disabled.
 * - 0b1 - Compare function enabled.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ACFE field. */
#define ADC_RD_SC2_ACFE(base) ((ADC_SC2_REG(base) & ADC_SC2_ACFE_MASK) >> ADC_SC2_ACFE_SHIFT)
#define ADC_BRD_SC2_ACFE(base) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ACFE_SHIFT))

/*! @brief Set the ACFE field to a new value. */
#define ADC_WR_SC2_ACFE(base, value) (ADC_RMW_SC2(base, ADC_SC2_ACFE_MASK, ADC_SC2_ACFE(value)))
#define ADC_BWR_SC2_ACFE(base, value) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ACFE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC2, field ADTRG[6] (RW)
 *
 * Selects the type of trigger used for initiating a conversion. Two types of
 * trigger are selectable: Software trigger: When software trigger is selected, a
 * conversion is initiated following a write to SC1A. Hardware trigger: When
 * hardware trigger is selected, a conversion is initiated following the assertion of
 * the ADHWT input after a pulse of the ADHWTSn input.
 *
 * Values:
 * - 0b0 - Software trigger selected.
 * - 0b1 - Hardware trigger selected.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ADTRG field. */
#define ADC_RD_SC2_ADTRG(base) ((ADC_SC2_REG(base) & ADC_SC2_ADTRG_MASK) >> ADC_SC2_ADTRG_SHIFT)
#define ADC_BRD_SC2_ADTRG(base) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ADTRG_SHIFT))

/*! @brief Set the ADTRG field to a new value. */
#define ADC_WR_SC2_ADTRG(base, value) (ADC_RMW_SC2(base, ADC_SC2_ADTRG_MASK, ADC_SC2_ADTRG(value)))
#define ADC_BWR_SC2_ADTRG(base, value) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ADTRG_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC2, field ADACT[7] (RO)
 *
 * Indicates that a conversion or hardware averaging is in progress. ADACT is
 * set when a conversion is initiated and cleared when a conversion is completed or
 * aborted.
 *
 * Values:
 * - 0b0 - Conversion not in progress.
 * - 0b1 - Conversion in progress.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC2_ADACT field. */
#define ADC_RD_SC2_ADACT(base) ((ADC_SC2_REG(base) & ADC_SC2_ADACT_MASK) >> ADC_SC2_ADACT_SHIFT)
#define ADC_BRD_SC2_ADACT(base) (BITBAND_ACCESS32(&ADC_SC2_REG(base), ADC_SC2_ADACT_SHIFT))
/*@}*/

/*******************************************************************************
 * ADC_SC3 - Status and Control Register 3
 ******************************************************************************/

/*!
 * @brief ADC_SC3 - Status and Control Register 3 (RW)
 *
 * Reset value: 0x00000000U
 *
 * The Status and Control Register 3 (SC3) controls the calibration, continuous
 * convert, and hardware averaging functions of the ADC module.
 */
/*!
 * @name Constants and macros for entire ADC_SC3 register
 */
/*@{*/
#define ADC_RD_SC3(base)         (ADC_SC3_REG(base))
#define ADC_WR_SC3(base, value)  (ADC_SC3_REG(base) = (value))
#define ADC_RMW_SC3(base, mask, value) (ADC_WR_SC3(base, (ADC_RD_SC3(base) & ~(mask)) | (value)))
#define ADC_SET_SC3(base, value) (ADC_WR_SC3(base, ADC_RD_SC3(base) |  (value)))
#define ADC_CLR_SC3(base, value) (ADC_WR_SC3(base, ADC_RD_SC3(base) & ~(value)))
#define ADC_TOG_SC3(base, value) (ADC_WR_SC3(base, ADC_RD_SC3(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_SC3 bitfields
 */

/*!
 * @name Register ADC_SC3, field AVGS[1:0] (RW)
 *
 * Determines how many ADC conversions will be averaged to create the ADC
 * average result.
 *
 * Values:
 * - 0b00 - 4 samples averaged.
 * - 0b01 - 8 samples averaged.
 * - 0b10 - 16 samples averaged.
 * - 0b11 - 32 samples averaged.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_AVGS field. */
#define ADC_RD_SC3_AVGS(base) ((ADC_SC3_REG(base) & ADC_SC3_AVGS_MASK) >> ADC_SC3_AVGS_SHIFT)
#define ADC_BRD_SC3_AVGS(base) (ADC_RD_SC3_AVGS(base))

/*! @brief Set the AVGS field to a new value. */
#define ADC_WR_SC3_AVGS(base, value) (ADC_RMW_SC3(base, (ADC_SC3_AVGS_MASK | ADC_SC3_CALF_MASK), ADC_SC3_AVGS(value)))
#define ADC_BWR_SC3_AVGS(base, value) (ADC_WR_SC3_AVGS(base, value))
/*@}*/

/*!
 * @name Register ADC_SC3, field AVGE[2] (RW)
 *
 * Enables the hardware average function of the ADC.
 *
 * Values:
 * - 0b0 - Hardware average function disabled.
 * - 0b1 - Hardware average function enabled.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_AVGE field. */
#define ADC_RD_SC3_AVGE(base) ((ADC_SC3_REG(base) & ADC_SC3_AVGE_MASK) >> ADC_SC3_AVGE_SHIFT)
#define ADC_BRD_SC3_AVGE(base) (BITBAND_ACCESS32(&ADC_SC3_REG(base), ADC_SC3_AVGE_SHIFT))

/*! @brief Set the AVGE field to a new value. */
#define ADC_WR_SC3_AVGE(base, value) (ADC_RMW_SC3(base, (ADC_SC3_AVGE_MASK | ADC_SC3_CALF_MASK), ADC_SC3_AVGE(value)))
#define ADC_BWR_SC3_AVGE(base, value) (BITBAND_ACCESS32(&ADC_SC3_REG(base), ADC_SC3_AVGE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC3, field ADCO[3] (RW)
 *
 * Enables continuous conversions.
 *
 * Values:
 * - 0b0 - One conversion or one set of conversions if the hardware average
 *     function is enabled, that is, AVGE=1, after initiating a conversion.
 * - 0b1 - Continuous conversions or sets of conversions if the hardware average
 *     function is enabled, that is, AVGE=1, after initiating a conversion.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_ADCO field. */
#define ADC_RD_SC3_ADCO(base) ((ADC_SC3_REG(base) & ADC_SC3_ADCO_MASK) >> ADC_SC3_ADCO_SHIFT)
#define ADC_BRD_SC3_ADCO(base) (BITBAND_ACCESS32(&ADC_SC3_REG(base), ADC_SC3_ADCO_SHIFT))

/*! @brief Set the ADCO field to a new value. */
#define ADC_WR_SC3_ADCO(base, value) (ADC_RMW_SC3(base, (ADC_SC3_ADCO_MASK | ADC_SC3_CALF_MASK), ADC_SC3_ADCO(value)))
#define ADC_BWR_SC3_ADCO(base, value) (BITBAND_ACCESS32(&ADC_SC3_REG(base), ADC_SC3_ADCO_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC3, field CALF[6] (W1C)
 *
 * Displays the result of the calibration sequence. The calibration sequence
 * will fail if SC2[ADTRG] = 1, any ADC register is written, or any stop mode is
 * entered before the calibration sequence completes. Writing 1 to CALF clears it.
 *
 * Values:
 * - 0b0 - Calibration completed normally.
 * - 0b1 - Calibration failed. ADC accuracy specifications are not guaranteed.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_CALF field. */
#define ADC_RD_SC3_CALF(base) ((ADC_SC3_REG(base) & ADC_SC3_CALF_MASK) >> ADC_SC3_CALF_SHIFT)
#define ADC_BRD_SC3_CALF(base) (BITBAND_ACCESS32(&ADC_SC3_REG(base), ADC_SC3_CALF_SHIFT))

/*! @brief Set the CALF field to a new value. */
#define ADC_WR_SC3_CALF(base, value) (ADC_RMW_SC3(base, ADC_SC3_CALF_MASK, ADC_SC3_CALF(value)))
#define ADC_BWR_SC3_CALF(base, value) (BITBAND_ACCESS32(&ADC_SC3_REG(base), ADC_SC3_CALF_SHIFT) = (value))
/*@}*/

/*!
 * @name Register ADC_SC3, field CAL[7] (RW)
 *
 * Begins the calibration sequence when set. This field stays set while the
 * calibration is in progress and is cleared when the calibration sequence is
 * completed. CALF must be checked to determine the result of the calibration sequence.
 * Once started, the calibration routine cannot be interrupted by writes to the
 * ADC registers or the results will be invalid and CALF will set. Setting CAL
 * will abort any current conversion.
 */
/*@{*/
/*! @brief Read current value of the ADC_SC3_CAL field. */
#define ADC_RD_SC3_CAL(base) ((ADC_SC3_REG(base) & ADC_SC3_CAL_MASK) >> ADC_SC3_CAL_SHIFT)
#define ADC_BRD_SC3_CAL(base) (BITBAND_ACCESS32(&ADC_SC3_REG(base), ADC_SC3_CAL_SHIFT))

/*! @brief Set the CAL field to a new value. */
#define ADC_WR_SC3_CAL(base, value) (ADC_RMW_SC3(base, (ADC_SC3_CAL_MASK | ADC_SC3_CALF_MASK), ADC_SC3_CAL(value)))
#define ADC_BWR_SC3_CAL(base, value) (BITBAND_ACCESS32(&ADC_SC3_REG(base), ADC_SC3_CAL_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * ADC_OFS - ADC Offset Correction Register
 ******************************************************************************/

/*!
 * @brief ADC_OFS - ADC Offset Correction Register (RW)
 *
 * Reset value: 0x00000004U
 *
 * The ADC Offset Correction Register (OFS) contains the user-selected or
 * calibration-generated offset error correction value. This register is a 2's
 * complement, left-justified, 16-bit value . The value in OFS is subtracted from the
 * conversion and the result is transferred into the result registers, Rn. If the
 * result is greater than the maximum or less than the minimum result value, it is
 * forced to the appropriate limit for the current mode of operation.
 */
/*!
 * @name Constants and macros for entire ADC_OFS register
 */
/*@{*/
#define ADC_RD_OFS(base)         (ADC_OFS_REG(base))
#define ADC_WR_OFS(base, value)  (ADC_OFS_REG(base) = (value))
#define ADC_RMW_OFS(base, mask, value) (ADC_WR_OFS(base, (ADC_RD_OFS(base) & ~(mask)) | (value)))
#define ADC_SET_OFS(base, value) (ADC_WR_OFS(base, ADC_RD_OFS(base) |  (value)))
#define ADC_CLR_OFS(base, value) (ADC_WR_OFS(base, ADC_RD_OFS(base) & ~(value)))
#define ADC_TOG_OFS(base, value) (ADC_WR_OFS(base, ADC_RD_OFS(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_OFS bitfields
 */

/*!
 * @name Register ADC_OFS, field OFS[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_OFS_OFS field. */
#define ADC_RD_OFS_OFS(base) ((ADC_OFS_REG(base) & ADC_OFS_OFS_MASK) >> ADC_OFS_OFS_SHIFT)
#define ADC_BRD_OFS_OFS(base) (ADC_RD_OFS_OFS(base))

/*! @brief Set the OFS field to a new value. */
#define ADC_WR_OFS_OFS(base, value) (ADC_RMW_OFS(base, ADC_OFS_OFS_MASK, ADC_OFS_OFS(value)))
#define ADC_BWR_OFS_OFS(base, value) (ADC_WR_OFS_OFS(base, value))
/*@}*/

/*******************************************************************************
 * ADC_PG - ADC Plus-Side Gain Register
 ******************************************************************************/

/*!
 * @brief ADC_PG - ADC Plus-Side Gain Register (RW)
 *
 * Reset value: 0x00008200U
 *
 * The Plus-Side Gain Register (PG) contains the gain error correction for the
 * plus-side input in differential mode or the overall conversion in single-ended
 * mode. PG, a 16-bit real number in binary format, is the gain adjustment
 * factor, with the radix point fixed between ADPG15 and ADPG14. This register must be
 * written by the user with the value described in the calibration procedure.
 * Otherwise, the gain error specifications may not be met.
 */
/*!
 * @name Constants and macros for entire ADC_PG register
 */
/*@{*/
#define ADC_RD_PG(base)          (ADC_PG_REG(base))
#define ADC_WR_PG(base, value)   (ADC_PG_REG(base) = (value))
#define ADC_RMW_PG(base, mask, value) (ADC_WR_PG(base, (ADC_RD_PG(base) & ~(mask)) | (value)))
#define ADC_SET_PG(base, value)  (ADC_WR_PG(base, ADC_RD_PG(base) |  (value)))
#define ADC_CLR_PG(base, value)  (ADC_WR_PG(base, ADC_RD_PG(base) & ~(value)))
#define ADC_TOG_PG(base, value)  (ADC_WR_PG(base, ADC_RD_PG(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_PG bitfields
 */

/*!
 * @name Register ADC_PG, field PG[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_PG_PG field. */
#define ADC_RD_PG_PG(base)   ((ADC_PG_REG(base) & ADC_PG_PG_MASK) >> ADC_PG_PG_SHIFT)
#define ADC_BRD_PG_PG(base)  (ADC_RD_PG_PG(base))

/*! @brief Set the PG field to a new value. */
#define ADC_WR_PG_PG(base, value) (ADC_RMW_PG(base, ADC_PG_PG_MASK, ADC_PG_PG(value)))
#define ADC_BWR_PG_PG(base, value) (ADC_WR_PG_PG(base, value))
/*@}*/

/*******************************************************************************
 * ADC_MG - ADC Minus-Side Gain Register
 ******************************************************************************/

/*!
 * @brief ADC_MG - ADC Minus-Side Gain Register (RW)
 *
 * Reset value: 0x00008200U
 *
 * The Minus-Side Gain Register (MG) contains the gain error correction for the
 * minus-side input in differential mode. This register is ignored in
 * single-ended mode. MG, a 16-bit real number in binary format, is the gain adjustment
 * factor, with the radix point fixed between ADMG15 and ADMG14. This register must
 * be written by the user with the value described in the calibration procedure.
 * Otherwise, the gain error specifications may not be met.
 */
/*!
 * @name Constants and macros for entire ADC_MG register
 */
/*@{*/
#define ADC_RD_MG(base)          (ADC_MG_REG(base))
#define ADC_WR_MG(base, value)   (ADC_MG_REG(base) = (value))
#define ADC_RMW_MG(base, mask, value) (ADC_WR_MG(base, (ADC_RD_MG(base) & ~(mask)) | (value)))
#define ADC_SET_MG(base, value)  (ADC_WR_MG(base, ADC_RD_MG(base) |  (value)))
#define ADC_CLR_MG(base, value)  (ADC_WR_MG(base, ADC_RD_MG(base) & ~(value)))
#define ADC_TOG_MG(base, value)  (ADC_WR_MG(base, ADC_RD_MG(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_MG bitfields
 */

/*!
 * @name Register ADC_MG, field MG[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the ADC_MG_MG field. */
#define ADC_RD_MG_MG(base)   ((ADC_MG_REG(base) & ADC_MG_MG_MASK) >> ADC_MG_MG_SHIFT)
#define ADC_BRD_MG_MG(base)  (ADC_RD_MG_MG(base))

/*! @brief Set the MG field to a new value. */
#define ADC_WR_MG_MG(base, value) (ADC_RMW_MG(base, ADC_MG_MG_MASK, ADC_MG_MG(value)))
#define ADC_BWR_MG_MG(base, value) (ADC_WR_MG_MG(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLPD - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLPD - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x0000000AU
 *
 * The Plus-Side General Calibration Value Registers (CLPx) contain calibration
 * information that is generated by the calibration function. These registers
 * contain seven calibration values of varying widths: CLP0[5:0], CLP1[6:0],
 * CLP2[7:0], CLP3[8:0], CLP4[9:0], CLPS[5:0], and CLPD[5:0]. CLPx are automatically set
 * when the self-calibration sequence is done, that is, CAL is cleared. If these
 * registers are written by the user after calibration, the linearity error
 * specifications may not be met.
 */
/*!
 * @name Constants and macros for entire ADC_CLPD register
 */
/*@{*/
#define ADC_RD_CLPD(base)        (ADC_CLPD_REG(base))
#define ADC_WR_CLPD(base, value) (ADC_CLPD_REG(base) = (value))
#define ADC_RMW_CLPD(base, mask, value) (ADC_WR_CLPD(base, (ADC_RD_CLPD(base) & ~(mask)) | (value)))
#define ADC_SET_CLPD(base, value) (ADC_WR_CLPD(base, ADC_RD_CLPD(base) |  (value)))
#define ADC_CLR_CLPD(base, value) (ADC_WR_CLPD(base, ADC_RD_CLPD(base) & ~(value)))
#define ADC_TOG_CLPD(base, value) (ADC_WR_CLPD(base, ADC_RD_CLPD(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLPD bitfields
 */

/*!
 * @name Register ADC_CLPD, field CLPD[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLPD_CLPD field. */
#define ADC_RD_CLPD_CLPD(base) ((ADC_CLPD_REG(base) & ADC_CLPD_CLPD_MASK) >> ADC_CLPD_CLPD_SHIFT)
#define ADC_BRD_CLPD_CLPD(base) (ADC_RD_CLPD_CLPD(base))

/*! @brief Set the CLPD field to a new value. */
#define ADC_WR_CLPD_CLPD(base, value) (ADC_RMW_CLPD(base, ADC_CLPD_CLPD_MASK, ADC_CLPD_CLPD(value)))
#define ADC_BWR_CLPD_CLPD(base, value) (ADC_WR_CLPD_CLPD(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLPS - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLPS - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLPS register
 */
/*@{*/
#define ADC_RD_CLPS(base)        (ADC_CLPS_REG(base))
#define ADC_WR_CLPS(base, value) (ADC_CLPS_REG(base) = (value))
#define ADC_RMW_CLPS(base, mask, value) (ADC_WR_CLPS(base, (ADC_RD_CLPS(base) & ~(mask)) | (value)))
#define ADC_SET_CLPS(base, value) (ADC_WR_CLPS(base, ADC_RD_CLPS(base) |  (value)))
#define ADC_CLR_CLPS(base, value) (ADC_WR_CLPS(base, ADC_RD_CLPS(base) & ~(value)))
#define ADC_TOG_CLPS(base, value) (ADC_WR_CLPS(base, ADC_RD_CLPS(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLPS bitfields
 */

/*!
 * @name Register ADC_CLPS, field CLPS[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLPS_CLPS field. */
#define ADC_RD_CLPS_CLPS(base) ((ADC_CLPS_REG(base) & ADC_CLPS_CLPS_MASK) >> ADC_CLPS_CLPS_SHIFT)
#define ADC_BRD_CLPS_CLPS(base) (ADC_RD_CLPS_CLPS(base))

/*! @brief Set the CLPS field to a new value. */
#define ADC_WR_CLPS_CLPS(base, value) (ADC_RMW_CLPS(base, ADC_CLPS_CLPS_MASK, ADC_CLPS_CLPS(value)))
#define ADC_BWR_CLPS_CLPS(base, value) (ADC_WR_CLPS_CLPS(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLP4 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP4 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000200U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP4 register
 */
/*@{*/
#define ADC_RD_CLP4(base)        (ADC_CLP4_REG(base))
#define ADC_WR_CLP4(base, value) (ADC_CLP4_REG(base) = (value))
#define ADC_RMW_CLP4(base, mask, value) (ADC_WR_CLP4(base, (ADC_RD_CLP4(base) & ~(mask)) | (value)))
#define ADC_SET_CLP4(base, value) (ADC_WR_CLP4(base, ADC_RD_CLP4(base) |  (value)))
#define ADC_CLR_CLP4(base, value) (ADC_WR_CLP4(base, ADC_RD_CLP4(base) & ~(value)))
#define ADC_TOG_CLP4(base, value) (ADC_WR_CLP4(base, ADC_RD_CLP4(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP4 bitfields
 */

/*!
 * @name Register ADC_CLP4, field CLP4[9:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP4_CLP4 field. */
#define ADC_RD_CLP4_CLP4(base) ((ADC_CLP4_REG(base) & ADC_CLP4_CLP4_MASK) >> ADC_CLP4_CLP4_SHIFT)
#define ADC_BRD_CLP4_CLP4(base) (ADC_RD_CLP4_CLP4(base))

/*! @brief Set the CLP4 field to a new value. */
#define ADC_WR_CLP4_CLP4(base, value) (ADC_RMW_CLP4(base, ADC_CLP4_CLP4_MASK, ADC_CLP4_CLP4(value)))
#define ADC_BWR_CLP4_CLP4(base, value) (ADC_WR_CLP4_CLP4(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLP3 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP3 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP3 register
 */
/*@{*/
#define ADC_RD_CLP3(base)        (ADC_CLP3_REG(base))
#define ADC_WR_CLP3(base, value) (ADC_CLP3_REG(base) = (value))
#define ADC_RMW_CLP3(base, mask, value) (ADC_WR_CLP3(base, (ADC_RD_CLP3(base) & ~(mask)) | (value)))
#define ADC_SET_CLP3(base, value) (ADC_WR_CLP3(base, ADC_RD_CLP3(base) |  (value)))
#define ADC_CLR_CLP3(base, value) (ADC_WR_CLP3(base, ADC_RD_CLP3(base) & ~(value)))
#define ADC_TOG_CLP3(base, value) (ADC_WR_CLP3(base, ADC_RD_CLP3(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP3 bitfields
 */

/*!
 * @name Register ADC_CLP3, field CLP3[8:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP3_CLP3 field. */
#define ADC_RD_CLP3_CLP3(base) ((ADC_CLP3_REG(base) & ADC_CLP3_CLP3_MASK) >> ADC_CLP3_CLP3_SHIFT)
#define ADC_BRD_CLP3_CLP3(base) (ADC_RD_CLP3_CLP3(base))

/*! @brief Set the CLP3 field to a new value. */
#define ADC_WR_CLP3_CLP3(base, value) (ADC_RMW_CLP3(base, ADC_CLP3_CLP3_MASK, ADC_CLP3_CLP3(value)))
#define ADC_BWR_CLP3_CLP3(base, value) (ADC_WR_CLP3_CLP3(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLP2 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP2 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000080U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP2 register
 */
/*@{*/
#define ADC_RD_CLP2(base)        (ADC_CLP2_REG(base))
#define ADC_WR_CLP2(base, value) (ADC_CLP2_REG(base) = (value))
#define ADC_RMW_CLP2(base, mask, value) (ADC_WR_CLP2(base, (ADC_RD_CLP2(base) & ~(mask)) | (value)))
#define ADC_SET_CLP2(base, value) (ADC_WR_CLP2(base, ADC_RD_CLP2(base) |  (value)))
#define ADC_CLR_CLP2(base, value) (ADC_WR_CLP2(base, ADC_RD_CLP2(base) & ~(value)))
#define ADC_TOG_CLP2(base, value) (ADC_WR_CLP2(base, ADC_RD_CLP2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP2 bitfields
 */

/*!
 * @name Register ADC_CLP2, field CLP2[7:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP2_CLP2 field. */
#define ADC_RD_CLP2_CLP2(base) ((ADC_CLP2_REG(base) & ADC_CLP2_CLP2_MASK) >> ADC_CLP2_CLP2_SHIFT)
#define ADC_BRD_CLP2_CLP2(base) (ADC_RD_CLP2_CLP2(base))

/*! @brief Set the CLP2 field to a new value. */
#define ADC_WR_CLP2_CLP2(base, value) (ADC_RMW_CLP2(base, ADC_CLP2_CLP2_MASK, ADC_CLP2_CLP2(value)))
#define ADC_BWR_CLP2_CLP2(base, value) (ADC_WR_CLP2_CLP2(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLP1 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP1 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000040U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP1 register
 */
/*@{*/
#define ADC_RD_CLP1(base)        (ADC_CLP1_REG(base))
#define ADC_WR_CLP1(base, value) (ADC_CLP1_REG(base) = (value))
#define ADC_RMW_CLP1(base, mask, value) (ADC_WR_CLP1(base, (ADC_RD_CLP1(base) & ~(mask)) | (value)))
#define ADC_SET_CLP1(base, value) (ADC_WR_CLP1(base, ADC_RD_CLP1(base) |  (value)))
#define ADC_CLR_CLP1(base, value) (ADC_WR_CLP1(base, ADC_RD_CLP1(base) & ~(value)))
#define ADC_TOG_CLP1(base, value) (ADC_WR_CLP1(base, ADC_RD_CLP1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP1 bitfields
 */

/*!
 * @name Register ADC_CLP1, field CLP1[6:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP1_CLP1 field. */
#define ADC_RD_CLP1_CLP1(base) ((ADC_CLP1_REG(base) & ADC_CLP1_CLP1_MASK) >> ADC_CLP1_CLP1_SHIFT)
#define ADC_BRD_CLP1_CLP1(base) (ADC_RD_CLP1_CLP1(base))

/*! @brief Set the CLP1 field to a new value. */
#define ADC_WR_CLP1_CLP1(base, value) (ADC_RMW_CLP1(base, ADC_CLP1_CLP1_MASK, ADC_CLP1_CLP1(value)))
#define ADC_BWR_CLP1_CLP1(base, value) (ADC_WR_CLP1_CLP1(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLP0 - ADC Plus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLP0 - ADC Plus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLPD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLP0 register
 */
/*@{*/
#define ADC_RD_CLP0(base)        (ADC_CLP0_REG(base))
#define ADC_WR_CLP0(base, value) (ADC_CLP0_REG(base) = (value))
#define ADC_RMW_CLP0(base, mask, value) (ADC_WR_CLP0(base, (ADC_RD_CLP0(base) & ~(mask)) | (value)))
#define ADC_SET_CLP0(base, value) (ADC_WR_CLP0(base, ADC_RD_CLP0(base) |  (value)))
#define ADC_CLR_CLP0(base, value) (ADC_WR_CLP0(base, ADC_RD_CLP0(base) & ~(value)))
#define ADC_TOG_CLP0(base, value) (ADC_WR_CLP0(base, ADC_RD_CLP0(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLP0 bitfields
 */

/*!
 * @name Register ADC_CLP0, field CLP0[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLP0_CLP0 field. */
#define ADC_RD_CLP0_CLP0(base) ((ADC_CLP0_REG(base) & ADC_CLP0_CLP0_MASK) >> ADC_CLP0_CLP0_SHIFT)
#define ADC_BRD_CLP0_CLP0(base) (ADC_RD_CLP0_CLP0(base))

/*! @brief Set the CLP0 field to a new value. */
#define ADC_WR_CLP0_CLP0(base, value) (ADC_RMW_CLP0(base, ADC_CLP0_CLP0_MASK, ADC_CLP0_CLP0(value)))
#define ADC_BWR_CLP0_CLP0(base, value) (ADC_WR_CLP0_CLP0(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLMD - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLMD - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x0000000AU
 *
 * The Minus-Side General Calibration Value (CLMx) registers contain calibration
 * information that is generated by the calibration function. These registers
 * contain seven calibration values of varying widths: CLM0[5:0], CLM1[6:0],
 * CLM2[7:0], CLM3[8:0], CLM4[9:0], CLMS[5:0], and CLMD[5:0]. CLMx are automatically
 * set when the self-calibration sequence is done, that is, CAL is cleared. If
 * these registers are written by the user after calibration, the linearity error
 * specifications may not be met.
 */
/*!
 * @name Constants and macros for entire ADC_CLMD register
 */
/*@{*/
#define ADC_RD_CLMD(base)        (ADC_CLMD_REG(base))
#define ADC_WR_CLMD(base, value) (ADC_CLMD_REG(base) = (value))
#define ADC_RMW_CLMD(base, mask, value) (ADC_WR_CLMD(base, (ADC_RD_CLMD(base) & ~(mask)) | (value)))
#define ADC_SET_CLMD(base, value) (ADC_WR_CLMD(base, ADC_RD_CLMD(base) |  (value)))
#define ADC_CLR_CLMD(base, value) (ADC_WR_CLMD(base, ADC_RD_CLMD(base) & ~(value)))
#define ADC_TOG_CLMD(base, value) (ADC_WR_CLMD(base, ADC_RD_CLMD(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLMD bitfields
 */

/*!
 * @name Register ADC_CLMD, field CLMD[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLMD_CLMD field. */
#define ADC_RD_CLMD_CLMD(base) ((ADC_CLMD_REG(base) & ADC_CLMD_CLMD_MASK) >> ADC_CLMD_CLMD_SHIFT)
#define ADC_BRD_CLMD_CLMD(base) (ADC_RD_CLMD_CLMD(base))

/*! @brief Set the CLMD field to a new value. */
#define ADC_WR_CLMD_CLMD(base, value) (ADC_RMW_CLMD(base, ADC_CLMD_CLMD_MASK, ADC_CLMD_CLMD(value)))
#define ADC_BWR_CLMD_CLMD(base, value) (ADC_WR_CLMD_CLMD(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLMS - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLMS - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLMS register
 */
/*@{*/
#define ADC_RD_CLMS(base)        (ADC_CLMS_REG(base))
#define ADC_WR_CLMS(base, value) (ADC_CLMS_REG(base) = (value))
#define ADC_RMW_CLMS(base, mask, value) (ADC_WR_CLMS(base, (ADC_RD_CLMS(base) & ~(mask)) | (value)))
#define ADC_SET_CLMS(base, value) (ADC_WR_CLMS(base, ADC_RD_CLMS(base) |  (value)))
#define ADC_CLR_CLMS(base, value) (ADC_WR_CLMS(base, ADC_RD_CLMS(base) & ~(value)))
#define ADC_TOG_CLMS(base, value) (ADC_WR_CLMS(base, ADC_RD_CLMS(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLMS bitfields
 */

/*!
 * @name Register ADC_CLMS, field CLMS[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLMS_CLMS field. */
#define ADC_RD_CLMS_CLMS(base) ((ADC_CLMS_REG(base) & ADC_CLMS_CLMS_MASK) >> ADC_CLMS_CLMS_SHIFT)
#define ADC_BRD_CLMS_CLMS(base) (ADC_RD_CLMS_CLMS(base))

/*! @brief Set the CLMS field to a new value. */
#define ADC_WR_CLMS_CLMS(base, value) (ADC_RMW_CLMS(base, ADC_CLMS_CLMS_MASK, ADC_CLMS_CLMS(value)))
#define ADC_BWR_CLMS_CLMS(base, value) (ADC_WR_CLMS_CLMS(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLM4 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM4 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000200U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM4 register
 */
/*@{*/
#define ADC_RD_CLM4(base)        (ADC_CLM4_REG(base))
#define ADC_WR_CLM4(base, value) (ADC_CLM4_REG(base) = (value))
#define ADC_RMW_CLM4(base, mask, value) (ADC_WR_CLM4(base, (ADC_RD_CLM4(base) & ~(mask)) | (value)))
#define ADC_SET_CLM4(base, value) (ADC_WR_CLM4(base, ADC_RD_CLM4(base) |  (value)))
#define ADC_CLR_CLM4(base, value) (ADC_WR_CLM4(base, ADC_RD_CLM4(base) & ~(value)))
#define ADC_TOG_CLM4(base, value) (ADC_WR_CLM4(base, ADC_RD_CLM4(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM4 bitfields
 */

/*!
 * @name Register ADC_CLM4, field CLM4[9:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM4_CLM4 field. */
#define ADC_RD_CLM4_CLM4(base) ((ADC_CLM4_REG(base) & ADC_CLM4_CLM4_MASK) >> ADC_CLM4_CLM4_SHIFT)
#define ADC_BRD_CLM4_CLM4(base) (ADC_RD_CLM4_CLM4(base))

/*! @brief Set the CLM4 field to a new value. */
#define ADC_WR_CLM4_CLM4(base, value) (ADC_RMW_CLM4(base, ADC_CLM4_CLM4_MASK, ADC_CLM4_CLM4(value)))
#define ADC_BWR_CLM4_CLM4(base, value) (ADC_WR_CLM4_CLM4(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLM3 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM3 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000100U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM3 register
 */
/*@{*/
#define ADC_RD_CLM3(base)        (ADC_CLM3_REG(base))
#define ADC_WR_CLM3(base, value) (ADC_CLM3_REG(base) = (value))
#define ADC_RMW_CLM3(base, mask, value) (ADC_WR_CLM3(base, (ADC_RD_CLM3(base) & ~(mask)) | (value)))
#define ADC_SET_CLM3(base, value) (ADC_WR_CLM3(base, ADC_RD_CLM3(base) |  (value)))
#define ADC_CLR_CLM3(base, value) (ADC_WR_CLM3(base, ADC_RD_CLM3(base) & ~(value)))
#define ADC_TOG_CLM3(base, value) (ADC_WR_CLM3(base, ADC_RD_CLM3(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM3 bitfields
 */

/*!
 * @name Register ADC_CLM3, field CLM3[8:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM3_CLM3 field. */
#define ADC_RD_CLM3_CLM3(base) ((ADC_CLM3_REG(base) & ADC_CLM3_CLM3_MASK) >> ADC_CLM3_CLM3_SHIFT)
#define ADC_BRD_CLM3_CLM3(base) (ADC_RD_CLM3_CLM3(base))

/*! @brief Set the CLM3 field to a new value. */
#define ADC_WR_CLM3_CLM3(base, value) (ADC_RMW_CLM3(base, ADC_CLM3_CLM3_MASK, ADC_CLM3_CLM3(value)))
#define ADC_BWR_CLM3_CLM3(base, value) (ADC_WR_CLM3_CLM3(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLM2 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM2 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000080U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM2 register
 */
/*@{*/
#define ADC_RD_CLM2(base)        (ADC_CLM2_REG(base))
#define ADC_WR_CLM2(base, value) (ADC_CLM2_REG(base) = (value))
#define ADC_RMW_CLM2(base, mask, value) (ADC_WR_CLM2(base, (ADC_RD_CLM2(base) & ~(mask)) | (value)))
#define ADC_SET_CLM2(base, value) (ADC_WR_CLM2(base, ADC_RD_CLM2(base) |  (value)))
#define ADC_CLR_CLM2(base, value) (ADC_WR_CLM2(base, ADC_RD_CLM2(base) & ~(value)))
#define ADC_TOG_CLM2(base, value) (ADC_WR_CLM2(base, ADC_RD_CLM2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM2 bitfields
 */

/*!
 * @name Register ADC_CLM2, field CLM2[7:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM2_CLM2 field. */
#define ADC_RD_CLM2_CLM2(base) ((ADC_CLM2_REG(base) & ADC_CLM2_CLM2_MASK) >> ADC_CLM2_CLM2_SHIFT)
#define ADC_BRD_CLM2_CLM2(base) (ADC_RD_CLM2_CLM2(base))

/*! @brief Set the CLM2 field to a new value. */
#define ADC_WR_CLM2_CLM2(base, value) (ADC_RMW_CLM2(base, ADC_CLM2_CLM2_MASK, ADC_CLM2_CLM2(value)))
#define ADC_BWR_CLM2_CLM2(base, value) (ADC_WR_CLM2_CLM2(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLM1 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM1 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000040U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM1 register
 */
/*@{*/
#define ADC_RD_CLM1(base)        (ADC_CLM1_REG(base))
#define ADC_WR_CLM1(base, value) (ADC_CLM1_REG(base) = (value))
#define ADC_RMW_CLM1(base, mask, value) (ADC_WR_CLM1(base, (ADC_RD_CLM1(base) & ~(mask)) | (value)))
#define ADC_SET_CLM1(base, value) (ADC_WR_CLM1(base, ADC_RD_CLM1(base) |  (value)))
#define ADC_CLR_CLM1(base, value) (ADC_WR_CLM1(base, ADC_RD_CLM1(base) & ~(value)))
#define ADC_TOG_CLM1(base, value) (ADC_WR_CLM1(base, ADC_RD_CLM1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM1 bitfields
 */

/*!
 * @name Register ADC_CLM1, field CLM1[6:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM1_CLM1 field. */
#define ADC_RD_CLM1_CLM1(base) ((ADC_CLM1_REG(base) & ADC_CLM1_CLM1_MASK) >> ADC_CLM1_CLM1_SHIFT)
#define ADC_BRD_CLM1_CLM1(base) (ADC_RD_CLM1_CLM1(base))

/*! @brief Set the CLM1 field to a new value. */
#define ADC_WR_CLM1_CLM1(base, value) (ADC_RMW_CLM1(base, ADC_CLM1_CLM1_MASK, ADC_CLM1_CLM1(value)))
#define ADC_BWR_CLM1_CLM1(base, value) (ADC_WR_CLM1_CLM1(base, value))
/*@}*/

/*******************************************************************************
 * ADC_CLM0 - ADC Minus-Side General Calibration Value Register
 ******************************************************************************/

/*!
 * @brief ADC_CLM0 - ADC Minus-Side General Calibration Value Register (RW)
 *
 * Reset value: 0x00000020U
 *
 * For more information, see CLMD register description.
 */
/*!
 * @name Constants and macros for entire ADC_CLM0 register
 */
/*@{*/
#define ADC_RD_CLM0(base)        (ADC_CLM0_REG(base))
#define ADC_WR_CLM0(base, value) (ADC_CLM0_REG(base) = (value))
#define ADC_RMW_CLM0(base, mask, value) (ADC_WR_CLM0(base, (ADC_RD_CLM0(base) & ~(mask)) | (value)))
#define ADC_SET_CLM0(base, value) (ADC_WR_CLM0(base, ADC_RD_CLM0(base) |  (value)))
#define ADC_CLR_CLM0(base, value) (ADC_WR_CLM0(base, ADC_RD_CLM0(base) & ~(value)))
#define ADC_TOG_CLM0(base, value) (ADC_WR_CLM0(base, ADC_RD_CLM0(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual ADC_CLM0 bitfields
 */

/*!
 * @name Register ADC_CLM0, field CLM0[5:0] (RW)
 *
 * Calibration Value
 */
/*@{*/
/*! @brief Read current value of the ADC_CLM0_CLM0 field. */
#define ADC_RD_CLM0_CLM0(base) ((ADC_CLM0_REG(base) & ADC_CLM0_CLM0_MASK) >> ADC_CLM0_CLM0_SHIFT)
#define ADC_BRD_CLM0_CLM0(base) (ADC_RD_CLM0_CLM0(base))

/*! @brief Set the CLM0 field to a new value. */
#define ADC_WR_CLM0_CLM0(base, value) (ADC_RMW_CLM0(base, ADC_CLM0_CLM0_MASK, ADC_CLM0_CLM0(value)))
#define ADC_BWR_CLM0_CLM0(base, value) (ADC_WR_CLM0_CLM0(base, value))
/*@}*/

/*
 * MK64F12 AIPS
 *
 * AIPS-Lite Bridge
 *
 * Registers defined in this header file:
 * - AIPS_MPRA - Master Privilege Register A
 * - AIPS_PACRA - Peripheral Access Control Register
 * - AIPS_PACRB - Peripheral Access Control Register
 * - AIPS_PACRC - Peripheral Access Control Register
 * - AIPS_PACRD - Peripheral Access Control Register
 * - AIPS_PACRE - Peripheral Access Control Register
 * - AIPS_PACRF - Peripheral Access Control Register
 * - AIPS_PACRG - Peripheral Access Control Register
 * - AIPS_PACRH - Peripheral Access Control Register
 * - AIPS_PACRI - Peripheral Access Control Register
 * - AIPS_PACRJ - Peripheral Access Control Register
 * - AIPS_PACRK - Peripheral Access Control Register
 * - AIPS_PACRL - Peripheral Access Control Register
 * - AIPS_PACRM - Peripheral Access Control Register
 * - AIPS_PACRN - Peripheral Access Control Register
 * - AIPS_PACRO - Peripheral Access Control Register
 * - AIPS_PACRP - Peripheral Access Control Register
 * - AIPS_PACRU - Peripheral Access Control Register
 */

#define AIPS_INSTANCE_COUNT (2U) /*!< Number of instances of the AIPS module. */
#define AIPS0_IDX (0U) /*!< Instance number for AIPS0. */
#define AIPS1_IDX (1U) /*!< Instance number for AIPS1. */

/*******************************************************************************
 * AIPS_MPRA - Master Privilege Register A
 ******************************************************************************/

/*!
 * @brief AIPS_MPRA - Master Privilege Register A (RW)
 *
 * Reset value: 0x77700000U
 *
 * The MPRA specifies identical 4-bit fields defining the access-privilege level
 * associated with a bus master to various peripherals on the chip. The register
 * provides one field per bus master. At reset, the default value loaded into
 * the MPRA fields is chip-specific. See the chip configuration details for the
 * value of a particular device. A register field that maps to an unimplemented
 * master or peripheral behaves as read-only-zero. Each master is assigned a logical
 * ID from 0 to 15. See the master logical ID assignment table in the
 * chip-specific AIPS information.
 */
/*!
 * @name Constants and macros for entire AIPS_MPRA register
 */
/*@{*/
#define AIPS_RD_MPRA(base)       (AIPS_MPRA_REG(base))
#define AIPS_WR_MPRA(base, value) (AIPS_MPRA_REG(base) = (value))
#define AIPS_RMW_MPRA(base, mask, value) (AIPS_WR_MPRA(base, (AIPS_RD_MPRA(base) & ~(mask)) | (value)))
#define AIPS_SET_MPRA(base, value) (AIPS_WR_MPRA(base, AIPS_RD_MPRA(base) |  (value)))
#define AIPS_CLR_MPRA(base, value) (AIPS_WR_MPRA(base, AIPS_RD_MPRA(base) & ~(value)))
#define AIPS_TOG_MPRA(base, value) (AIPS_WR_MPRA(base, AIPS_RD_MPRA(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_MPRA bitfields
 */

/*!
 * @name Register AIPS_MPRA, field MPL5[8] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0b0 - Accesses from this master are forced to user-mode.
 * - 0b1 - Accesses from this master are not forced to user-mode.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MPL5 field. */
#define AIPS_RD_MPRA_MPL5(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MPL5_MASK) >> AIPS_MPRA_MPL5_SHIFT)
#define AIPS_BRD_MPRA_MPL5(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL5_SHIFT))

/*! @brief Set the MPL5 field to a new value. */
#define AIPS_WR_MPRA_MPL5(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MPL5_MASK, AIPS_MPRA_MPL5(value)))
#define AIPS_BWR_MPRA_MPL5(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTW5[9] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for write accesses.
 * - 0b1 - This master is trusted for write accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTW5 field. */
#define AIPS_RD_MPRA_MTW5(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTW5_MASK) >> AIPS_MPRA_MTW5_SHIFT)
#define AIPS_BRD_MPRA_MTW5(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW5_SHIFT))

/*! @brief Set the MTW5 field to a new value. */
#define AIPS_WR_MPRA_MTW5(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTW5_MASK, AIPS_MPRA_MTW5(value)))
#define AIPS_BWR_MPRA_MTW5(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTR5[10] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for read accesses.
 * - 0b1 - This master is trusted for read accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTR5 field. */
#define AIPS_RD_MPRA_MTR5(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTR5_MASK) >> AIPS_MPRA_MTR5_SHIFT)
#define AIPS_BRD_MPRA_MTR5(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR5_SHIFT))

/*! @brief Set the MTR5 field to a new value. */
#define AIPS_WR_MPRA_MTR5(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTR5_MASK, AIPS_MPRA_MTR5(value)))
#define AIPS_BWR_MPRA_MTR5(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MPL4[12] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0b0 - Accesses from this master are forced to user-mode.
 * - 0b1 - Accesses from this master are not forced to user-mode.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MPL4 field. */
#define AIPS_RD_MPRA_MPL4(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MPL4_MASK) >> AIPS_MPRA_MPL4_SHIFT)
#define AIPS_BRD_MPRA_MPL4(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL4_SHIFT))

/*! @brief Set the MPL4 field to a new value. */
#define AIPS_WR_MPRA_MPL4(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MPL4_MASK, AIPS_MPRA_MPL4(value)))
#define AIPS_BWR_MPRA_MPL4(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTW4[13] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for write accesses.
 * - 0b1 - This master is trusted for write accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTW4 field. */
#define AIPS_RD_MPRA_MTW4(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTW4_MASK) >> AIPS_MPRA_MTW4_SHIFT)
#define AIPS_BRD_MPRA_MTW4(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW4_SHIFT))

/*! @brief Set the MTW4 field to a new value. */
#define AIPS_WR_MPRA_MTW4(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTW4_MASK, AIPS_MPRA_MTW4(value)))
#define AIPS_BWR_MPRA_MTW4(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTR4[14] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for read accesses.
 * - 0b1 - This master is trusted for read accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTR4 field. */
#define AIPS_RD_MPRA_MTR4(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTR4_MASK) >> AIPS_MPRA_MTR4_SHIFT)
#define AIPS_BRD_MPRA_MTR4(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR4_SHIFT))

/*! @brief Set the MTR4 field to a new value. */
#define AIPS_WR_MPRA_MTR4(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTR4_MASK, AIPS_MPRA_MTR4(value)))
#define AIPS_BWR_MPRA_MTR4(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MPL3[16] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0b0 - Accesses from this master are forced to user-mode.
 * - 0b1 - Accesses from this master are not forced to user-mode.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MPL3 field. */
#define AIPS_RD_MPRA_MPL3(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MPL3_MASK) >> AIPS_MPRA_MPL3_SHIFT)
#define AIPS_BRD_MPRA_MPL3(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL3_SHIFT))

/*! @brief Set the MPL3 field to a new value. */
#define AIPS_WR_MPRA_MPL3(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MPL3_MASK, AIPS_MPRA_MPL3(value)))
#define AIPS_BWR_MPRA_MPL3(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTW3[17] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for write accesses.
 * - 0b1 - This master is trusted for write accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTW3 field. */
#define AIPS_RD_MPRA_MTW3(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTW3_MASK) >> AIPS_MPRA_MTW3_SHIFT)
#define AIPS_BRD_MPRA_MTW3(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW3_SHIFT))

/*! @brief Set the MTW3 field to a new value. */
#define AIPS_WR_MPRA_MTW3(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTW3_MASK, AIPS_MPRA_MTW3(value)))
#define AIPS_BWR_MPRA_MTW3(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTR3[18] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for read accesses.
 * - 0b1 - This master is trusted for read accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTR3 field. */
#define AIPS_RD_MPRA_MTR3(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTR3_MASK) >> AIPS_MPRA_MTR3_SHIFT)
#define AIPS_BRD_MPRA_MTR3(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR3_SHIFT))

/*! @brief Set the MTR3 field to a new value. */
#define AIPS_WR_MPRA_MTR3(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTR3_MASK, AIPS_MPRA_MTR3(value)))
#define AIPS_BWR_MPRA_MTR3(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MPL2[20] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0b0 - Accesses from this master are forced to user-mode.
 * - 0b1 - Accesses from this master are not forced to user-mode.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MPL2 field. */
#define AIPS_RD_MPRA_MPL2(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MPL2_MASK) >> AIPS_MPRA_MPL2_SHIFT)
#define AIPS_BRD_MPRA_MPL2(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL2_SHIFT))

/*! @brief Set the MPL2 field to a new value. */
#define AIPS_WR_MPRA_MPL2(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MPL2_MASK, AIPS_MPRA_MPL2(value)))
#define AIPS_BWR_MPRA_MPL2(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTW2[21] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for write accesses.
 * - 0b1 - This master is trusted for write accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTW2 field. */
#define AIPS_RD_MPRA_MTW2(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTW2_MASK) >> AIPS_MPRA_MTW2_SHIFT)
#define AIPS_BRD_MPRA_MTW2(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW2_SHIFT))

/*! @brief Set the MTW2 field to a new value. */
#define AIPS_WR_MPRA_MTW2(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTW2_MASK, AIPS_MPRA_MTW2(value)))
#define AIPS_BWR_MPRA_MTW2(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTR2[22] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for read accesses.
 * - 0b1 - This master is trusted for read accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTR2 field. */
#define AIPS_RD_MPRA_MTR2(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTR2_MASK) >> AIPS_MPRA_MTR2_SHIFT)
#define AIPS_BRD_MPRA_MTR2(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR2_SHIFT))

/*! @brief Set the MTR2 field to a new value. */
#define AIPS_WR_MPRA_MTR2(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTR2_MASK, AIPS_MPRA_MTR2(value)))
#define AIPS_BWR_MPRA_MTR2(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MPL1[24] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0b0 - Accesses from this master are forced to user-mode.
 * - 0b1 - Accesses from this master are not forced to user-mode.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MPL1 field. */
#define AIPS_RD_MPRA_MPL1(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MPL1_MASK) >> AIPS_MPRA_MPL1_SHIFT)
#define AIPS_BRD_MPRA_MPL1(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL1_SHIFT))

/*! @brief Set the MPL1 field to a new value. */
#define AIPS_WR_MPRA_MPL1(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MPL1_MASK, AIPS_MPRA_MPL1(value)))
#define AIPS_BWR_MPRA_MPL1(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTW1[25] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for write accesses.
 * - 0b1 - This master is trusted for write accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTW1 field. */
#define AIPS_RD_MPRA_MTW1(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTW1_MASK) >> AIPS_MPRA_MTW1_SHIFT)
#define AIPS_BRD_MPRA_MTW1(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW1_SHIFT))

/*! @brief Set the MTW1 field to a new value. */
#define AIPS_WR_MPRA_MTW1(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTW1_MASK, AIPS_MPRA_MTW1(value)))
#define AIPS_BWR_MPRA_MTW1(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTR1[26] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for read accesses.
 * - 0b1 - This master is trusted for read accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTR1 field. */
#define AIPS_RD_MPRA_MTR1(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTR1_MASK) >> AIPS_MPRA_MTR1_SHIFT)
#define AIPS_BRD_MPRA_MTR1(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR1_SHIFT))

/*! @brief Set the MTR1 field to a new value. */
#define AIPS_WR_MPRA_MTR1(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTR1_MASK, AIPS_MPRA_MTR1(value)))
#define AIPS_BWR_MPRA_MTR1(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MPL0[28] (RW)
 *
 * Specifies how the privilege level of the master is determined.
 *
 * Values:
 * - 0b0 - Accesses from this master are forced to user-mode.
 * - 0b1 - Accesses from this master are not forced to user-mode.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MPL0 field. */
#define AIPS_RD_MPRA_MPL0(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MPL0_MASK) >> AIPS_MPRA_MPL0_SHIFT)
#define AIPS_BRD_MPRA_MPL0(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL0_SHIFT))

/*! @brief Set the MPL0 field to a new value. */
#define AIPS_WR_MPRA_MPL0(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MPL0_MASK, AIPS_MPRA_MPL0(value)))
#define AIPS_BWR_MPRA_MPL0(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MPL0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTW0[29] (RW)
 *
 * Determines whether the master is trusted for write accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for write accesses.
 * - 0b1 - This master is trusted for write accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTW0 field. */
#define AIPS_RD_MPRA_MTW0(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTW0_MASK) >> AIPS_MPRA_MTW0_SHIFT)
#define AIPS_BRD_MPRA_MTW0(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW0_SHIFT))

/*! @brief Set the MTW0 field to a new value. */
#define AIPS_WR_MPRA_MTW0(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTW0_MASK, AIPS_MPRA_MTW0(value)))
#define AIPS_BWR_MPRA_MTW0(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTW0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_MPRA, field MTR0[30] (RW)
 *
 * Determines whether the master is trusted for read accesses.
 *
 * Values:
 * - 0b0 - This master is not trusted for read accesses.
 * - 0b1 - This master is trusted for read accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_MPRA_MTR0 field. */
#define AIPS_RD_MPRA_MTR0(base) ((AIPS_MPRA_REG(base) & AIPS_MPRA_MTR0_MASK) >> AIPS_MPRA_MTR0_SHIFT)
#define AIPS_BRD_MPRA_MTR0(base) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR0_SHIFT))

/*! @brief Set the MTR0 field to a new value. */
#define AIPS_WR_MPRA_MTR0(base, value) (AIPS_RMW_MPRA(base, AIPS_MPRA_MTR0_MASK, AIPS_MPRA_MTR0(value)))
#define AIPS_BWR_MPRA_MTR0(base, value) (BITBAND_ACCESS32(&AIPS_MPRA_REG(base), AIPS_MPRA_MTR0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRA - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRA - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x50004000U
 *
 * Each PACR register consists of eight 4-bit PACR fields. Each PACR field
 * defines the access levels for a particular peripheral. The mapping between a
 * peripheral and its PACR field is shown in the table below. The peripheral assignment
 * to each PACR is defined by the memory map slot that the peripheral is
 * assigned to. See this chip's memory map for the assignment of a particular
 * peripheral. The following table shows the location of each peripheral slot's PACR field
 * in the PACR registers. Offset Register [31:28] [27:24] [23:20] [19:16] [15:12]
 * [11:8] [7:4] [3:0] 0x20 PACRA PACR0 PACR1 PACR2 PACR3 PACR4 PACR5 PACR6 PACR7
 * 0x24 PACRB PACR8 PACR9 PACR10 PACR11 PACR12 PACR13 PACR14 PACR15 0x28 PACRC
 * PACR16 PACR17 PACR18 PACR19 PACR20 PACR21 PACR22 PACR23 0x2C PACRD PACR24
 * PACR25 PACR26 PACR27 PACR28 PACR29 PACR30 PACR31 0x30 Reserved 0x34 Reserved 0x38
 * Reserved 0x3C Reserved 0x40 PACRE PACR32 PACR33 PACR34 PACR35 PACR36 PACR37
 * PACR38 PACR39 0x44 PACRF PACR40 PACR41 PACR42 PACR43 PACR44 PACR45 PACR46 PACR47
 * 0x48 PACRG PACR48 PACR49 PACR50 PACR51 PACR52 PACR53 PACR54 PACR55 0x4C PACRH
 * PACR56 PACR57 PACR58 PACR59 PACR60 PACR61 PACR62 PACR63 0x50 PACRI PACR64
 * PACR65 PACR66 PACR67 PACR68 PACR69 PACR70 PACR71 0x54 PACRJ PACR72 PACR73 PACR74
 * PACR75 PACR76 PACR77 PACR78 PACR79 0x58 PACRK PACR80 PACR81 PACR82 PACR83
 * PACR84 PACR85 PACR86 PACR87 0x5C PACRL PACR88 PACR89 PACR90 PACR91 PACR92 PACR93
 * PACR94 PACR95 0x60 PACRM PACR96 PACR97 PACR98 PACR99 PACR100 PACR101 PACR102
 * PACR103 0x64 PACRN PACR104 PACR105 PACR106 PACR107 PACR108 PACR109 PACR110
 * PACR111 0x68 PACRO PACR112 PACR113 PACR114 PACR115 PACR116 PACR117 PACR118 PACR119
 * 0x6C PACRP PACR120 PACR121 PACR122 PACR123 PACR124 PACR125 PACR126 PACR127 0x80
 * PACRU PACR GBL0 PACR GBL1 Reserved The register field descriptions for PACR
 * A-D, which control peripheral slots 0-31, are shown below. The following
 * section, PACRPeripheral Access Control Register , shows the register field
 * descriptions for PACR E-P. All PACR registers are identical. They are divided into two
 * sections because they occupy two non-contiguous address spaces.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRA register
 */
/*@{*/
#define AIPS_RD_PACRA(base)      (AIPS_PACRA_REG(base))
#define AIPS_WR_PACRA(base, value) (AIPS_PACRA_REG(base) = (value))
#define AIPS_RMW_PACRA(base, mask, value) (AIPS_WR_PACRA(base, (AIPS_RD_PACRA(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRA(base, value) (AIPS_WR_PACRA(base, AIPS_RD_PACRA(base) |  (value)))
#define AIPS_CLR_PACRA(base, value) (AIPS_WR_PACRA(base, AIPS_RD_PACRA(base) & ~(value)))
#define AIPS_TOG_PACRA(base, value) (AIPS_WR_PACRA(base, AIPS_RD_PACRA(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRA bitfields
 */

/*!
 * @name Register AIPS_PACRA, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_TP7 field. */
#define AIPS_RD_PACRA_TP7(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_TP7_MASK) >> AIPS_PACRA_TP7_SHIFT)
#define AIPS_BRD_PACRA_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRA_TP7(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_TP7_MASK, AIPS_PACRA_TP7(value)))
#define AIPS_BWR_PACRA_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_WP7 field. */
#define AIPS_RD_PACRA_WP7(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_WP7_MASK) >> AIPS_PACRA_WP7_SHIFT)
#define AIPS_BRD_PACRA_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRA_WP7(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_WP7_MASK, AIPS_PACRA_WP7(value)))
#define AIPS_BWR_PACRA_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_SP7 field. */
#define AIPS_RD_PACRA_SP7(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_SP7_MASK) >> AIPS_PACRA_SP7_SHIFT)
#define AIPS_BRD_PACRA_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRA_SP7(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_SP7_MASK, AIPS_PACRA_SP7(value)))
#define AIPS_BWR_PACRA_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_TP6 field. */
#define AIPS_RD_PACRA_TP6(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_TP6_MASK) >> AIPS_PACRA_TP6_SHIFT)
#define AIPS_BRD_PACRA_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRA_TP6(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_TP6_MASK, AIPS_PACRA_TP6(value)))
#define AIPS_BWR_PACRA_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_WP6 field. */
#define AIPS_RD_PACRA_WP6(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_WP6_MASK) >> AIPS_PACRA_WP6_SHIFT)
#define AIPS_BRD_PACRA_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRA_WP6(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_WP6_MASK, AIPS_PACRA_WP6(value)))
#define AIPS_BWR_PACRA_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_SP6 field. */
#define AIPS_RD_PACRA_SP6(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_SP6_MASK) >> AIPS_PACRA_SP6_SHIFT)
#define AIPS_BRD_PACRA_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRA_SP6(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_SP6_MASK, AIPS_PACRA_SP6(value)))
#define AIPS_BWR_PACRA_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_TP5 field. */
#define AIPS_RD_PACRA_TP5(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_TP5_MASK) >> AIPS_PACRA_TP5_SHIFT)
#define AIPS_BRD_PACRA_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRA_TP5(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_TP5_MASK, AIPS_PACRA_TP5(value)))
#define AIPS_BWR_PACRA_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_WP5 field. */
#define AIPS_RD_PACRA_WP5(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_WP5_MASK) >> AIPS_PACRA_WP5_SHIFT)
#define AIPS_BRD_PACRA_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRA_WP5(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_WP5_MASK, AIPS_PACRA_WP5(value)))
#define AIPS_BWR_PACRA_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_SP5 field. */
#define AIPS_RD_PACRA_SP5(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_SP5_MASK) >> AIPS_PACRA_SP5_SHIFT)
#define AIPS_BRD_PACRA_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRA_SP5(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_SP5_MASK, AIPS_PACRA_SP5(value)))
#define AIPS_BWR_PACRA_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_TP4 field. */
#define AIPS_RD_PACRA_TP4(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_TP4_MASK) >> AIPS_PACRA_TP4_SHIFT)
#define AIPS_BRD_PACRA_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRA_TP4(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_TP4_MASK, AIPS_PACRA_TP4(value)))
#define AIPS_BWR_PACRA_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_WP4 field. */
#define AIPS_RD_PACRA_WP4(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_WP4_MASK) >> AIPS_PACRA_WP4_SHIFT)
#define AIPS_BRD_PACRA_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRA_WP4(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_WP4_MASK, AIPS_PACRA_WP4(value)))
#define AIPS_BWR_PACRA_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_SP4 field. */
#define AIPS_RD_PACRA_SP4(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_SP4_MASK) >> AIPS_PACRA_SP4_SHIFT)
#define AIPS_BRD_PACRA_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRA_SP4(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_SP4_MASK, AIPS_PACRA_SP4(value)))
#define AIPS_BWR_PACRA_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_TP3 field. */
#define AIPS_RD_PACRA_TP3(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_TP3_MASK) >> AIPS_PACRA_TP3_SHIFT)
#define AIPS_BRD_PACRA_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRA_TP3(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_TP3_MASK, AIPS_PACRA_TP3(value)))
#define AIPS_BWR_PACRA_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_WP3 field. */
#define AIPS_RD_PACRA_WP3(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_WP3_MASK) >> AIPS_PACRA_WP3_SHIFT)
#define AIPS_BRD_PACRA_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRA_WP3(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_WP3_MASK, AIPS_PACRA_WP3(value)))
#define AIPS_BWR_PACRA_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_SP3 field. */
#define AIPS_RD_PACRA_SP3(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_SP3_MASK) >> AIPS_PACRA_SP3_SHIFT)
#define AIPS_BRD_PACRA_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRA_SP3(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_SP3_MASK, AIPS_PACRA_SP3(value)))
#define AIPS_BWR_PACRA_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_TP2 field. */
#define AIPS_RD_PACRA_TP2(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_TP2_MASK) >> AIPS_PACRA_TP2_SHIFT)
#define AIPS_BRD_PACRA_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRA_TP2(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_TP2_MASK, AIPS_PACRA_TP2(value)))
#define AIPS_BWR_PACRA_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_WP2 field. */
#define AIPS_RD_PACRA_WP2(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_WP2_MASK) >> AIPS_PACRA_WP2_SHIFT)
#define AIPS_BRD_PACRA_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRA_WP2(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_WP2_MASK, AIPS_PACRA_WP2(value)))
#define AIPS_BWR_PACRA_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_SP2 field. */
#define AIPS_RD_PACRA_SP2(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_SP2_MASK) >> AIPS_PACRA_SP2_SHIFT)
#define AIPS_BRD_PACRA_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRA_SP2(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_SP2_MASK, AIPS_PACRA_SP2(value)))
#define AIPS_BWR_PACRA_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_TP1 field. */
#define AIPS_RD_PACRA_TP1(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_TP1_MASK) >> AIPS_PACRA_TP1_SHIFT)
#define AIPS_BRD_PACRA_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRA_TP1(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_TP1_MASK, AIPS_PACRA_TP1(value)))
#define AIPS_BWR_PACRA_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_WP1 field. */
#define AIPS_RD_PACRA_WP1(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_WP1_MASK) >> AIPS_PACRA_WP1_SHIFT)
#define AIPS_BRD_PACRA_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRA_WP1(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_WP1_MASK, AIPS_PACRA_WP1(value)))
#define AIPS_BWR_PACRA_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_SP1 field. */
#define AIPS_RD_PACRA_SP1(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_SP1_MASK) >> AIPS_PACRA_SP1_SHIFT)
#define AIPS_BRD_PACRA_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRA_SP1(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_SP1_MASK, AIPS_PACRA_SP1(value)))
#define AIPS_BWR_PACRA_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_TP0 field. */
#define AIPS_RD_PACRA_TP0(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_TP0_MASK) >> AIPS_PACRA_TP0_SHIFT)
#define AIPS_BRD_PACRA_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRA_TP0(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_TP0_MASK, AIPS_PACRA_TP0(value)))
#define AIPS_BWR_PACRA_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_WP0 field. */
#define AIPS_RD_PACRA_WP0(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_WP0_MASK) >> AIPS_PACRA_WP0_SHIFT)
#define AIPS_BRD_PACRA_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRA_WP0(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_WP0_MASK, AIPS_PACRA_WP0(value)))
#define AIPS_BWR_PACRA_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRA, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRA_SP0 field. */
#define AIPS_RD_PACRA_SP0(base) ((AIPS_PACRA_REG(base) & AIPS_PACRA_SP0_MASK) >> AIPS_PACRA_SP0_SHIFT)
#define AIPS_BRD_PACRA_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRA_SP0(base, value) (AIPS_RMW_PACRA(base, AIPS_PACRA_SP0_MASK, AIPS_PACRA_SP0(value)))
#define AIPS_BWR_PACRA_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRA_REG(base), AIPS_PACRA_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRB - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRB - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44004400U
 *
 * Each PACR register consists of eight 4-bit PACR fields. Each PACR field
 * defines the access levels for a particular peripheral. The mapping between a
 * peripheral and its PACR field is shown in the table below. The peripheral assignment
 * to each PACR is defined by the memory map slot that the peripheral is
 * assigned to. See this chip's memory map for the assignment of a particular
 * peripheral. The following table shows the location of each peripheral slot's PACR field
 * in the PACR registers. Offset Register [31:28] [27:24] [23:20] [19:16] [15:12]
 * [11:8] [7:4] [3:0] 0x20 PACRA PACR0 PACR1 PACR2 PACR3 PACR4 PACR5 PACR6 PACR7
 * 0x24 PACRB PACR8 PACR9 PACR10 PACR11 PACR12 PACR13 PACR14 PACR15 0x28 PACRC
 * PACR16 PACR17 PACR18 PACR19 PACR20 PACR21 PACR22 PACR23 0x2C PACRD PACR24
 * PACR25 PACR26 PACR27 PACR28 PACR29 PACR30 PACR31 0x30 Reserved 0x34 Reserved 0x38
 * Reserved 0x3C Reserved 0x40 PACRE PACR32 PACR33 PACR34 PACR35 PACR36 PACR37
 * PACR38 PACR39 0x44 PACRF PACR40 PACR41 PACR42 PACR43 PACR44 PACR45 PACR46 PACR47
 * 0x48 PACRG PACR48 PACR49 PACR50 PACR51 PACR52 PACR53 PACR54 PACR55 0x4C PACRH
 * PACR56 PACR57 PACR58 PACR59 PACR60 PACR61 PACR62 PACR63 0x50 PACRI PACR64
 * PACR65 PACR66 PACR67 PACR68 PACR69 PACR70 PACR71 0x54 PACRJ PACR72 PACR73 PACR74
 * PACR75 PACR76 PACR77 PACR78 PACR79 0x58 PACRK PACR80 PACR81 PACR82 PACR83
 * PACR84 PACR85 PACR86 PACR87 0x5C PACRL PACR88 PACR89 PACR90 PACR91 PACR92 PACR93
 * PACR94 PACR95 0x60 PACRM PACR96 PACR97 PACR98 PACR99 PACR100 PACR101 PACR102
 * PACR103 0x64 PACRN PACR104 PACR105 PACR106 PACR107 PACR108 PACR109 PACR110
 * PACR111 0x68 PACRO PACR112 PACR113 PACR114 PACR115 PACR116 PACR117 PACR118 PACR119
 * 0x6C PACRP PACR120 PACR121 PACR122 PACR123 PACR124 PACR125 PACR126 PACR127 0x80
 * PACRU PACR GBL0 PACR GBL1 Reserved The register field descriptions for PACR
 * A-D, which control peripheral slots 0-31, are shown below. The following
 * section, PACRPeripheral Access Control Register , shows the register field
 * descriptions for PACR E-P. All PACR registers are identical. They are divided into two
 * sections because they occupy two non-contiguous address spaces.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRB register
 */
/*@{*/
#define AIPS_RD_PACRB(base)      (AIPS_PACRB_REG(base))
#define AIPS_WR_PACRB(base, value) (AIPS_PACRB_REG(base) = (value))
#define AIPS_RMW_PACRB(base, mask, value) (AIPS_WR_PACRB(base, (AIPS_RD_PACRB(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRB(base, value) (AIPS_WR_PACRB(base, AIPS_RD_PACRB(base) |  (value)))
#define AIPS_CLR_PACRB(base, value) (AIPS_WR_PACRB(base, AIPS_RD_PACRB(base) & ~(value)))
#define AIPS_TOG_PACRB(base, value) (AIPS_WR_PACRB(base, AIPS_RD_PACRB(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRB bitfields
 */

/*!
 * @name Register AIPS_PACRB, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_TP7 field. */
#define AIPS_RD_PACRB_TP7(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_TP7_MASK) >> AIPS_PACRB_TP7_SHIFT)
#define AIPS_BRD_PACRB_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRB_TP7(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_TP7_MASK, AIPS_PACRB_TP7(value)))
#define AIPS_BWR_PACRB_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_WP7 field. */
#define AIPS_RD_PACRB_WP7(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_WP7_MASK) >> AIPS_PACRB_WP7_SHIFT)
#define AIPS_BRD_PACRB_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRB_WP7(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_WP7_MASK, AIPS_PACRB_WP7(value)))
#define AIPS_BWR_PACRB_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_SP7 field. */
#define AIPS_RD_PACRB_SP7(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_SP7_MASK) >> AIPS_PACRB_SP7_SHIFT)
#define AIPS_BRD_PACRB_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRB_SP7(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_SP7_MASK, AIPS_PACRB_SP7(value)))
#define AIPS_BWR_PACRB_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_TP6 field. */
#define AIPS_RD_PACRB_TP6(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_TP6_MASK) >> AIPS_PACRB_TP6_SHIFT)
#define AIPS_BRD_PACRB_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRB_TP6(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_TP6_MASK, AIPS_PACRB_TP6(value)))
#define AIPS_BWR_PACRB_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_WP6 field. */
#define AIPS_RD_PACRB_WP6(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_WP6_MASK) >> AIPS_PACRB_WP6_SHIFT)
#define AIPS_BRD_PACRB_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRB_WP6(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_WP6_MASK, AIPS_PACRB_WP6(value)))
#define AIPS_BWR_PACRB_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_SP6 field. */
#define AIPS_RD_PACRB_SP6(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_SP6_MASK) >> AIPS_PACRB_SP6_SHIFT)
#define AIPS_BRD_PACRB_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRB_SP6(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_SP6_MASK, AIPS_PACRB_SP6(value)))
#define AIPS_BWR_PACRB_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_TP5 field. */
#define AIPS_RD_PACRB_TP5(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_TP5_MASK) >> AIPS_PACRB_TP5_SHIFT)
#define AIPS_BRD_PACRB_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRB_TP5(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_TP5_MASK, AIPS_PACRB_TP5(value)))
#define AIPS_BWR_PACRB_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_WP5 field. */
#define AIPS_RD_PACRB_WP5(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_WP5_MASK) >> AIPS_PACRB_WP5_SHIFT)
#define AIPS_BRD_PACRB_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRB_WP5(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_WP5_MASK, AIPS_PACRB_WP5(value)))
#define AIPS_BWR_PACRB_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_SP5 field. */
#define AIPS_RD_PACRB_SP5(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_SP5_MASK) >> AIPS_PACRB_SP5_SHIFT)
#define AIPS_BRD_PACRB_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRB_SP5(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_SP5_MASK, AIPS_PACRB_SP5(value)))
#define AIPS_BWR_PACRB_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_TP4 field. */
#define AIPS_RD_PACRB_TP4(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_TP4_MASK) >> AIPS_PACRB_TP4_SHIFT)
#define AIPS_BRD_PACRB_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRB_TP4(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_TP4_MASK, AIPS_PACRB_TP4(value)))
#define AIPS_BWR_PACRB_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_WP4 field. */
#define AIPS_RD_PACRB_WP4(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_WP4_MASK) >> AIPS_PACRB_WP4_SHIFT)
#define AIPS_BRD_PACRB_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRB_WP4(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_WP4_MASK, AIPS_PACRB_WP4(value)))
#define AIPS_BWR_PACRB_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_SP4 field. */
#define AIPS_RD_PACRB_SP4(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_SP4_MASK) >> AIPS_PACRB_SP4_SHIFT)
#define AIPS_BRD_PACRB_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRB_SP4(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_SP4_MASK, AIPS_PACRB_SP4(value)))
#define AIPS_BWR_PACRB_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_TP3 field. */
#define AIPS_RD_PACRB_TP3(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_TP3_MASK) >> AIPS_PACRB_TP3_SHIFT)
#define AIPS_BRD_PACRB_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRB_TP3(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_TP3_MASK, AIPS_PACRB_TP3(value)))
#define AIPS_BWR_PACRB_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_WP3 field. */
#define AIPS_RD_PACRB_WP3(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_WP3_MASK) >> AIPS_PACRB_WP3_SHIFT)
#define AIPS_BRD_PACRB_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRB_WP3(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_WP3_MASK, AIPS_PACRB_WP3(value)))
#define AIPS_BWR_PACRB_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_SP3 field. */
#define AIPS_RD_PACRB_SP3(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_SP3_MASK) >> AIPS_PACRB_SP3_SHIFT)
#define AIPS_BRD_PACRB_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRB_SP3(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_SP3_MASK, AIPS_PACRB_SP3(value)))
#define AIPS_BWR_PACRB_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_TP2 field. */
#define AIPS_RD_PACRB_TP2(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_TP2_MASK) >> AIPS_PACRB_TP2_SHIFT)
#define AIPS_BRD_PACRB_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRB_TP2(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_TP2_MASK, AIPS_PACRB_TP2(value)))
#define AIPS_BWR_PACRB_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_WP2 field. */
#define AIPS_RD_PACRB_WP2(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_WP2_MASK) >> AIPS_PACRB_WP2_SHIFT)
#define AIPS_BRD_PACRB_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRB_WP2(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_WP2_MASK, AIPS_PACRB_WP2(value)))
#define AIPS_BWR_PACRB_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_SP2 field. */
#define AIPS_RD_PACRB_SP2(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_SP2_MASK) >> AIPS_PACRB_SP2_SHIFT)
#define AIPS_BRD_PACRB_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRB_SP2(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_SP2_MASK, AIPS_PACRB_SP2(value)))
#define AIPS_BWR_PACRB_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_TP1 field. */
#define AIPS_RD_PACRB_TP1(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_TP1_MASK) >> AIPS_PACRB_TP1_SHIFT)
#define AIPS_BRD_PACRB_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRB_TP1(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_TP1_MASK, AIPS_PACRB_TP1(value)))
#define AIPS_BWR_PACRB_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_WP1 field. */
#define AIPS_RD_PACRB_WP1(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_WP1_MASK) >> AIPS_PACRB_WP1_SHIFT)
#define AIPS_BRD_PACRB_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRB_WP1(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_WP1_MASK, AIPS_PACRB_WP1(value)))
#define AIPS_BWR_PACRB_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_SP1 field. */
#define AIPS_RD_PACRB_SP1(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_SP1_MASK) >> AIPS_PACRB_SP1_SHIFT)
#define AIPS_BRD_PACRB_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRB_SP1(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_SP1_MASK, AIPS_PACRB_SP1(value)))
#define AIPS_BWR_PACRB_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_TP0 field. */
#define AIPS_RD_PACRB_TP0(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_TP0_MASK) >> AIPS_PACRB_TP0_SHIFT)
#define AIPS_BRD_PACRB_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRB_TP0(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_TP0_MASK, AIPS_PACRB_TP0(value)))
#define AIPS_BWR_PACRB_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_WP0 field. */
#define AIPS_RD_PACRB_WP0(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_WP0_MASK) >> AIPS_PACRB_WP0_SHIFT)
#define AIPS_BRD_PACRB_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRB_WP0(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_WP0_MASK, AIPS_PACRB_WP0(value)))
#define AIPS_BWR_PACRB_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRB, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRB_SP0 field. */
#define AIPS_RD_PACRB_SP0(base) ((AIPS_PACRB_REG(base) & AIPS_PACRB_SP0_MASK) >> AIPS_PACRB_SP0_SHIFT)
#define AIPS_BRD_PACRB_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRB_SP0(base, value) (AIPS_RMW_PACRB(base, AIPS_PACRB_SP0_MASK, AIPS_PACRB_SP0(value)))
#define AIPS_BWR_PACRB_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRB_REG(base), AIPS_PACRB_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRC - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRC - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * Each PACR register consists of eight 4-bit PACR fields. Each PACR field
 * defines the access levels for a particular peripheral. The mapping between a
 * peripheral and its PACR field is shown in the table below. The peripheral assignment
 * to each PACR is defined by the memory map slot that the peripheral is
 * assigned to. See this chip's memory map for the assignment of a particular
 * peripheral. The following table shows the location of each peripheral slot's PACR field
 * in the PACR registers. Offset Register [31:28] [27:24] [23:20] [19:16] [15:12]
 * [11:8] [7:4] [3:0] 0x20 PACRA PACR0 PACR1 PACR2 PACR3 PACR4 PACR5 PACR6 PACR7
 * 0x24 PACRB PACR8 PACR9 PACR10 PACR11 PACR12 PACR13 PACR14 PACR15 0x28 PACRC
 * PACR16 PACR17 PACR18 PACR19 PACR20 PACR21 PACR22 PACR23 0x2C PACRD PACR24
 * PACR25 PACR26 PACR27 PACR28 PACR29 PACR30 PACR31 0x30 Reserved 0x34 Reserved 0x38
 * Reserved 0x3C Reserved 0x40 PACRE PACR32 PACR33 PACR34 PACR35 PACR36 PACR37
 * PACR38 PACR39 0x44 PACRF PACR40 PACR41 PACR42 PACR43 PACR44 PACR45 PACR46 PACR47
 * 0x48 PACRG PACR48 PACR49 PACR50 PACR51 PACR52 PACR53 PACR54 PACR55 0x4C PACRH
 * PACR56 PACR57 PACR58 PACR59 PACR60 PACR61 PACR62 PACR63 0x50 PACRI PACR64
 * PACR65 PACR66 PACR67 PACR68 PACR69 PACR70 PACR71 0x54 PACRJ PACR72 PACR73 PACR74
 * PACR75 PACR76 PACR77 PACR78 PACR79 0x58 PACRK PACR80 PACR81 PACR82 PACR83
 * PACR84 PACR85 PACR86 PACR87 0x5C PACRL PACR88 PACR89 PACR90 PACR91 PACR92 PACR93
 * PACR94 PACR95 0x60 PACRM PACR96 PACR97 PACR98 PACR99 PACR100 PACR101 PACR102
 * PACR103 0x64 PACRN PACR104 PACR105 PACR106 PACR107 PACR108 PACR109 PACR110
 * PACR111 0x68 PACRO PACR112 PACR113 PACR114 PACR115 PACR116 PACR117 PACR118 PACR119
 * 0x6C PACRP PACR120 PACR121 PACR122 PACR123 PACR124 PACR125 PACR126 PACR127 0x80
 * PACRU PACR GBL0 PACR GBL1 Reserved The register field descriptions for PACR
 * A-D, which control peripheral slots 0-31, are shown below. The following
 * section, PACRPeripheral Access Control Register , shows the register field
 * descriptions for PACR E-P. All PACR registers are identical. They are divided into two
 * sections because they occupy two non-contiguous address spaces.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRC register
 */
/*@{*/
#define AIPS_RD_PACRC(base)      (AIPS_PACRC_REG(base))
#define AIPS_WR_PACRC(base, value) (AIPS_PACRC_REG(base) = (value))
#define AIPS_RMW_PACRC(base, mask, value) (AIPS_WR_PACRC(base, (AIPS_RD_PACRC(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRC(base, value) (AIPS_WR_PACRC(base, AIPS_RD_PACRC(base) |  (value)))
#define AIPS_CLR_PACRC(base, value) (AIPS_WR_PACRC(base, AIPS_RD_PACRC(base) & ~(value)))
#define AIPS_TOG_PACRC(base, value) (AIPS_WR_PACRC(base, AIPS_RD_PACRC(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRC bitfields
 */

/*!
 * @name Register AIPS_PACRC, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_TP7 field. */
#define AIPS_RD_PACRC_TP7(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_TP7_MASK) >> AIPS_PACRC_TP7_SHIFT)
#define AIPS_BRD_PACRC_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRC_TP7(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_TP7_MASK, AIPS_PACRC_TP7(value)))
#define AIPS_BWR_PACRC_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_WP7 field. */
#define AIPS_RD_PACRC_WP7(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_WP7_MASK) >> AIPS_PACRC_WP7_SHIFT)
#define AIPS_BRD_PACRC_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRC_WP7(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_WP7_MASK, AIPS_PACRC_WP7(value)))
#define AIPS_BWR_PACRC_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_SP7 field. */
#define AIPS_RD_PACRC_SP7(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_SP7_MASK) >> AIPS_PACRC_SP7_SHIFT)
#define AIPS_BRD_PACRC_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRC_SP7(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_SP7_MASK, AIPS_PACRC_SP7(value)))
#define AIPS_BWR_PACRC_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_TP6 field. */
#define AIPS_RD_PACRC_TP6(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_TP6_MASK) >> AIPS_PACRC_TP6_SHIFT)
#define AIPS_BRD_PACRC_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRC_TP6(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_TP6_MASK, AIPS_PACRC_TP6(value)))
#define AIPS_BWR_PACRC_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_WP6 field. */
#define AIPS_RD_PACRC_WP6(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_WP6_MASK) >> AIPS_PACRC_WP6_SHIFT)
#define AIPS_BRD_PACRC_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRC_WP6(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_WP6_MASK, AIPS_PACRC_WP6(value)))
#define AIPS_BWR_PACRC_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_SP6 field. */
#define AIPS_RD_PACRC_SP6(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_SP6_MASK) >> AIPS_PACRC_SP6_SHIFT)
#define AIPS_BRD_PACRC_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRC_SP6(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_SP6_MASK, AIPS_PACRC_SP6(value)))
#define AIPS_BWR_PACRC_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_TP5 field. */
#define AIPS_RD_PACRC_TP5(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_TP5_MASK) >> AIPS_PACRC_TP5_SHIFT)
#define AIPS_BRD_PACRC_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRC_TP5(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_TP5_MASK, AIPS_PACRC_TP5(value)))
#define AIPS_BWR_PACRC_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_WP5 field. */
#define AIPS_RD_PACRC_WP5(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_WP5_MASK) >> AIPS_PACRC_WP5_SHIFT)
#define AIPS_BRD_PACRC_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRC_WP5(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_WP5_MASK, AIPS_PACRC_WP5(value)))
#define AIPS_BWR_PACRC_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_SP5 field. */
#define AIPS_RD_PACRC_SP5(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_SP5_MASK) >> AIPS_PACRC_SP5_SHIFT)
#define AIPS_BRD_PACRC_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRC_SP5(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_SP5_MASK, AIPS_PACRC_SP5(value)))
#define AIPS_BWR_PACRC_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_TP4 field. */
#define AIPS_RD_PACRC_TP4(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_TP4_MASK) >> AIPS_PACRC_TP4_SHIFT)
#define AIPS_BRD_PACRC_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRC_TP4(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_TP4_MASK, AIPS_PACRC_TP4(value)))
#define AIPS_BWR_PACRC_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_WP4 field. */
#define AIPS_RD_PACRC_WP4(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_WP4_MASK) >> AIPS_PACRC_WP4_SHIFT)
#define AIPS_BRD_PACRC_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRC_WP4(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_WP4_MASK, AIPS_PACRC_WP4(value)))
#define AIPS_BWR_PACRC_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_SP4 field. */
#define AIPS_RD_PACRC_SP4(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_SP4_MASK) >> AIPS_PACRC_SP4_SHIFT)
#define AIPS_BRD_PACRC_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRC_SP4(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_SP4_MASK, AIPS_PACRC_SP4(value)))
#define AIPS_BWR_PACRC_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_TP3 field. */
#define AIPS_RD_PACRC_TP3(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_TP3_MASK) >> AIPS_PACRC_TP3_SHIFT)
#define AIPS_BRD_PACRC_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRC_TP3(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_TP3_MASK, AIPS_PACRC_TP3(value)))
#define AIPS_BWR_PACRC_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_WP3 field. */
#define AIPS_RD_PACRC_WP3(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_WP3_MASK) >> AIPS_PACRC_WP3_SHIFT)
#define AIPS_BRD_PACRC_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRC_WP3(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_WP3_MASK, AIPS_PACRC_WP3(value)))
#define AIPS_BWR_PACRC_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_SP3 field. */
#define AIPS_RD_PACRC_SP3(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_SP3_MASK) >> AIPS_PACRC_SP3_SHIFT)
#define AIPS_BRD_PACRC_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRC_SP3(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_SP3_MASK, AIPS_PACRC_SP3(value)))
#define AIPS_BWR_PACRC_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_TP2 field. */
#define AIPS_RD_PACRC_TP2(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_TP2_MASK) >> AIPS_PACRC_TP2_SHIFT)
#define AIPS_BRD_PACRC_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRC_TP2(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_TP2_MASK, AIPS_PACRC_TP2(value)))
#define AIPS_BWR_PACRC_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_WP2 field. */
#define AIPS_RD_PACRC_WP2(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_WP2_MASK) >> AIPS_PACRC_WP2_SHIFT)
#define AIPS_BRD_PACRC_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRC_WP2(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_WP2_MASK, AIPS_PACRC_WP2(value)))
#define AIPS_BWR_PACRC_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_SP2 field. */
#define AIPS_RD_PACRC_SP2(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_SP2_MASK) >> AIPS_PACRC_SP2_SHIFT)
#define AIPS_BRD_PACRC_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRC_SP2(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_SP2_MASK, AIPS_PACRC_SP2(value)))
#define AIPS_BWR_PACRC_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_TP1 field. */
#define AIPS_RD_PACRC_TP1(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_TP1_MASK) >> AIPS_PACRC_TP1_SHIFT)
#define AIPS_BRD_PACRC_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRC_TP1(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_TP1_MASK, AIPS_PACRC_TP1(value)))
#define AIPS_BWR_PACRC_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_WP1 field. */
#define AIPS_RD_PACRC_WP1(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_WP1_MASK) >> AIPS_PACRC_WP1_SHIFT)
#define AIPS_BRD_PACRC_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRC_WP1(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_WP1_MASK, AIPS_PACRC_WP1(value)))
#define AIPS_BWR_PACRC_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_SP1 field. */
#define AIPS_RD_PACRC_SP1(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_SP1_MASK) >> AIPS_PACRC_SP1_SHIFT)
#define AIPS_BRD_PACRC_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRC_SP1(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_SP1_MASK, AIPS_PACRC_SP1(value)))
#define AIPS_BWR_PACRC_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_TP0 field. */
#define AIPS_RD_PACRC_TP0(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_TP0_MASK) >> AIPS_PACRC_TP0_SHIFT)
#define AIPS_BRD_PACRC_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRC_TP0(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_TP0_MASK, AIPS_PACRC_TP0(value)))
#define AIPS_BWR_PACRC_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_WP0 field. */
#define AIPS_RD_PACRC_WP0(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_WP0_MASK) >> AIPS_PACRC_WP0_SHIFT)
#define AIPS_BRD_PACRC_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRC_WP0(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_WP0_MASK, AIPS_PACRC_WP0(value)))
#define AIPS_BWR_PACRC_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRC, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRC_SP0 field. */
#define AIPS_RD_PACRC_SP0(base) ((AIPS_PACRC_REG(base) & AIPS_PACRC_SP0_MASK) >> AIPS_PACRC_SP0_SHIFT)
#define AIPS_BRD_PACRC_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRC_SP0(base, value) (AIPS_RMW_PACRC(base, AIPS_PACRC_SP0_MASK, AIPS_PACRC_SP0(value)))
#define AIPS_BWR_PACRC_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRC_REG(base), AIPS_PACRC_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRD - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRD - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x00000004U
 *
 * Each PACR register consists of eight 4-bit PACR fields. Each PACR field
 * defines the access levels for a particular peripheral. The mapping between a
 * peripheral and its PACR field is shown in the table below. The peripheral assignment
 * to each PACR is defined by the memory map slot that the peripheral is
 * assigned to. See this chip's memory map for the assignment of a particular
 * peripheral. The following table shows the location of each peripheral slot's PACR field
 * in the PACR registers. Offset Register [31:28] [27:24] [23:20] [19:16] [15:12]
 * [11:8] [7:4] [3:0] 0x20 PACRA PACR0 PACR1 PACR2 PACR3 PACR4 PACR5 PACR6 PACR7
 * 0x24 PACRB PACR8 PACR9 PACR10 PACR11 PACR12 PACR13 PACR14 PACR15 0x28 PACRC
 * PACR16 PACR17 PACR18 PACR19 PACR20 PACR21 PACR22 PACR23 0x2C PACRD PACR24
 * PACR25 PACR26 PACR27 PACR28 PACR29 PACR30 PACR31 0x30 Reserved 0x34 Reserved 0x38
 * Reserved 0x3C Reserved 0x40 PACRE PACR32 PACR33 PACR34 PACR35 PACR36 PACR37
 * PACR38 PACR39 0x44 PACRF PACR40 PACR41 PACR42 PACR43 PACR44 PACR45 PACR46 PACR47
 * 0x48 PACRG PACR48 PACR49 PACR50 PACR51 PACR52 PACR53 PACR54 PACR55 0x4C PACRH
 * PACR56 PACR57 PACR58 PACR59 PACR60 PACR61 PACR62 PACR63 0x50 PACRI PACR64
 * PACR65 PACR66 PACR67 PACR68 PACR69 PACR70 PACR71 0x54 PACRJ PACR72 PACR73 PACR74
 * PACR75 PACR76 PACR77 PACR78 PACR79 0x58 PACRK PACR80 PACR81 PACR82 PACR83
 * PACR84 PACR85 PACR86 PACR87 0x5C PACRL PACR88 PACR89 PACR90 PACR91 PACR92 PACR93
 * PACR94 PACR95 0x60 PACRM PACR96 PACR97 PACR98 PACR99 PACR100 PACR101 PACR102
 * PACR103 0x64 PACRN PACR104 PACR105 PACR106 PACR107 PACR108 PACR109 PACR110
 * PACR111 0x68 PACRO PACR112 PACR113 PACR114 PACR115 PACR116 PACR117 PACR118 PACR119
 * 0x6C PACRP PACR120 PACR121 PACR122 PACR123 PACR124 PACR125 PACR126 PACR127 0x80
 * PACRU PACR GBL0 PACR GBL1 Reserved The register field descriptions for PACR
 * A-D, which control peripheral slots 0-31, are shown below. The following
 * section, PACRPeripheral Access Control Register , shows the register field
 * descriptions for PACR E-P. All PACR registers are identical. They are divided into two
 * sections because they occupy two non-contiguous address spaces.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRD register
 */
/*@{*/
#define AIPS_RD_PACRD(base)      (AIPS_PACRD_REG(base))
#define AIPS_WR_PACRD(base, value) (AIPS_PACRD_REG(base) = (value))
#define AIPS_RMW_PACRD(base, mask, value) (AIPS_WR_PACRD(base, (AIPS_RD_PACRD(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRD(base, value) (AIPS_WR_PACRD(base, AIPS_RD_PACRD(base) |  (value)))
#define AIPS_CLR_PACRD(base, value) (AIPS_WR_PACRD(base, AIPS_RD_PACRD(base) & ~(value)))
#define AIPS_TOG_PACRD(base, value) (AIPS_WR_PACRD(base, AIPS_RD_PACRD(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRD bitfields
 */

/*!
 * @name Register AIPS_PACRD, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_TP7 field. */
#define AIPS_RD_PACRD_TP7(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_TP7_MASK) >> AIPS_PACRD_TP7_SHIFT)
#define AIPS_BRD_PACRD_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRD_TP7(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_TP7_MASK, AIPS_PACRD_TP7(value)))
#define AIPS_BWR_PACRD_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_WP7 field. */
#define AIPS_RD_PACRD_WP7(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_WP7_MASK) >> AIPS_PACRD_WP7_SHIFT)
#define AIPS_BRD_PACRD_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRD_WP7(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_WP7_MASK, AIPS_PACRD_WP7(value)))
#define AIPS_BWR_PACRD_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_SP7 field. */
#define AIPS_RD_PACRD_SP7(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_SP7_MASK) >> AIPS_PACRD_SP7_SHIFT)
#define AIPS_BRD_PACRD_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRD_SP7(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_SP7_MASK, AIPS_PACRD_SP7(value)))
#define AIPS_BWR_PACRD_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_TP6 field. */
#define AIPS_RD_PACRD_TP6(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_TP6_MASK) >> AIPS_PACRD_TP6_SHIFT)
#define AIPS_BRD_PACRD_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRD_TP6(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_TP6_MASK, AIPS_PACRD_TP6(value)))
#define AIPS_BWR_PACRD_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_WP6 field. */
#define AIPS_RD_PACRD_WP6(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_WP6_MASK) >> AIPS_PACRD_WP6_SHIFT)
#define AIPS_BRD_PACRD_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRD_WP6(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_WP6_MASK, AIPS_PACRD_WP6(value)))
#define AIPS_BWR_PACRD_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_SP6 field. */
#define AIPS_RD_PACRD_SP6(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_SP6_MASK) >> AIPS_PACRD_SP6_SHIFT)
#define AIPS_BRD_PACRD_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRD_SP6(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_SP6_MASK, AIPS_PACRD_SP6(value)))
#define AIPS_BWR_PACRD_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_TP5 field. */
#define AIPS_RD_PACRD_TP5(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_TP5_MASK) >> AIPS_PACRD_TP5_SHIFT)
#define AIPS_BRD_PACRD_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRD_TP5(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_TP5_MASK, AIPS_PACRD_TP5(value)))
#define AIPS_BWR_PACRD_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_WP5 field. */
#define AIPS_RD_PACRD_WP5(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_WP5_MASK) >> AIPS_PACRD_WP5_SHIFT)
#define AIPS_BRD_PACRD_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRD_WP5(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_WP5_MASK, AIPS_PACRD_WP5(value)))
#define AIPS_BWR_PACRD_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_SP5 field. */
#define AIPS_RD_PACRD_SP5(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_SP5_MASK) >> AIPS_PACRD_SP5_SHIFT)
#define AIPS_BRD_PACRD_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRD_SP5(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_SP5_MASK, AIPS_PACRD_SP5(value)))
#define AIPS_BWR_PACRD_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_TP4 field. */
#define AIPS_RD_PACRD_TP4(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_TP4_MASK) >> AIPS_PACRD_TP4_SHIFT)
#define AIPS_BRD_PACRD_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRD_TP4(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_TP4_MASK, AIPS_PACRD_TP4(value)))
#define AIPS_BWR_PACRD_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_WP4 field. */
#define AIPS_RD_PACRD_WP4(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_WP4_MASK) >> AIPS_PACRD_WP4_SHIFT)
#define AIPS_BRD_PACRD_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRD_WP4(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_WP4_MASK, AIPS_PACRD_WP4(value)))
#define AIPS_BWR_PACRD_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_SP4 field. */
#define AIPS_RD_PACRD_SP4(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_SP4_MASK) >> AIPS_PACRD_SP4_SHIFT)
#define AIPS_BRD_PACRD_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRD_SP4(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_SP4_MASK, AIPS_PACRD_SP4(value)))
#define AIPS_BWR_PACRD_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_TP3 field. */
#define AIPS_RD_PACRD_TP3(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_TP3_MASK) >> AIPS_PACRD_TP3_SHIFT)
#define AIPS_BRD_PACRD_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRD_TP3(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_TP3_MASK, AIPS_PACRD_TP3(value)))
#define AIPS_BWR_PACRD_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_WP3 field. */
#define AIPS_RD_PACRD_WP3(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_WP3_MASK) >> AIPS_PACRD_WP3_SHIFT)
#define AIPS_BRD_PACRD_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRD_WP3(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_WP3_MASK, AIPS_PACRD_WP3(value)))
#define AIPS_BWR_PACRD_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_SP3 field. */
#define AIPS_RD_PACRD_SP3(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_SP3_MASK) >> AIPS_PACRD_SP3_SHIFT)
#define AIPS_BRD_PACRD_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRD_SP3(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_SP3_MASK, AIPS_PACRD_SP3(value)))
#define AIPS_BWR_PACRD_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_TP2 field. */
#define AIPS_RD_PACRD_TP2(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_TP2_MASK) >> AIPS_PACRD_TP2_SHIFT)
#define AIPS_BRD_PACRD_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRD_TP2(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_TP2_MASK, AIPS_PACRD_TP2(value)))
#define AIPS_BWR_PACRD_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_WP2 field. */
#define AIPS_RD_PACRD_WP2(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_WP2_MASK) >> AIPS_PACRD_WP2_SHIFT)
#define AIPS_BRD_PACRD_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRD_WP2(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_WP2_MASK, AIPS_PACRD_WP2(value)))
#define AIPS_BWR_PACRD_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_SP2 field. */
#define AIPS_RD_PACRD_SP2(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_SP2_MASK) >> AIPS_PACRD_SP2_SHIFT)
#define AIPS_BRD_PACRD_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRD_SP2(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_SP2_MASK, AIPS_PACRD_SP2(value)))
#define AIPS_BWR_PACRD_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_TP1 field. */
#define AIPS_RD_PACRD_TP1(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_TP1_MASK) >> AIPS_PACRD_TP1_SHIFT)
#define AIPS_BRD_PACRD_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRD_TP1(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_TP1_MASK, AIPS_PACRD_TP1(value)))
#define AIPS_BWR_PACRD_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_WP1 field. */
#define AIPS_RD_PACRD_WP1(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_WP1_MASK) >> AIPS_PACRD_WP1_SHIFT)
#define AIPS_BRD_PACRD_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRD_WP1(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_WP1_MASK, AIPS_PACRD_WP1(value)))
#define AIPS_BWR_PACRD_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_SP1 field. */
#define AIPS_RD_PACRD_SP1(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_SP1_MASK) >> AIPS_PACRD_SP1_SHIFT)
#define AIPS_BRD_PACRD_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRD_SP1(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_SP1_MASK, AIPS_PACRD_SP1(value)))
#define AIPS_BWR_PACRD_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_TP0 field. */
#define AIPS_RD_PACRD_TP0(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_TP0_MASK) >> AIPS_PACRD_TP0_SHIFT)
#define AIPS_BRD_PACRD_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRD_TP0(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_TP0_MASK, AIPS_PACRD_TP0(value)))
#define AIPS_BWR_PACRD_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_WP0 field. */
#define AIPS_RD_PACRD_WP0(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_WP0_MASK) >> AIPS_PACRD_WP0_SHIFT)
#define AIPS_BRD_PACRD_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRD_WP0(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_WP0_MASK, AIPS_PACRD_WP0(value)))
#define AIPS_BWR_PACRD_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRD, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRD_SP0 field. */
#define AIPS_RD_PACRD_SP0(base) ((AIPS_PACRD_REG(base) & AIPS_PACRD_SP0_MASK) >> AIPS_PACRD_SP0_SHIFT)
#define AIPS_BRD_PACRD_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRD_SP0(base, value) (AIPS_RMW_PACRD(base, AIPS_PACRD_SP0_MASK, AIPS_PACRD_SP0(value)))
#define AIPS_BWR_PACRD_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRD_REG(base), AIPS_PACRD_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRE - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRE - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRE register
 */
/*@{*/
#define AIPS_RD_PACRE(base)      (AIPS_PACRE_REG(base))
#define AIPS_WR_PACRE(base, value) (AIPS_PACRE_REG(base) = (value))
#define AIPS_RMW_PACRE(base, mask, value) (AIPS_WR_PACRE(base, (AIPS_RD_PACRE(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRE(base, value) (AIPS_WR_PACRE(base, AIPS_RD_PACRE(base) |  (value)))
#define AIPS_CLR_PACRE(base, value) (AIPS_WR_PACRE(base, AIPS_RD_PACRE(base) & ~(value)))
#define AIPS_TOG_PACRE(base, value) (AIPS_WR_PACRE(base, AIPS_RD_PACRE(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRE bitfields
 */

/*!
 * @name Register AIPS_PACRE, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_TP7 field. */
#define AIPS_RD_PACRE_TP7(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_TP7_MASK) >> AIPS_PACRE_TP7_SHIFT)
#define AIPS_BRD_PACRE_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRE_TP7(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_TP7_MASK, AIPS_PACRE_TP7(value)))
#define AIPS_BWR_PACRE_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_WP7 field. */
#define AIPS_RD_PACRE_WP7(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_WP7_MASK) >> AIPS_PACRE_WP7_SHIFT)
#define AIPS_BRD_PACRE_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRE_WP7(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_WP7_MASK, AIPS_PACRE_WP7(value)))
#define AIPS_BWR_PACRE_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_SP7 field. */
#define AIPS_RD_PACRE_SP7(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_SP7_MASK) >> AIPS_PACRE_SP7_SHIFT)
#define AIPS_BRD_PACRE_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRE_SP7(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_SP7_MASK, AIPS_PACRE_SP7(value)))
#define AIPS_BWR_PACRE_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_TP6 field. */
#define AIPS_RD_PACRE_TP6(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_TP6_MASK) >> AIPS_PACRE_TP6_SHIFT)
#define AIPS_BRD_PACRE_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRE_TP6(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_TP6_MASK, AIPS_PACRE_TP6(value)))
#define AIPS_BWR_PACRE_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_WP6 field. */
#define AIPS_RD_PACRE_WP6(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_WP6_MASK) >> AIPS_PACRE_WP6_SHIFT)
#define AIPS_BRD_PACRE_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRE_WP6(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_WP6_MASK, AIPS_PACRE_WP6(value)))
#define AIPS_BWR_PACRE_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_SP6 field. */
#define AIPS_RD_PACRE_SP6(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_SP6_MASK) >> AIPS_PACRE_SP6_SHIFT)
#define AIPS_BRD_PACRE_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRE_SP6(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_SP6_MASK, AIPS_PACRE_SP6(value)))
#define AIPS_BWR_PACRE_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_TP5 field. */
#define AIPS_RD_PACRE_TP5(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_TP5_MASK) >> AIPS_PACRE_TP5_SHIFT)
#define AIPS_BRD_PACRE_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRE_TP5(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_TP5_MASK, AIPS_PACRE_TP5(value)))
#define AIPS_BWR_PACRE_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_WP5 field. */
#define AIPS_RD_PACRE_WP5(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_WP5_MASK) >> AIPS_PACRE_WP5_SHIFT)
#define AIPS_BRD_PACRE_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRE_WP5(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_WP5_MASK, AIPS_PACRE_WP5(value)))
#define AIPS_BWR_PACRE_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_SP5 field. */
#define AIPS_RD_PACRE_SP5(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_SP5_MASK) >> AIPS_PACRE_SP5_SHIFT)
#define AIPS_BRD_PACRE_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRE_SP5(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_SP5_MASK, AIPS_PACRE_SP5(value)))
#define AIPS_BWR_PACRE_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_TP4 field. */
#define AIPS_RD_PACRE_TP4(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_TP4_MASK) >> AIPS_PACRE_TP4_SHIFT)
#define AIPS_BRD_PACRE_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRE_TP4(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_TP4_MASK, AIPS_PACRE_TP4(value)))
#define AIPS_BWR_PACRE_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_WP4 field. */
#define AIPS_RD_PACRE_WP4(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_WP4_MASK) >> AIPS_PACRE_WP4_SHIFT)
#define AIPS_BRD_PACRE_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRE_WP4(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_WP4_MASK, AIPS_PACRE_WP4(value)))
#define AIPS_BWR_PACRE_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_SP4 field. */
#define AIPS_RD_PACRE_SP4(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_SP4_MASK) >> AIPS_PACRE_SP4_SHIFT)
#define AIPS_BRD_PACRE_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRE_SP4(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_SP4_MASK, AIPS_PACRE_SP4(value)))
#define AIPS_BWR_PACRE_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_TP3 field. */
#define AIPS_RD_PACRE_TP3(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_TP3_MASK) >> AIPS_PACRE_TP3_SHIFT)
#define AIPS_BRD_PACRE_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRE_TP3(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_TP3_MASK, AIPS_PACRE_TP3(value)))
#define AIPS_BWR_PACRE_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_WP3 field. */
#define AIPS_RD_PACRE_WP3(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_WP3_MASK) >> AIPS_PACRE_WP3_SHIFT)
#define AIPS_BRD_PACRE_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRE_WP3(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_WP3_MASK, AIPS_PACRE_WP3(value)))
#define AIPS_BWR_PACRE_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_SP3 field. */
#define AIPS_RD_PACRE_SP3(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_SP3_MASK) >> AIPS_PACRE_SP3_SHIFT)
#define AIPS_BRD_PACRE_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRE_SP3(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_SP3_MASK, AIPS_PACRE_SP3(value)))
#define AIPS_BWR_PACRE_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_TP2 field. */
#define AIPS_RD_PACRE_TP2(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_TP2_MASK) >> AIPS_PACRE_TP2_SHIFT)
#define AIPS_BRD_PACRE_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRE_TP2(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_TP2_MASK, AIPS_PACRE_TP2(value)))
#define AIPS_BWR_PACRE_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_WP2 field. */
#define AIPS_RD_PACRE_WP2(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_WP2_MASK) >> AIPS_PACRE_WP2_SHIFT)
#define AIPS_BRD_PACRE_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRE_WP2(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_WP2_MASK, AIPS_PACRE_WP2(value)))
#define AIPS_BWR_PACRE_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_SP2 field. */
#define AIPS_RD_PACRE_SP2(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_SP2_MASK) >> AIPS_PACRE_SP2_SHIFT)
#define AIPS_BRD_PACRE_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRE_SP2(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_SP2_MASK, AIPS_PACRE_SP2(value)))
#define AIPS_BWR_PACRE_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_TP1 field. */
#define AIPS_RD_PACRE_TP1(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_TP1_MASK) >> AIPS_PACRE_TP1_SHIFT)
#define AIPS_BRD_PACRE_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRE_TP1(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_TP1_MASK, AIPS_PACRE_TP1(value)))
#define AIPS_BWR_PACRE_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_WP1 field. */
#define AIPS_RD_PACRE_WP1(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_WP1_MASK) >> AIPS_PACRE_WP1_SHIFT)
#define AIPS_BRD_PACRE_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRE_WP1(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_WP1_MASK, AIPS_PACRE_WP1(value)))
#define AIPS_BWR_PACRE_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_SP1 field. */
#define AIPS_RD_PACRE_SP1(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_SP1_MASK) >> AIPS_PACRE_SP1_SHIFT)
#define AIPS_BRD_PACRE_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRE_SP1(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_SP1_MASK, AIPS_PACRE_SP1(value)))
#define AIPS_BWR_PACRE_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_TP0 field. */
#define AIPS_RD_PACRE_TP0(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_TP0_MASK) >> AIPS_PACRE_TP0_SHIFT)
#define AIPS_BRD_PACRE_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRE_TP0(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_TP0_MASK, AIPS_PACRE_TP0(value)))
#define AIPS_BWR_PACRE_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_WP0 field. */
#define AIPS_RD_PACRE_WP0(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_WP0_MASK) >> AIPS_PACRE_WP0_SHIFT)
#define AIPS_BRD_PACRE_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRE_WP0(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_WP0_MASK, AIPS_PACRE_WP0(value)))
#define AIPS_BWR_PACRE_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRE, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRE_SP0 field. */
#define AIPS_RD_PACRE_SP0(base) ((AIPS_PACRE_REG(base) & AIPS_PACRE_SP0_MASK) >> AIPS_PACRE_SP0_SHIFT)
#define AIPS_BRD_PACRE_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRE_SP0(base, value) (AIPS_RMW_PACRE(base, AIPS_PACRE_SP0_MASK, AIPS_PACRE_SP0(value)))
#define AIPS_BWR_PACRE_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRE_REG(base), AIPS_PACRE_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRF - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRF - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRF register
 */
/*@{*/
#define AIPS_RD_PACRF(base)      (AIPS_PACRF_REG(base))
#define AIPS_WR_PACRF(base, value) (AIPS_PACRF_REG(base) = (value))
#define AIPS_RMW_PACRF(base, mask, value) (AIPS_WR_PACRF(base, (AIPS_RD_PACRF(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRF(base, value) (AIPS_WR_PACRF(base, AIPS_RD_PACRF(base) |  (value)))
#define AIPS_CLR_PACRF(base, value) (AIPS_WR_PACRF(base, AIPS_RD_PACRF(base) & ~(value)))
#define AIPS_TOG_PACRF(base, value) (AIPS_WR_PACRF(base, AIPS_RD_PACRF(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRF bitfields
 */

/*!
 * @name Register AIPS_PACRF, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_TP7 field. */
#define AIPS_RD_PACRF_TP7(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_TP7_MASK) >> AIPS_PACRF_TP7_SHIFT)
#define AIPS_BRD_PACRF_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRF_TP7(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_TP7_MASK, AIPS_PACRF_TP7(value)))
#define AIPS_BWR_PACRF_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_WP7 field. */
#define AIPS_RD_PACRF_WP7(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_WP7_MASK) >> AIPS_PACRF_WP7_SHIFT)
#define AIPS_BRD_PACRF_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRF_WP7(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_WP7_MASK, AIPS_PACRF_WP7(value)))
#define AIPS_BWR_PACRF_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_SP7 field. */
#define AIPS_RD_PACRF_SP7(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_SP7_MASK) >> AIPS_PACRF_SP7_SHIFT)
#define AIPS_BRD_PACRF_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRF_SP7(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_SP7_MASK, AIPS_PACRF_SP7(value)))
#define AIPS_BWR_PACRF_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_TP6 field. */
#define AIPS_RD_PACRF_TP6(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_TP6_MASK) >> AIPS_PACRF_TP6_SHIFT)
#define AIPS_BRD_PACRF_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRF_TP6(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_TP6_MASK, AIPS_PACRF_TP6(value)))
#define AIPS_BWR_PACRF_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_WP6 field. */
#define AIPS_RD_PACRF_WP6(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_WP6_MASK) >> AIPS_PACRF_WP6_SHIFT)
#define AIPS_BRD_PACRF_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRF_WP6(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_WP6_MASK, AIPS_PACRF_WP6(value)))
#define AIPS_BWR_PACRF_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_SP6 field. */
#define AIPS_RD_PACRF_SP6(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_SP6_MASK) >> AIPS_PACRF_SP6_SHIFT)
#define AIPS_BRD_PACRF_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRF_SP6(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_SP6_MASK, AIPS_PACRF_SP6(value)))
#define AIPS_BWR_PACRF_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_TP5 field. */
#define AIPS_RD_PACRF_TP5(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_TP5_MASK) >> AIPS_PACRF_TP5_SHIFT)
#define AIPS_BRD_PACRF_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRF_TP5(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_TP5_MASK, AIPS_PACRF_TP5(value)))
#define AIPS_BWR_PACRF_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_WP5 field. */
#define AIPS_RD_PACRF_WP5(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_WP5_MASK) >> AIPS_PACRF_WP5_SHIFT)
#define AIPS_BRD_PACRF_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRF_WP5(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_WP5_MASK, AIPS_PACRF_WP5(value)))
#define AIPS_BWR_PACRF_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_SP5 field. */
#define AIPS_RD_PACRF_SP5(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_SP5_MASK) >> AIPS_PACRF_SP5_SHIFT)
#define AIPS_BRD_PACRF_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRF_SP5(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_SP5_MASK, AIPS_PACRF_SP5(value)))
#define AIPS_BWR_PACRF_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_TP4 field. */
#define AIPS_RD_PACRF_TP4(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_TP4_MASK) >> AIPS_PACRF_TP4_SHIFT)
#define AIPS_BRD_PACRF_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRF_TP4(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_TP4_MASK, AIPS_PACRF_TP4(value)))
#define AIPS_BWR_PACRF_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_WP4 field. */
#define AIPS_RD_PACRF_WP4(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_WP4_MASK) >> AIPS_PACRF_WP4_SHIFT)
#define AIPS_BRD_PACRF_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRF_WP4(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_WP4_MASK, AIPS_PACRF_WP4(value)))
#define AIPS_BWR_PACRF_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_SP4 field. */
#define AIPS_RD_PACRF_SP4(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_SP4_MASK) >> AIPS_PACRF_SP4_SHIFT)
#define AIPS_BRD_PACRF_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRF_SP4(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_SP4_MASK, AIPS_PACRF_SP4(value)))
#define AIPS_BWR_PACRF_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_TP3 field. */
#define AIPS_RD_PACRF_TP3(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_TP3_MASK) >> AIPS_PACRF_TP3_SHIFT)
#define AIPS_BRD_PACRF_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRF_TP3(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_TP3_MASK, AIPS_PACRF_TP3(value)))
#define AIPS_BWR_PACRF_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_WP3 field. */
#define AIPS_RD_PACRF_WP3(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_WP3_MASK) >> AIPS_PACRF_WP3_SHIFT)
#define AIPS_BRD_PACRF_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRF_WP3(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_WP3_MASK, AIPS_PACRF_WP3(value)))
#define AIPS_BWR_PACRF_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_SP3 field. */
#define AIPS_RD_PACRF_SP3(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_SP3_MASK) >> AIPS_PACRF_SP3_SHIFT)
#define AIPS_BRD_PACRF_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRF_SP3(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_SP3_MASK, AIPS_PACRF_SP3(value)))
#define AIPS_BWR_PACRF_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_TP2 field. */
#define AIPS_RD_PACRF_TP2(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_TP2_MASK) >> AIPS_PACRF_TP2_SHIFT)
#define AIPS_BRD_PACRF_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRF_TP2(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_TP2_MASK, AIPS_PACRF_TP2(value)))
#define AIPS_BWR_PACRF_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_WP2 field. */
#define AIPS_RD_PACRF_WP2(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_WP2_MASK) >> AIPS_PACRF_WP2_SHIFT)
#define AIPS_BRD_PACRF_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRF_WP2(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_WP2_MASK, AIPS_PACRF_WP2(value)))
#define AIPS_BWR_PACRF_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_SP2 field. */
#define AIPS_RD_PACRF_SP2(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_SP2_MASK) >> AIPS_PACRF_SP2_SHIFT)
#define AIPS_BRD_PACRF_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRF_SP2(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_SP2_MASK, AIPS_PACRF_SP2(value)))
#define AIPS_BWR_PACRF_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_TP1 field. */
#define AIPS_RD_PACRF_TP1(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_TP1_MASK) >> AIPS_PACRF_TP1_SHIFT)
#define AIPS_BRD_PACRF_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRF_TP1(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_TP1_MASK, AIPS_PACRF_TP1(value)))
#define AIPS_BWR_PACRF_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_WP1 field. */
#define AIPS_RD_PACRF_WP1(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_WP1_MASK) >> AIPS_PACRF_WP1_SHIFT)
#define AIPS_BRD_PACRF_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRF_WP1(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_WP1_MASK, AIPS_PACRF_WP1(value)))
#define AIPS_BWR_PACRF_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_SP1 field. */
#define AIPS_RD_PACRF_SP1(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_SP1_MASK) >> AIPS_PACRF_SP1_SHIFT)
#define AIPS_BRD_PACRF_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRF_SP1(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_SP1_MASK, AIPS_PACRF_SP1(value)))
#define AIPS_BWR_PACRF_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_TP0 field. */
#define AIPS_RD_PACRF_TP0(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_TP0_MASK) >> AIPS_PACRF_TP0_SHIFT)
#define AIPS_BRD_PACRF_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRF_TP0(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_TP0_MASK, AIPS_PACRF_TP0(value)))
#define AIPS_BWR_PACRF_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_WP0 field. */
#define AIPS_RD_PACRF_WP0(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_WP0_MASK) >> AIPS_PACRF_WP0_SHIFT)
#define AIPS_BRD_PACRF_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRF_WP0(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_WP0_MASK, AIPS_PACRF_WP0(value)))
#define AIPS_BWR_PACRF_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRF, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRF_SP0 field. */
#define AIPS_RD_PACRF_SP0(base) ((AIPS_PACRF_REG(base) & AIPS_PACRF_SP0_MASK) >> AIPS_PACRF_SP0_SHIFT)
#define AIPS_BRD_PACRF_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRF_SP0(base, value) (AIPS_RMW_PACRF(base, AIPS_PACRF_SP0_MASK, AIPS_PACRF_SP0(value)))
#define AIPS_BWR_PACRF_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRF_REG(base), AIPS_PACRF_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRG - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRG - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRG register
 */
/*@{*/
#define AIPS_RD_PACRG(base)      (AIPS_PACRG_REG(base))
#define AIPS_WR_PACRG(base, value) (AIPS_PACRG_REG(base) = (value))
#define AIPS_RMW_PACRG(base, mask, value) (AIPS_WR_PACRG(base, (AIPS_RD_PACRG(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRG(base, value) (AIPS_WR_PACRG(base, AIPS_RD_PACRG(base) |  (value)))
#define AIPS_CLR_PACRG(base, value) (AIPS_WR_PACRG(base, AIPS_RD_PACRG(base) & ~(value)))
#define AIPS_TOG_PACRG(base, value) (AIPS_WR_PACRG(base, AIPS_RD_PACRG(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRG bitfields
 */

/*!
 * @name Register AIPS_PACRG, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_TP7 field. */
#define AIPS_RD_PACRG_TP7(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_TP7_MASK) >> AIPS_PACRG_TP7_SHIFT)
#define AIPS_BRD_PACRG_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRG_TP7(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_TP7_MASK, AIPS_PACRG_TP7(value)))
#define AIPS_BWR_PACRG_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_WP7 field. */
#define AIPS_RD_PACRG_WP7(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_WP7_MASK) >> AIPS_PACRG_WP7_SHIFT)
#define AIPS_BRD_PACRG_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRG_WP7(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_WP7_MASK, AIPS_PACRG_WP7(value)))
#define AIPS_BWR_PACRG_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_SP7 field. */
#define AIPS_RD_PACRG_SP7(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_SP7_MASK) >> AIPS_PACRG_SP7_SHIFT)
#define AIPS_BRD_PACRG_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRG_SP7(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_SP7_MASK, AIPS_PACRG_SP7(value)))
#define AIPS_BWR_PACRG_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_TP6 field. */
#define AIPS_RD_PACRG_TP6(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_TP6_MASK) >> AIPS_PACRG_TP6_SHIFT)
#define AIPS_BRD_PACRG_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRG_TP6(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_TP6_MASK, AIPS_PACRG_TP6(value)))
#define AIPS_BWR_PACRG_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_WP6 field. */
#define AIPS_RD_PACRG_WP6(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_WP6_MASK) >> AIPS_PACRG_WP6_SHIFT)
#define AIPS_BRD_PACRG_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRG_WP6(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_WP6_MASK, AIPS_PACRG_WP6(value)))
#define AIPS_BWR_PACRG_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_SP6 field. */
#define AIPS_RD_PACRG_SP6(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_SP6_MASK) >> AIPS_PACRG_SP6_SHIFT)
#define AIPS_BRD_PACRG_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRG_SP6(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_SP6_MASK, AIPS_PACRG_SP6(value)))
#define AIPS_BWR_PACRG_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_TP5 field. */
#define AIPS_RD_PACRG_TP5(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_TP5_MASK) >> AIPS_PACRG_TP5_SHIFT)
#define AIPS_BRD_PACRG_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRG_TP5(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_TP5_MASK, AIPS_PACRG_TP5(value)))
#define AIPS_BWR_PACRG_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_WP5 field. */
#define AIPS_RD_PACRG_WP5(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_WP5_MASK) >> AIPS_PACRG_WP5_SHIFT)
#define AIPS_BRD_PACRG_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRG_WP5(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_WP5_MASK, AIPS_PACRG_WP5(value)))
#define AIPS_BWR_PACRG_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_SP5 field. */
#define AIPS_RD_PACRG_SP5(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_SP5_MASK) >> AIPS_PACRG_SP5_SHIFT)
#define AIPS_BRD_PACRG_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRG_SP5(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_SP5_MASK, AIPS_PACRG_SP5(value)))
#define AIPS_BWR_PACRG_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_TP4 field. */
#define AIPS_RD_PACRG_TP4(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_TP4_MASK) >> AIPS_PACRG_TP4_SHIFT)
#define AIPS_BRD_PACRG_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRG_TP4(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_TP4_MASK, AIPS_PACRG_TP4(value)))
#define AIPS_BWR_PACRG_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_WP4 field. */
#define AIPS_RD_PACRG_WP4(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_WP4_MASK) >> AIPS_PACRG_WP4_SHIFT)
#define AIPS_BRD_PACRG_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRG_WP4(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_WP4_MASK, AIPS_PACRG_WP4(value)))
#define AIPS_BWR_PACRG_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_SP4 field. */
#define AIPS_RD_PACRG_SP4(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_SP4_MASK) >> AIPS_PACRG_SP4_SHIFT)
#define AIPS_BRD_PACRG_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRG_SP4(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_SP4_MASK, AIPS_PACRG_SP4(value)))
#define AIPS_BWR_PACRG_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_TP3 field. */
#define AIPS_RD_PACRG_TP3(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_TP3_MASK) >> AIPS_PACRG_TP3_SHIFT)
#define AIPS_BRD_PACRG_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRG_TP3(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_TP3_MASK, AIPS_PACRG_TP3(value)))
#define AIPS_BWR_PACRG_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_WP3 field. */
#define AIPS_RD_PACRG_WP3(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_WP3_MASK) >> AIPS_PACRG_WP3_SHIFT)
#define AIPS_BRD_PACRG_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRG_WP3(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_WP3_MASK, AIPS_PACRG_WP3(value)))
#define AIPS_BWR_PACRG_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_SP3 field. */
#define AIPS_RD_PACRG_SP3(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_SP3_MASK) >> AIPS_PACRG_SP3_SHIFT)
#define AIPS_BRD_PACRG_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRG_SP3(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_SP3_MASK, AIPS_PACRG_SP3(value)))
#define AIPS_BWR_PACRG_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_TP2 field. */
#define AIPS_RD_PACRG_TP2(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_TP2_MASK) >> AIPS_PACRG_TP2_SHIFT)
#define AIPS_BRD_PACRG_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRG_TP2(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_TP2_MASK, AIPS_PACRG_TP2(value)))
#define AIPS_BWR_PACRG_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_WP2 field. */
#define AIPS_RD_PACRG_WP2(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_WP2_MASK) >> AIPS_PACRG_WP2_SHIFT)
#define AIPS_BRD_PACRG_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRG_WP2(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_WP2_MASK, AIPS_PACRG_WP2(value)))
#define AIPS_BWR_PACRG_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_SP2 field. */
#define AIPS_RD_PACRG_SP2(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_SP2_MASK) >> AIPS_PACRG_SP2_SHIFT)
#define AIPS_BRD_PACRG_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRG_SP2(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_SP2_MASK, AIPS_PACRG_SP2(value)))
#define AIPS_BWR_PACRG_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_TP1 field. */
#define AIPS_RD_PACRG_TP1(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_TP1_MASK) >> AIPS_PACRG_TP1_SHIFT)
#define AIPS_BRD_PACRG_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRG_TP1(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_TP1_MASK, AIPS_PACRG_TP1(value)))
#define AIPS_BWR_PACRG_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_WP1 field. */
#define AIPS_RD_PACRG_WP1(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_WP1_MASK) >> AIPS_PACRG_WP1_SHIFT)
#define AIPS_BRD_PACRG_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRG_WP1(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_WP1_MASK, AIPS_PACRG_WP1(value)))
#define AIPS_BWR_PACRG_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_SP1 field. */
#define AIPS_RD_PACRG_SP1(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_SP1_MASK) >> AIPS_PACRG_SP1_SHIFT)
#define AIPS_BRD_PACRG_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRG_SP1(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_SP1_MASK, AIPS_PACRG_SP1(value)))
#define AIPS_BWR_PACRG_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_TP0 field. */
#define AIPS_RD_PACRG_TP0(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_TP0_MASK) >> AIPS_PACRG_TP0_SHIFT)
#define AIPS_BRD_PACRG_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRG_TP0(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_TP0_MASK, AIPS_PACRG_TP0(value)))
#define AIPS_BWR_PACRG_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_WP0 field. */
#define AIPS_RD_PACRG_WP0(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_WP0_MASK) >> AIPS_PACRG_WP0_SHIFT)
#define AIPS_BRD_PACRG_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRG_WP0(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_WP0_MASK, AIPS_PACRG_WP0(value)))
#define AIPS_BWR_PACRG_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRG, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRG_SP0 field. */
#define AIPS_RD_PACRG_SP0(base) ((AIPS_PACRG_REG(base) & AIPS_PACRG_SP0_MASK) >> AIPS_PACRG_SP0_SHIFT)
#define AIPS_BRD_PACRG_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRG_SP0(base, value) (AIPS_RMW_PACRG(base, AIPS_PACRG_SP0_MASK, AIPS_PACRG_SP0(value)))
#define AIPS_BWR_PACRG_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRG_REG(base), AIPS_PACRG_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRH - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRH - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRH register
 */
/*@{*/
#define AIPS_RD_PACRH(base)      (AIPS_PACRH_REG(base))
#define AIPS_WR_PACRH(base, value) (AIPS_PACRH_REG(base) = (value))
#define AIPS_RMW_PACRH(base, mask, value) (AIPS_WR_PACRH(base, (AIPS_RD_PACRH(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRH(base, value) (AIPS_WR_PACRH(base, AIPS_RD_PACRH(base) |  (value)))
#define AIPS_CLR_PACRH(base, value) (AIPS_WR_PACRH(base, AIPS_RD_PACRH(base) & ~(value)))
#define AIPS_TOG_PACRH(base, value) (AIPS_WR_PACRH(base, AIPS_RD_PACRH(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRH bitfields
 */

/*!
 * @name Register AIPS_PACRH, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_TP7 field. */
#define AIPS_RD_PACRH_TP7(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_TP7_MASK) >> AIPS_PACRH_TP7_SHIFT)
#define AIPS_BRD_PACRH_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRH_TP7(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_TP7_MASK, AIPS_PACRH_TP7(value)))
#define AIPS_BWR_PACRH_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_WP7 field. */
#define AIPS_RD_PACRH_WP7(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_WP7_MASK) >> AIPS_PACRH_WP7_SHIFT)
#define AIPS_BRD_PACRH_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRH_WP7(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_WP7_MASK, AIPS_PACRH_WP7(value)))
#define AIPS_BWR_PACRH_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_SP7 field. */
#define AIPS_RD_PACRH_SP7(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_SP7_MASK) >> AIPS_PACRH_SP7_SHIFT)
#define AIPS_BRD_PACRH_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRH_SP7(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_SP7_MASK, AIPS_PACRH_SP7(value)))
#define AIPS_BWR_PACRH_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_TP6 field. */
#define AIPS_RD_PACRH_TP6(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_TP6_MASK) >> AIPS_PACRH_TP6_SHIFT)
#define AIPS_BRD_PACRH_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRH_TP6(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_TP6_MASK, AIPS_PACRH_TP6(value)))
#define AIPS_BWR_PACRH_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_WP6 field. */
#define AIPS_RD_PACRH_WP6(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_WP6_MASK) >> AIPS_PACRH_WP6_SHIFT)
#define AIPS_BRD_PACRH_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRH_WP6(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_WP6_MASK, AIPS_PACRH_WP6(value)))
#define AIPS_BWR_PACRH_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_SP6 field. */
#define AIPS_RD_PACRH_SP6(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_SP6_MASK) >> AIPS_PACRH_SP6_SHIFT)
#define AIPS_BRD_PACRH_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRH_SP6(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_SP6_MASK, AIPS_PACRH_SP6(value)))
#define AIPS_BWR_PACRH_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_TP5 field. */
#define AIPS_RD_PACRH_TP5(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_TP5_MASK) >> AIPS_PACRH_TP5_SHIFT)
#define AIPS_BRD_PACRH_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRH_TP5(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_TP5_MASK, AIPS_PACRH_TP5(value)))
#define AIPS_BWR_PACRH_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_WP5 field. */
#define AIPS_RD_PACRH_WP5(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_WP5_MASK) >> AIPS_PACRH_WP5_SHIFT)
#define AIPS_BRD_PACRH_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRH_WP5(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_WP5_MASK, AIPS_PACRH_WP5(value)))
#define AIPS_BWR_PACRH_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_SP5 field. */
#define AIPS_RD_PACRH_SP5(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_SP5_MASK) >> AIPS_PACRH_SP5_SHIFT)
#define AIPS_BRD_PACRH_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRH_SP5(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_SP5_MASK, AIPS_PACRH_SP5(value)))
#define AIPS_BWR_PACRH_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_TP4 field. */
#define AIPS_RD_PACRH_TP4(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_TP4_MASK) >> AIPS_PACRH_TP4_SHIFT)
#define AIPS_BRD_PACRH_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRH_TP4(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_TP4_MASK, AIPS_PACRH_TP4(value)))
#define AIPS_BWR_PACRH_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_WP4 field. */
#define AIPS_RD_PACRH_WP4(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_WP4_MASK) >> AIPS_PACRH_WP4_SHIFT)
#define AIPS_BRD_PACRH_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRH_WP4(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_WP4_MASK, AIPS_PACRH_WP4(value)))
#define AIPS_BWR_PACRH_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_SP4 field. */
#define AIPS_RD_PACRH_SP4(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_SP4_MASK) >> AIPS_PACRH_SP4_SHIFT)
#define AIPS_BRD_PACRH_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRH_SP4(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_SP4_MASK, AIPS_PACRH_SP4(value)))
#define AIPS_BWR_PACRH_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_TP3 field. */
#define AIPS_RD_PACRH_TP3(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_TP3_MASK) >> AIPS_PACRH_TP3_SHIFT)
#define AIPS_BRD_PACRH_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRH_TP3(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_TP3_MASK, AIPS_PACRH_TP3(value)))
#define AIPS_BWR_PACRH_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_WP3 field. */
#define AIPS_RD_PACRH_WP3(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_WP3_MASK) >> AIPS_PACRH_WP3_SHIFT)
#define AIPS_BRD_PACRH_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRH_WP3(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_WP3_MASK, AIPS_PACRH_WP3(value)))
#define AIPS_BWR_PACRH_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_SP3 field. */
#define AIPS_RD_PACRH_SP3(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_SP3_MASK) >> AIPS_PACRH_SP3_SHIFT)
#define AIPS_BRD_PACRH_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRH_SP3(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_SP3_MASK, AIPS_PACRH_SP3(value)))
#define AIPS_BWR_PACRH_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_TP2 field. */
#define AIPS_RD_PACRH_TP2(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_TP2_MASK) >> AIPS_PACRH_TP2_SHIFT)
#define AIPS_BRD_PACRH_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRH_TP2(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_TP2_MASK, AIPS_PACRH_TP2(value)))
#define AIPS_BWR_PACRH_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_WP2 field. */
#define AIPS_RD_PACRH_WP2(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_WP2_MASK) >> AIPS_PACRH_WP2_SHIFT)
#define AIPS_BRD_PACRH_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRH_WP2(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_WP2_MASK, AIPS_PACRH_WP2(value)))
#define AIPS_BWR_PACRH_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_SP2 field. */
#define AIPS_RD_PACRH_SP2(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_SP2_MASK) >> AIPS_PACRH_SP2_SHIFT)
#define AIPS_BRD_PACRH_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRH_SP2(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_SP2_MASK, AIPS_PACRH_SP2(value)))
#define AIPS_BWR_PACRH_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_TP1 field. */
#define AIPS_RD_PACRH_TP1(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_TP1_MASK) >> AIPS_PACRH_TP1_SHIFT)
#define AIPS_BRD_PACRH_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRH_TP1(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_TP1_MASK, AIPS_PACRH_TP1(value)))
#define AIPS_BWR_PACRH_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_WP1 field. */
#define AIPS_RD_PACRH_WP1(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_WP1_MASK) >> AIPS_PACRH_WP1_SHIFT)
#define AIPS_BRD_PACRH_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRH_WP1(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_WP1_MASK, AIPS_PACRH_WP1(value)))
#define AIPS_BWR_PACRH_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_SP1 field. */
#define AIPS_RD_PACRH_SP1(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_SP1_MASK) >> AIPS_PACRH_SP1_SHIFT)
#define AIPS_BRD_PACRH_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRH_SP1(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_SP1_MASK, AIPS_PACRH_SP1(value)))
#define AIPS_BWR_PACRH_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_TP0 field. */
#define AIPS_RD_PACRH_TP0(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_TP0_MASK) >> AIPS_PACRH_TP0_SHIFT)
#define AIPS_BRD_PACRH_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRH_TP0(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_TP0_MASK, AIPS_PACRH_TP0(value)))
#define AIPS_BWR_PACRH_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_WP0 field. */
#define AIPS_RD_PACRH_WP0(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_WP0_MASK) >> AIPS_PACRH_WP0_SHIFT)
#define AIPS_BRD_PACRH_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRH_WP0(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_WP0_MASK, AIPS_PACRH_WP0(value)))
#define AIPS_BWR_PACRH_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRH, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRH_SP0 field. */
#define AIPS_RD_PACRH_SP0(base) ((AIPS_PACRH_REG(base) & AIPS_PACRH_SP0_MASK) >> AIPS_PACRH_SP0_SHIFT)
#define AIPS_BRD_PACRH_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRH_SP0(base, value) (AIPS_RMW_PACRH(base, AIPS_PACRH_SP0_MASK, AIPS_PACRH_SP0(value)))
#define AIPS_BWR_PACRH_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRH_REG(base), AIPS_PACRH_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRI - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRI - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRI register
 */
/*@{*/
#define AIPS_RD_PACRI(base)      (AIPS_PACRI_REG(base))
#define AIPS_WR_PACRI(base, value) (AIPS_PACRI_REG(base) = (value))
#define AIPS_RMW_PACRI(base, mask, value) (AIPS_WR_PACRI(base, (AIPS_RD_PACRI(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRI(base, value) (AIPS_WR_PACRI(base, AIPS_RD_PACRI(base) |  (value)))
#define AIPS_CLR_PACRI(base, value) (AIPS_WR_PACRI(base, AIPS_RD_PACRI(base) & ~(value)))
#define AIPS_TOG_PACRI(base, value) (AIPS_WR_PACRI(base, AIPS_RD_PACRI(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRI bitfields
 */

/*!
 * @name Register AIPS_PACRI, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_TP7 field. */
#define AIPS_RD_PACRI_TP7(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_TP7_MASK) >> AIPS_PACRI_TP7_SHIFT)
#define AIPS_BRD_PACRI_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRI_TP7(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_TP7_MASK, AIPS_PACRI_TP7(value)))
#define AIPS_BWR_PACRI_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_WP7 field. */
#define AIPS_RD_PACRI_WP7(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_WP7_MASK) >> AIPS_PACRI_WP7_SHIFT)
#define AIPS_BRD_PACRI_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRI_WP7(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_WP7_MASK, AIPS_PACRI_WP7(value)))
#define AIPS_BWR_PACRI_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_SP7 field. */
#define AIPS_RD_PACRI_SP7(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_SP7_MASK) >> AIPS_PACRI_SP7_SHIFT)
#define AIPS_BRD_PACRI_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRI_SP7(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_SP7_MASK, AIPS_PACRI_SP7(value)))
#define AIPS_BWR_PACRI_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_TP6 field. */
#define AIPS_RD_PACRI_TP6(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_TP6_MASK) >> AIPS_PACRI_TP6_SHIFT)
#define AIPS_BRD_PACRI_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRI_TP6(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_TP6_MASK, AIPS_PACRI_TP6(value)))
#define AIPS_BWR_PACRI_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_WP6 field. */
#define AIPS_RD_PACRI_WP6(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_WP6_MASK) >> AIPS_PACRI_WP6_SHIFT)
#define AIPS_BRD_PACRI_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRI_WP6(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_WP6_MASK, AIPS_PACRI_WP6(value)))
#define AIPS_BWR_PACRI_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_SP6 field. */
#define AIPS_RD_PACRI_SP6(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_SP6_MASK) >> AIPS_PACRI_SP6_SHIFT)
#define AIPS_BRD_PACRI_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRI_SP6(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_SP6_MASK, AIPS_PACRI_SP6(value)))
#define AIPS_BWR_PACRI_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_TP5 field. */
#define AIPS_RD_PACRI_TP5(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_TP5_MASK) >> AIPS_PACRI_TP5_SHIFT)
#define AIPS_BRD_PACRI_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRI_TP5(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_TP5_MASK, AIPS_PACRI_TP5(value)))
#define AIPS_BWR_PACRI_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_WP5 field. */
#define AIPS_RD_PACRI_WP5(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_WP5_MASK) >> AIPS_PACRI_WP5_SHIFT)
#define AIPS_BRD_PACRI_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRI_WP5(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_WP5_MASK, AIPS_PACRI_WP5(value)))
#define AIPS_BWR_PACRI_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_SP5 field. */
#define AIPS_RD_PACRI_SP5(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_SP5_MASK) >> AIPS_PACRI_SP5_SHIFT)
#define AIPS_BRD_PACRI_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRI_SP5(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_SP5_MASK, AIPS_PACRI_SP5(value)))
#define AIPS_BWR_PACRI_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_TP4 field. */
#define AIPS_RD_PACRI_TP4(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_TP4_MASK) >> AIPS_PACRI_TP4_SHIFT)
#define AIPS_BRD_PACRI_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRI_TP4(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_TP4_MASK, AIPS_PACRI_TP4(value)))
#define AIPS_BWR_PACRI_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_WP4 field. */
#define AIPS_RD_PACRI_WP4(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_WP4_MASK) >> AIPS_PACRI_WP4_SHIFT)
#define AIPS_BRD_PACRI_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRI_WP4(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_WP4_MASK, AIPS_PACRI_WP4(value)))
#define AIPS_BWR_PACRI_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_SP4 field. */
#define AIPS_RD_PACRI_SP4(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_SP4_MASK) >> AIPS_PACRI_SP4_SHIFT)
#define AIPS_BRD_PACRI_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRI_SP4(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_SP4_MASK, AIPS_PACRI_SP4(value)))
#define AIPS_BWR_PACRI_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_TP3 field. */
#define AIPS_RD_PACRI_TP3(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_TP3_MASK) >> AIPS_PACRI_TP3_SHIFT)
#define AIPS_BRD_PACRI_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRI_TP3(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_TP3_MASK, AIPS_PACRI_TP3(value)))
#define AIPS_BWR_PACRI_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_WP3 field. */
#define AIPS_RD_PACRI_WP3(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_WP3_MASK) >> AIPS_PACRI_WP3_SHIFT)
#define AIPS_BRD_PACRI_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRI_WP3(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_WP3_MASK, AIPS_PACRI_WP3(value)))
#define AIPS_BWR_PACRI_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_SP3 field. */
#define AIPS_RD_PACRI_SP3(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_SP3_MASK) >> AIPS_PACRI_SP3_SHIFT)
#define AIPS_BRD_PACRI_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRI_SP3(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_SP3_MASK, AIPS_PACRI_SP3(value)))
#define AIPS_BWR_PACRI_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_TP2 field. */
#define AIPS_RD_PACRI_TP2(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_TP2_MASK) >> AIPS_PACRI_TP2_SHIFT)
#define AIPS_BRD_PACRI_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRI_TP2(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_TP2_MASK, AIPS_PACRI_TP2(value)))
#define AIPS_BWR_PACRI_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_WP2 field. */
#define AIPS_RD_PACRI_WP2(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_WP2_MASK) >> AIPS_PACRI_WP2_SHIFT)
#define AIPS_BRD_PACRI_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRI_WP2(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_WP2_MASK, AIPS_PACRI_WP2(value)))
#define AIPS_BWR_PACRI_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_SP2 field. */
#define AIPS_RD_PACRI_SP2(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_SP2_MASK) >> AIPS_PACRI_SP2_SHIFT)
#define AIPS_BRD_PACRI_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRI_SP2(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_SP2_MASK, AIPS_PACRI_SP2(value)))
#define AIPS_BWR_PACRI_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_TP1 field. */
#define AIPS_RD_PACRI_TP1(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_TP1_MASK) >> AIPS_PACRI_TP1_SHIFT)
#define AIPS_BRD_PACRI_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRI_TP1(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_TP1_MASK, AIPS_PACRI_TP1(value)))
#define AIPS_BWR_PACRI_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_WP1 field. */
#define AIPS_RD_PACRI_WP1(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_WP1_MASK) >> AIPS_PACRI_WP1_SHIFT)
#define AIPS_BRD_PACRI_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRI_WP1(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_WP1_MASK, AIPS_PACRI_WP1(value)))
#define AIPS_BWR_PACRI_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_SP1 field. */
#define AIPS_RD_PACRI_SP1(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_SP1_MASK) >> AIPS_PACRI_SP1_SHIFT)
#define AIPS_BRD_PACRI_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRI_SP1(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_SP1_MASK, AIPS_PACRI_SP1(value)))
#define AIPS_BWR_PACRI_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_TP0 field. */
#define AIPS_RD_PACRI_TP0(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_TP0_MASK) >> AIPS_PACRI_TP0_SHIFT)
#define AIPS_BRD_PACRI_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRI_TP0(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_TP0_MASK, AIPS_PACRI_TP0(value)))
#define AIPS_BWR_PACRI_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_WP0 field. */
#define AIPS_RD_PACRI_WP0(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_WP0_MASK) >> AIPS_PACRI_WP0_SHIFT)
#define AIPS_BRD_PACRI_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRI_WP0(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_WP0_MASK, AIPS_PACRI_WP0(value)))
#define AIPS_BWR_PACRI_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRI, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRI_SP0 field. */
#define AIPS_RD_PACRI_SP0(base) ((AIPS_PACRI_REG(base) & AIPS_PACRI_SP0_MASK) >> AIPS_PACRI_SP0_SHIFT)
#define AIPS_BRD_PACRI_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRI_SP0(base, value) (AIPS_RMW_PACRI(base, AIPS_PACRI_SP0_MASK, AIPS_PACRI_SP0(value)))
#define AIPS_BWR_PACRI_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRI_REG(base), AIPS_PACRI_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRJ - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRJ - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRJ register
 */
/*@{*/
#define AIPS_RD_PACRJ(base)      (AIPS_PACRJ_REG(base))
#define AIPS_WR_PACRJ(base, value) (AIPS_PACRJ_REG(base) = (value))
#define AIPS_RMW_PACRJ(base, mask, value) (AIPS_WR_PACRJ(base, (AIPS_RD_PACRJ(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRJ(base, value) (AIPS_WR_PACRJ(base, AIPS_RD_PACRJ(base) |  (value)))
#define AIPS_CLR_PACRJ(base, value) (AIPS_WR_PACRJ(base, AIPS_RD_PACRJ(base) & ~(value)))
#define AIPS_TOG_PACRJ(base, value) (AIPS_WR_PACRJ(base, AIPS_RD_PACRJ(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRJ bitfields
 */

/*!
 * @name Register AIPS_PACRJ, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_TP7 field. */
#define AIPS_RD_PACRJ_TP7(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_TP7_MASK) >> AIPS_PACRJ_TP7_SHIFT)
#define AIPS_BRD_PACRJ_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRJ_TP7(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_TP7_MASK, AIPS_PACRJ_TP7(value)))
#define AIPS_BWR_PACRJ_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_WP7 field. */
#define AIPS_RD_PACRJ_WP7(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_WP7_MASK) >> AIPS_PACRJ_WP7_SHIFT)
#define AIPS_BRD_PACRJ_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRJ_WP7(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_WP7_MASK, AIPS_PACRJ_WP7(value)))
#define AIPS_BWR_PACRJ_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_SP7 field. */
#define AIPS_RD_PACRJ_SP7(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_SP7_MASK) >> AIPS_PACRJ_SP7_SHIFT)
#define AIPS_BRD_PACRJ_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRJ_SP7(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_SP7_MASK, AIPS_PACRJ_SP7(value)))
#define AIPS_BWR_PACRJ_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_TP6 field. */
#define AIPS_RD_PACRJ_TP6(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_TP6_MASK) >> AIPS_PACRJ_TP6_SHIFT)
#define AIPS_BRD_PACRJ_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRJ_TP6(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_TP6_MASK, AIPS_PACRJ_TP6(value)))
#define AIPS_BWR_PACRJ_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_WP6 field. */
#define AIPS_RD_PACRJ_WP6(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_WP6_MASK) >> AIPS_PACRJ_WP6_SHIFT)
#define AIPS_BRD_PACRJ_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRJ_WP6(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_WP6_MASK, AIPS_PACRJ_WP6(value)))
#define AIPS_BWR_PACRJ_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_SP6 field. */
#define AIPS_RD_PACRJ_SP6(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_SP6_MASK) >> AIPS_PACRJ_SP6_SHIFT)
#define AIPS_BRD_PACRJ_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRJ_SP6(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_SP6_MASK, AIPS_PACRJ_SP6(value)))
#define AIPS_BWR_PACRJ_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_TP5 field. */
#define AIPS_RD_PACRJ_TP5(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_TP5_MASK) >> AIPS_PACRJ_TP5_SHIFT)
#define AIPS_BRD_PACRJ_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRJ_TP5(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_TP5_MASK, AIPS_PACRJ_TP5(value)))
#define AIPS_BWR_PACRJ_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_WP5 field. */
#define AIPS_RD_PACRJ_WP5(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_WP5_MASK) >> AIPS_PACRJ_WP5_SHIFT)
#define AIPS_BRD_PACRJ_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRJ_WP5(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_WP5_MASK, AIPS_PACRJ_WP5(value)))
#define AIPS_BWR_PACRJ_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_SP5 field. */
#define AIPS_RD_PACRJ_SP5(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_SP5_MASK) >> AIPS_PACRJ_SP5_SHIFT)
#define AIPS_BRD_PACRJ_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRJ_SP5(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_SP5_MASK, AIPS_PACRJ_SP5(value)))
#define AIPS_BWR_PACRJ_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_TP4 field. */
#define AIPS_RD_PACRJ_TP4(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_TP4_MASK) >> AIPS_PACRJ_TP4_SHIFT)
#define AIPS_BRD_PACRJ_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRJ_TP4(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_TP4_MASK, AIPS_PACRJ_TP4(value)))
#define AIPS_BWR_PACRJ_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_WP4 field. */
#define AIPS_RD_PACRJ_WP4(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_WP4_MASK) >> AIPS_PACRJ_WP4_SHIFT)
#define AIPS_BRD_PACRJ_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRJ_WP4(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_WP4_MASK, AIPS_PACRJ_WP4(value)))
#define AIPS_BWR_PACRJ_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_SP4 field. */
#define AIPS_RD_PACRJ_SP4(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_SP4_MASK) >> AIPS_PACRJ_SP4_SHIFT)
#define AIPS_BRD_PACRJ_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRJ_SP4(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_SP4_MASK, AIPS_PACRJ_SP4(value)))
#define AIPS_BWR_PACRJ_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_TP3 field. */
#define AIPS_RD_PACRJ_TP3(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_TP3_MASK) >> AIPS_PACRJ_TP3_SHIFT)
#define AIPS_BRD_PACRJ_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRJ_TP3(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_TP3_MASK, AIPS_PACRJ_TP3(value)))
#define AIPS_BWR_PACRJ_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_WP3 field. */
#define AIPS_RD_PACRJ_WP3(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_WP3_MASK) >> AIPS_PACRJ_WP3_SHIFT)
#define AIPS_BRD_PACRJ_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRJ_WP3(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_WP3_MASK, AIPS_PACRJ_WP3(value)))
#define AIPS_BWR_PACRJ_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_SP3 field. */
#define AIPS_RD_PACRJ_SP3(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_SP3_MASK) >> AIPS_PACRJ_SP3_SHIFT)
#define AIPS_BRD_PACRJ_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRJ_SP3(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_SP3_MASK, AIPS_PACRJ_SP3(value)))
#define AIPS_BWR_PACRJ_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_TP2 field. */
#define AIPS_RD_PACRJ_TP2(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_TP2_MASK) >> AIPS_PACRJ_TP2_SHIFT)
#define AIPS_BRD_PACRJ_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRJ_TP2(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_TP2_MASK, AIPS_PACRJ_TP2(value)))
#define AIPS_BWR_PACRJ_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_WP2 field. */
#define AIPS_RD_PACRJ_WP2(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_WP2_MASK) >> AIPS_PACRJ_WP2_SHIFT)
#define AIPS_BRD_PACRJ_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRJ_WP2(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_WP2_MASK, AIPS_PACRJ_WP2(value)))
#define AIPS_BWR_PACRJ_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_SP2 field. */
#define AIPS_RD_PACRJ_SP2(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_SP2_MASK) >> AIPS_PACRJ_SP2_SHIFT)
#define AIPS_BRD_PACRJ_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRJ_SP2(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_SP2_MASK, AIPS_PACRJ_SP2(value)))
#define AIPS_BWR_PACRJ_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_TP1 field. */
#define AIPS_RD_PACRJ_TP1(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_TP1_MASK) >> AIPS_PACRJ_TP1_SHIFT)
#define AIPS_BRD_PACRJ_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRJ_TP1(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_TP1_MASK, AIPS_PACRJ_TP1(value)))
#define AIPS_BWR_PACRJ_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_WP1 field. */
#define AIPS_RD_PACRJ_WP1(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_WP1_MASK) >> AIPS_PACRJ_WP1_SHIFT)
#define AIPS_BRD_PACRJ_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRJ_WP1(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_WP1_MASK, AIPS_PACRJ_WP1(value)))
#define AIPS_BWR_PACRJ_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_SP1 field. */
#define AIPS_RD_PACRJ_SP1(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_SP1_MASK) >> AIPS_PACRJ_SP1_SHIFT)
#define AIPS_BRD_PACRJ_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRJ_SP1(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_SP1_MASK, AIPS_PACRJ_SP1(value)))
#define AIPS_BWR_PACRJ_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_TP0 field. */
#define AIPS_RD_PACRJ_TP0(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_TP0_MASK) >> AIPS_PACRJ_TP0_SHIFT)
#define AIPS_BRD_PACRJ_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRJ_TP0(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_TP0_MASK, AIPS_PACRJ_TP0(value)))
#define AIPS_BWR_PACRJ_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_WP0 field. */
#define AIPS_RD_PACRJ_WP0(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_WP0_MASK) >> AIPS_PACRJ_WP0_SHIFT)
#define AIPS_BRD_PACRJ_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRJ_WP0(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_WP0_MASK, AIPS_PACRJ_WP0(value)))
#define AIPS_BWR_PACRJ_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRJ, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRJ_SP0 field. */
#define AIPS_RD_PACRJ_SP0(base) ((AIPS_PACRJ_REG(base) & AIPS_PACRJ_SP0_MASK) >> AIPS_PACRJ_SP0_SHIFT)
#define AIPS_BRD_PACRJ_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRJ_SP0(base, value) (AIPS_RMW_PACRJ(base, AIPS_PACRJ_SP0_MASK, AIPS_PACRJ_SP0(value)))
#define AIPS_BWR_PACRJ_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRJ_REG(base), AIPS_PACRJ_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRK - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRK - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRK register
 */
/*@{*/
#define AIPS_RD_PACRK(base)      (AIPS_PACRK_REG(base))
#define AIPS_WR_PACRK(base, value) (AIPS_PACRK_REG(base) = (value))
#define AIPS_RMW_PACRK(base, mask, value) (AIPS_WR_PACRK(base, (AIPS_RD_PACRK(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRK(base, value) (AIPS_WR_PACRK(base, AIPS_RD_PACRK(base) |  (value)))
#define AIPS_CLR_PACRK(base, value) (AIPS_WR_PACRK(base, AIPS_RD_PACRK(base) & ~(value)))
#define AIPS_TOG_PACRK(base, value) (AIPS_WR_PACRK(base, AIPS_RD_PACRK(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRK bitfields
 */

/*!
 * @name Register AIPS_PACRK, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_TP7 field. */
#define AIPS_RD_PACRK_TP7(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_TP7_MASK) >> AIPS_PACRK_TP7_SHIFT)
#define AIPS_BRD_PACRK_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRK_TP7(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_TP7_MASK, AIPS_PACRK_TP7(value)))
#define AIPS_BWR_PACRK_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_WP7 field. */
#define AIPS_RD_PACRK_WP7(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_WP7_MASK) >> AIPS_PACRK_WP7_SHIFT)
#define AIPS_BRD_PACRK_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRK_WP7(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_WP7_MASK, AIPS_PACRK_WP7(value)))
#define AIPS_BWR_PACRK_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_SP7 field. */
#define AIPS_RD_PACRK_SP7(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_SP7_MASK) >> AIPS_PACRK_SP7_SHIFT)
#define AIPS_BRD_PACRK_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRK_SP7(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_SP7_MASK, AIPS_PACRK_SP7(value)))
#define AIPS_BWR_PACRK_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_TP6 field. */
#define AIPS_RD_PACRK_TP6(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_TP6_MASK) >> AIPS_PACRK_TP6_SHIFT)
#define AIPS_BRD_PACRK_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRK_TP6(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_TP6_MASK, AIPS_PACRK_TP6(value)))
#define AIPS_BWR_PACRK_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_WP6 field. */
#define AIPS_RD_PACRK_WP6(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_WP6_MASK) >> AIPS_PACRK_WP6_SHIFT)
#define AIPS_BRD_PACRK_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRK_WP6(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_WP6_MASK, AIPS_PACRK_WP6(value)))
#define AIPS_BWR_PACRK_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_SP6 field. */
#define AIPS_RD_PACRK_SP6(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_SP6_MASK) >> AIPS_PACRK_SP6_SHIFT)
#define AIPS_BRD_PACRK_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRK_SP6(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_SP6_MASK, AIPS_PACRK_SP6(value)))
#define AIPS_BWR_PACRK_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_TP5 field. */
#define AIPS_RD_PACRK_TP5(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_TP5_MASK) >> AIPS_PACRK_TP5_SHIFT)
#define AIPS_BRD_PACRK_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRK_TP5(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_TP5_MASK, AIPS_PACRK_TP5(value)))
#define AIPS_BWR_PACRK_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_WP5 field. */
#define AIPS_RD_PACRK_WP5(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_WP5_MASK) >> AIPS_PACRK_WP5_SHIFT)
#define AIPS_BRD_PACRK_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRK_WP5(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_WP5_MASK, AIPS_PACRK_WP5(value)))
#define AIPS_BWR_PACRK_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_SP5 field. */
#define AIPS_RD_PACRK_SP5(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_SP5_MASK) >> AIPS_PACRK_SP5_SHIFT)
#define AIPS_BRD_PACRK_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRK_SP5(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_SP5_MASK, AIPS_PACRK_SP5(value)))
#define AIPS_BWR_PACRK_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_TP4 field. */
#define AIPS_RD_PACRK_TP4(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_TP4_MASK) >> AIPS_PACRK_TP4_SHIFT)
#define AIPS_BRD_PACRK_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRK_TP4(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_TP4_MASK, AIPS_PACRK_TP4(value)))
#define AIPS_BWR_PACRK_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_WP4 field. */
#define AIPS_RD_PACRK_WP4(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_WP4_MASK) >> AIPS_PACRK_WP4_SHIFT)
#define AIPS_BRD_PACRK_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRK_WP4(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_WP4_MASK, AIPS_PACRK_WP4(value)))
#define AIPS_BWR_PACRK_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_SP4 field. */
#define AIPS_RD_PACRK_SP4(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_SP4_MASK) >> AIPS_PACRK_SP4_SHIFT)
#define AIPS_BRD_PACRK_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRK_SP4(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_SP4_MASK, AIPS_PACRK_SP4(value)))
#define AIPS_BWR_PACRK_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_TP3 field. */
#define AIPS_RD_PACRK_TP3(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_TP3_MASK) >> AIPS_PACRK_TP3_SHIFT)
#define AIPS_BRD_PACRK_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRK_TP3(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_TP3_MASK, AIPS_PACRK_TP3(value)))
#define AIPS_BWR_PACRK_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_WP3 field. */
#define AIPS_RD_PACRK_WP3(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_WP3_MASK) >> AIPS_PACRK_WP3_SHIFT)
#define AIPS_BRD_PACRK_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRK_WP3(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_WP3_MASK, AIPS_PACRK_WP3(value)))
#define AIPS_BWR_PACRK_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_SP3 field. */
#define AIPS_RD_PACRK_SP3(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_SP3_MASK) >> AIPS_PACRK_SP3_SHIFT)
#define AIPS_BRD_PACRK_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRK_SP3(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_SP3_MASK, AIPS_PACRK_SP3(value)))
#define AIPS_BWR_PACRK_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_TP2 field. */
#define AIPS_RD_PACRK_TP2(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_TP2_MASK) >> AIPS_PACRK_TP2_SHIFT)
#define AIPS_BRD_PACRK_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRK_TP2(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_TP2_MASK, AIPS_PACRK_TP2(value)))
#define AIPS_BWR_PACRK_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_WP2 field. */
#define AIPS_RD_PACRK_WP2(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_WP2_MASK) >> AIPS_PACRK_WP2_SHIFT)
#define AIPS_BRD_PACRK_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRK_WP2(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_WP2_MASK, AIPS_PACRK_WP2(value)))
#define AIPS_BWR_PACRK_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_SP2 field. */
#define AIPS_RD_PACRK_SP2(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_SP2_MASK) >> AIPS_PACRK_SP2_SHIFT)
#define AIPS_BRD_PACRK_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRK_SP2(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_SP2_MASK, AIPS_PACRK_SP2(value)))
#define AIPS_BWR_PACRK_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_TP1 field. */
#define AIPS_RD_PACRK_TP1(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_TP1_MASK) >> AIPS_PACRK_TP1_SHIFT)
#define AIPS_BRD_PACRK_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRK_TP1(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_TP1_MASK, AIPS_PACRK_TP1(value)))
#define AIPS_BWR_PACRK_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_WP1 field. */
#define AIPS_RD_PACRK_WP1(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_WP1_MASK) >> AIPS_PACRK_WP1_SHIFT)
#define AIPS_BRD_PACRK_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRK_WP1(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_WP1_MASK, AIPS_PACRK_WP1(value)))
#define AIPS_BWR_PACRK_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_SP1 field. */
#define AIPS_RD_PACRK_SP1(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_SP1_MASK) >> AIPS_PACRK_SP1_SHIFT)
#define AIPS_BRD_PACRK_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRK_SP1(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_SP1_MASK, AIPS_PACRK_SP1(value)))
#define AIPS_BWR_PACRK_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_TP0 field. */
#define AIPS_RD_PACRK_TP0(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_TP0_MASK) >> AIPS_PACRK_TP0_SHIFT)
#define AIPS_BRD_PACRK_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRK_TP0(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_TP0_MASK, AIPS_PACRK_TP0(value)))
#define AIPS_BWR_PACRK_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_WP0 field. */
#define AIPS_RD_PACRK_WP0(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_WP0_MASK) >> AIPS_PACRK_WP0_SHIFT)
#define AIPS_BRD_PACRK_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRK_WP0(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_WP0_MASK, AIPS_PACRK_WP0(value)))
#define AIPS_BWR_PACRK_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRK, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRK_SP0 field. */
#define AIPS_RD_PACRK_SP0(base) ((AIPS_PACRK_REG(base) & AIPS_PACRK_SP0_MASK) >> AIPS_PACRK_SP0_SHIFT)
#define AIPS_BRD_PACRK_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRK_SP0(base, value) (AIPS_RMW_PACRK(base, AIPS_PACRK_SP0_MASK, AIPS_PACRK_SP0(value)))
#define AIPS_BWR_PACRK_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRK_REG(base), AIPS_PACRK_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRL - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRL - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRL register
 */
/*@{*/
#define AIPS_RD_PACRL(base)      (AIPS_PACRL_REG(base))
#define AIPS_WR_PACRL(base, value) (AIPS_PACRL_REG(base) = (value))
#define AIPS_RMW_PACRL(base, mask, value) (AIPS_WR_PACRL(base, (AIPS_RD_PACRL(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRL(base, value) (AIPS_WR_PACRL(base, AIPS_RD_PACRL(base) |  (value)))
#define AIPS_CLR_PACRL(base, value) (AIPS_WR_PACRL(base, AIPS_RD_PACRL(base) & ~(value)))
#define AIPS_TOG_PACRL(base, value) (AIPS_WR_PACRL(base, AIPS_RD_PACRL(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRL bitfields
 */

/*!
 * @name Register AIPS_PACRL, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_TP7 field. */
#define AIPS_RD_PACRL_TP7(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_TP7_MASK) >> AIPS_PACRL_TP7_SHIFT)
#define AIPS_BRD_PACRL_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRL_TP7(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_TP7_MASK, AIPS_PACRL_TP7(value)))
#define AIPS_BWR_PACRL_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_WP7 field. */
#define AIPS_RD_PACRL_WP7(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_WP7_MASK) >> AIPS_PACRL_WP7_SHIFT)
#define AIPS_BRD_PACRL_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRL_WP7(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_WP7_MASK, AIPS_PACRL_WP7(value)))
#define AIPS_BWR_PACRL_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_SP7 field. */
#define AIPS_RD_PACRL_SP7(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_SP7_MASK) >> AIPS_PACRL_SP7_SHIFT)
#define AIPS_BRD_PACRL_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRL_SP7(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_SP7_MASK, AIPS_PACRL_SP7(value)))
#define AIPS_BWR_PACRL_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_TP6 field. */
#define AIPS_RD_PACRL_TP6(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_TP6_MASK) >> AIPS_PACRL_TP6_SHIFT)
#define AIPS_BRD_PACRL_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRL_TP6(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_TP6_MASK, AIPS_PACRL_TP6(value)))
#define AIPS_BWR_PACRL_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_WP6 field. */
#define AIPS_RD_PACRL_WP6(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_WP6_MASK) >> AIPS_PACRL_WP6_SHIFT)
#define AIPS_BRD_PACRL_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRL_WP6(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_WP6_MASK, AIPS_PACRL_WP6(value)))
#define AIPS_BWR_PACRL_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_SP6 field. */
#define AIPS_RD_PACRL_SP6(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_SP6_MASK) >> AIPS_PACRL_SP6_SHIFT)
#define AIPS_BRD_PACRL_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRL_SP6(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_SP6_MASK, AIPS_PACRL_SP6(value)))
#define AIPS_BWR_PACRL_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_TP5 field. */
#define AIPS_RD_PACRL_TP5(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_TP5_MASK) >> AIPS_PACRL_TP5_SHIFT)
#define AIPS_BRD_PACRL_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRL_TP5(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_TP5_MASK, AIPS_PACRL_TP5(value)))
#define AIPS_BWR_PACRL_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_WP5 field. */
#define AIPS_RD_PACRL_WP5(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_WP5_MASK) >> AIPS_PACRL_WP5_SHIFT)
#define AIPS_BRD_PACRL_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRL_WP5(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_WP5_MASK, AIPS_PACRL_WP5(value)))
#define AIPS_BWR_PACRL_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_SP5 field. */
#define AIPS_RD_PACRL_SP5(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_SP5_MASK) >> AIPS_PACRL_SP5_SHIFT)
#define AIPS_BRD_PACRL_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRL_SP5(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_SP5_MASK, AIPS_PACRL_SP5(value)))
#define AIPS_BWR_PACRL_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_TP4 field. */
#define AIPS_RD_PACRL_TP4(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_TP4_MASK) >> AIPS_PACRL_TP4_SHIFT)
#define AIPS_BRD_PACRL_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRL_TP4(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_TP4_MASK, AIPS_PACRL_TP4(value)))
#define AIPS_BWR_PACRL_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_WP4 field. */
#define AIPS_RD_PACRL_WP4(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_WP4_MASK) >> AIPS_PACRL_WP4_SHIFT)
#define AIPS_BRD_PACRL_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRL_WP4(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_WP4_MASK, AIPS_PACRL_WP4(value)))
#define AIPS_BWR_PACRL_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_SP4 field. */
#define AIPS_RD_PACRL_SP4(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_SP4_MASK) >> AIPS_PACRL_SP4_SHIFT)
#define AIPS_BRD_PACRL_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRL_SP4(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_SP4_MASK, AIPS_PACRL_SP4(value)))
#define AIPS_BWR_PACRL_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_TP3 field. */
#define AIPS_RD_PACRL_TP3(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_TP3_MASK) >> AIPS_PACRL_TP3_SHIFT)
#define AIPS_BRD_PACRL_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRL_TP3(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_TP3_MASK, AIPS_PACRL_TP3(value)))
#define AIPS_BWR_PACRL_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_WP3 field. */
#define AIPS_RD_PACRL_WP3(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_WP3_MASK) >> AIPS_PACRL_WP3_SHIFT)
#define AIPS_BRD_PACRL_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRL_WP3(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_WP3_MASK, AIPS_PACRL_WP3(value)))
#define AIPS_BWR_PACRL_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_SP3 field. */
#define AIPS_RD_PACRL_SP3(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_SP3_MASK) >> AIPS_PACRL_SP3_SHIFT)
#define AIPS_BRD_PACRL_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRL_SP3(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_SP3_MASK, AIPS_PACRL_SP3(value)))
#define AIPS_BWR_PACRL_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_TP2 field. */
#define AIPS_RD_PACRL_TP2(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_TP2_MASK) >> AIPS_PACRL_TP2_SHIFT)
#define AIPS_BRD_PACRL_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRL_TP2(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_TP2_MASK, AIPS_PACRL_TP2(value)))
#define AIPS_BWR_PACRL_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_WP2 field. */
#define AIPS_RD_PACRL_WP2(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_WP2_MASK) >> AIPS_PACRL_WP2_SHIFT)
#define AIPS_BRD_PACRL_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRL_WP2(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_WP2_MASK, AIPS_PACRL_WP2(value)))
#define AIPS_BWR_PACRL_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_SP2 field. */
#define AIPS_RD_PACRL_SP2(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_SP2_MASK) >> AIPS_PACRL_SP2_SHIFT)
#define AIPS_BRD_PACRL_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRL_SP2(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_SP2_MASK, AIPS_PACRL_SP2(value)))
#define AIPS_BWR_PACRL_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_TP1 field. */
#define AIPS_RD_PACRL_TP1(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_TP1_MASK) >> AIPS_PACRL_TP1_SHIFT)
#define AIPS_BRD_PACRL_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRL_TP1(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_TP1_MASK, AIPS_PACRL_TP1(value)))
#define AIPS_BWR_PACRL_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_WP1 field. */
#define AIPS_RD_PACRL_WP1(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_WP1_MASK) >> AIPS_PACRL_WP1_SHIFT)
#define AIPS_BRD_PACRL_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRL_WP1(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_WP1_MASK, AIPS_PACRL_WP1(value)))
#define AIPS_BWR_PACRL_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_SP1 field. */
#define AIPS_RD_PACRL_SP1(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_SP1_MASK) >> AIPS_PACRL_SP1_SHIFT)
#define AIPS_BRD_PACRL_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRL_SP1(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_SP1_MASK, AIPS_PACRL_SP1(value)))
#define AIPS_BWR_PACRL_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_TP0 field. */
#define AIPS_RD_PACRL_TP0(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_TP0_MASK) >> AIPS_PACRL_TP0_SHIFT)
#define AIPS_BRD_PACRL_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRL_TP0(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_TP0_MASK, AIPS_PACRL_TP0(value)))
#define AIPS_BWR_PACRL_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_WP0 field. */
#define AIPS_RD_PACRL_WP0(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_WP0_MASK) >> AIPS_PACRL_WP0_SHIFT)
#define AIPS_BRD_PACRL_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRL_WP0(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_WP0_MASK, AIPS_PACRL_WP0(value)))
#define AIPS_BWR_PACRL_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRL, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRL_SP0 field. */
#define AIPS_RD_PACRL_SP0(base) ((AIPS_PACRL_REG(base) & AIPS_PACRL_SP0_MASK) >> AIPS_PACRL_SP0_SHIFT)
#define AIPS_BRD_PACRL_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRL_SP0(base, value) (AIPS_RMW_PACRL(base, AIPS_PACRL_SP0_MASK, AIPS_PACRL_SP0(value)))
#define AIPS_BWR_PACRL_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRL_REG(base), AIPS_PACRL_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRM - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRM - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRM register
 */
/*@{*/
#define AIPS_RD_PACRM(base)      (AIPS_PACRM_REG(base))
#define AIPS_WR_PACRM(base, value) (AIPS_PACRM_REG(base) = (value))
#define AIPS_RMW_PACRM(base, mask, value) (AIPS_WR_PACRM(base, (AIPS_RD_PACRM(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRM(base, value) (AIPS_WR_PACRM(base, AIPS_RD_PACRM(base) |  (value)))
#define AIPS_CLR_PACRM(base, value) (AIPS_WR_PACRM(base, AIPS_RD_PACRM(base) & ~(value)))
#define AIPS_TOG_PACRM(base, value) (AIPS_WR_PACRM(base, AIPS_RD_PACRM(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRM bitfields
 */

/*!
 * @name Register AIPS_PACRM, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_TP7 field. */
#define AIPS_RD_PACRM_TP7(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_TP7_MASK) >> AIPS_PACRM_TP7_SHIFT)
#define AIPS_BRD_PACRM_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRM_TP7(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_TP7_MASK, AIPS_PACRM_TP7(value)))
#define AIPS_BWR_PACRM_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_WP7 field. */
#define AIPS_RD_PACRM_WP7(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_WP7_MASK) >> AIPS_PACRM_WP7_SHIFT)
#define AIPS_BRD_PACRM_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRM_WP7(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_WP7_MASK, AIPS_PACRM_WP7(value)))
#define AIPS_BWR_PACRM_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_SP7 field. */
#define AIPS_RD_PACRM_SP7(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_SP7_MASK) >> AIPS_PACRM_SP7_SHIFT)
#define AIPS_BRD_PACRM_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRM_SP7(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_SP7_MASK, AIPS_PACRM_SP7(value)))
#define AIPS_BWR_PACRM_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_TP6 field. */
#define AIPS_RD_PACRM_TP6(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_TP6_MASK) >> AIPS_PACRM_TP6_SHIFT)
#define AIPS_BRD_PACRM_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRM_TP6(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_TP6_MASK, AIPS_PACRM_TP6(value)))
#define AIPS_BWR_PACRM_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_WP6 field. */
#define AIPS_RD_PACRM_WP6(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_WP6_MASK) >> AIPS_PACRM_WP6_SHIFT)
#define AIPS_BRD_PACRM_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRM_WP6(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_WP6_MASK, AIPS_PACRM_WP6(value)))
#define AIPS_BWR_PACRM_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_SP6 field. */
#define AIPS_RD_PACRM_SP6(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_SP6_MASK) >> AIPS_PACRM_SP6_SHIFT)
#define AIPS_BRD_PACRM_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRM_SP6(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_SP6_MASK, AIPS_PACRM_SP6(value)))
#define AIPS_BWR_PACRM_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_TP5 field. */
#define AIPS_RD_PACRM_TP5(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_TP5_MASK) >> AIPS_PACRM_TP5_SHIFT)
#define AIPS_BRD_PACRM_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRM_TP5(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_TP5_MASK, AIPS_PACRM_TP5(value)))
#define AIPS_BWR_PACRM_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_WP5 field. */
#define AIPS_RD_PACRM_WP5(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_WP5_MASK) >> AIPS_PACRM_WP5_SHIFT)
#define AIPS_BRD_PACRM_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRM_WP5(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_WP5_MASK, AIPS_PACRM_WP5(value)))
#define AIPS_BWR_PACRM_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_SP5 field. */
#define AIPS_RD_PACRM_SP5(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_SP5_MASK) >> AIPS_PACRM_SP5_SHIFT)
#define AIPS_BRD_PACRM_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRM_SP5(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_SP5_MASK, AIPS_PACRM_SP5(value)))
#define AIPS_BWR_PACRM_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_TP4 field. */
#define AIPS_RD_PACRM_TP4(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_TP4_MASK) >> AIPS_PACRM_TP4_SHIFT)
#define AIPS_BRD_PACRM_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRM_TP4(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_TP4_MASK, AIPS_PACRM_TP4(value)))
#define AIPS_BWR_PACRM_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_WP4 field. */
#define AIPS_RD_PACRM_WP4(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_WP4_MASK) >> AIPS_PACRM_WP4_SHIFT)
#define AIPS_BRD_PACRM_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRM_WP4(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_WP4_MASK, AIPS_PACRM_WP4(value)))
#define AIPS_BWR_PACRM_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_SP4 field. */
#define AIPS_RD_PACRM_SP4(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_SP4_MASK) >> AIPS_PACRM_SP4_SHIFT)
#define AIPS_BRD_PACRM_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRM_SP4(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_SP4_MASK, AIPS_PACRM_SP4(value)))
#define AIPS_BWR_PACRM_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_TP3 field. */
#define AIPS_RD_PACRM_TP3(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_TP3_MASK) >> AIPS_PACRM_TP3_SHIFT)
#define AIPS_BRD_PACRM_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRM_TP3(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_TP3_MASK, AIPS_PACRM_TP3(value)))
#define AIPS_BWR_PACRM_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_WP3 field. */
#define AIPS_RD_PACRM_WP3(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_WP3_MASK) >> AIPS_PACRM_WP3_SHIFT)
#define AIPS_BRD_PACRM_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRM_WP3(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_WP3_MASK, AIPS_PACRM_WP3(value)))
#define AIPS_BWR_PACRM_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_SP3 field. */
#define AIPS_RD_PACRM_SP3(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_SP3_MASK) >> AIPS_PACRM_SP3_SHIFT)
#define AIPS_BRD_PACRM_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRM_SP3(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_SP3_MASK, AIPS_PACRM_SP3(value)))
#define AIPS_BWR_PACRM_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_TP2 field. */
#define AIPS_RD_PACRM_TP2(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_TP2_MASK) >> AIPS_PACRM_TP2_SHIFT)
#define AIPS_BRD_PACRM_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRM_TP2(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_TP2_MASK, AIPS_PACRM_TP2(value)))
#define AIPS_BWR_PACRM_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_WP2 field. */
#define AIPS_RD_PACRM_WP2(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_WP2_MASK) >> AIPS_PACRM_WP2_SHIFT)
#define AIPS_BRD_PACRM_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRM_WP2(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_WP2_MASK, AIPS_PACRM_WP2(value)))
#define AIPS_BWR_PACRM_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_SP2 field. */
#define AIPS_RD_PACRM_SP2(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_SP2_MASK) >> AIPS_PACRM_SP2_SHIFT)
#define AIPS_BRD_PACRM_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRM_SP2(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_SP2_MASK, AIPS_PACRM_SP2(value)))
#define AIPS_BWR_PACRM_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_TP1 field. */
#define AIPS_RD_PACRM_TP1(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_TP1_MASK) >> AIPS_PACRM_TP1_SHIFT)
#define AIPS_BRD_PACRM_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRM_TP1(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_TP1_MASK, AIPS_PACRM_TP1(value)))
#define AIPS_BWR_PACRM_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_WP1 field. */
#define AIPS_RD_PACRM_WP1(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_WP1_MASK) >> AIPS_PACRM_WP1_SHIFT)
#define AIPS_BRD_PACRM_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRM_WP1(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_WP1_MASK, AIPS_PACRM_WP1(value)))
#define AIPS_BWR_PACRM_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_SP1 field. */
#define AIPS_RD_PACRM_SP1(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_SP1_MASK) >> AIPS_PACRM_SP1_SHIFT)
#define AIPS_BRD_PACRM_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRM_SP1(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_SP1_MASK, AIPS_PACRM_SP1(value)))
#define AIPS_BWR_PACRM_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_TP0 field. */
#define AIPS_RD_PACRM_TP0(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_TP0_MASK) >> AIPS_PACRM_TP0_SHIFT)
#define AIPS_BRD_PACRM_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRM_TP0(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_TP0_MASK, AIPS_PACRM_TP0(value)))
#define AIPS_BWR_PACRM_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_WP0 field. */
#define AIPS_RD_PACRM_WP0(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_WP0_MASK) >> AIPS_PACRM_WP0_SHIFT)
#define AIPS_BRD_PACRM_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRM_WP0(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_WP0_MASK, AIPS_PACRM_WP0(value)))
#define AIPS_BWR_PACRM_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRM, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRM_SP0 field. */
#define AIPS_RD_PACRM_SP0(base) ((AIPS_PACRM_REG(base) & AIPS_PACRM_SP0_MASK) >> AIPS_PACRM_SP0_SHIFT)
#define AIPS_BRD_PACRM_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRM_SP0(base, value) (AIPS_RMW_PACRM(base, AIPS_PACRM_SP0_MASK, AIPS_PACRM_SP0(value)))
#define AIPS_BWR_PACRM_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRM_REG(base), AIPS_PACRM_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRN - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRN - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRN register
 */
/*@{*/
#define AIPS_RD_PACRN(base)      (AIPS_PACRN_REG(base))
#define AIPS_WR_PACRN(base, value) (AIPS_PACRN_REG(base) = (value))
#define AIPS_RMW_PACRN(base, mask, value) (AIPS_WR_PACRN(base, (AIPS_RD_PACRN(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRN(base, value) (AIPS_WR_PACRN(base, AIPS_RD_PACRN(base) |  (value)))
#define AIPS_CLR_PACRN(base, value) (AIPS_WR_PACRN(base, AIPS_RD_PACRN(base) & ~(value)))
#define AIPS_TOG_PACRN(base, value) (AIPS_WR_PACRN(base, AIPS_RD_PACRN(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRN bitfields
 */

/*!
 * @name Register AIPS_PACRN, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_TP7 field. */
#define AIPS_RD_PACRN_TP7(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_TP7_MASK) >> AIPS_PACRN_TP7_SHIFT)
#define AIPS_BRD_PACRN_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRN_TP7(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_TP7_MASK, AIPS_PACRN_TP7(value)))
#define AIPS_BWR_PACRN_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_WP7 field. */
#define AIPS_RD_PACRN_WP7(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_WP7_MASK) >> AIPS_PACRN_WP7_SHIFT)
#define AIPS_BRD_PACRN_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRN_WP7(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_WP7_MASK, AIPS_PACRN_WP7(value)))
#define AIPS_BWR_PACRN_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_SP7 field. */
#define AIPS_RD_PACRN_SP7(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_SP7_MASK) >> AIPS_PACRN_SP7_SHIFT)
#define AIPS_BRD_PACRN_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRN_SP7(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_SP7_MASK, AIPS_PACRN_SP7(value)))
#define AIPS_BWR_PACRN_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_TP6 field. */
#define AIPS_RD_PACRN_TP6(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_TP6_MASK) >> AIPS_PACRN_TP6_SHIFT)
#define AIPS_BRD_PACRN_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRN_TP6(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_TP6_MASK, AIPS_PACRN_TP6(value)))
#define AIPS_BWR_PACRN_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_WP6 field. */
#define AIPS_RD_PACRN_WP6(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_WP6_MASK) >> AIPS_PACRN_WP6_SHIFT)
#define AIPS_BRD_PACRN_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRN_WP6(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_WP6_MASK, AIPS_PACRN_WP6(value)))
#define AIPS_BWR_PACRN_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_SP6 field. */
#define AIPS_RD_PACRN_SP6(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_SP6_MASK) >> AIPS_PACRN_SP6_SHIFT)
#define AIPS_BRD_PACRN_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRN_SP6(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_SP6_MASK, AIPS_PACRN_SP6(value)))
#define AIPS_BWR_PACRN_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_TP5 field. */
#define AIPS_RD_PACRN_TP5(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_TP5_MASK) >> AIPS_PACRN_TP5_SHIFT)
#define AIPS_BRD_PACRN_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRN_TP5(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_TP5_MASK, AIPS_PACRN_TP5(value)))
#define AIPS_BWR_PACRN_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_WP5 field. */
#define AIPS_RD_PACRN_WP5(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_WP5_MASK) >> AIPS_PACRN_WP5_SHIFT)
#define AIPS_BRD_PACRN_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRN_WP5(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_WP5_MASK, AIPS_PACRN_WP5(value)))
#define AIPS_BWR_PACRN_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_SP5 field. */
#define AIPS_RD_PACRN_SP5(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_SP5_MASK) >> AIPS_PACRN_SP5_SHIFT)
#define AIPS_BRD_PACRN_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRN_SP5(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_SP5_MASK, AIPS_PACRN_SP5(value)))
#define AIPS_BWR_PACRN_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_TP4 field. */
#define AIPS_RD_PACRN_TP4(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_TP4_MASK) >> AIPS_PACRN_TP4_SHIFT)
#define AIPS_BRD_PACRN_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRN_TP4(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_TP4_MASK, AIPS_PACRN_TP4(value)))
#define AIPS_BWR_PACRN_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_WP4 field. */
#define AIPS_RD_PACRN_WP4(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_WP4_MASK) >> AIPS_PACRN_WP4_SHIFT)
#define AIPS_BRD_PACRN_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRN_WP4(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_WP4_MASK, AIPS_PACRN_WP4(value)))
#define AIPS_BWR_PACRN_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_SP4 field. */
#define AIPS_RD_PACRN_SP4(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_SP4_MASK) >> AIPS_PACRN_SP4_SHIFT)
#define AIPS_BRD_PACRN_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRN_SP4(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_SP4_MASK, AIPS_PACRN_SP4(value)))
#define AIPS_BWR_PACRN_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_TP3 field. */
#define AIPS_RD_PACRN_TP3(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_TP3_MASK) >> AIPS_PACRN_TP3_SHIFT)
#define AIPS_BRD_PACRN_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRN_TP3(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_TP3_MASK, AIPS_PACRN_TP3(value)))
#define AIPS_BWR_PACRN_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_WP3 field. */
#define AIPS_RD_PACRN_WP3(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_WP3_MASK) >> AIPS_PACRN_WP3_SHIFT)
#define AIPS_BRD_PACRN_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRN_WP3(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_WP3_MASK, AIPS_PACRN_WP3(value)))
#define AIPS_BWR_PACRN_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_SP3 field. */
#define AIPS_RD_PACRN_SP3(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_SP3_MASK) >> AIPS_PACRN_SP3_SHIFT)
#define AIPS_BRD_PACRN_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRN_SP3(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_SP3_MASK, AIPS_PACRN_SP3(value)))
#define AIPS_BWR_PACRN_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_TP2 field. */
#define AIPS_RD_PACRN_TP2(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_TP2_MASK) >> AIPS_PACRN_TP2_SHIFT)
#define AIPS_BRD_PACRN_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRN_TP2(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_TP2_MASK, AIPS_PACRN_TP2(value)))
#define AIPS_BWR_PACRN_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_WP2 field. */
#define AIPS_RD_PACRN_WP2(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_WP2_MASK) >> AIPS_PACRN_WP2_SHIFT)
#define AIPS_BRD_PACRN_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRN_WP2(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_WP2_MASK, AIPS_PACRN_WP2(value)))
#define AIPS_BWR_PACRN_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_SP2 field. */
#define AIPS_RD_PACRN_SP2(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_SP2_MASK) >> AIPS_PACRN_SP2_SHIFT)
#define AIPS_BRD_PACRN_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRN_SP2(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_SP2_MASK, AIPS_PACRN_SP2(value)))
#define AIPS_BWR_PACRN_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_TP1 field. */
#define AIPS_RD_PACRN_TP1(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_TP1_MASK) >> AIPS_PACRN_TP1_SHIFT)
#define AIPS_BRD_PACRN_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRN_TP1(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_TP1_MASK, AIPS_PACRN_TP1(value)))
#define AIPS_BWR_PACRN_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_WP1 field. */
#define AIPS_RD_PACRN_WP1(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_WP1_MASK) >> AIPS_PACRN_WP1_SHIFT)
#define AIPS_BRD_PACRN_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRN_WP1(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_WP1_MASK, AIPS_PACRN_WP1(value)))
#define AIPS_BWR_PACRN_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_SP1 field. */
#define AIPS_RD_PACRN_SP1(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_SP1_MASK) >> AIPS_PACRN_SP1_SHIFT)
#define AIPS_BRD_PACRN_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRN_SP1(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_SP1_MASK, AIPS_PACRN_SP1(value)))
#define AIPS_BWR_PACRN_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_TP0 field. */
#define AIPS_RD_PACRN_TP0(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_TP0_MASK) >> AIPS_PACRN_TP0_SHIFT)
#define AIPS_BRD_PACRN_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRN_TP0(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_TP0_MASK, AIPS_PACRN_TP0(value)))
#define AIPS_BWR_PACRN_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_WP0 field. */
#define AIPS_RD_PACRN_WP0(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_WP0_MASK) >> AIPS_PACRN_WP0_SHIFT)
#define AIPS_BRD_PACRN_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRN_WP0(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_WP0_MASK, AIPS_PACRN_WP0(value)))
#define AIPS_BWR_PACRN_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRN, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRN_SP0 field. */
#define AIPS_RD_PACRN_SP0(base) ((AIPS_PACRN_REG(base) & AIPS_PACRN_SP0_MASK) >> AIPS_PACRN_SP0_SHIFT)
#define AIPS_BRD_PACRN_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRN_SP0(base, value) (AIPS_RMW_PACRN(base, AIPS_PACRN_SP0_MASK, AIPS_PACRN_SP0(value)))
#define AIPS_BWR_PACRN_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRN_REG(base), AIPS_PACRN_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRO - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRO - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRO register
 */
/*@{*/
#define AIPS_RD_PACRO(base)      (AIPS_PACRO_REG(base))
#define AIPS_WR_PACRO(base, value) (AIPS_PACRO_REG(base) = (value))
#define AIPS_RMW_PACRO(base, mask, value) (AIPS_WR_PACRO(base, (AIPS_RD_PACRO(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRO(base, value) (AIPS_WR_PACRO(base, AIPS_RD_PACRO(base) |  (value)))
#define AIPS_CLR_PACRO(base, value) (AIPS_WR_PACRO(base, AIPS_RD_PACRO(base) & ~(value)))
#define AIPS_TOG_PACRO(base, value) (AIPS_WR_PACRO(base, AIPS_RD_PACRO(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRO bitfields
 */

/*!
 * @name Register AIPS_PACRO, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_TP7 field. */
#define AIPS_RD_PACRO_TP7(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_TP7_MASK) >> AIPS_PACRO_TP7_SHIFT)
#define AIPS_BRD_PACRO_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRO_TP7(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_TP7_MASK, AIPS_PACRO_TP7(value)))
#define AIPS_BWR_PACRO_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_WP7 field. */
#define AIPS_RD_PACRO_WP7(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_WP7_MASK) >> AIPS_PACRO_WP7_SHIFT)
#define AIPS_BRD_PACRO_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRO_WP7(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_WP7_MASK, AIPS_PACRO_WP7(value)))
#define AIPS_BWR_PACRO_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_SP7 field. */
#define AIPS_RD_PACRO_SP7(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_SP7_MASK) >> AIPS_PACRO_SP7_SHIFT)
#define AIPS_BRD_PACRO_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRO_SP7(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_SP7_MASK, AIPS_PACRO_SP7(value)))
#define AIPS_BWR_PACRO_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_TP6 field. */
#define AIPS_RD_PACRO_TP6(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_TP6_MASK) >> AIPS_PACRO_TP6_SHIFT)
#define AIPS_BRD_PACRO_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRO_TP6(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_TP6_MASK, AIPS_PACRO_TP6(value)))
#define AIPS_BWR_PACRO_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_WP6 field. */
#define AIPS_RD_PACRO_WP6(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_WP6_MASK) >> AIPS_PACRO_WP6_SHIFT)
#define AIPS_BRD_PACRO_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRO_WP6(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_WP6_MASK, AIPS_PACRO_WP6(value)))
#define AIPS_BWR_PACRO_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_SP6 field. */
#define AIPS_RD_PACRO_SP6(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_SP6_MASK) >> AIPS_PACRO_SP6_SHIFT)
#define AIPS_BRD_PACRO_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRO_SP6(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_SP6_MASK, AIPS_PACRO_SP6(value)))
#define AIPS_BWR_PACRO_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_TP5 field. */
#define AIPS_RD_PACRO_TP5(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_TP5_MASK) >> AIPS_PACRO_TP5_SHIFT)
#define AIPS_BRD_PACRO_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRO_TP5(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_TP5_MASK, AIPS_PACRO_TP5(value)))
#define AIPS_BWR_PACRO_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_WP5 field. */
#define AIPS_RD_PACRO_WP5(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_WP5_MASK) >> AIPS_PACRO_WP5_SHIFT)
#define AIPS_BRD_PACRO_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRO_WP5(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_WP5_MASK, AIPS_PACRO_WP5(value)))
#define AIPS_BWR_PACRO_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_SP5 field. */
#define AIPS_RD_PACRO_SP5(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_SP5_MASK) >> AIPS_PACRO_SP5_SHIFT)
#define AIPS_BRD_PACRO_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRO_SP5(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_SP5_MASK, AIPS_PACRO_SP5(value)))
#define AIPS_BWR_PACRO_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_TP4 field. */
#define AIPS_RD_PACRO_TP4(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_TP4_MASK) >> AIPS_PACRO_TP4_SHIFT)
#define AIPS_BRD_PACRO_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRO_TP4(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_TP4_MASK, AIPS_PACRO_TP4(value)))
#define AIPS_BWR_PACRO_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_WP4 field. */
#define AIPS_RD_PACRO_WP4(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_WP4_MASK) >> AIPS_PACRO_WP4_SHIFT)
#define AIPS_BRD_PACRO_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRO_WP4(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_WP4_MASK, AIPS_PACRO_WP4(value)))
#define AIPS_BWR_PACRO_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_SP4 field. */
#define AIPS_RD_PACRO_SP4(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_SP4_MASK) >> AIPS_PACRO_SP4_SHIFT)
#define AIPS_BRD_PACRO_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRO_SP4(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_SP4_MASK, AIPS_PACRO_SP4(value)))
#define AIPS_BWR_PACRO_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_TP3 field. */
#define AIPS_RD_PACRO_TP3(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_TP3_MASK) >> AIPS_PACRO_TP3_SHIFT)
#define AIPS_BRD_PACRO_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRO_TP3(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_TP3_MASK, AIPS_PACRO_TP3(value)))
#define AIPS_BWR_PACRO_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_WP3 field. */
#define AIPS_RD_PACRO_WP3(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_WP3_MASK) >> AIPS_PACRO_WP3_SHIFT)
#define AIPS_BRD_PACRO_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRO_WP3(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_WP3_MASK, AIPS_PACRO_WP3(value)))
#define AIPS_BWR_PACRO_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_SP3 field. */
#define AIPS_RD_PACRO_SP3(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_SP3_MASK) >> AIPS_PACRO_SP3_SHIFT)
#define AIPS_BRD_PACRO_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRO_SP3(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_SP3_MASK, AIPS_PACRO_SP3(value)))
#define AIPS_BWR_PACRO_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_TP2 field. */
#define AIPS_RD_PACRO_TP2(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_TP2_MASK) >> AIPS_PACRO_TP2_SHIFT)
#define AIPS_BRD_PACRO_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRO_TP2(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_TP2_MASK, AIPS_PACRO_TP2(value)))
#define AIPS_BWR_PACRO_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_WP2 field. */
#define AIPS_RD_PACRO_WP2(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_WP2_MASK) >> AIPS_PACRO_WP2_SHIFT)
#define AIPS_BRD_PACRO_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRO_WP2(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_WP2_MASK, AIPS_PACRO_WP2(value)))
#define AIPS_BWR_PACRO_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_SP2 field. */
#define AIPS_RD_PACRO_SP2(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_SP2_MASK) >> AIPS_PACRO_SP2_SHIFT)
#define AIPS_BRD_PACRO_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRO_SP2(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_SP2_MASK, AIPS_PACRO_SP2(value)))
#define AIPS_BWR_PACRO_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_TP1 field. */
#define AIPS_RD_PACRO_TP1(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_TP1_MASK) >> AIPS_PACRO_TP1_SHIFT)
#define AIPS_BRD_PACRO_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRO_TP1(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_TP1_MASK, AIPS_PACRO_TP1(value)))
#define AIPS_BWR_PACRO_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_WP1 field. */
#define AIPS_RD_PACRO_WP1(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_WP1_MASK) >> AIPS_PACRO_WP1_SHIFT)
#define AIPS_BRD_PACRO_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRO_WP1(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_WP1_MASK, AIPS_PACRO_WP1(value)))
#define AIPS_BWR_PACRO_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_SP1 field. */
#define AIPS_RD_PACRO_SP1(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_SP1_MASK) >> AIPS_PACRO_SP1_SHIFT)
#define AIPS_BRD_PACRO_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRO_SP1(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_SP1_MASK, AIPS_PACRO_SP1(value)))
#define AIPS_BWR_PACRO_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_TP0 field. */
#define AIPS_RD_PACRO_TP0(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_TP0_MASK) >> AIPS_PACRO_TP0_SHIFT)
#define AIPS_BRD_PACRO_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRO_TP0(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_TP0_MASK, AIPS_PACRO_TP0(value)))
#define AIPS_BWR_PACRO_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_WP0 field. */
#define AIPS_RD_PACRO_WP0(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_WP0_MASK) >> AIPS_PACRO_WP0_SHIFT)
#define AIPS_BRD_PACRO_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRO_WP0(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_WP0_MASK, AIPS_PACRO_WP0(value)))
#define AIPS_BWR_PACRO_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRO, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRO_SP0 field. */
#define AIPS_RD_PACRO_SP0(base) ((AIPS_PACRO_REG(base) & AIPS_PACRO_SP0_MASK) >> AIPS_PACRO_SP0_SHIFT)
#define AIPS_BRD_PACRO_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRO_SP0(base, value) (AIPS_RMW_PACRO(base, AIPS_PACRO_SP0_MASK, AIPS_PACRO_SP0(value)))
#define AIPS_BWR_PACRO_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRO_REG(base), AIPS_PACRO_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRP - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRP - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44444444U
 *
 * This section describes PACR registers E-P, which control peripheral slots
 * 32-127. See PACRPeripheral Access Control Register for the description of these
 * registers.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRP register
 */
/*@{*/
#define AIPS_RD_PACRP(base)      (AIPS_PACRP_REG(base))
#define AIPS_WR_PACRP(base, value) (AIPS_PACRP_REG(base) = (value))
#define AIPS_RMW_PACRP(base, mask, value) (AIPS_WR_PACRP(base, (AIPS_RD_PACRP(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRP(base, value) (AIPS_WR_PACRP(base, AIPS_RD_PACRP(base) |  (value)))
#define AIPS_CLR_PACRP(base, value) (AIPS_WR_PACRP(base, AIPS_RD_PACRP(base) & ~(value)))
#define AIPS_TOG_PACRP(base, value) (AIPS_WR_PACRP(base, AIPS_RD_PACRP(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRP bitfields
 */

/*!
 * @name Register AIPS_PACRP, field TP7[0] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_TP7 field. */
#define AIPS_RD_PACRP_TP7(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_TP7_MASK) >> AIPS_PACRP_TP7_SHIFT)
#define AIPS_BRD_PACRP_TP7(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP7_SHIFT))

/*! @brief Set the TP7 field to a new value. */
#define AIPS_WR_PACRP_TP7(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_TP7_MASK, AIPS_PACRP_TP7(value)))
#define AIPS_BWR_PACRP_TP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field WP7[1] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_WP7 field. */
#define AIPS_RD_PACRP_WP7(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_WP7_MASK) >> AIPS_PACRP_WP7_SHIFT)
#define AIPS_BRD_PACRP_WP7(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP7_SHIFT))

/*! @brief Set the WP7 field to a new value. */
#define AIPS_WR_PACRP_WP7(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_WP7_MASK, AIPS_PACRP_WP7(value)))
#define AIPS_BWR_PACRP_WP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field SP7[2] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_SP7 field. */
#define AIPS_RD_PACRP_SP7(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_SP7_MASK) >> AIPS_PACRP_SP7_SHIFT)
#define AIPS_BRD_PACRP_SP7(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP7_SHIFT))

/*! @brief Set the SP7 field to a new value. */
#define AIPS_WR_PACRP_SP7(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_SP7_MASK, AIPS_PACRP_SP7(value)))
#define AIPS_BWR_PACRP_SP7(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field TP6[4] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_TP6 field. */
#define AIPS_RD_PACRP_TP6(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_TP6_MASK) >> AIPS_PACRP_TP6_SHIFT)
#define AIPS_BRD_PACRP_TP6(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP6_SHIFT))

/*! @brief Set the TP6 field to a new value. */
#define AIPS_WR_PACRP_TP6(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_TP6_MASK, AIPS_PACRP_TP6(value)))
#define AIPS_BWR_PACRP_TP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field WP6[5] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_WP6 field. */
#define AIPS_RD_PACRP_WP6(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_WP6_MASK) >> AIPS_PACRP_WP6_SHIFT)
#define AIPS_BRD_PACRP_WP6(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP6_SHIFT))

/*! @brief Set the WP6 field to a new value. */
#define AIPS_WR_PACRP_WP6(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_WP6_MASK, AIPS_PACRP_WP6(value)))
#define AIPS_BWR_PACRP_WP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field SP6[6] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_SP6 field. */
#define AIPS_RD_PACRP_SP6(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_SP6_MASK) >> AIPS_PACRP_SP6_SHIFT)
#define AIPS_BRD_PACRP_SP6(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP6_SHIFT))

/*! @brief Set the SP6 field to a new value. */
#define AIPS_WR_PACRP_SP6(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_SP6_MASK, AIPS_PACRP_SP6(value)))
#define AIPS_BWR_PACRP_SP6(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field TP5[8] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_TP5 field. */
#define AIPS_RD_PACRP_TP5(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_TP5_MASK) >> AIPS_PACRP_TP5_SHIFT)
#define AIPS_BRD_PACRP_TP5(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP5_SHIFT))

/*! @brief Set the TP5 field to a new value. */
#define AIPS_WR_PACRP_TP5(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_TP5_MASK, AIPS_PACRP_TP5(value)))
#define AIPS_BWR_PACRP_TP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field WP5[9] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_WP5 field. */
#define AIPS_RD_PACRP_WP5(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_WP5_MASK) >> AIPS_PACRP_WP5_SHIFT)
#define AIPS_BRD_PACRP_WP5(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP5_SHIFT))

/*! @brief Set the WP5 field to a new value. */
#define AIPS_WR_PACRP_WP5(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_WP5_MASK, AIPS_PACRP_WP5(value)))
#define AIPS_BWR_PACRP_WP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field SP5[10] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_SP5 field. */
#define AIPS_RD_PACRP_SP5(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_SP5_MASK) >> AIPS_PACRP_SP5_SHIFT)
#define AIPS_BRD_PACRP_SP5(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP5_SHIFT))

/*! @brief Set the SP5 field to a new value. */
#define AIPS_WR_PACRP_SP5(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_SP5_MASK, AIPS_PACRP_SP5(value)))
#define AIPS_BWR_PACRP_SP5(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field TP4[12] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_TP4 field. */
#define AIPS_RD_PACRP_TP4(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_TP4_MASK) >> AIPS_PACRP_TP4_SHIFT)
#define AIPS_BRD_PACRP_TP4(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP4_SHIFT))

/*! @brief Set the TP4 field to a new value. */
#define AIPS_WR_PACRP_TP4(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_TP4_MASK, AIPS_PACRP_TP4(value)))
#define AIPS_BWR_PACRP_TP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field WP4[13] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_WP4 field. */
#define AIPS_RD_PACRP_WP4(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_WP4_MASK) >> AIPS_PACRP_WP4_SHIFT)
#define AIPS_BRD_PACRP_WP4(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP4_SHIFT))

/*! @brief Set the WP4 field to a new value. */
#define AIPS_WR_PACRP_WP4(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_WP4_MASK, AIPS_PACRP_WP4(value)))
#define AIPS_BWR_PACRP_WP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field SP4[14] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_SP4 field. */
#define AIPS_RD_PACRP_SP4(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_SP4_MASK) >> AIPS_PACRP_SP4_SHIFT)
#define AIPS_BRD_PACRP_SP4(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP4_SHIFT))

/*! @brief Set the SP4 field to a new value. */
#define AIPS_WR_PACRP_SP4(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_SP4_MASK, AIPS_PACRP_SP4(value)))
#define AIPS_BWR_PACRP_SP4(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field TP3[16] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_TP3 field. */
#define AIPS_RD_PACRP_TP3(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_TP3_MASK) >> AIPS_PACRP_TP3_SHIFT)
#define AIPS_BRD_PACRP_TP3(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP3_SHIFT))

/*! @brief Set the TP3 field to a new value. */
#define AIPS_WR_PACRP_TP3(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_TP3_MASK, AIPS_PACRP_TP3(value)))
#define AIPS_BWR_PACRP_TP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field WP3[17] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_WP3 field. */
#define AIPS_RD_PACRP_WP3(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_WP3_MASK) >> AIPS_PACRP_WP3_SHIFT)
#define AIPS_BRD_PACRP_WP3(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP3_SHIFT))

/*! @brief Set the WP3 field to a new value. */
#define AIPS_WR_PACRP_WP3(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_WP3_MASK, AIPS_PACRP_WP3(value)))
#define AIPS_BWR_PACRP_WP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field SP3[18] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_SP3 field. */
#define AIPS_RD_PACRP_SP3(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_SP3_MASK) >> AIPS_PACRP_SP3_SHIFT)
#define AIPS_BRD_PACRP_SP3(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP3_SHIFT))

/*! @brief Set the SP3 field to a new value. */
#define AIPS_WR_PACRP_SP3(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_SP3_MASK, AIPS_PACRP_SP3(value)))
#define AIPS_BWR_PACRP_SP3(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field TP2[20] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_TP2 field. */
#define AIPS_RD_PACRP_TP2(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_TP2_MASK) >> AIPS_PACRP_TP2_SHIFT)
#define AIPS_BRD_PACRP_TP2(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP2_SHIFT))

/*! @brief Set the TP2 field to a new value. */
#define AIPS_WR_PACRP_TP2(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_TP2_MASK, AIPS_PACRP_TP2(value)))
#define AIPS_BWR_PACRP_TP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field WP2[21] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_WP2 field. */
#define AIPS_RD_PACRP_WP2(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_WP2_MASK) >> AIPS_PACRP_WP2_SHIFT)
#define AIPS_BRD_PACRP_WP2(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP2_SHIFT))

/*! @brief Set the WP2 field to a new value. */
#define AIPS_WR_PACRP_WP2(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_WP2_MASK, AIPS_PACRP_WP2(value)))
#define AIPS_BWR_PACRP_WP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field SP2[22] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_SP2 field. */
#define AIPS_RD_PACRP_SP2(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_SP2_MASK) >> AIPS_PACRP_SP2_SHIFT)
#define AIPS_BRD_PACRP_SP2(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP2_SHIFT))

/*! @brief Set the SP2 field to a new value. */
#define AIPS_WR_PACRP_SP2(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_SP2_MASK, AIPS_PACRP_SP2(value)))
#define AIPS_BWR_PACRP_SP2(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_TP1 field. */
#define AIPS_RD_PACRP_TP1(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_TP1_MASK) >> AIPS_PACRP_TP1_SHIFT)
#define AIPS_BRD_PACRP_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRP_TP1(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_TP1_MASK, AIPS_PACRP_TP1(value)))
#define AIPS_BWR_PACRP_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_WP1 field. */
#define AIPS_RD_PACRP_WP1(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_WP1_MASK) >> AIPS_PACRP_WP1_SHIFT)
#define AIPS_BRD_PACRP_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRP_WP1(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_WP1_MASK, AIPS_PACRP_WP1(value)))
#define AIPS_BWR_PACRP_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master must
 * be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_SP1 field. */
#define AIPS_RD_PACRP_SP1(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_SP1_MASK) >> AIPS_PACRP_SP1_SHIFT)
#define AIPS_BRD_PACRP_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRP_SP1(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_SP1_MASK, AIPS_PACRP_SP1(value)))
#define AIPS_BWR_PACRP_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this bit is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_TP0 field. */
#define AIPS_RD_PACRP_TP0(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_TP0_MASK) >> AIPS_PACRP_TP0_SHIFT)
#define AIPS_BRD_PACRP_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRP_TP0(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_TP0_MASK, AIPS_PACRP_TP0(value)))
#define AIPS_BWR_PACRP_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_WP0 field. */
#define AIPS_RD_PACRP_WP0(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_WP0_MASK) >> AIPS_PACRP_WP0_SHIFT)
#define AIPS_BRD_PACRP_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRP_WP0(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_WP0_MASK, AIPS_PACRP_WP0(value)))
#define AIPS_BWR_PACRP_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRP, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRP_SP0 field. */
#define AIPS_RD_PACRP_SP0(base) ((AIPS_PACRP_REG(base) & AIPS_PACRP_SP0_MASK) >> AIPS_PACRP_SP0_SHIFT)
#define AIPS_BRD_PACRP_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRP_SP0(base, value) (AIPS_RMW_PACRP(base, AIPS_PACRP_SP0_MASK, AIPS_PACRP_SP0(value)))
#define AIPS_BWR_PACRP_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRP_REG(base), AIPS_PACRP_SP0_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AIPS_PACRU - Peripheral Access Control Register
 ******************************************************************************/

/*!
 * @brief AIPS_PACRU - Peripheral Access Control Register (RW)
 *
 * Reset value: 0x44000000U
 *
 * PACRU defines the access levels for the two global spaces.
 */
/*!
 * @name Constants and macros for entire AIPS_PACRU register
 */
/*@{*/
#define AIPS_RD_PACRU(base)      (AIPS_PACRU_REG(base))
#define AIPS_WR_PACRU(base, value) (AIPS_PACRU_REG(base) = (value))
#define AIPS_RMW_PACRU(base, mask, value) (AIPS_WR_PACRU(base, (AIPS_RD_PACRU(base) & ~(mask)) | (value)))
#define AIPS_SET_PACRU(base, value) (AIPS_WR_PACRU(base, AIPS_RD_PACRU(base) |  (value)))
#define AIPS_CLR_PACRU(base, value) (AIPS_WR_PACRU(base, AIPS_RD_PACRU(base) & ~(value)))
#define AIPS_TOG_PACRU(base, value) (AIPS_WR_PACRU(base, AIPS_RD_PACRU(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AIPS_PACRU bitfields
 */

/*!
 * @name Register AIPS_PACRU, field TP1[24] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRU_TP1 field. */
#define AIPS_RD_PACRU_TP1(base) ((AIPS_PACRU_REG(base) & AIPS_PACRU_TP1_MASK) >> AIPS_PACRU_TP1_SHIFT)
#define AIPS_BRD_PACRU_TP1(base) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_TP1_SHIFT))

/*! @brief Set the TP1 field to a new value. */
#define AIPS_WR_PACRU_TP1(base, value) (AIPS_RMW_PACRU(base, AIPS_PACRU_TP1_MASK, AIPS_PACRU_TP1(value)))
#define AIPS_BWR_PACRU_TP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_TP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRU, field WP1[25] (RW)
 *
 * Determines whether the peripheral allows write accesss. When this bit is set
 * and a write access is attempted, access terminates with an error response and
 * no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRU_WP1 field. */
#define AIPS_RD_PACRU_WP1(base) ((AIPS_PACRU_REG(base) & AIPS_PACRU_WP1_MASK) >> AIPS_PACRU_WP1_SHIFT)
#define AIPS_BRD_PACRU_WP1(base) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_WP1_SHIFT))

/*! @brief Set the WP1 field to a new value. */
#define AIPS_WR_PACRU_WP1(base, value) (AIPS_RMW_PACRU(base, AIPS_PACRU_WP1_MASK, AIPS_PACRU_WP1(value)))
#define AIPS_BWR_PACRU_WP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_WP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRU, field SP1[26] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * accesses. When this field is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control field for the master
 * must be set. If not, access terminates with an error response and no peripheral
 * access initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRU_SP1 field. */
#define AIPS_RD_PACRU_SP1(base) ((AIPS_PACRU_REG(base) & AIPS_PACRU_SP1_MASK) >> AIPS_PACRU_SP1_SHIFT)
#define AIPS_BRD_PACRU_SP1(base) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_SP1_SHIFT))

/*! @brief Set the SP1 field to a new value. */
#define AIPS_WR_PACRU_SP1(base, value) (AIPS_RMW_PACRU(base, AIPS_PACRU_SP1_MASK, AIPS_PACRU_SP1(value)))
#define AIPS_BWR_PACRU_SP1(base, value) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_SP1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRU, field TP0[28] (RW)
 *
 * Determines whether the peripheral allows accesses from an untrusted master.
 * When this field is set and an access is attempted by an untrusted master, the
 * access terminates with an error response and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - Accesses from an untrusted master are allowed.
 * - 0b1 - Accesses from an untrusted master are not allowed.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRU_TP0 field. */
#define AIPS_RD_PACRU_TP0(base) ((AIPS_PACRU_REG(base) & AIPS_PACRU_TP0_MASK) >> AIPS_PACRU_TP0_SHIFT)
#define AIPS_BRD_PACRU_TP0(base) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_TP0_SHIFT))

/*! @brief Set the TP0 field to a new value. */
#define AIPS_WR_PACRU_TP0(base, value) (AIPS_RMW_PACRU(base, AIPS_PACRU_TP0_MASK, AIPS_PACRU_TP0(value)))
#define AIPS_BWR_PACRU_TP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_TP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRU, field WP0[29] (RW)
 *
 * Determines whether the peripheral allows write accesses. When this field is
 * set and a write access is attempted, access terminates with an error response
 * and no peripheral access initiates.
 *
 * Values:
 * - 0b0 - This peripheral allows write accesses.
 * - 0b1 - This peripheral is write protected.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRU_WP0 field. */
#define AIPS_RD_PACRU_WP0(base) ((AIPS_PACRU_REG(base) & AIPS_PACRU_WP0_MASK) >> AIPS_PACRU_WP0_SHIFT)
#define AIPS_BRD_PACRU_WP0(base) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_WP0_SHIFT))

/*! @brief Set the WP0 field to a new value. */
#define AIPS_WR_PACRU_WP0(base, value) (AIPS_RMW_PACRU(base, AIPS_PACRU_WP0_MASK, AIPS_PACRU_WP0(value)))
#define AIPS_BWR_PACRU_WP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_WP0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AIPS_PACRU, field SP0[30] (RW)
 *
 * Determines whether the peripheral requires supervisor privilege level for
 * access. When this bit is set, the master privilege level must indicate the
 * supervisor access attribute, and the MPRx[MPLn] control bit for the master must be
 * set. If not, access terminates with an error response and no peripheral access
 * initiates.
 *
 * Values:
 * - 0b0 - This peripheral does not require supervisor privilege level for
 *     accesses.
 * - 0b1 - This peripheral requires supervisor privilege level for accesses.
 */
/*@{*/
/*! @brief Read current value of the AIPS_PACRU_SP0 field. */
#define AIPS_RD_PACRU_SP0(base) ((AIPS_PACRU_REG(base) & AIPS_PACRU_SP0_MASK) >> AIPS_PACRU_SP0_SHIFT)
#define AIPS_BRD_PACRU_SP0(base) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_SP0_SHIFT))

/*! @brief Set the SP0 field to a new value. */
#define AIPS_WR_PACRU_SP0(base, value) (AIPS_RMW_PACRU(base, AIPS_PACRU_SP0_MASK, AIPS_PACRU_SP0(value)))
#define AIPS_BWR_PACRU_SP0(base, value) (BITBAND_ACCESS32(&AIPS_PACRU_REG(base), AIPS_PACRU_SP0_SHIFT) = (value))
/*@}*/

/*
 * MK64F12 AXBS
 *
 * Crossbar switch
 *
 * Registers defined in this header file:
 * - AXBS_PRS - Priority Registers Slave
 * - AXBS_CRS - Control Register
 * - AXBS_MGPCR0 - Master General Purpose Control Register
 * - AXBS_MGPCR1 - Master General Purpose Control Register
 * - AXBS_MGPCR2 - Master General Purpose Control Register
 * - AXBS_MGPCR3 - Master General Purpose Control Register
 * - AXBS_MGPCR4 - Master General Purpose Control Register
 * - AXBS_MGPCR5 - Master General Purpose Control Register
 */

#define AXBS_INSTANCE_COUNT (1U) /*!< Number of instances of the AXBS module. */
#define AXBS_IDX (0U) /*!< Instance number for AXBS. */

/*******************************************************************************
 * AXBS_PRS - Priority Registers Slave
 ******************************************************************************/

/*!
 * @brief AXBS_PRS - Priority Registers Slave (RW)
 *
 * Reset value: 0x00543210U
 *
 * The priority registers (PRSn) set the priority of each master port on a per
 * slave port basis and reside in each slave port. The priority register can be
 * accessed only with 32-bit accesses. After the CRSn[RO] bit is set, the PRSn
 * register can only be read; attempts to write to it have no effect on PRSn and
 * result in a bus-error response to the master initiating the write. Two available
 * masters must not be programmed with the same priority level. Attempts to
 * program two or more masters with the same priority level result in a bus-error
 * response and the PRSn is not updated. Valid values for the Mn priority fields
 * depend on which masters are available on the chip. This information can be found in
 * the chip-specific information for the crossbar. If the chip contains less
 * than five masters, values 0 to 3 are valid. Writing other values will result in
 * an error. If the chip contains five or more masters, valid values are 0 to n-1,
 * where n is the number of masters attached to the AXBS module. Other values
 * will result in an error.
 */
/*!
 * @name Constants and macros for entire AXBS_PRS register
 */
/*@{*/
#define AXBS_RD_PRS(base, index) (AXBS_PRS_REG(base, index))
#define AXBS_WR_PRS(base, index, value) (AXBS_PRS_REG(base, index) = (value))
#define AXBS_RMW_PRS(base, index, mask, value) (AXBS_WR_PRS(base, index, (AXBS_RD_PRS(base, index) & ~(mask)) | (value)))
#define AXBS_SET_PRS(base, index, value) (AXBS_WR_PRS(base, index, AXBS_RD_PRS(base, index) |  (value)))
#define AXBS_CLR_PRS(base, index, value) (AXBS_WR_PRS(base, index, AXBS_RD_PRS(base, index) & ~(value)))
#define AXBS_TOG_PRS(base, index, value) (AXBS_WR_PRS(base, index, AXBS_RD_PRS(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AXBS_PRS bitfields
 */

/*!
 * @name Register AXBS_PRS, field M0[2:0] (RW)
 *
 * Values:
 * - 0b000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 0b001 - This master has level 2 priority when accessing the slave port.
 * - 0b010 - This master has level 3 priority when accessing the slave port.
 * - 0b011 - This master has level 4 priority when accessing the slave port.
 * - 0b100 - This master has level 5 priority when accessing the slave port.
 * - 0b101 - This master has level 6 priority when accessing the slave port.
 * - 0b110 - This master has level 7 priority when accessing the slave port.
 * - 0b111 - This master has level 8, or lowest, priority when accessing the
 *     slave port.
 */
/*@{*/
/*! @brief Read current value of the AXBS_PRS_M0 field. */
#define AXBS_RD_PRS_M0(base, index) ((AXBS_PRS_REG(base, index) & AXBS_PRS_M0_MASK) >> AXBS_PRS_M0_SHIFT)
#define AXBS_BRD_PRS_M0(base, index) (AXBS_RD_PRS_M0(base, index))

/*! @brief Set the M0 field to a new value. */
#define AXBS_WR_PRS_M0(base, index, value) (AXBS_RMW_PRS(base, index, AXBS_PRS_M0_MASK, AXBS_PRS_M0(value)))
#define AXBS_BWR_PRS_M0(base, index, value) (AXBS_WR_PRS_M0(base, index, value))
/*@}*/

/*!
 * @name Register AXBS_PRS, field M1[6:4] (RW)
 *
 * Values:
 * - 0b000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 0b001 - This master has level 2 priority when accessing the slave port.
 * - 0b010 - This master has level 3 priority when accessing the slave port.
 * - 0b011 - This master has level 4 priority when accessing the slave port.
 * - 0b100 - This master has level 5 priority when accessing the slave port.
 * - 0b101 - This master has level 6 priority when accessing the slave port.
 * - 0b110 - This master has level 7 priority when accessing the slave port.
 * - 0b111 - This master has level 8, or lowest, priority when accessing the
 *     slave port.
 */
/*@{*/
/*! @brief Read current value of the AXBS_PRS_M1 field. */
#define AXBS_RD_PRS_M1(base, index) ((AXBS_PRS_REG(base, index) & AXBS_PRS_M1_MASK) >> AXBS_PRS_M1_SHIFT)
#define AXBS_BRD_PRS_M1(base, index) (AXBS_RD_PRS_M1(base, index))

/*! @brief Set the M1 field to a new value. */
#define AXBS_WR_PRS_M1(base, index, value) (AXBS_RMW_PRS(base, index, AXBS_PRS_M1_MASK, AXBS_PRS_M1(value)))
#define AXBS_BWR_PRS_M1(base, index, value) (AXBS_WR_PRS_M1(base, index, value))
/*@}*/

/*!
 * @name Register AXBS_PRS, field M2[10:8] (RW)
 *
 * Values:
 * - 0b000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 0b001 - This master has level 2 priority when accessing the slave port.
 * - 0b010 - This master has level 3 priority when accessing the slave port.
 * - 0b011 - This master has level 4 priority when accessing the slave port.
 * - 0b100 - This master has level 5 priority when accessing the slave port.
 * - 0b101 - This master has level 6 priority when accessing the slave port.
 * - 0b110 - This master has level 7 priority when accessing the slave port.
 * - 0b111 - This master has level 8, or lowest, priority when accessing the
 *     slave port.
 */
/*@{*/
/*! @brief Read current value of the AXBS_PRS_M2 field. */
#define AXBS_RD_PRS_M2(base, index) ((AXBS_PRS_REG(base, index) & AXBS_PRS_M2_MASK) >> AXBS_PRS_M2_SHIFT)
#define AXBS_BRD_PRS_M2(base, index) (AXBS_RD_PRS_M2(base, index))

/*! @brief Set the M2 field to a new value. */
#define AXBS_WR_PRS_M2(base, index, value) (AXBS_RMW_PRS(base, index, AXBS_PRS_M2_MASK, AXBS_PRS_M2(value)))
#define AXBS_BWR_PRS_M2(base, index, value) (AXBS_WR_PRS_M2(base, index, value))
/*@}*/

/*!
 * @name Register AXBS_PRS, field M3[14:12] (RW)
 *
 * Values:
 * - 0b000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 0b001 - This master has level 2 priority when accessing the slave port.
 * - 0b010 - This master has level 3 priority when accessing the slave port.
 * - 0b011 - This master has level 4 priority when accessing the slave port.
 * - 0b100 - This master has level 5 priority when accessing the slave port.
 * - 0b101 - This master has level 6 priority when accessing the slave port.
 * - 0b110 - This master has level 7 priority when accessing the slave port.
 * - 0b111 - This master has level 8, or lowest, priority when accessing the
 *     slave port.
 */
/*@{*/
/*! @brief Read current value of the AXBS_PRS_M3 field. */
#define AXBS_RD_PRS_M3(base, index) ((AXBS_PRS_REG(base, index) & AXBS_PRS_M3_MASK) >> AXBS_PRS_M3_SHIFT)
#define AXBS_BRD_PRS_M3(base, index) (AXBS_RD_PRS_M3(base, index))

/*! @brief Set the M3 field to a new value. */
#define AXBS_WR_PRS_M3(base, index, value) (AXBS_RMW_PRS(base, index, AXBS_PRS_M3_MASK, AXBS_PRS_M3(value)))
#define AXBS_BWR_PRS_M3(base, index, value) (AXBS_WR_PRS_M3(base, index, value))
/*@}*/

/*!
 * @name Register AXBS_PRS, field M4[18:16] (RW)
 *
 * Values:
 * - 0b000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 0b001 - This master has level 2 priority when accessing the slave port.
 * - 0b010 - This master has level 3 priority when accessing the slave port.
 * - 0b011 - This master has level 4 priority when accessing the slave port.
 * - 0b100 - This master has level 5 priority when accessing the slave port.
 * - 0b101 - This master has level 6 priority when accessing the slave port.
 * - 0b110 - This master has level 7 priority when accessing the slave port.
 * - 0b111 - This master has level 8, or lowest, priority when accessing the
 *     slave port.
 */
/*@{*/
/*! @brief Read current value of the AXBS_PRS_M4 field. */
#define AXBS_RD_PRS_M4(base, index) ((AXBS_PRS_REG(base, index) & AXBS_PRS_M4_MASK) >> AXBS_PRS_M4_SHIFT)
#define AXBS_BRD_PRS_M4(base, index) (AXBS_RD_PRS_M4(base, index))

/*! @brief Set the M4 field to a new value. */
#define AXBS_WR_PRS_M4(base, index, value) (AXBS_RMW_PRS(base, index, AXBS_PRS_M4_MASK, AXBS_PRS_M4(value)))
#define AXBS_BWR_PRS_M4(base, index, value) (AXBS_WR_PRS_M4(base, index, value))
/*@}*/

/*!
 * @name Register AXBS_PRS, field M5[22:20] (RW)
 *
 * Values:
 * - 0b000 - This master has level 1, or highest, priority when accessing the
 *     slave port.
 * - 0b001 - This master has level 2 priority when accessing the slave port.
 * - 0b010 - This master has level 3 priority when accessing the slave port.
 * - 0b011 - This master has level 4 priority when accessing the slave port.
 * - 0b100 - This master has level 5 priority when accessing the slave port.
 * - 0b101 - This master has level 6 priority when accessing the slave port.
 * - 0b110 - This master has level 7 priority when accessing the slave port.
 * - 0b111 - This master has level 8, or lowest, priority when accessing the
 *     slave port.
 */
/*@{*/
/*! @brief Read current value of the AXBS_PRS_M5 field. */
#define AXBS_RD_PRS_M5(base, index) ((AXBS_PRS_REG(base, index) & AXBS_PRS_M5_MASK) >> AXBS_PRS_M5_SHIFT)
#define AXBS_BRD_PRS_M5(base, index) (AXBS_RD_PRS_M5(base, index))

/*! @brief Set the M5 field to a new value. */
#define AXBS_WR_PRS_M5(base, index, value) (AXBS_RMW_PRS(base, index, AXBS_PRS_M5_MASK, AXBS_PRS_M5(value)))
#define AXBS_BWR_PRS_M5(base, index, value) (AXBS_WR_PRS_M5(base, index, value))
/*@}*/

/*******************************************************************************
 * AXBS_CRS - Control Register
 ******************************************************************************/

/*!
 * @brief AXBS_CRS - Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers control several features of each slave port and must be
 * accessed using 32-bit accesses. After CRSn[RO] is set, the PRSn can only be read;
 * attempts to write to it have no effect and result in an error response.
 */
/*!
 * @name Constants and macros for entire AXBS_CRS register
 */
/*@{*/
#define AXBS_RD_CRS(base, index) (AXBS_CRS_REG(base, index))
#define AXBS_WR_CRS(base, index, value) (AXBS_CRS_REG(base, index) = (value))
#define AXBS_RMW_CRS(base, index, mask, value) (AXBS_WR_CRS(base, index, (AXBS_RD_CRS(base, index) & ~(mask)) | (value)))
#define AXBS_SET_CRS(base, index, value) (AXBS_WR_CRS(base, index, AXBS_RD_CRS(base, index) |  (value)))
#define AXBS_CLR_CRS(base, index, value) (AXBS_WR_CRS(base, index, AXBS_RD_CRS(base, index) & ~(value)))
#define AXBS_TOG_CRS(base, index, value) (AXBS_WR_CRS(base, index, AXBS_RD_CRS(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AXBS_CRS bitfields
 */

/*!
 * @name Register AXBS_CRS, field PARK[2:0] (RW)
 *
 * Determines which master port the current slave port parks on when no masters
 * are actively making requests and the PCTL bits are cleared. Select only master
 * ports that are present on the chip. Otherwise, undefined behavior might occur.
 *
 * Values:
 * - 0b000 - Park on master port M0
 * - 0b001 - Park on master port M1
 * - 0b010 - Park on master port M2
 * - 0b011 - Park on master port M3
 * - 0b100 - Park on master port M4
 * - 0b101 - Park on master port M5
 * - 0b110 - Park on master port M6
 * - 0b111 - Park on master port M7
 */
/*@{*/
/*! @brief Read current value of the AXBS_CRS_PARK field. */
#define AXBS_RD_CRS_PARK(base, index) ((AXBS_CRS_REG(base, index) & AXBS_CRS_PARK_MASK) >> AXBS_CRS_PARK_SHIFT)
#define AXBS_BRD_CRS_PARK(base, index) (AXBS_RD_CRS_PARK(base, index))

/*! @brief Set the PARK field to a new value. */
#define AXBS_WR_CRS_PARK(base, index, value) (AXBS_RMW_CRS(base, index, AXBS_CRS_PARK_MASK, AXBS_CRS_PARK(value)))
#define AXBS_BWR_CRS_PARK(base, index, value) (AXBS_WR_CRS_PARK(base, index, value))
/*@}*/

/*!
 * @name Register AXBS_CRS, field PCTL[5:4] (RW)
 *
 * Determines the slave port's parking control. The low-power park feature
 * results in an overall power savings if the slave port is not saturated. However,
 * this forces an extra latency clock when any master tries to access the slave
 * port while not in use because it is not parked on any master.
 *
 * Values:
 * - 0b00 - When no master makes a request, the arbiter parks the slave port on
 *     the master port defined by the PARK field
 * - 0b01 - When no master makes a request, the arbiter parks the slave port on
 *     the last master to be in control of the slave port
 * - 0b10 - When no master makes a request, the slave port is not parked on a
 *     master and the arbiter drives all outputs to a constant safe state
 * - 0b11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the AXBS_CRS_PCTL field. */
#define AXBS_RD_CRS_PCTL(base, index) ((AXBS_CRS_REG(base, index) & AXBS_CRS_PCTL_MASK) >> AXBS_CRS_PCTL_SHIFT)
#define AXBS_BRD_CRS_PCTL(base, index) (AXBS_RD_CRS_PCTL(base, index))

/*! @brief Set the PCTL field to a new value. */
#define AXBS_WR_CRS_PCTL(base, index, value) (AXBS_RMW_CRS(base, index, AXBS_CRS_PCTL_MASK, AXBS_CRS_PCTL(value)))
#define AXBS_BWR_CRS_PCTL(base, index, value) (AXBS_WR_CRS_PCTL(base, index, value))
/*@}*/

/*!
 * @name Register AXBS_CRS, field ARB[9:8] (RW)
 *
 * Selects the arbitration policy for the slave port.
 *
 * Values:
 * - 0b00 - Fixed priority
 * - 0b01 - Round-robin, or rotating, priority
 * - 0b10 - Reserved
 * - 0b11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the AXBS_CRS_ARB field. */
#define AXBS_RD_CRS_ARB(base, index) ((AXBS_CRS_REG(base, index) & AXBS_CRS_ARB_MASK) >> AXBS_CRS_ARB_SHIFT)
#define AXBS_BRD_CRS_ARB(base, index) (AXBS_RD_CRS_ARB(base, index))

/*! @brief Set the ARB field to a new value. */
#define AXBS_WR_CRS_ARB(base, index, value) (AXBS_RMW_CRS(base, index, AXBS_CRS_ARB_MASK, AXBS_CRS_ARB(value)))
#define AXBS_BWR_CRS_ARB(base, index, value) (AXBS_WR_CRS_ARB(base, index, value))
/*@}*/

/*!
 * @name Register AXBS_CRS, field HLP[30] (RW)
 *
 * Sets the initial arbitration priority for low power mode requests . Setting
 * this bit will not affect the request for low power mode from attaining highest
 * priority once it has control of the slave ports.
 *
 * Values:
 * - 0b0 - The low power mode request has the highest priority for arbitration
 *     on this slave port
 * - 0b1 - The low power mode request has the lowest initial priority for
 *     arbitration on this slave port
 */
/*@{*/
/*! @brief Read current value of the AXBS_CRS_HLP field. */
#define AXBS_RD_CRS_HLP(base, index) ((AXBS_CRS_REG(base, index) & AXBS_CRS_HLP_MASK) >> AXBS_CRS_HLP_SHIFT)
#define AXBS_BRD_CRS_HLP(base, index) (BITBAND_ACCESS32(&AXBS_CRS_REG(base, index), AXBS_CRS_HLP_SHIFT))

/*! @brief Set the HLP field to a new value. */
#define AXBS_WR_CRS_HLP(base, index, value) (AXBS_RMW_CRS(base, index, AXBS_CRS_HLP_MASK, AXBS_CRS_HLP(value)))
#define AXBS_BWR_CRS_HLP(base, index, value) (BITBAND_ACCESS32(&AXBS_CRS_REG(base, index), AXBS_CRS_HLP_SHIFT) = (value))
/*@}*/

/*!
 * @name Register AXBS_CRS, field RO[31] (RW)
 *
 * Forces the slave port's CSRn and PRSn registers to be read-only. After set,
 * only a hardware reset clears it.
 *
 * Values:
 * - 0b0 - The slave port's registers are writeable
 * - 0b1 - The slave port's registers are read-only and cannot be written.
 *     Attempted writes have no effect on the registers and result in a bus error
 *     response.
 */
/*@{*/
/*! @brief Read current value of the AXBS_CRS_RO field. */
#define AXBS_RD_CRS_RO(base, index) ((AXBS_CRS_REG(base, index) & AXBS_CRS_RO_MASK) >> AXBS_CRS_RO_SHIFT)
#define AXBS_BRD_CRS_RO(base, index) (BITBAND_ACCESS32(&AXBS_CRS_REG(base, index), AXBS_CRS_RO_SHIFT))

/*! @brief Set the RO field to a new value. */
#define AXBS_WR_CRS_RO(base, index, value) (AXBS_RMW_CRS(base, index, AXBS_CRS_RO_MASK, AXBS_CRS_RO(value)))
#define AXBS_BWR_CRS_RO(base, index, value) (BITBAND_ACCESS32(&AXBS_CRS_REG(base, index), AXBS_CRS_RO_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * AXBS_MGPCR0 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief AXBS_MGPCR0 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
/*!
 * @name Constants and macros for entire AXBS_MGPCR0 register
 */
/*@{*/
#define AXBS_RD_MGPCR0(base)     (AXBS_MGPCR0_REG(base))
#define AXBS_WR_MGPCR0(base, value) (AXBS_MGPCR0_REG(base) = (value))
#define AXBS_RMW_MGPCR0(base, mask, value) (AXBS_WR_MGPCR0(base, (AXBS_RD_MGPCR0(base) & ~(mask)) | (value)))
#define AXBS_SET_MGPCR0(base, value) (AXBS_WR_MGPCR0(base, AXBS_RD_MGPCR0(base) |  (value)))
#define AXBS_CLR_MGPCR0(base, value) (AXBS_WR_MGPCR0(base, AXBS_RD_MGPCR0(base) & ~(value)))
#define AXBS_TOG_MGPCR0(base, value) (AXBS_WR_MGPCR0(base, AXBS_RD_MGPCR0(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR0 bitfields
 */

/*!
 * @name Register AXBS_MGPCR0, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 0b000 - No arbitration is allowed during an undefined length burst
 * - 0b001 - Arbitration is allowed at any time during an undefined length burst
 * - 0b010 - Arbitration is allowed after four beats of an undefined length burst
 * - 0b011 - Arbitration is allowed after eight beats of an undefined length
 *     burst
 * - 0b100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 0b101 - Reserved
 * - 0b110 - Reserved
 * - 0b111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the AXBS_MGPCR0_AULB field. */
#define AXBS_RD_MGPCR0_AULB(base) ((AXBS_MGPCR0_REG(base) & AXBS_MGPCR0_AULB_MASK) >> AXBS_MGPCR0_AULB_SHIFT)
#define AXBS_BRD_MGPCR0_AULB(base) (AXBS_RD_MGPCR0_AULB(base))

/*! @brief Set the AULB field to a new value. */
#define AXBS_WR_MGPCR0_AULB(base, value) (AXBS_RMW_MGPCR0(base, AXBS_MGPCR0_AULB_MASK, AXBS_MGPCR0_AULB(value)))
#define AXBS_BWR_MGPCR0_AULB(base, value) (AXBS_WR_MGPCR0_AULB(base, value))
/*@}*/

/*******************************************************************************
 * AXBS_MGPCR1 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief AXBS_MGPCR1 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
/*!
 * @name Constants and macros for entire AXBS_MGPCR1 register
 */
/*@{*/
#define AXBS_RD_MGPCR1(base)     (AXBS_MGPCR1_REG(base))
#define AXBS_WR_MGPCR1(base, value) (AXBS_MGPCR1_REG(base) = (value))
#define AXBS_RMW_MGPCR1(base, mask, value) (AXBS_WR_MGPCR1(base, (AXBS_RD_MGPCR1(base) & ~(mask)) | (value)))
#define AXBS_SET_MGPCR1(base, value) (AXBS_WR_MGPCR1(base, AXBS_RD_MGPCR1(base) |  (value)))
#define AXBS_CLR_MGPCR1(base, value) (AXBS_WR_MGPCR1(base, AXBS_RD_MGPCR1(base) & ~(value)))
#define AXBS_TOG_MGPCR1(base, value) (AXBS_WR_MGPCR1(base, AXBS_RD_MGPCR1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR1 bitfields
 */

/*!
 * @name Register AXBS_MGPCR1, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 0b000 - No arbitration is allowed during an undefined length burst
 * - 0b001 - Arbitration is allowed at any time during an undefined length burst
 * - 0b010 - Arbitration is allowed after four beats of an undefined length burst
 * - 0b011 - Arbitration is allowed after eight beats of an undefined length
 *     burst
 * - 0b100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 0b101 - Reserved
 * - 0b110 - Reserved
 * - 0b111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the AXBS_MGPCR1_AULB field. */
#define AXBS_RD_MGPCR1_AULB(base) ((AXBS_MGPCR1_REG(base) & AXBS_MGPCR1_AULB_MASK) >> AXBS_MGPCR1_AULB_SHIFT)
#define AXBS_BRD_MGPCR1_AULB(base) (AXBS_RD_MGPCR1_AULB(base))

/*! @brief Set the AULB field to a new value. */
#define AXBS_WR_MGPCR1_AULB(base, value) (AXBS_RMW_MGPCR1(base, AXBS_MGPCR1_AULB_MASK, AXBS_MGPCR1_AULB(value)))
#define AXBS_BWR_MGPCR1_AULB(base, value) (AXBS_WR_MGPCR1_AULB(base, value))
/*@}*/

/*******************************************************************************
 * AXBS_MGPCR2 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief AXBS_MGPCR2 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
/*!
 * @name Constants and macros for entire AXBS_MGPCR2 register
 */
/*@{*/
#define AXBS_RD_MGPCR2(base)     (AXBS_MGPCR2_REG(base))
#define AXBS_WR_MGPCR2(base, value) (AXBS_MGPCR2_REG(base) = (value))
#define AXBS_RMW_MGPCR2(base, mask, value) (AXBS_WR_MGPCR2(base, (AXBS_RD_MGPCR2(base) & ~(mask)) | (value)))
#define AXBS_SET_MGPCR2(base, value) (AXBS_WR_MGPCR2(base, AXBS_RD_MGPCR2(base) |  (value)))
#define AXBS_CLR_MGPCR2(base, value) (AXBS_WR_MGPCR2(base, AXBS_RD_MGPCR2(base) & ~(value)))
#define AXBS_TOG_MGPCR2(base, value) (AXBS_WR_MGPCR2(base, AXBS_RD_MGPCR2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR2 bitfields
 */

/*!
 * @name Register AXBS_MGPCR2, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 0b000 - No arbitration is allowed during an undefined length burst
 * - 0b001 - Arbitration is allowed at any time during an undefined length burst
 * - 0b010 - Arbitration is allowed after four beats of an undefined length burst
 * - 0b011 - Arbitration is allowed after eight beats of an undefined length
 *     burst
 * - 0b100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 0b101 - Reserved
 * - 0b110 - Reserved
 * - 0b111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the AXBS_MGPCR2_AULB field. */
#define AXBS_RD_MGPCR2_AULB(base) ((AXBS_MGPCR2_REG(base) & AXBS_MGPCR2_AULB_MASK) >> AXBS_MGPCR2_AULB_SHIFT)
#define AXBS_BRD_MGPCR2_AULB(base) (AXBS_RD_MGPCR2_AULB(base))

/*! @brief Set the AULB field to a new value. */
#define AXBS_WR_MGPCR2_AULB(base, value) (AXBS_RMW_MGPCR2(base, AXBS_MGPCR2_AULB_MASK, AXBS_MGPCR2_AULB(value)))
#define AXBS_BWR_MGPCR2_AULB(base, value) (AXBS_WR_MGPCR2_AULB(base, value))
/*@}*/

/*******************************************************************************
 * AXBS_MGPCR3 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief AXBS_MGPCR3 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
/*!
 * @name Constants and macros for entire AXBS_MGPCR3 register
 */
/*@{*/
#define AXBS_RD_MGPCR3(base)     (AXBS_MGPCR3_REG(base))
#define AXBS_WR_MGPCR3(base, value) (AXBS_MGPCR3_REG(base) = (value))
#define AXBS_RMW_MGPCR3(base, mask, value) (AXBS_WR_MGPCR3(base, (AXBS_RD_MGPCR3(base) & ~(mask)) | (value)))
#define AXBS_SET_MGPCR3(base, value) (AXBS_WR_MGPCR3(base, AXBS_RD_MGPCR3(base) |  (value)))
#define AXBS_CLR_MGPCR3(base, value) (AXBS_WR_MGPCR3(base, AXBS_RD_MGPCR3(base) & ~(value)))
#define AXBS_TOG_MGPCR3(base, value) (AXBS_WR_MGPCR3(base, AXBS_RD_MGPCR3(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR3 bitfields
 */

/*!
 * @name Register AXBS_MGPCR3, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 0b000 - No arbitration is allowed during an undefined length burst
 * - 0b001 - Arbitration is allowed at any time during an undefined length burst
 * - 0b010 - Arbitration is allowed after four beats of an undefined length burst
 * - 0b011 - Arbitration is allowed after eight beats of an undefined length
 *     burst
 * - 0b100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 0b101 - Reserved
 * - 0b110 - Reserved
 * - 0b111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the AXBS_MGPCR3_AULB field. */
#define AXBS_RD_MGPCR3_AULB(base) ((AXBS_MGPCR3_REG(base) & AXBS_MGPCR3_AULB_MASK) >> AXBS_MGPCR3_AULB_SHIFT)
#define AXBS_BRD_MGPCR3_AULB(base) (AXBS_RD_MGPCR3_AULB(base))

/*! @brief Set the AULB field to a new value. */
#define AXBS_WR_MGPCR3_AULB(base, value) (AXBS_RMW_MGPCR3(base, AXBS_MGPCR3_AULB_MASK, AXBS_MGPCR3_AULB(value)))
#define AXBS_BWR_MGPCR3_AULB(base, value) (AXBS_WR_MGPCR3_AULB(base, value))
/*@}*/

/*******************************************************************************
 * AXBS_MGPCR4 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief AXBS_MGPCR4 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
/*!
 * @name Constants and macros for entire AXBS_MGPCR4 register
 */
/*@{*/
#define AXBS_RD_MGPCR4(base)     (AXBS_MGPCR4_REG(base))
#define AXBS_WR_MGPCR4(base, value) (AXBS_MGPCR4_REG(base) = (value))
#define AXBS_RMW_MGPCR4(base, mask, value) (AXBS_WR_MGPCR4(base, (AXBS_RD_MGPCR4(base) & ~(mask)) | (value)))
#define AXBS_SET_MGPCR4(base, value) (AXBS_WR_MGPCR4(base, AXBS_RD_MGPCR4(base) |  (value)))
#define AXBS_CLR_MGPCR4(base, value) (AXBS_WR_MGPCR4(base, AXBS_RD_MGPCR4(base) & ~(value)))
#define AXBS_TOG_MGPCR4(base, value) (AXBS_WR_MGPCR4(base, AXBS_RD_MGPCR4(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR4 bitfields
 */

/*!
 * @name Register AXBS_MGPCR4, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 0b000 - No arbitration is allowed during an undefined length burst
 * - 0b001 - Arbitration is allowed at any time during an undefined length burst
 * - 0b010 - Arbitration is allowed after four beats of an undefined length burst
 * - 0b011 - Arbitration is allowed after eight beats of an undefined length
 *     burst
 * - 0b100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 0b101 - Reserved
 * - 0b110 - Reserved
 * - 0b111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the AXBS_MGPCR4_AULB field. */
#define AXBS_RD_MGPCR4_AULB(base) ((AXBS_MGPCR4_REG(base) & AXBS_MGPCR4_AULB_MASK) >> AXBS_MGPCR4_AULB_SHIFT)
#define AXBS_BRD_MGPCR4_AULB(base) (AXBS_RD_MGPCR4_AULB(base))

/*! @brief Set the AULB field to a new value. */
#define AXBS_WR_MGPCR4_AULB(base, value) (AXBS_RMW_MGPCR4(base, AXBS_MGPCR4_AULB_MASK, AXBS_MGPCR4_AULB(value)))
#define AXBS_BWR_MGPCR4_AULB(base, value) (AXBS_WR_MGPCR4_AULB(base, value))
/*@}*/

/*******************************************************************************
 * AXBS_MGPCR5 - Master General Purpose Control Register
 ******************************************************************************/

/*!
 * @brief AXBS_MGPCR5 - Master General Purpose Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The MGPCR controls only whether the master's undefined length burst accesses
 * are allowed to complete uninterrupted or whether they can be broken by
 * requests from higher priority masters. The MGPCR can be accessed only in Supervisor
 * mode with 32-bit accesses.
 */
/*!
 * @name Constants and macros for entire AXBS_MGPCR5 register
 */
/*@{*/
#define AXBS_RD_MGPCR5(base)     (AXBS_MGPCR5_REG(base))
#define AXBS_WR_MGPCR5(base, value) (AXBS_MGPCR5_REG(base) = (value))
#define AXBS_RMW_MGPCR5(base, mask, value) (AXBS_WR_MGPCR5(base, (AXBS_RD_MGPCR5(base) & ~(mask)) | (value)))
#define AXBS_SET_MGPCR5(base, value) (AXBS_WR_MGPCR5(base, AXBS_RD_MGPCR5(base) |  (value)))
#define AXBS_CLR_MGPCR5(base, value) (AXBS_WR_MGPCR5(base, AXBS_RD_MGPCR5(base) & ~(value)))
#define AXBS_TOG_MGPCR5(base, value) (AXBS_WR_MGPCR5(base, AXBS_RD_MGPCR5(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual AXBS_MGPCR5 bitfields
 */

/*!
 * @name Register AXBS_MGPCR5, field AULB[2:0] (RW)
 *
 * Determines whether, and when, the crossbar switch arbitrates away the slave
 * port the master owns when the master is performing undefined length burst
 * accesses.
 *
 * Values:
 * - 0b000 - No arbitration is allowed during an undefined length burst
 * - 0b001 - Arbitration is allowed at any time during an undefined length burst
 * - 0b010 - Arbitration is allowed after four beats of an undefined length burst
 * - 0b011 - Arbitration is allowed after eight beats of an undefined length
 *     burst
 * - 0b100 - Arbitration is allowed after 16 beats of an undefined length burst
 * - 0b101 - Reserved
 * - 0b110 - Reserved
 * - 0b111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the AXBS_MGPCR5_AULB field. */
#define AXBS_RD_MGPCR5_AULB(base) ((AXBS_MGPCR5_REG(base) & AXBS_MGPCR5_AULB_MASK) >> AXBS_MGPCR5_AULB_SHIFT)
#define AXBS_BRD_MGPCR5_AULB(base) (AXBS_RD_MGPCR5_AULB(base))

/*! @brief Set the AULB field to a new value. */
#define AXBS_WR_MGPCR5_AULB(base, value) (AXBS_RMW_MGPCR5(base, AXBS_MGPCR5_AULB_MASK, AXBS_MGPCR5_AULB(value)))
#define AXBS_BWR_MGPCR5_AULB(base, value) (AXBS_WR_MGPCR5_AULB(base, value))
/*@}*/

/*
 * MK64F12 CAN
 *
 * Flex Controller Area Network module
 *
 * Registers defined in this header file:
 * - CAN_MCR - Module Configuration Register
 * - CAN_CTRL1 - Control 1 register
 * - CAN_TIMER - Free Running Timer
 * - CAN_RXMGMASK - Rx Mailboxes Global Mask Register
 * - CAN_RX14MASK - Rx 14 Mask register
 * - CAN_RX15MASK - Rx 15 Mask register
 * - CAN_ECR - Error Counter
 * - CAN_ESR1 - Error and Status 1 register
 * - CAN_IMASK1 - Interrupt Masks 1 register
 * - CAN_IFLAG1 - Interrupt Flags 1 register
 * - CAN_CTRL2 - Control 2 register
 * - CAN_ESR2 - Error and Status 2 register
 * - CAN_CRCR - CRC Register
 * - CAN_RXFGMASK - Rx FIFO Global Mask register
 * - CAN_RXFIR - Rx FIFO Information Register
 * - CAN_CS - Message Buffer 0 CS Register
 * - CAN_ID - Message Buffer 0 ID Register
 * - CAN_WORD0 - Message Buffer 0 WORD0 Register
 * - CAN_WORD1 - Message Buffer 0 WORD1 Register
 * - CAN_RXIMR - Rx Individual Mask Registers
 */

#define CAN_INSTANCE_COUNT (1U) /*!< Number of instances of the CAN module. */
#define CAN0_IDX (0U) /*!< Instance number for CAN0. */

/*******************************************************************************
 * CAN_MCR - Module Configuration Register
 ******************************************************************************/

/*!
 * @brief CAN_MCR - Module Configuration Register (RW)
 *
 * Reset value: 0xD890000FU
 *
 * This register defines global system configurations, such as the module
 * operation modes and the maximum message buffer configuration.
 */
/*!
 * @name Constants and macros for entire CAN_MCR register
 */
/*@{*/
#define CAN_RD_MCR(base)         (CAN_MCR_REG(base))
#define CAN_WR_MCR(base, value)  (CAN_MCR_REG(base) = (value))
#define CAN_RMW_MCR(base, mask, value) (CAN_WR_MCR(base, (CAN_RD_MCR(base) & ~(mask)) | (value)))
#define CAN_SET_MCR(base, value) (CAN_WR_MCR(base, CAN_RD_MCR(base) |  (value)))
#define CAN_CLR_MCR(base, value) (CAN_WR_MCR(base, CAN_RD_MCR(base) & ~(value)))
#define CAN_TOG_MCR(base, value) (CAN_WR_MCR(base, CAN_RD_MCR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_MCR bitfields
 */

/*!
 * @name Register CAN_MCR, field MAXMB[6:0] (RW)
 *
 * This 7-bit field defines the number of the last Message Buffers that will
 * take part in the matching and arbitration processes. The reset value (0x0F) is
 * equivalent to a 16 MB configuration. This field can be written only in Freeze
 * mode because it is blocked by hardware in other modes. Number of the last MB =
 * MAXMB MAXMB must be programmed with a value smaller than the parameter
 * NUMBER_OF_MB, otherwise the number of the last effective Message Buffer will be:
 * (NUMBER_OF_MB - 1) Additionally, the value of MAXMB must encompass the FIFO size
 * defined by CTRL2[RFFN]. MAXMB also impacts the definition of the minimum number
 * of peripheral clocks per CAN bit as described in Table "Minimum Ratio Between
 * Peripheral Clock Frequency and CAN Bit Rate" (in Section "Arbitration and
 * Matching Timing").
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_MAXMB field. */
#define CAN_RD_MCR_MAXMB(base) ((CAN_MCR_REG(base) & CAN_MCR_MAXMB_MASK) >> CAN_MCR_MAXMB_SHIFT)
#define CAN_BRD_MCR_MAXMB(base) (CAN_RD_MCR_MAXMB(base))

/*! @brief Set the MAXMB field to a new value. */
#define CAN_WR_MCR_MAXMB(base, value) (CAN_RMW_MCR(base, CAN_MCR_MAXMB_MASK, CAN_MCR_MAXMB(value)))
#define CAN_BWR_MCR_MAXMB(base, value) (CAN_WR_MCR_MAXMB(base, value))
/*@}*/

/*!
 * @name Register CAN_MCR, field IDAM[9:8] (RW)
 *
 * This 2-bit field identifies the format of the Rx FIFO ID Filter Table
 * elements. Note that all elements of the table are configured at the same time by this
 * field (they are all the same format). See Section "Rx FIFO Structure". This
 * field can be written only in Freeze mode because it is blocked by hardware in
 * other modes.
 *
 * Values:
 * - 0b00 - Format A: One full ID (standard and extended) per ID Filter Table
 *     element.
 * - 0b01 - Format B: Two full standard IDs or two partial 14-bit (standard and
 *     extended) IDs per ID Filter Table element.
 * - 0b10 - Format C: Four partial 8-bit Standard IDs per ID Filter Table
 *     element.
 * - 0b11 - Format D: All frames rejected.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_IDAM field. */
#define CAN_RD_MCR_IDAM(base) ((CAN_MCR_REG(base) & CAN_MCR_IDAM_MASK) >> CAN_MCR_IDAM_SHIFT)
#define CAN_BRD_MCR_IDAM(base) (CAN_RD_MCR_IDAM(base))

/*! @brief Set the IDAM field to a new value. */
#define CAN_WR_MCR_IDAM(base, value) (CAN_RMW_MCR(base, CAN_MCR_IDAM_MASK, CAN_MCR_IDAM(value)))
#define CAN_BWR_MCR_IDAM(base, value) (CAN_WR_MCR_IDAM(base, value))
/*@}*/

/*!
 * @name Register CAN_MCR, field AEN[12] (RW)
 *
 * This bit is supplied for backwards compatibility with legacy applications.
 * When asserted, it enables the Tx abort mechanism. This mechanism guarantees a
 * safe procedure for aborting a pending transmission, so that no frame is sent in
 * the CAN bus without notification. This bit can be written only in Freeze mode
 * because it is blocked by hardware in other modes. When MCR[AEN] is asserted,
 * only the abort mechanism (see Section "Transmission Abort Mechanism") must be
 * used for updating Mailboxes configured for transmission. Writing the Abort code
 * into Rx Mailboxes can cause unpredictable results when the MCR[AEN] is
 * asserted.
 *
 * Values:
 * - 0b0 - Abort disabled.
 * - 0b1 - Abort enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_AEN field. */
#define CAN_RD_MCR_AEN(base) ((CAN_MCR_REG(base) & CAN_MCR_AEN_MASK) >> CAN_MCR_AEN_SHIFT)
#define CAN_BRD_MCR_AEN(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_AEN_SHIFT))

/*! @brief Set the AEN field to a new value. */
#define CAN_WR_MCR_AEN(base, value) (CAN_RMW_MCR(base, CAN_MCR_AEN_MASK, CAN_MCR_AEN(value)))
#define CAN_BWR_MCR_AEN(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_AEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field LPRIOEN[13] (RW)
 *
 * This bit is provided for backwards compatibility with legacy applications. It
 * controls whether the local priority feature is enabled or not. It is used to
 * expand the ID used during the arbitration process. With this expanded ID
 * concept, the arbitration process is done based on the full 32-bit word, but the
 * actual transmitted ID still has 11-bit for standard frames and 29-bit for
 * extended frames. This bit can be written only in Freeze mode because it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 0b0 - Local Priority disabled.
 * - 0b1 - Local Priority enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_LPRIOEN field. */
#define CAN_RD_MCR_LPRIOEN(base) ((CAN_MCR_REG(base) & CAN_MCR_LPRIOEN_MASK) >> CAN_MCR_LPRIOEN_SHIFT)
#define CAN_BRD_MCR_LPRIOEN(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_LPRIOEN_SHIFT))

/*! @brief Set the LPRIOEN field to a new value. */
#define CAN_WR_MCR_LPRIOEN(base, value) (CAN_RMW_MCR(base, CAN_MCR_LPRIOEN_MASK, CAN_MCR_LPRIOEN(value)))
#define CAN_BWR_MCR_LPRIOEN(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_LPRIOEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field IRMQ[16] (RW)
 *
 * This bit indicates whether Rx matching process will be based either on
 * individual masking and queue or on masking scheme with RXMGMASK, RX14MASK and
 * RX15MASK, RXFGMASK. This bit can be written only in Freeze mode because it is
 * blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - Individual Rx masking and queue feature are disabled. For backward
 *     compatibility with legacy applications, the reading of C/S word locks the MB
 *     even if it is EMPTY.
 * - 0b1 - Individual Rx masking and queue feature are enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_IRMQ field. */
#define CAN_RD_MCR_IRMQ(base) ((CAN_MCR_REG(base) & CAN_MCR_IRMQ_MASK) >> CAN_MCR_IRMQ_SHIFT)
#define CAN_BRD_MCR_IRMQ(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_IRMQ_SHIFT))

/*! @brief Set the IRMQ field to a new value. */
#define CAN_WR_MCR_IRMQ(base, value) (CAN_RMW_MCR(base, CAN_MCR_IRMQ_MASK, CAN_MCR_IRMQ(value)))
#define CAN_BWR_MCR_IRMQ(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_IRMQ_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field SRXDIS[17] (RW)
 *
 * This bit defines whether FlexCAN is allowed to receive frames transmitted by
 * itself. If this bit is asserted, frames transmitted by the module will not be
 * stored in any MB, regardless if the MB is programmed with an ID that matches
 * the transmitted frame, and no interrupt flag or interrupt signal will be
 * generated due to the frame reception. This bit can be written only in Freeze mode
 * because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - Self reception enabled.
 * - 0b1 - Self reception disabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_SRXDIS field. */
#define CAN_RD_MCR_SRXDIS(base) ((CAN_MCR_REG(base) & CAN_MCR_SRXDIS_MASK) >> CAN_MCR_SRXDIS_SHIFT)
#define CAN_BRD_MCR_SRXDIS(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_SRXDIS_SHIFT))

/*! @brief Set the SRXDIS field to a new value. */
#define CAN_WR_MCR_SRXDIS(base, value) (CAN_RMW_MCR(base, CAN_MCR_SRXDIS_MASK, CAN_MCR_SRXDIS(value)))
#define CAN_BWR_MCR_SRXDIS(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_SRXDIS_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field WAKSRC[19] (RW)
 *
 * This bit defines whether the integrated low-pass filter is applied to protect
 * the Rx CAN input from spurious wake up. This bit can be written only in
 * Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - FlexCAN uses the unfiltered Rx input to detect recessive to dominant
 *     edges on the CAN bus.
 * - 0b1 - FlexCAN uses the filtered Rx input to detect recessive to dominant
 *     edges on the CAN bus.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_WAKSRC field. */
#define CAN_RD_MCR_WAKSRC(base) ((CAN_MCR_REG(base) & CAN_MCR_WAKSRC_MASK) >> CAN_MCR_WAKSRC_SHIFT)
#define CAN_BRD_MCR_WAKSRC(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_WAKSRC_SHIFT))

/*! @brief Set the WAKSRC field to a new value. */
#define CAN_WR_MCR_WAKSRC(base, value) (CAN_RMW_MCR(base, CAN_MCR_WAKSRC_MASK, CAN_MCR_WAKSRC(value)))
#define CAN_BWR_MCR_WAKSRC(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_WAKSRC_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field LPMACK[20] (RO)
 *
 * This read-only bit indicates that FlexCAN is in a low-power mode (Disable
 * mode , Stop mode ). A low-power mode cannot be entered until all current
 * transmission or reception processes have finished, so the CPU can poll the LPMACK bit
 * to know when FlexCAN has actually entered low power mode. LPMACK will be
 * asserted within 180 CAN bits from the low-power mode request by the CPU, and
 * negated within 2 CAN bits after the low-power mode request removal (see Section
 * "Protocol Timing").
 *
 * Values:
 * - 0b0 - FlexCAN is not in a low-power mode.
 * - 0b1 - FlexCAN is in a low-power mode.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_LPMACK field. */
#define CAN_RD_MCR_LPMACK(base) ((CAN_MCR_REG(base) & CAN_MCR_LPMACK_MASK) >> CAN_MCR_LPMACK_SHIFT)
#define CAN_BRD_MCR_LPMACK(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_LPMACK_SHIFT))
/*@}*/

/*!
 * @name Register CAN_MCR, field WRNEN[21] (RW)
 *
 * When asserted, this bit enables the generation of the TWRNINT and RWRNINT
 * flags in the Error and Status Register. If WRNEN is negated, the TWRNINT and
 * RWRNINT flags will always be zero, independent of the values of the error
 * counters, and no warning interrupt will ever be generated. This bit can be written
 * only in Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - TWRNINT and RWRNINT bits are zero, independent of the values in the
 *     error counters.
 * - 0b1 - TWRNINT and RWRNINT bits are set when the respective error counter
 *     transitions from less than 96 to greater than or equal to 96.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_WRNEN field. */
#define CAN_RD_MCR_WRNEN(base) ((CAN_MCR_REG(base) & CAN_MCR_WRNEN_MASK) >> CAN_MCR_WRNEN_SHIFT)
#define CAN_BRD_MCR_WRNEN(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_WRNEN_SHIFT))

/*! @brief Set the WRNEN field to a new value. */
#define CAN_WR_MCR_WRNEN(base, value) (CAN_RMW_MCR(base, CAN_MCR_WRNEN_MASK, CAN_MCR_WRNEN(value)))
#define CAN_BWR_MCR_WRNEN(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_WRNEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field SLFWAK[22] (RW)
 *
 * This bit enables the Self Wake Up feature when FlexCAN is in a low-power mode
 * other than Disable mode. When this feature is enabled, the FlexCAN module
 * monitors the bus for wake up event, that is, a recessive-to-dominant transition.
 * If a wake up event is detected during Stop mode, then FlexCAN generates, if
 * enabled to do so, a Wake Up interrupt to the CPU so that it can exit Stop mode
 * globally and FlexCAN can request to resume the clocks. When FlexCAN is in a
 * low-power mode other than Disable mode, this bit cannot be written as it is
 * blocked by hardware.
 *
 * Values:
 * - 0b0 - FlexCAN Self Wake Up feature is disabled.
 * - 0b1 - FlexCAN Self Wake Up feature is enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_SLFWAK field. */
#define CAN_RD_MCR_SLFWAK(base) ((CAN_MCR_REG(base) & CAN_MCR_SLFWAK_MASK) >> CAN_MCR_SLFWAK_SHIFT)
#define CAN_BRD_MCR_SLFWAK(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_SLFWAK_SHIFT))

/*! @brief Set the SLFWAK field to a new value. */
#define CAN_WR_MCR_SLFWAK(base, value) (CAN_RMW_MCR(base, CAN_MCR_SLFWAK_MASK, CAN_MCR_SLFWAK(value)))
#define CAN_BWR_MCR_SLFWAK(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_SLFWAK_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field SUPV[23] (RW)
 *
 * This bit configures the FlexCAN to be either in Supervisor or User mode. The
 * registers affected by this bit are marked as S/U in the Access Type column of
 * the module memory map. Reset value of this bit is 1, so the affected registers
 * start with Supervisor access allowance only . This bit can be written only in
 * Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - FlexCAN is in User mode. Affected registers allow both Supervisor and
 *     Unrestricted accesses .
 * - 0b1 - FlexCAN is in Supervisor mode. Affected registers allow only
 *     Supervisor access. Unrestricted access behaves as though the access was done to an
 *     unimplemented register location .
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_SUPV field. */
#define CAN_RD_MCR_SUPV(base) ((CAN_MCR_REG(base) & CAN_MCR_SUPV_MASK) >> CAN_MCR_SUPV_SHIFT)
#define CAN_BRD_MCR_SUPV(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_SUPV_SHIFT))

/*! @brief Set the SUPV field to a new value. */
#define CAN_WR_MCR_SUPV(base, value) (CAN_RMW_MCR(base, CAN_MCR_SUPV_MASK, CAN_MCR_SUPV(value)))
#define CAN_BWR_MCR_SUPV(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_SUPV_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field FRZACK[24] (RO)
 *
 * This read-only bit indicates that FlexCAN is in Freeze mode and its prescaler
 * is stopped. The Freeze mode request cannot be granted until current
 * transmission or reception processes have finished. Therefore the software can poll the
 * FRZACK bit to know when FlexCAN has actually entered Freeze mode. If Freeze
 * Mode request is negated, then this bit is negated after the FlexCAN prescaler is
 * running again. If Freeze mode is requested while FlexCAN is in a low power
 * mode, then the FRZACK bit will be set only when the low-power mode is exited.
 * See Section "Freeze Mode". FRZACK will be asserted within 178 CAN bits from the
 * freeze mode request by the CPU, and negated within 2 CAN bits after the freeze
 * mode request removal (see Section "Protocol Timing").
 *
 * Values:
 * - 0b0 - FlexCAN not in Freeze mode, prescaler running.
 * - 0b1 - FlexCAN in Freeze mode, prescaler stopped.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_FRZACK field. */
#define CAN_RD_MCR_FRZACK(base) ((CAN_MCR_REG(base) & CAN_MCR_FRZACK_MASK) >> CAN_MCR_FRZACK_SHIFT)
#define CAN_BRD_MCR_FRZACK(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_FRZACK_SHIFT))
/*@}*/

/*!
 * @name Register CAN_MCR, field SOFTRST[25] (RW)
 *
 * When this bit is asserted, FlexCAN resets its internal state machines and
 * some of the memory mapped registers. The following registers are reset: MCR
 * (except the MDIS bit), TIMER , ECR, ESR1, ESR2, IMASK1, IMASK2, IFLAG1, IFLAG2 and
 * CRCR. Configuration registers that control the interface to the CAN bus are
 * not affected by soft reset. The following registers are unaffected: CTRL1,
 * CTRL2, all RXIMR registers, RXMGMASK, RX14MASK, RX15MASK, RXFGMASK, RXFIR, all
 * Message Buffers . The SOFTRST bit can be asserted directly by the CPU when it
 * writes to the MCR Register, but it is also asserted when global soft reset is
 * requested at MCU level . Because soft reset is synchronous and has to follow a
 * request/acknowledge procedure across clock domains, it may take some time to
 * fully propagate its effect. The SOFTRST bit remains asserted while reset is
 * pending, and is automatically negated when reset completes. Therefore, software can
 * poll this bit to know when the soft reset has completed. Soft reset cannot be
 * applied while clocks are shut down in a low power mode. The module should be
 * first removed from low power mode, and then soft reset can be applied.
 *
 * Values:
 * - 0b0 - No reset request.
 * - 0b1 - Resets the registers affected by soft reset.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_SOFTRST field. */
#define CAN_RD_MCR_SOFTRST(base) ((CAN_MCR_REG(base) & CAN_MCR_SOFTRST_MASK) >> CAN_MCR_SOFTRST_SHIFT)
#define CAN_BRD_MCR_SOFTRST(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_SOFTRST_SHIFT))

/*! @brief Set the SOFTRST field to a new value. */
#define CAN_WR_MCR_SOFTRST(base, value) (CAN_RMW_MCR(base, CAN_MCR_SOFTRST_MASK, CAN_MCR_SOFTRST(value)))
#define CAN_BWR_MCR_SOFTRST(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_SOFTRST_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field WAKMSK[26] (RW)
 *
 * This bit enables the Wake Up Interrupt generation under Self Wake Up
 * mechanism.
 *
 * Values:
 * - 0b0 - Wake Up Interrupt is disabled.
 * - 0b1 - Wake Up Interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_WAKMSK field. */
#define CAN_RD_MCR_WAKMSK(base) ((CAN_MCR_REG(base) & CAN_MCR_WAKMSK_MASK) >> CAN_MCR_WAKMSK_SHIFT)
#define CAN_BRD_MCR_WAKMSK(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_WAKMSK_SHIFT))

/*! @brief Set the WAKMSK field to a new value. */
#define CAN_WR_MCR_WAKMSK(base, value) (CAN_RMW_MCR(base, CAN_MCR_WAKMSK_MASK, CAN_MCR_WAKMSK(value)))
#define CAN_BWR_MCR_WAKMSK(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_WAKMSK_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field NOTRDY[27] (RO)
 *
 * This read-only bit indicates that FlexCAN is either in Disable mode , Stop
 * mode or Freeze mode. It is negated once FlexCAN has exited these modes.
 *
 * Values:
 * - 0b0 - FlexCAN module is either in Normal mode, Listen-Only mode or
 *     Loop-Back mode.
 * - 0b1 - FlexCAN module is either in Disable mode , Stop mode or Freeze mode.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_NOTRDY field. */
#define CAN_RD_MCR_NOTRDY(base) ((CAN_MCR_REG(base) & CAN_MCR_NOTRDY_MASK) >> CAN_MCR_NOTRDY_SHIFT)
#define CAN_BRD_MCR_NOTRDY(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_NOTRDY_SHIFT))
/*@}*/

/*!
 * @name Register CAN_MCR, field HALT[28] (RW)
 *
 * Assertion of this bit puts the FlexCAN module into Freeze mode. The CPU
 * should clear it after initializing the Message Buffers and Control Register. No
 * reception or transmission is performed by FlexCAN before this bit is cleared.
 * Freeze mode cannot be entered while FlexCAN is in a low power mode.
 *
 * Values:
 * - 0b0 - No Freeze mode request.
 * - 0b1 - Enters Freeze mode if the FRZ bit is asserted.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_HALT field. */
#define CAN_RD_MCR_HALT(base) ((CAN_MCR_REG(base) & CAN_MCR_HALT_MASK) >> CAN_MCR_HALT_SHIFT)
#define CAN_BRD_MCR_HALT(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_HALT_SHIFT))

/*! @brief Set the HALT field to a new value. */
#define CAN_WR_MCR_HALT(base, value) (CAN_RMW_MCR(base, CAN_MCR_HALT_MASK, CAN_MCR_HALT(value)))
#define CAN_BWR_MCR_HALT(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_HALT_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field RFEN[29] (RW)
 *
 * This bit controls whether the Rx FIFO feature is enabled or not. When RFEN is
 * set, MBs 0 to 5 cannot be used for normal reception and transmission because
 * the corresponding memory region (0x80-0xDC) is used by the FIFO engine as well
 * as additional MBs (up to 32, depending on CTRL2[RFFN] setting) which are used
 * as Rx FIFO ID Filter Table elements. RFEN also impacts the definition of the
 * minimum number of peripheral clocks per CAN bit as described in the table
 * "Minimum Ratio Between Peripheral Clock Frequency and CAN Bit Rate" (in section
 * "Arbitration and Matching Timing"). This bit can be written only in Freeze mode
 * because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - Rx FIFO not enabled.
 * - 0b1 - Rx FIFO enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_RFEN field. */
#define CAN_RD_MCR_RFEN(base) ((CAN_MCR_REG(base) & CAN_MCR_RFEN_MASK) >> CAN_MCR_RFEN_SHIFT)
#define CAN_BRD_MCR_RFEN(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_RFEN_SHIFT))

/*! @brief Set the RFEN field to a new value. */
#define CAN_WR_MCR_RFEN(base, value) (CAN_RMW_MCR(base, CAN_MCR_RFEN_MASK, CAN_MCR_RFEN(value)))
#define CAN_BWR_MCR_RFEN(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_RFEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field FRZ[30] (RW)
 *
 * The FRZ bit specifies the FlexCAN behavior when the HALT bit in the MCR
 * Register is set or when Debug mode is requested at MCU level . When FRZ is
 * asserted, FlexCAN is enabled to enter Freeze mode. Negation of this bit field causes
 * FlexCAN to exit from Freeze mode.
 *
 * Values:
 * - 0b0 - Not enabled to enter Freeze mode.
 * - 0b1 - Enabled to enter Freeze mode.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_FRZ field. */
#define CAN_RD_MCR_FRZ(base) ((CAN_MCR_REG(base) & CAN_MCR_FRZ_MASK) >> CAN_MCR_FRZ_SHIFT)
#define CAN_BRD_MCR_FRZ(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_FRZ_SHIFT))

/*! @brief Set the FRZ field to a new value. */
#define CAN_WR_MCR_FRZ(base, value) (CAN_RMW_MCR(base, CAN_MCR_FRZ_MASK, CAN_MCR_FRZ(value)))
#define CAN_BWR_MCR_FRZ(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_FRZ_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_MCR, field MDIS[31] (RW)
 *
 * This bit controls whether FlexCAN is enabled or not. When disabled, FlexCAN
 * disables the clocks to the CAN Protocol Engine and Controller Host Interface
 * sub-modules. This is the only bit within this register not affected by soft
 * reset.
 *
 * Values:
 * - 0b0 - Enable the FlexCAN module.
 * - 0b1 - Disable the FlexCAN module.
 */
/*@{*/
/*! @brief Read current value of the CAN_MCR_MDIS field. */
#define CAN_RD_MCR_MDIS(base) ((CAN_MCR_REG(base) & CAN_MCR_MDIS_MASK) >> CAN_MCR_MDIS_SHIFT)
#define CAN_BRD_MCR_MDIS(base) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_MDIS_SHIFT))

/*! @brief Set the MDIS field to a new value. */
#define CAN_WR_MCR_MDIS(base, value) (CAN_RMW_MCR(base, CAN_MCR_MDIS_MASK, CAN_MCR_MDIS(value)))
#define CAN_BWR_MCR_MDIS(base, value) (BITBAND_ACCESS32(&CAN_MCR_REG(base), CAN_MCR_MDIS_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * CAN_CTRL1 - Control 1 register
 ******************************************************************************/

/*!
 * @brief CAN_CTRL1 - Control 1 register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register is defined for specific FlexCAN control features related to the
 * CAN bus, such as bit-rate, programmable sampling point within an Rx bit, Loop
 * Back mode, Listen-Only mode, Bus Off recovery behavior and interrupt enabling
 * (Bus-Off, Error, Warning). It also determines the Division Factor for the
 * clock prescaler.
 */
/*!
 * @name Constants and macros for entire CAN_CTRL1 register
 */
/*@{*/
#define CAN_RD_CTRL1(base)       (CAN_CTRL1_REG(base))
#define CAN_WR_CTRL1(base, value) (CAN_CTRL1_REG(base) = (value))
#define CAN_RMW_CTRL1(base, mask, value) (CAN_WR_CTRL1(base, (CAN_RD_CTRL1(base) & ~(mask)) | (value)))
#define CAN_SET_CTRL1(base, value) (CAN_WR_CTRL1(base, CAN_RD_CTRL1(base) |  (value)))
#define CAN_CLR_CTRL1(base, value) (CAN_WR_CTRL1(base, CAN_RD_CTRL1(base) & ~(value)))
#define CAN_TOG_CTRL1(base, value) (CAN_WR_CTRL1(base, CAN_RD_CTRL1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_CTRL1 bitfields
 */

/*!
 * @name Register CAN_CTRL1, field PROPSEG[2:0] (RW)
 *
 * This 3-bit field defines the length of the Propagation Segment in the bit
 * time. The valid programmable values are 0-7. This field can be written only in
 * Freeze mode because it is blocked by hardware in other modes. Propagation
 * Segment Time = (PROPSEG + 1) * Time-Quanta. Time-Quantum = one Sclock period.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_PROPSEG field. */
#define CAN_RD_CTRL1_PROPSEG(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_PROPSEG_MASK) >> CAN_CTRL1_PROPSEG_SHIFT)
#define CAN_BRD_CTRL1_PROPSEG(base) (CAN_RD_CTRL1_PROPSEG(base))

/*! @brief Set the PROPSEG field to a new value. */
#define CAN_WR_CTRL1_PROPSEG(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_PROPSEG_MASK, CAN_CTRL1_PROPSEG(value)))
#define CAN_BWR_CTRL1_PROPSEG(base, value) (CAN_WR_CTRL1_PROPSEG(base, value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LOM[3] (RW)
 *
 * This bit configures FlexCAN to operate in Listen-Only mode. In this mode,
 * transmission is disabled, all error counters are frozen and the module operates
 * in a CAN Error Passive mode. Only messages acknowledged by another CAN station
 * will be received. If FlexCAN detects a message that has not been acknowledged,
 * it will flag a BIT0 error without changing the REC, as if it was trying to
 * acknowledge the message. Listen-Only mode acknowledgement can be obtained by the
 * state of ESR1[FLTCONF] field which is Passive Error when Listen-Only mode is
 * entered. There can be some delay between the Listen-Only mode request and
 * acknowledge. This bit can be written only in Freeze mode because it is blocked by
 * hardware in other modes.
 *
 * Values:
 * - 0b0 - Listen-Only mode is deactivated.
 * - 0b1 - FlexCAN module operates in Listen-Only mode.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_LOM field. */
#define CAN_RD_CTRL1_LOM(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_LOM_MASK) >> CAN_CTRL1_LOM_SHIFT)
#define CAN_BRD_CTRL1_LOM(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_LOM_SHIFT))

/*! @brief Set the LOM field to a new value. */
#define CAN_WR_CTRL1_LOM(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_LOM_MASK, CAN_CTRL1_LOM(value)))
#define CAN_BWR_CTRL1_LOM(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_LOM_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LBUF[4] (RW)
 *
 * This bit defines the ordering mechanism for Message Buffer transmission. When
 * asserted, the LPRIOEN bit does not affect the priority arbitration. This bit
 * can be written only in Freeze mode because it is blocked by hardware in other
 * modes.
 *
 * Values:
 * - 0b0 - Buffer with highest priority is transmitted first.
 * - 0b1 - Lowest number buffer is transmitted first.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_LBUF field. */
#define CAN_RD_CTRL1_LBUF(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_LBUF_MASK) >> CAN_CTRL1_LBUF_SHIFT)
#define CAN_BRD_CTRL1_LBUF(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_LBUF_SHIFT))

/*! @brief Set the LBUF field to a new value. */
#define CAN_WR_CTRL1_LBUF(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_LBUF_MASK, CAN_CTRL1_LBUF(value)))
#define CAN_BWR_CTRL1_LBUF(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_LBUF_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field TSYN[5] (RW)
 *
 * This bit enables a mechanism that resets the free-running timer each time a
 * message is received in Message Buffer 0. This feature provides means to
 * synchronize multiple FlexCAN stations with a special "SYNC" message, that is, global
 * network time. If the RFEN bit in MCR is set (Rx FIFO enabled), the first
 * available Mailbox, according to CTRL2[RFFN] setting, is used for timer
 * synchronization instead of MB0. This bit can be written only in Freeze mode because it is
 * blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - Timer Sync feature disabled
 * - 0b1 - Timer Sync feature enabled
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_TSYN field. */
#define CAN_RD_CTRL1_TSYN(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_TSYN_MASK) >> CAN_CTRL1_TSYN_SHIFT)
#define CAN_BRD_CTRL1_TSYN(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_TSYN_SHIFT))

/*! @brief Set the TSYN field to a new value. */
#define CAN_WR_CTRL1_TSYN(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_TSYN_MASK, CAN_CTRL1_TSYN(value)))
#define CAN_BWR_CTRL1_TSYN(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_TSYN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field BOFFREC[6] (RW)
 *
 * This bit defines how FlexCAN recovers from Bus Off state. If this bit is
 * negated, automatic recovering from Bus Off state occurs according to the CAN
 * Specification 2.0B. If the bit is asserted, automatic recovering from Bus Off is
 * disabled and the module remains in Bus Off state until the bit is negated by the
 * user. If the negation occurs before 128 sequences of 11 recessive bits are
 * detected on the CAN bus, then Bus Off recovery happens as if the BOFFREC bit had
 * never been asserted. If the negation occurs after 128 sequences of 11
 * recessive bits occurred, then FlexCAN will re-synchronize to the bus by waiting for
 * 11 recessive bits before joining the bus. After negation, the BOFFREC bit can
 * be re-asserted again during Bus Off, but it will be effective only the next
 * time the module enters Bus Off. If BOFFREC was negated when the module entered
 * Bus Off, asserting it during Bus Off will not be effective for the current Bus
 * Off recovery.
 *
 * Values:
 * - 0b0 - Automatic recovering from Bus Off state enabled, according to CAN
 *     Spec 2.0 part B.
 * - 0b1 - Automatic recovering from Bus Off state disabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_BOFFREC field. */
#define CAN_RD_CTRL1_BOFFREC(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_BOFFREC_MASK) >> CAN_CTRL1_BOFFREC_SHIFT)
#define CAN_BRD_CTRL1_BOFFREC(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_BOFFREC_SHIFT))

/*! @brief Set the BOFFREC field to a new value. */
#define CAN_WR_CTRL1_BOFFREC(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_BOFFREC_MASK, CAN_CTRL1_BOFFREC(value)))
#define CAN_BWR_CTRL1_BOFFREC(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_BOFFREC_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field SMP[7] (RW)
 *
 * This bit defines the sampling mode of CAN bits at the Rx input. This bit can
 * be written only in Freeze mode because it is blocked by hardware in other
 * modes.
 *
 * Values:
 * - 0b0 - Just one sample is used to determine the bit value.
 * - 0b1 - Three samples are used to determine the value of the received bit:
 *     the regular one (sample point) and 2 preceding samples; a majority rule is
 *     used.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_SMP field. */
#define CAN_RD_CTRL1_SMP(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_SMP_MASK) >> CAN_CTRL1_SMP_SHIFT)
#define CAN_BRD_CTRL1_SMP(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_SMP_SHIFT))

/*! @brief Set the SMP field to a new value. */
#define CAN_WR_CTRL1_SMP(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_SMP_MASK, CAN_CTRL1_SMP(value)))
#define CAN_BWR_CTRL1_SMP(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_SMP_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field RWRNMSK[10] (RW)
 *
 * This bit provides a mask for the Rx Warning Interrupt associated with the
 * RWRNINT flag in the Error and Status Register. This bit is read as zero when
 * MCR[WRNEN] bit is negated. This bit can be written only if MCR[WRNEN] bit is
 * asserted.
 *
 * Values:
 * - 0b0 - Rx Warning Interrupt disabled.
 * - 0b1 - Rx Warning Interrupt enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_RWRNMSK field. */
#define CAN_RD_CTRL1_RWRNMSK(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_RWRNMSK_MASK) >> CAN_CTRL1_RWRNMSK_SHIFT)
#define CAN_BRD_CTRL1_RWRNMSK(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_RWRNMSK_SHIFT))

/*! @brief Set the RWRNMSK field to a new value. */
#define CAN_WR_CTRL1_RWRNMSK(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_RWRNMSK_MASK, CAN_CTRL1_RWRNMSK(value)))
#define CAN_BWR_CTRL1_RWRNMSK(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_RWRNMSK_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field TWRNMSK[11] (RW)
 *
 * This bit provides a mask for the Tx Warning Interrupt associated with the
 * TWRNINT flag in the Error and Status Register. This bit is read as zero when
 * MCR[WRNEN] bit is negated. This bit can be written only if MCR[WRNEN] bit is
 * asserted.
 *
 * Values:
 * - 0b0 - Tx Warning Interrupt disabled.
 * - 0b1 - Tx Warning Interrupt enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_TWRNMSK field. */
#define CAN_RD_CTRL1_TWRNMSK(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_TWRNMSK_MASK) >> CAN_CTRL1_TWRNMSK_SHIFT)
#define CAN_BRD_CTRL1_TWRNMSK(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_TWRNMSK_SHIFT))

/*! @brief Set the TWRNMSK field to a new value. */
#define CAN_WR_CTRL1_TWRNMSK(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_TWRNMSK_MASK, CAN_CTRL1_TWRNMSK(value)))
#define CAN_BWR_CTRL1_TWRNMSK(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_TWRNMSK_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field LPB[12] (RW)
 *
 * This bit configures FlexCAN to operate in Loop-Back mode. In this mode,
 * FlexCAN performs an internal loop back that can be used for self test operation.
 * The bit stream output of the transmitter is fed back internally to the receiver
 * input. The Rx CAN input pin is ignored and the Tx CAN output goes to the
 * recessive state (logic 1). FlexCAN behaves as it normally does when transmitting,
 * and treats its own transmitted message as a message received from a remote
 * node. In this mode, FlexCAN ignores the bit sent during the ACK slot in the CAN
 * frame acknowledge field, generating an internal acknowledge bit to ensure proper
 * reception of its own message. Both transmit and receive interrupts are
 * generated. This bit can be written only in Freeze mode because it is blocked by
 * hardware in other modes. In this mode, the MCR[SRXDIS] cannot be asserted because
 * this will impede the self reception of a transmitted message.
 *
 * Values:
 * - 0b0 - Loop Back disabled.
 * - 0b1 - Loop Back enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_LPB field. */
#define CAN_RD_CTRL1_LPB(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_LPB_MASK) >> CAN_CTRL1_LPB_SHIFT)
#define CAN_BRD_CTRL1_LPB(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_LPB_SHIFT))

/*! @brief Set the LPB field to a new value. */
#define CAN_WR_CTRL1_LPB(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_LPB_MASK, CAN_CTRL1_LPB(value)))
#define CAN_BWR_CTRL1_LPB(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_LPB_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field CLKSRC[13] (RW)
 *
 * This bit selects the clock source to the CAN Protocol Engine (PE) to be
 * either the peripheral clock (driven by the PLL) or the crystal oscillator clock.
 * The selected clock is the one fed to the prescaler to generate the Serial Clock
 * (Sclock). In order to guarantee reliable operation, this bit can be written
 * only in Disable mode because it is blocked by hardware in other modes. See
 * Section "Protocol Timing".
 *
 * Values:
 * - 0b0 - The CAN engine clock source is the oscillator clock. Under this
 *     condition, the oscillator clock frequency must be lower than the bus clock.
 * - 0b1 - The CAN engine clock source is the peripheral clock.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_CLKSRC field. */
#define CAN_RD_CTRL1_CLKSRC(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_CLKSRC_MASK) >> CAN_CTRL1_CLKSRC_SHIFT)
#define CAN_BRD_CTRL1_CLKSRC(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_CLKSRC_SHIFT))

/*! @brief Set the CLKSRC field to a new value. */
#define CAN_WR_CTRL1_CLKSRC(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_CLKSRC_MASK, CAN_CTRL1_CLKSRC(value)))
#define CAN_BWR_CTRL1_CLKSRC(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_CLKSRC_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field ERRMSK[14] (RW)
 *
 * This bit provides a mask for the Error Interrupt.
 *
 * Values:
 * - 0b0 - Error interrupt disabled.
 * - 0b1 - Error interrupt enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_ERRMSK field. */
#define CAN_RD_CTRL1_ERRMSK(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_ERRMSK_MASK) >> CAN_CTRL1_ERRMSK_SHIFT)
#define CAN_BRD_CTRL1_ERRMSK(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_ERRMSK_SHIFT))

/*! @brief Set the ERRMSK field to a new value. */
#define CAN_WR_CTRL1_ERRMSK(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_ERRMSK_MASK, CAN_CTRL1_ERRMSK(value)))
#define CAN_BWR_CTRL1_ERRMSK(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_ERRMSK_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field BOFFMSK[15] (RW)
 *
 * This bit provides a mask for the Bus Off Interrupt.
 *
 * Values:
 * - 0b0 - Bus Off interrupt disabled.
 * - 0b1 - Bus Off interrupt enabled.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_BOFFMSK field. */
#define CAN_RD_CTRL1_BOFFMSK(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_BOFFMSK_MASK) >> CAN_CTRL1_BOFFMSK_SHIFT)
#define CAN_BRD_CTRL1_BOFFMSK(base) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_BOFFMSK_SHIFT))

/*! @brief Set the BOFFMSK field to a new value. */
#define CAN_WR_CTRL1_BOFFMSK(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_BOFFMSK_MASK, CAN_CTRL1_BOFFMSK(value)))
#define CAN_BWR_CTRL1_BOFFMSK(base, value) (BITBAND_ACCESS32(&CAN_CTRL1_REG(base), CAN_CTRL1_BOFFMSK_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PSEG2[18:16] (RW)
 *
 * This 3-bit field defines the length of Phase Buffer Segment 2 in the bit
 * time. The valid programmable values are 1-7. This field can be written only in
 * Freeze mode because it is blocked by hardware in other modes. Phase Buffer
 * Segment 2 = (PSEG2 + 1) * Time-Quanta.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_PSEG2 field. */
#define CAN_RD_CTRL1_PSEG2(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_PSEG2_MASK) >> CAN_CTRL1_PSEG2_SHIFT)
#define CAN_BRD_CTRL1_PSEG2(base) (CAN_RD_CTRL1_PSEG2(base))

/*! @brief Set the PSEG2 field to a new value. */
#define CAN_WR_CTRL1_PSEG2(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_PSEG2_MASK, CAN_CTRL1_PSEG2(value)))
#define CAN_BWR_CTRL1_PSEG2(base, value) (CAN_WR_CTRL1_PSEG2(base, value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PSEG1[21:19] (RW)
 *
 * This 3-bit field defines the length of Phase Buffer Segment 1 in the bit
 * time. The valid programmable values are 0-7. This field can be written only in
 * Freeze mode because it is blocked by hardware in other modes. Phase Buffer
 * Segment 1 = (PSEG1 + 1) * Time-Quanta.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_PSEG1 field. */
#define CAN_RD_CTRL1_PSEG1(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_PSEG1_MASK) >> CAN_CTRL1_PSEG1_SHIFT)
#define CAN_BRD_CTRL1_PSEG1(base) (CAN_RD_CTRL1_PSEG1(base))

/*! @brief Set the PSEG1 field to a new value. */
#define CAN_WR_CTRL1_PSEG1(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_PSEG1_MASK, CAN_CTRL1_PSEG1(value)))
#define CAN_BWR_CTRL1_PSEG1(base, value) (CAN_WR_CTRL1_PSEG1(base, value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field RJW[23:22] (RW)
 *
 * This 2-bit field defines the maximum number of time quanta that a bit time
 * can be changed by one re-synchronization. One time quantum is equal to the
 * Sclock period. The valid programmable values are 0-3. This field can be written
 * only in Freeze mode because it is blocked by hardware in other modes. Resync Jump
 * Width = RJW + 1.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_RJW field. */
#define CAN_RD_CTRL1_RJW(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_RJW_MASK) >> CAN_CTRL1_RJW_SHIFT)
#define CAN_BRD_CTRL1_RJW(base) (CAN_RD_CTRL1_RJW(base))

/*! @brief Set the RJW field to a new value. */
#define CAN_WR_CTRL1_RJW(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_RJW_MASK, CAN_CTRL1_RJW(value)))
#define CAN_BWR_CTRL1_RJW(base, value) (CAN_WR_CTRL1_RJW(base, value))
/*@}*/

/*!
 * @name Register CAN_CTRL1, field PRESDIV[31:24] (RW)
 *
 * This 8-bit field defines the ratio between the PE clock frequency and the
 * Serial Clock (Sclock) frequency. The Sclock period defines the time quantum of
 * the CAN protocol. For the reset value, the Sclock frequency is equal to the PE
 * clock frequency. The Maximum value of this field is 0xFF, that gives a minimum
 * Sclock frequency equal to the PE clock frequency divided by 256. See Section
 * "Protocol Timing". This field can be written only in Freeze mode because it is
 * blocked by hardware in other modes. Sclock frequency = PE clock frequency /
 * (PRESDIV + 1)
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL1_PRESDIV field. */
#define CAN_RD_CTRL1_PRESDIV(base) ((CAN_CTRL1_REG(base) & CAN_CTRL1_PRESDIV_MASK) >> CAN_CTRL1_PRESDIV_SHIFT)
#define CAN_BRD_CTRL1_PRESDIV(base) (CAN_RD_CTRL1_PRESDIV(base))

/*! @brief Set the PRESDIV field to a new value. */
#define CAN_WR_CTRL1_PRESDIV(base, value) (CAN_RMW_CTRL1(base, CAN_CTRL1_PRESDIV_MASK, CAN_CTRL1_PRESDIV(value)))
#define CAN_BWR_CTRL1_PRESDIV(base, value) (CAN_WR_CTRL1_PRESDIV(base, value))
/*@}*/

/*******************************************************************************
 * CAN_TIMER - Free Running Timer
 ******************************************************************************/

/*!
 * @brief CAN_TIMER - Free Running Timer (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register represents a 16-bit free running counter that can be read and
 * written by the CPU. The timer starts from 0x0 after Reset, counts linearly to
 * 0xFFFF, and wraps around. The timer is clocked by the FlexCAN bit-clock, which
 * defines the baud rate on the CAN bus. During a message transmission/reception,
 * it increments by one for each bit that is received or transmitted. When there
 * is no message on the bus, it counts using the previously programmed baud
 * rate. The timer is not incremented during Disable , Stop, and Freeze modes. The
 * timer value is captured when the second bit of the identifier field of any frame
 * is on the CAN bus. This captured value is written into the Time Stamp entry
 * in a message buffer after a successful reception or transmission of a message.
 * If bit CTRL1[TSYN] is asserted, the Timer is reset whenever a message is
 * received in the first available Mailbox, according to CTRL2[RFFN] setting. The CPU
 * can write to this register anytime. However, if the write occurs at the same
 * time that the Timer is being reset by a reception in the first Mailbox, then
 * the write value is discarded. Reading this register affects the Mailbox
 * Unlocking procedure; see Section "Mailbox Lock Mechanism".
 */
/*!
 * @name Constants and macros for entire CAN_TIMER register
 */
/*@{*/
#define CAN_RD_TIMER(base)       (CAN_TIMER_REG(base))
#define CAN_WR_TIMER(base, value) (CAN_TIMER_REG(base) = (value))
#define CAN_RMW_TIMER(base, mask, value) (CAN_WR_TIMER(base, (CAN_RD_TIMER(base) & ~(mask)) | (value)))
#define CAN_SET_TIMER(base, value) (CAN_WR_TIMER(base, CAN_RD_TIMER(base) |  (value)))
#define CAN_CLR_TIMER(base, value) (CAN_WR_TIMER(base, CAN_RD_TIMER(base) & ~(value)))
#define CAN_TOG_TIMER(base, value) (CAN_WR_TIMER(base, CAN_RD_TIMER(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_TIMER bitfields
 */

/*!
 * @name Register CAN_TIMER, field TIMER[15:0] (RW)
 *
 * Contains the free-running counter value.
 */
/*@{*/
/*! @brief Read current value of the CAN_TIMER_TIMER field. */
#define CAN_RD_TIMER_TIMER(base) ((CAN_TIMER_REG(base) & CAN_TIMER_TIMER_MASK) >> CAN_TIMER_TIMER_SHIFT)
#define CAN_BRD_TIMER_TIMER(base) (CAN_RD_TIMER_TIMER(base))

/*! @brief Set the TIMER field to a new value. */
#define CAN_WR_TIMER_TIMER(base, value) (CAN_RMW_TIMER(base, CAN_TIMER_TIMER_MASK, CAN_TIMER_TIMER(value)))
#define CAN_BWR_TIMER_TIMER(base, value) (CAN_WR_TIMER_TIMER(base, value))
/*@}*/

/*******************************************************************************
 * CAN_RXMGMASK - Rx Mailboxes Global Mask Register
 ******************************************************************************/

/*!
 * @brief CAN_RXMGMASK - Rx Mailboxes Global Mask Register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * This register is located in RAM. RXMGMASK is provided for legacy application
 * support. When the MCR[IRMQ] bit is negated, RXMGMASK is always in effect. When
 * the MCR[IRMQ] bit is asserted, RXMGMASK has no effect. RXMGMASK is used to
 * mask the filter fields of all Rx MBs, excluding MBs 14-15, which have individual
 * mask registers. This register can only be written in Freeze mode as it is
 * blocked by hardware in other modes.
 */
/*!
 * @name Constants and macros for entire CAN_RXMGMASK register
 */
/*@{*/
#define CAN_RD_RXMGMASK(base)    (CAN_RXMGMASK_REG(base))
#define CAN_WR_RXMGMASK(base, value) (CAN_RXMGMASK_REG(base) = (value))
#define CAN_RMW_RXMGMASK(base, mask, value) (CAN_WR_RXMGMASK(base, (CAN_RD_RXMGMASK(base) & ~(mask)) | (value)))
#define CAN_SET_RXMGMASK(base, value) (CAN_WR_RXMGMASK(base, CAN_RD_RXMGMASK(base) |  (value)))
#define CAN_CLR_RXMGMASK(base, value) (CAN_WR_RXMGMASK(base, CAN_RD_RXMGMASK(base) & ~(value)))
#define CAN_TOG_RXMGMASK(base, value) (CAN_WR_RXMGMASK(base, CAN_RD_RXMGMASK(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CAN_RX14MASK - Rx 14 Mask register
 ******************************************************************************/

/*!
 * @brief CAN_RX14MASK - Rx 14 Mask register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * This register is located in RAM. RX14MASK is provided for legacy application
 * support. When the MCR[IRMQ] bit is asserted, RX14MASK has no effect. RX14MASK
 * is used to mask the filter fields of Message Buffer 14. This register can only
 * be programmed while the module is in Freeze mode as it is blocked by hardware
 * in other modes.
 */
/*!
 * @name Constants and macros for entire CAN_RX14MASK register
 */
/*@{*/
#define CAN_RD_RX14MASK(base)    (CAN_RX14MASK_REG(base))
#define CAN_WR_RX14MASK(base, value) (CAN_RX14MASK_REG(base) = (value))
#define CAN_RMW_RX14MASK(base, mask, value) (CAN_WR_RX14MASK(base, (CAN_RD_RX14MASK(base) & ~(mask)) | (value)))
#define CAN_SET_RX14MASK(base, value) (CAN_WR_RX14MASK(base, CAN_RD_RX14MASK(base) |  (value)))
#define CAN_CLR_RX14MASK(base, value) (CAN_WR_RX14MASK(base, CAN_RD_RX14MASK(base) & ~(value)))
#define CAN_TOG_RX14MASK(base, value) (CAN_WR_RX14MASK(base, CAN_RD_RX14MASK(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CAN_RX15MASK - Rx 15 Mask register
 ******************************************************************************/

/*!
 * @brief CAN_RX15MASK - Rx 15 Mask register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * This register is located in RAM. RX15MASK is provided for legacy application
 * support. When the MCR[IRMQ] bit is asserted, RX15MASK has no effect. RX15MASK
 * is used to mask the filter fields of Message Buffer 15. This register can be
 * programmed only while the module is in Freeze mode because it is blocked by
 * hardware in other modes.
 */
/*!
 * @name Constants and macros for entire CAN_RX15MASK register
 */
/*@{*/
#define CAN_RD_RX15MASK(base)    (CAN_RX15MASK_REG(base))
#define CAN_WR_RX15MASK(base, value) (CAN_RX15MASK_REG(base) = (value))
#define CAN_RMW_RX15MASK(base, mask, value) (CAN_WR_RX15MASK(base, (CAN_RD_RX15MASK(base) & ~(mask)) | (value)))
#define CAN_SET_RX15MASK(base, value) (CAN_WR_RX15MASK(base, CAN_RD_RX15MASK(base) |  (value)))
#define CAN_CLR_RX15MASK(base, value) (CAN_WR_RX15MASK(base, CAN_RD_RX15MASK(base) & ~(value)))
#define CAN_TOG_RX15MASK(base, value) (CAN_WR_RX15MASK(base, CAN_RD_RX15MASK(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CAN_ECR - Error Counter
 ******************************************************************************/

/*!
 * @brief CAN_ECR - Error Counter (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register has two 8-bit fields reflecting the value of two FlexCAN error
 * counters: Transmit Error Counter (TXERRCNT field) and Receive Error Counter
 * (RXERRCNT field). The rules for increasing and decreasing these counters are
 * described in the CAN protocol and are completely implemented in the FlexCAN
 * module. Both counters are read-only except in Freeze mode, where they can be
 * written by the CPU. FlexCAN responds to any bus state as described in the protocol,
 * for example, transmit Error Active or Error Passive flag, delay its
 * transmission start time (Error Passive) and avoid any influence on the bus when in Bus
 * Off state. The following are the basic rules for FlexCAN bus state transitions:
 * If the value of TXERRCNT or RXERRCNT increases to be greater than or equal to
 * 128, the FLTCONF field in the Error and Status Register is updated to reflect
 * 'Error Passive' state. If the FlexCAN state is 'Error Passive', and either
 * TXERRCNT or RXERRCNT decrements to a value less than or equal to 127 while the
 * other already satisfies this condition, the FLTCONF field in the Error and
 * Status Register is updated to reflect 'Error Active' state. If the value of
 * TXERRCNT increases to be greater than 255, the FLTCONF field in the Error and Status
 * Register is updated to reflect 'Bus Off' state, and an interrupt may be
 * issued. The value of TXERRCNT is then reset to zero. If FlexCAN is in 'Bus Off'
 * state, then TXERRCNT is cascaded together with another internal counter to count
 * the 128th occurrences of 11 consecutive recessive bits on the bus. Hence,
 * TXERRCNT is reset to zero and counts in a manner where the internal counter counts
 * 11 such bits and then wraps around while incrementing the TXERRCNT. When
 * TXERRCNT reaches the value of 128, the FLTCONF field in the Error and Status
 * Register is updated to be 'Error Active' and both error counters are reset to zero.
 * At any instance of dominant bit following a stream of less than 11
 * consecutive recessive bits, the internal counter resets itself to zero without affecting
 * the TXERRCNT value. If during system start-up, only one node is operating,
 * then its TXERRCNT increases in each message it is trying to transmit, as a
 * result of acknowledge errors (indicated by the ACKERR bit in the Error and Status
 * Register). After the transition to 'Error Passive' state, the TXERRCNT does not
 * increment anymore by acknowledge errors. Therefore the device never goes to
 * the 'Bus Off' state. If the RXERRCNT increases to a value greater than 127, it
 * is not incremented further, even if more errors are detected while being a
 * receiver. At the next successful message reception, the counter is set to a value
 * between 119 and 127 to resume to 'Error Active' state.
 */
/*!
 * @name Constants and macros for entire CAN_ECR register
 */
/*@{*/
#define CAN_RD_ECR(base)         (CAN_ECR_REG(base))
#define CAN_WR_ECR(base, value)  (CAN_ECR_REG(base) = (value))
#define CAN_RMW_ECR(base, mask, value) (CAN_WR_ECR(base, (CAN_RD_ECR(base) & ~(mask)) | (value)))
#define CAN_SET_ECR(base, value) (CAN_WR_ECR(base, CAN_RD_ECR(base) |  (value)))
#define CAN_CLR_ECR(base, value) (CAN_WR_ECR(base, CAN_RD_ECR(base) & ~(value)))
#define CAN_TOG_ECR(base, value) (CAN_WR_ECR(base, CAN_RD_ECR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_ECR bitfields
 */

/*!
 * @name Register CAN_ECR, field TXERRCNT[7:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_ECR_TXERRCNT field. */
#define CAN_RD_ECR_TXERRCNT(base) ((CAN_ECR_REG(base) & CAN_ECR_TXERRCNT_MASK) >> CAN_ECR_TXERRCNT_SHIFT)
#define CAN_BRD_ECR_TXERRCNT(base) (CAN_RD_ECR_TXERRCNT(base))

/*! @brief Set the TXERRCNT field to a new value. */
#define CAN_WR_ECR_TXERRCNT(base, value) (CAN_RMW_ECR(base, CAN_ECR_TXERRCNT_MASK, CAN_ECR_TXERRCNT(value)))
#define CAN_BWR_ECR_TXERRCNT(base, value) (CAN_WR_ECR_TXERRCNT(base, value))
/*@}*/

/*!
 * @name Register CAN_ECR, field RXERRCNT[15:8] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_ECR_RXERRCNT field. */
#define CAN_RD_ECR_RXERRCNT(base) ((CAN_ECR_REG(base) & CAN_ECR_RXERRCNT_MASK) >> CAN_ECR_RXERRCNT_SHIFT)
#define CAN_BRD_ECR_RXERRCNT(base) (CAN_RD_ECR_RXERRCNT(base))

/*! @brief Set the RXERRCNT field to a new value. */
#define CAN_WR_ECR_RXERRCNT(base, value) (CAN_RMW_ECR(base, CAN_ECR_RXERRCNT_MASK, CAN_ECR_RXERRCNT(value)))
#define CAN_BWR_ECR_RXERRCNT(base, value) (CAN_WR_ECR_RXERRCNT(base, value))
/*@}*/

/*******************************************************************************
 * CAN_ESR1 - Error and Status 1 register
 ******************************************************************************/

/*!
 * @brief CAN_ESR1 - Error and Status 1 register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register reflects various error conditions, some general status of the
 * device and it is the source of interrupts to the CPU. The CPU read action
 * clears bits 15-10. Therefore the reported error conditions (bits 15-10) are those
 * that occurred since the last time the CPU read this register. Bits 9-3 are
 * status bits. The following table shows the FlexCAN state variables and their
 * meanings. Other combinations not shown in the table are reserved. SYNCH IDLE TX RX
 * FlexCAN State 0 0 0 0 Not synchronized to CAN bus 1 1 x x Idle 1 0 1 0
 * Transmitting 1 0 0 1 Receiving
 */
/*!
 * @name Constants and macros for entire CAN_ESR1 register
 */
/*@{*/
#define CAN_RD_ESR1(base)        (CAN_ESR1_REG(base))
#define CAN_WR_ESR1(base, value) (CAN_ESR1_REG(base) = (value))
#define CAN_RMW_ESR1(base, mask, value) (CAN_WR_ESR1(base, (CAN_RD_ESR1(base) & ~(mask)) | (value)))
#define CAN_SET_ESR1(base, value) (CAN_WR_ESR1(base, CAN_RD_ESR1(base) |  (value)))
#define CAN_CLR_ESR1(base, value) (CAN_WR_ESR1(base, CAN_RD_ESR1(base) & ~(value)))
#define CAN_TOG_ESR1(base, value) (CAN_WR_ESR1(base, CAN_RD_ESR1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_ESR1 bitfields
 */

/*!
 * @name Register CAN_ESR1, field WAKINT[0] (W1C)
 *
 * This field applies when FlexCAN is in low-power mode under Self Wake Up
 * mechanism: Stop mode When a recessive-to-dominant transition is detected on the CAN
 * bus and if the MCR[WAKMSK] bit is set, an interrupt is generated to the CPU.
 * This bit is cleared by writing it to 1. When MCR[SLFWAK] is negated, this flag
 * is masked. The CPU must clear this flag before disabling the bit. Otherwise
 * it will be set when the SLFWAK is set again. Writing 0 has no effect.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - Indicates a recessive to dominant transition was received on the CAN
 *     bus.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_WAKINT field. */
#define CAN_RD_ESR1_WAKINT(base) ((CAN_ESR1_REG(base) & CAN_ESR1_WAKINT_MASK) >> CAN_ESR1_WAKINT_SHIFT)
#define CAN_BRD_ESR1_WAKINT(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_WAKINT_SHIFT))

/*! @brief Set the WAKINT field to a new value. */
#define CAN_WR_ESR1_WAKINT(base, value) (CAN_RMW_ESR1(base, (CAN_ESR1_WAKINT_MASK | CAN_ESR1_ERRINT_MASK | CAN_ESR1_BOFFINT_MASK | CAN_ESR1_RWRNINT_MASK | CAN_ESR1_TWRNINT_MASK), CAN_ESR1_WAKINT(value)))
#define CAN_BWR_ESR1_WAKINT(base, value) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_WAKINT_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_ESR1, field ERRINT[1] (W1C)
 *
 * This bit indicates that at least one of the Error Bits (bits 15-10) is set.
 * If the corresponding mask bit CTRL1[ERRMSK] is set, an interrupt is generated
 * to the CPU. This bit is cleared by writing it to 1. Writing 0 has no effect.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - Indicates setting of any Error Bit in the Error and Status Register.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_ERRINT field. */
#define CAN_RD_ESR1_ERRINT(base) ((CAN_ESR1_REG(base) & CAN_ESR1_ERRINT_MASK) >> CAN_ESR1_ERRINT_SHIFT)
#define CAN_BRD_ESR1_ERRINT(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_ERRINT_SHIFT))

/*! @brief Set the ERRINT field to a new value. */
#define CAN_WR_ESR1_ERRINT(base, value) (CAN_RMW_ESR1(base, (CAN_ESR1_ERRINT_MASK | CAN_ESR1_WAKINT_MASK | CAN_ESR1_BOFFINT_MASK | CAN_ESR1_RWRNINT_MASK | CAN_ESR1_TWRNINT_MASK), CAN_ESR1_ERRINT(value)))
#define CAN_BWR_ESR1_ERRINT(base, value) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_ERRINT_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_ESR1, field BOFFINT[2] (W1C)
 *
 * This bit is set when FlexCAN enters 'Bus Off' state. If the corresponding
 * mask bit in the Control Register (BOFFMSK) is set, an interrupt is generated to
 * the CPU. This bit is cleared by writing it to 1. Writing 0 has no effect.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - FlexCAN module entered Bus Off state.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_BOFFINT field. */
#define CAN_RD_ESR1_BOFFINT(base) ((CAN_ESR1_REG(base) & CAN_ESR1_BOFFINT_MASK) >> CAN_ESR1_BOFFINT_SHIFT)
#define CAN_BRD_ESR1_BOFFINT(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_BOFFINT_SHIFT))

/*! @brief Set the BOFFINT field to a new value. */
#define CAN_WR_ESR1_BOFFINT(base, value) (CAN_RMW_ESR1(base, (CAN_ESR1_BOFFINT_MASK | CAN_ESR1_WAKINT_MASK | CAN_ESR1_ERRINT_MASK | CAN_ESR1_RWRNINT_MASK | CAN_ESR1_TWRNINT_MASK), CAN_ESR1_BOFFINT(value)))
#define CAN_BWR_ESR1_BOFFINT(base, value) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_BOFFINT_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_ESR1, field RX[3] (RO)
 *
 * This bit indicates if FlexCAN is receiving a message. See the table in the
 * overall CAN_ESR1 register description.
 *
 * Values:
 * - 0b0 - FlexCAN is not receiving a message.
 * - 0b1 - FlexCAN is receiving a message.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_RX field. */
#define CAN_RD_ESR1_RX(base) ((CAN_ESR1_REG(base) & CAN_ESR1_RX_MASK) >> CAN_ESR1_RX_SHIFT)
#define CAN_BRD_ESR1_RX(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_RX_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field FLTCONF[5:4] (RO)
 *
 * This 2-bit field indicates the Confinement State of the FlexCAN module. If
 * the LOM bit in the Control Register is asserted, after some delay that depends
 * on the CAN bit timing the FLTCONF field will indicate "Error Passive". The very
 * same delay affects the way how FLTCONF reflects an update to ECR register by
 * the CPU. It may be necessary up to one CAN bit time to get them coherent
 * again. Because the Control Register is not affected by soft reset, the FLTCONF
 * field will not be affected by soft reset if the LOM bit is asserted.
 *
 * Values:
 * - 0b00 - Error Active
 * - 0b01 - Error Passive
 * - 0b1x - Bus Off
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_FLTCONF field. */
#define CAN_RD_ESR1_FLTCONF(base) ((CAN_ESR1_REG(base) & CAN_ESR1_FLTCONF_MASK) >> CAN_ESR1_FLTCONF_SHIFT)
#define CAN_BRD_ESR1_FLTCONF(base) (CAN_RD_ESR1_FLTCONF(base))
/*@}*/

/*!
 * @name Register CAN_ESR1, field TX[6] (RO)
 *
 * This bit indicates if FlexCAN is transmitting a message. See the table in the
 * overall CAN_ESR1 register description.
 *
 * Values:
 * - 0b0 - FlexCAN is not transmitting a message.
 * - 0b1 - FlexCAN is transmitting a message.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_TX field. */
#define CAN_RD_ESR1_TX(base) ((CAN_ESR1_REG(base) & CAN_ESR1_TX_MASK) >> CAN_ESR1_TX_SHIFT)
#define CAN_BRD_ESR1_TX(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_TX_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field IDLE[7] (RO)
 *
 * This bit indicates when CAN bus is in IDLE state. See the table in the
 * overall CAN_ESR1 register description.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - CAN bus is now IDLE.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_IDLE field. */
#define CAN_RD_ESR1_IDLE(base) ((CAN_ESR1_REG(base) & CAN_ESR1_IDLE_MASK) >> CAN_ESR1_IDLE_SHIFT)
#define CAN_BRD_ESR1_IDLE(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_IDLE_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field RXWRN[8] (RO)
 *
 * This bit indicates when repetitive errors are occurring during message
 * reception. This bit is not updated during Freeze mode.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - RXERRCNT is greater than or equal to 96.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_RXWRN field. */
#define CAN_RD_ESR1_RXWRN(base) ((CAN_ESR1_REG(base) & CAN_ESR1_RXWRN_MASK) >> CAN_ESR1_RXWRN_SHIFT)
#define CAN_BRD_ESR1_RXWRN(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_RXWRN_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field TXWRN[9] (RO)
 *
 * This bit indicates when repetitive errors are occurring during message
 * transmission. This bit is not updated during Freeze mode.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - TXERRCNT is greater than or equal to 96.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_TXWRN field. */
#define CAN_RD_ESR1_TXWRN(base) ((CAN_ESR1_REG(base) & CAN_ESR1_TXWRN_MASK) >> CAN_ESR1_TXWRN_SHIFT)
#define CAN_BRD_ESR1_TXWRN(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_TXWRN_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field STFERR[10] (RO)
 *
 * This bit indicates that a Stuffing Error has been etected.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - A Stuffing Error occurred since last read of this register.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_STFERR field. */
#define CAN_RD_ESR1_STFERR(base) ((CAN_ESR1_REG(base) & CAN_ESR1_STFERR_MASK) >> CAN_ESR1_STFERR_SHIFT)
#define CAN_BRD_ESR1_STFERR(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_STFERR_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field FRMERR[11] (RO)
 *
 * This bit indicates that a Form Error has been detected by the receiver node,
 * that is, a fixed-form bit field contains at least one illegal bit.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - A Form Error occurred since last read of this register.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_FRMERR field. */
#define CAN_RD_ESR1_FRMERR(base) ((CAN_ESR1_REG(base) & CAN_ESR1_FRMERR_MASK) >> CAN_ESR1_FRMERR_SHIFT)
#define CAN_BRD_ESR1_FRMERR(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_FRMERR_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field CRCERR[12] (RO)
 *
 * This bit indicates that a CRC Error has been detected by the receiver node,
 * that is, the calculated CRC is different from the received.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - A CRC error occurred since last read of this register.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_CRCERR field. */
#define CAN_RD_ESR1_CRCERR(base) ((CAN_ESR1_REG(base) & CAN_ESR1_CRCERR_MASK) >> CAN_ESR1_CRCERR_SHIFT)
#define CAN_BRD_ESR1_CRCERR(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_CRCERR_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field ACKERR[13] (RO)
 *
 * This bit indicates that an Acknowledge Error has been detected by the
 * transmitter node, that is, a dominant bit has not been detected during the ACK SLOT.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - An ACK error occurred since last read of this register.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_ACKERR field. */
#define CAN_RD_ESR1_ACKERR(base) ((CAN_ESR1_REG(base) & CAN_ESR1_ACKERR_MASK) >> CAN_ESR1_ACKERR_SHIFT)
#define CAN_BRD_ESR1_ACKERR(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_ACKERR_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field BIT0ERR[14] (RO)
 *
 * This bit indicates when an inconsistency occurs between the transmitted and
 * the received bit in a message.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - At least one bit sent as dominant is received as recessive.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_BIT0ERR field. */
#define CAN_RD_ESR1_BIT0ERR(base) ((CAN_ESR1_REG(base) & CAN_ESR1_BIT0ERR_MASK) >> CAN_ESR1_BIT0ERR_SHIFT)
#define CAN_BRD_ESR1_BIT0ERR(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_BIT0ERR_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field BIT1ERR[15] (RO)
 *
 * This bit indicates when an inconsistency occurs between the transmitted and
 * the received bit in a message. This bit is not set by a transmitter in case of
 * arbitration field or ACK slot, or in case of a node sending a passive error
 * flag that detects dominant bits.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - At least one bit sent as recessive is received as dominant.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_BIT1ERR field. */
#define CAN_RD_ESR1_BIT1ERR(base) ((CAN_ESR1_REG(base) & CAN_ESR1_BIT1ERR_MASK) >> CAN_ESR1_BIT1ERR_SHIFT)
#define CAN_BRD_ESR1_BIT1ERR(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_BIT1ERR_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR1, field RWRNINT[16] (W1C)
 *
 * If the WRNEN bit in MCR is asserted, the RWRNINT bit is set when the RXWRN
 * flag transitions from 0 to 1, meaning that the Rx error counters reached 96. If
 * the corresponding mask bit in the Control Register (RWRNMSK) is set, an
 * interrupt is generated to the CPU. This bit is cleared by writing it to 1. When
 * WRNEN is negated, this flag is masked. CPU must clear this flag before disabling
 * the bit. Otherwise it will be set when the WRNEN is set again. Writing 0 has no
 * effect. This bit is not updated during Freeze mode.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - The Rx error counter transitioned from less than 96 to greater than
 *     or equal to 96.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_RWRNINT field. */
#define CAN_RD_ESR1_RWRNINT(base) ((CAN_ESR1_REG(base) & CAN_ESR1_RWRNINT_MASK) >> CAN_ESR1_RWRNINT_SHIFT)
#define CAN_BRD_ESR1_RWRNINT(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_RWRNINT_SHIFT))

/*! @brief Set the RWRNINT field to a new value. */
#define CAN_WR_ESR1_RWRNINT(base, value) (CAN_RMW_ESR1(base, (CAN_ESR1_RWRNINT_MASK | CAN_ESR1_WAKINT_MASK | CAN_ESR1_ERRINT_MASK | CAN_ESR1_BOFFINT_MASK | CAN_ESR1_TWRNINT_MASK), CAN_ESR1_RWRNINT(value)))
#define CAN_BWR_ESR1_RWRNINT(base, value) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_RWRNINT_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_ESR1, field TWRNINT[17] (W1C)
 *
 * If the WRNEN bit in MCR is asserted, the TWRNINT bit is set when the TXWRN
 * flag transitions from 0 to 1, meaning that the Tx error counter reached 96. If
 * the corresponding mask bit in the Control Register (TWRNMSK) is set, an
 * interrupt is generated to the CPU. This bit is cleared by writing it to 1. When WRNEN
 * is negated, this flag is masked. CPU must clear this flag before disabling
 * the bit. Otherwise it will be set when the WRNEN is set again. Writing 0 has no
 * effect. This flag is not generated during Bus Off state. This bit is not
 * updated during Freeze mode.
 *
 * Values:
 * - 0b0 - No such occurrence.
 * - 0b1 - The Tx error counter transitioned from less than 96 to greater than
 *     or equal to 96.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_TWRNINT field. */
#define CAN_RD_ESR1_TWRNINT(base) ((CAN_ESR1_REG(base) & CAN_ESR1_TWRNINT_MASK) >> CAN_ESR1_TWRNINT_SHIFT)
#define CAN_BRD_ESR1_TWRNINT(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_TWRNINT_SHIFT))

/*! @brief Set the TWRNINT field to a new value. */
#define CAN_WR_ESR1_TWRNINT(base, value) (CAN_RMW_ESR1(base, (CAN_ESR1_TWRNINT_MASK | CAN_ESR1_WAKINT_MASK | CAN_ESR1_ERRINT_MASK | CAN_ESR1_BOFFINT_MASK | CAN_ESR1_RWRNINT_MASK), CAN_ESR1_TWRNINT(value)))
#define CAN_BWR_ESR1_TWRNINT(base, value) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_TWRNINT_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_ESR1, field SYNCH[18] (RO)
 *
 * This read-only flag indicates whether the FlexCAN is synchronized to the CAN
 * bus and able to participate in the communication process. It is set and
 * cleared by the FlexCAN. See the table in the overall CAN_ESR1 register description.
 *
 * Values:
 * - 0b0 - FlexCAN is not synchronized to the CAN bus.
 * - 0b1 - FlexCAN is synchronized to the CAN bus.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR1_SYNCH field. */
#define CAN_RD_ESR1_SYNCH(base) ((CAN_ESR1_REG(base) & CAN_ESR1_SYNCH_MASK) >> CAN_ESR1_SYNCH_SHIFT)
#define CAN_BRD_ESR1_SYNCH(base) (BITBAND_ACCESS32(&CAN_ESR1_REG(base), CAN_ESR1_SYNCH_SHIFT))
/*@}*/

/*******************************************************************************
 * CAN_IMASK1 - Interrupt Masks 1 register
 ******************************************************************************/

/*!
 * @brief CAN_IMASK1 - Interrupt Masks 1 register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register allows any number of a range of the 32 Message Buffer
 * Interrupts to be enabled or disabled for MB31 to MB0. It contains one interrupt mask
 * bit per buffer, enabling the CPU to determine which buffer generates an
 * interrupt after a successful transmission or reception, that is, when the
 * corresponding IFLAG1 bit is set.
 */
/*!
 * @name Constants and macros for entire CAN_IMASK1 register
 */
/*@{*/
#define CAN_RD_IMASK1(base)      (CAN_IMASK1_REG(base))
#define CAN_WR_IMASK1(base, value) (CAN_IMASK1_REG(base) = (value))
#define CAN_RMW_IMASK1(base, mask, value) (CAN_WR_IMASK1(base, (CAN_RD_IMASK1(base) & ~(mask)) | (value)))
#define CAN_SET_IMASK1(base, value) (CAN_WR_IMASK1(base, CAN_RD_IMASK1(base) |  (value)))
#define CAN_CLR_IMASK1(base, value) (CAN_WR_IMASK1(base, CAN_RD_IMASK1(base) & ~(value)))
#define CAN_TOG_IMASK1(base, value) (CAN_WR_IMASK1(base, CAN_RD_IMASK1(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CAN_IFLAG1 - Interrupt Flags 1 register
 ******************************************************************************/

/*!
 * @brief CAN_IFLAG1 - Interrupt Flags 1 register (W1C)
 *
 * Reset value: 0x00000000U
 *
 * This register defines the flags for the 32 Message Buffer interrupts for MB31
 * to MB0. It contains one interrupt flag bit per buffer. Each successful
 * transmission or reception sets the corresponding IFLAG1 bit. If the corresponding
 * IMASK1 bit is set, an interrupt will be generated. The interrupt flag must be
 * cleared by writing 1 to it. Writing 0 has no effect. The BUF7I to BUF5I flags
 * are also used to represent FIFO interrupts when the Rx FIFO is enabled. When the
 * bit MCR[RFEN] is set, the function of the 8 least significant interrupt flags
 * BUF[7:0]I changes: BUF7I, BUF6I and BUF5I indicate operating conditions of
 * the FIFO, and the BUF4TO0I field is reserved. Before enabling the RFEN, the CPU
 * must service the IFLAG bits asserted in the Rx FIFO region; see Section "Rx
 * FIFO". Otherwise, these IFLAG bits will mistakenly show the related MBs now
 * belonging to FIFO as having contents to be serviced. When the RFEN bit is negated,
 * the FIFO flags must be cleared. The same care must be taken when an RFFN
 * value is selected extending Rx FIFO filters beyond MB7. For example, when RFFN is
 * 0x8, the MB0-23 range is occupied by Rx FIFO filters and related IFLAG bits
 * must be cleared. Before updating MCR[MAXMB] field, CPU must service the IFLAG1
 * bits whose MB value is greater than the MCR[MAXMB] to be updated; otherwise,
 * they will remain set and be inconsistent with the number of MBs available.
 */
/*!
 * @name Constants and macros for entire CAN_IFLAG1 register
 */
/*@{*/
#define CAN_RD_IFLAG1(base)      (CAN_IFLAG1_REG(base))
#define CAN_WR_IFLAG1(base, value) (CAN_IFLAG1_REG(base) = (value))
#define CAN_RMW_IFLAG1(base, mask, value) (CAN_WR_IFLAG1(base, (CAN_RD_IFLAG1(base) & ~(mask)) | (value)))
#define CAN_SET_IFLAG1(base, value) (CAN_WR_IFLAG1(base, CAN_RD_IFLAG1(base) |  (value)))
#define CAN_CLR_IFLAG1(base, value) (CAN_WR_IFLAG1(base, CAN_RD_IFLAG1(base) & ~(value)))
#define CAN_TOG_IFLAG1(base, value) (CAN_WR_IFLAG1(base, CAN_RD_IFLAG1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_IFLAG1 bitfields
 */

/*!
 * @name Register CAN_IFLAG1, field BUF0I[0] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), this bit flags
 * the interrupt for MB0. This flag is cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by CPU writes. The BUF0I flag is reserved when MCR[RFEN] is
 * set.
 *
 * Values:
 * - 0b0 - The corresponding buffer has no occurrence of successfully completed
 *     transmission or reception when MCR[RFEN]=0.
 * - 0b1 - The corresponding buffer has successfully completed transmission or
 *     reception when MCR[RFEN]=0.
 */
/*@{*/
/*! @brief Read current value of the CAN_IFLAG1_BUF0I field. */
#define CAN_RD_IFLAG1_BUF0I(base) ((CAN_IFLAG1_REG(base) & CAN_IFLAG1_BUF0I_MASK) >> CAN_IFLAG1_BUF0I_SHIFT)
#define CAN_BRD_IFLAG1_BUF0I(base) (BITBAND_ACCESS32(&CAN_IFLAG1_REG(base), CAN_IFLAG1_BUF0I_SHIFT))

/*! @brief Set the BUF0I field to a new value. */
#define CAN_WR_IFLAG1_BUF0I(base, value) (CAN_RMW_IFLAG1(base, (CAN_IFLAG1_BUF0I_MASK | CAN_IFLAG1_BUF4TO1I_MASK | CAN_IFLAG1_BUF5I_MASK | CAN_IFLAG1_BUF6I_MASK | CAN_IFLAG1_BUF7I_MASK | CAN_IFLAG1_BUF31TO8I_MASK), CAN_IFLAG1_BUF0I(value)))
#define CAN_BWR_IFLAG1_BUF0I(base, value) (BITBAND_ACCESS32(&CAN_IFLAG1_REG(base), CAN_IFLAG1_BUF0I_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF4TO1I[4:1] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), these bits flag
 * the interrupts for MB4 to MB1. These flags are cleared by the FlexCAN whenever
 * the bit MCR[RFEN] is changed by CPU writes. The BUF4TO1I flags are reserved
 * when MCR[RFEN] is set.
 *
 * Values:
 * - 0b0000 - The corresponding buffer has no occurrence of successfully
 *     completed transmission or reception when MCR[RFEN]=0.
 * - 0b0001 - The corresponding buffer has successfully completed transmission
 *     or reception when MCR[RFEN]=0.
 */
/*@{*/
/*! @brief Read current value of the CAN_IFLAG1_BUF4TO1I field. */
#define CAN_RD_IFLAG1_BUF4TO1I(base) ((CAN_IFLAG1_REG(base) & CAN_IFLAG1_BUF4TO1I_MASK) >> CAN_IFLAG1_BUF4TO1I_SHIFT)
#define CAN_BRD_IFLAG1_BUF4TO1I(base) (CAN_RD_IFLAG1_BUF4TO1I(base))

/*! @brief Set the BUF4TO1I field to a new value. */
#define CAN_WR_IFLAG1_BUF4TO1I(base, value) (CAN_RMW_IFLAG1(base, (CAN_IFLAG1_BUF4TO1I_MASK | CAN_IFLAG1_BUF0I_MASK | CAN_IFLAG1_BUF5I_MASK | CAN_IFLAG1_BUF6I_MASK | CAN_IFLAG1_BUF7I_MASK | CAN_IFLAG1_BUF31TO8I_MASK), CAN_IFLAG1_BUF4TO1I(value)))
#define CAN_BWR_IFLAG1_BUF4TO1I(base, value) (CAN_WR_IFLAG1_BUF4TO1I(base, value))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF5I[5] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), this bit flags
 * the interrupt for MB5. This flag is cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by CPU writes. The BUF5I flag represents "Frames available in
 * Rx FIFO" when MCR[RFEN] is set. In this case, the flag indicates that at
 * least one frame is available to be read from the Rx FIFO.
 *
 * Values:
 * - 0b0 - No occurrence of MB5 completing transmission/reception when
 *     MCR[RFEN]=0, or of frame(s) available in the FIFO, when MCR[RFEN]=1
 * - 0b1 - MB5 completed transmission/reception when MCR[RFEN]=0, or frame(s)
 *     available in the Rx FIFO when MCR[RFEN]=1
 */
/*@{*/
/*! @brief Read current value of the CAN_IFLAG1_BUF5I field. */
#define CAN_RD_IFLAG1_BUF5I(base) ((CAN_IFLAG1_REG(base) & CAN_IFLAG1_BUF5I_MASK) >> CAN_IFLAG1_BUF5I_SHIFT)
#define CAN_BRD_IFLAG1_BUF5I(base) (BITBAND_ACCESS32(&CAN_IFLAG1_REG(base), CAN_IFLAG1_BUF5I_SHIFT))

/*! @brief Set the BUF5I field to a new value. */
#define CAN_WR_IFLAG1_BUF5I(base, value) (CAN_RMW_IFLAG1(base, (CAN_IFLAG1_BUF5I_MASK | CAN_IFLAG1_BUF0I_MASK | CAN_IFLAG1_BUF4TO1I_MASK | CAN_IFLAG1_BUF6I_MASK | CAN_IFLAG1_BUF7I_MASK | CAN_IFLAG1_BUF31TO8I_MASK), CAN_IFLAG1_BUF5I(value)))
#define CAN_BWR_IFLAG1_BUF5I(base, value) (BITBAND_ACCESS32(&CAN_IFLAG1_REG(base), CAN_IFLAG1_BUF5I_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF6I[6] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), this bit flags
 * the interrupt for MB6. This flag is cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by CPU writes. The BUF6I flag represents "Rx FIFO Warning"
 * when MCR[RFEN] is set. In this case, the flag indicates when the number of
 * unread messages within the Rx FIFO is increased to 5 from 4 due to the reception of
 * a new one, meaning that the Rx FIFO is almost full. Note that if the flag is
 * cleared while the number of unread messages is greater than 4, it does not
 * assert again until the number of unread messages within the Rx FIFO is decreased
 * to be equal to or less than 4.
 *
 * Values:
 * - 0b0 - No occurrence of MB6 completing transmission/reception when
 *     MCR[RFEN]=0, or of Rx FIFO almost full when MCR[RFEN]=1
 * - 0b1 - MB6 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO
 *     almost full when MCR[RFEN]=1
 */
/*@{*/
/*! @brief Read current value of the CAN_IFLAG1_BUF6I field. */
#define CAN_RD_IFLAG1_BUF6I(base) ((CAN_IFLAG1_REG(base) & CAN_IFLAG1_BUF6I_MASK) >> CAN_IFLAG1_BUF6I_SHIFT)
#define CAN_BRD_IFLAG1_BUF6I(base) (BITBAND_ACCESS32(&CAN_IFLAG1_REG(base), CAN_IFLAG1_BUF6I_SHIFT))

/*! @brief Set the BUF6I field to a new value. */
#define CAN_WR_IFLAG1_BUF6I(base, value) (CAN_RMW_IFLAG1(base, (CAN_IFLAG1_BUF6I_MASK | CAN_IFLAG1_BUF0I_MASK | CAN_IFLAG1_BUF4TO1I_MASK | CAN_IFLAG1_BUF5I_MASK | CAN_IFLAG1_BUF7I_MASK | CAN_IFLAG1_BUF31TO8I_MASK), CAN_IFLAG1_BUF6I(value)))
#define CAN_BWR_IFLAG1_BUF6I(base, value) (BITBAND_ACCESS32(&CAN_IFLAG1_REG(base), CAN_IFLAG1_BUF6I_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF7I[7] (W1C)
 *
 * When the RFEN bit in the MCR is cleared (Rx FIFO disabled), this bit flags
 * the interrupt for MB7. This flag is cleared by the FlexCAN whenever the bit
 * MCR[RFEN] is changed by CPU writes. The BUF7I flag represents "Rx FIFO Overflow"
 * when MCR[RFEN] is set. In this case, the flag indicates that a message was lost
 * because the Rx FIFO is full. Note that the flag will not be asserted when the
 * Rx FIFO is full and the message was captured by a Mailbox.
 *
 * Values:
 * - 0b0 - No occurrence of MB7 completing transmission/reception when
 *     MCR[RFEN]=0, or of Rx FIFO overflow when MCR[RFEN]=1
 * - 0b1 - MB7 completed transmission/reception when MCR[RFEN]=0, or Rx FIFO
 *     overflow when MCR[RFEN]=1
 */
/*@{*/
/*! @brief Read current value of the CAN_IFLAG1_BUF7I field. */
#define CAN_RD_IFLAG1_BUF7I(base) ((CAN_IFLAG1_REG(base) & CAN_IFLAG1_BUF7I_MASK) >> CAN_IFLAG1_BUF7I_SHIFT)
#define CAN_BRD_IFLAG1_BUF7I(base) (BITBAND_ACCESS32(&CAN_IFLAG1_REG(base), CAN_IFLAG1_BUF7I_SHIFT))

/*! @brief Set the BUF7I field to a new value. */
#define CAN_WR_IFLAG1_BUF7I(base, value) (CAN_RMW_IFLAG1(base, (CAN_IFLAG1_BUF7I_MASK | CAN_IFLAG1_BUF0I_MASK | CAN_IFLAG1_BUF4TO1I_MASK | CAN_IFLAG1_BUF5I_MASK | CAN_IFLAG1_BUF6I_MASK | CAN_IFLAG1_BUF31TO8I_MASK), CAN_IFLAG1_BUF7I(value)))
#define CAN_BWR_IFLAG1_BUF7I(base, value) (BITBAND_ACCESS32(&CAN_IFLAG1_REG(base), CAN_IFLAG1_BUF7I_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_IFLAG1, field BUF31TO8I[31:8] (W1C)
 *
 * Each bit flags the corresponding FlexCAN Message Buffer interrupt for MB31 to
 * MB8.
 *
 * Values:
 * - 0b000000000000000000000000 - The corresponding buffer has no occurrence of
 *     successfully completed transmission or reception.
 * - 0b000000000000000000000001 - The corresponding buffer has successfully
 *     completed transmission or reception.
 */
/*@{*/
/*! @brief Read current value of the CAN_IFLAG1_BUF31TO8I field. */
#define CAN_RD_IFLAG1_BUF31TO8I(base) ((CAN_IFLAG1_REG(base) & CAN_IFLAG1_BUF31TO8I_MASK) >> CAN_IFLAG1_BUF31TO8I_SHIFT)
#define CAN_BRD_IFLAG1_BUF31TO8I(base) (CAN_RD_IFLAG1_BUF31TO8I(base))

/*! @brief Set the BUF31TO8I field to a new value. */
#define CAN_WR_IFLAG1_BUF31TO8I(base, value) (CAN_RMW_IFLAG1(base, (CAN_IFLAG1_BUF31TO8I_MASK | CAN_IFLAG1_BUF0I_MASK | CAN_IFLAG1_BUF4TO1I_MASK | CAN_IFLAG1_BUF5I_MASK | CAN_IFLAG1_BUF6I_MASK | CAN_IFLAG1_BUF7I_MASK), CAN_IFLAG1_BUF31TO8I(value)))
#define CAN_BWR_IFLAG1_BUF31TO8I(base, value) (CAN_WR_IFLAG1_BUF31TO8I(base, value))
/*@}*/

/*******************************************************************************
 * CAN_CTRL2 - Control 2 register
 ******************************************************************************/

/*!
 * @brief CAN_CTRL2 - Control 2 register (RW)
 *
 * Reset value: 0x00B00000U
 *
 * This register contains control bits for CAN errors, FIFO features, and mode
 * selection.
 */
/*!
 * @name Constants and macros for entire CAN_CTRL2 register
 */
/*@{*/
#define CAN_RD_CTRL2(base)       (CAN_CTRL2_REG(base))
#define CAN_WR_CTRL2(base, value) (CAN_CTRL2_REG(base) = (value))
#define CAN_RMW_CTRL2(base, mask, value) (CAN_WR_CTRL2(base, (CAN_RD_CTRL2(base) & ~(mask)) | (value)))
#define CAN_SET_CTRL2(base, value) (CAN_WR_CTRL2(base, CAN_RD_CTRL2(base) |  (value)))
#define CAN_CLR_CTRL2(base, value) (CAN_WR_CTRL2(base, CAN_RD_CTRL2(base) & ~(value)))
#define CAN_TOG_CTRL2(base, value) (CAN_WR_CTRL2(base, CAN_RD_CTRL2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_CTRL2 bitfields
 */

/*!
 * @name Register CAN_CTRL2, field EACEN[16] (RW)
 *
 * This bit controls the comparison of IDE and RTR bits whithin Rx Mailboxes
 * filters with their corresponding bits in the incoming frame by the matching
 * process. This bit does not affect matching for Rx FIFO. This bit can be written
 * only in Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - Rx Mailbox filter's IDE bit is always compared and RTR is never
 *     compared despite mask bits.
 * - 0b1 - Enables the comparison of both Rx Mailbox filter's IDE and RTR bit
 *     with their corresponding bits within the incoming frame. Mask bits do apply.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL2_EACEN field. */
#define CAN_RD_CTRL2_EACEN(base) ((CAN_CTRL2_REG(base) & CAN_CTRL2_EACEN_MASK) >> CAN_CTRL2_EACEN_SHIFT)
#define CAN_BRD_CTRL2_EACEN(base) (BITBAND_ACCESS32(&CAN_CTRL2_REG(base), CAN_CTRL2_EACEN_SHIFT))

/*! @brief Set the EACEN field to a new value. */
#define CAN_WR_CTRL2_EACEN(base, value) (CAN_RMW_CTRL2(base, CAN_CTRL2_EACEN_MASK, CAN_CTRL2_EACEN(value)))
#define CAN_BWR_CTRL2_EACEN(base, value) (BITBAND_ACCESS32(&CAN_CTRL2_REG(base), CAN_CTRL2_EACEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field RRS[17] (RW)
 *
 * If this bit is asserted Remote Request Frame is submitted to a matching
 * process and stored in the corresponding Message Buffer in the same fashion of a
 * Data Frame. No automatic Remote Response Frame will be generated. If this bit is
 * negated the Remote Request Frame is submitted to a matching process and an
 * automatic Remote Response Frame is generated if a Message Buffer with CODE=0b1010
 * is found with the same ID. This bit can be written only in Freeze mode
 * because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - Remote Response Frame is generated.
 * - 0b1 - Remote Request Frame is stored.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL2_RRS field. */
#define CAN_RD_CTRL2_RRS(base) ((CAN_CTRL2_REG(base) & CAN_CTRL2_RRS_MASK) >> CAN_CTRL2_RRS_SHIFT)
#define CAN_BRD_CTRL2_RRS(base) (BITBAND_ACCESS32(&CAN_CTRL2_REG(base), CAN_CTRL2_RRS_SHIFT))

/*! @brief Set the RRS field to a new value. */
#define CAN_WR_CTRL2_RRS(base, value) (CAN_RMW_CTRL2(base, CAN_CTRL2_RRS_MASK, CAN_CTRL2_RRS(value)))
#define CAN_BWR_CTRL2_RRS(base, value) (BITBAND_ACCESS32(&CAN_CTRL2_REG(base), CAN_CTRL2_RRS_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field MRP[18] (RW)
 *
 * If this bit is set the matching process starts from the Mailboxes and if no
 * match occurs the matching continues on the Rx FIFO. This bit can be written
 * only in Freeze mode because it is blocked by hardware in other modes.
 *
 * Values:
 * - 0b0 - Matching starts from Rx FIFO and continues on Mailboxes.
 * - 0b1 - Matching starts from Mailboxes and continues on Rx FIFO.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL2_MRP field. */
#define CAN_RD_CTRL2_MRP(base) ((CAN_CTRL2_REG(base) & CAN_CTRL2_MRP_MASK) >> CAN_CTRL2_MRP_SHIFT)
#define CAN_BRD_CTRL2_MRP(base) (BITBAND_ACCESS32(&CAN_CTRL2_REG(base), CAN_CTRL2_MRP_SHIFT))

/*! @brief Set the MRP field to a new value. */
#define CAN_WR_CTRL2_MRP(base, value) (CAN_RMW_CTRL2(base, CAN_CTRL2_MRP_MASK, CAN_CTRL2_MRP(value)))
#define CAN_BWR_CTRL2_MRP(base, value) (BITBAND_ACCESS32(&CAN_CTRL2_REG(base), CAN_CTRL2_MRP_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field TASD[23:19] (RW)
 *
 * This 5-bit field indicates how many CAN bits the Tx arbitration process start
 * point can be delayed from the first bit of CRC field on CAN bus. This field
 * can be written only in Freeze mode because it is blocked by hardware in other
 * modes. This field is useful to optimize the transmit performance based on
 * factors such as: peripheral/serial clock ratio, CAN bit timing and number of MBs.
 * The duration of an arbitration process, in terms of CAN bits, is directly
 * proportional to the number of available MBs and CAN baud rate and inversely
 * proportional to the peripheral clock frequency. The optimal arbitration timing is
 * that in which the last MB is scanned right before the first bit of the
 * Intermission field of a CAN frame. Therefore, if there are few MBs and the system/serial
 * clock ratio is high and the CAN baud rate is low then the arbitration can be
 * delayed and vice-versa. If TASD is 0 then the arbitration start is not
 * delayed, thus the CPU has less time to configure a Tx MB for the next arbitration,
 * but more time is reserved for arbitration. On the other hand, if TASD is 24 then
 * the CPU can configure a Tx MB later and less time is reserved for
 * arbitration. If too little time is reserved for arbitration the FlexCAN may be not able
 * to find winner MBs in time to compete with other nodes for the CAN bus. If the
 * arbitration ends too much time before the first bit of Intermission field then
 * there is a chance that the CPU reconfigures some Tx MBs and the winner MB is
 * not the best to be transmitted. The optimal configuration for TASD can be
 * calculated as: TASD = 25 - {f CANCLK * [MAXMB + 3 - (RFEN * 8) - (RFEN * RFFN *
 * 2)] * 2} / {f SYS * [1+(PSEG1+1)+(PSEG2+1)+(PROPSEG+1)] * (PRESDIV+1)} where: f
 * CANCLK is the Protocol Engine (PE) Clock (see section "Protocol Timing"), in
 * Hz f SYS is the peripheral clock, in Hz MAXMB is the value in CTRL1[MAXMB]
 * field RFEN is the value in CTRL1[RFEN] bit RFFN is the value in CTRL2[RFFN] field
 * PSEG1 is the value in CTRL1[PSEG1] field PSEG2 is the value in CTRL1[PSEG2]
 * field PROPSEG is the value in CTRL1[PROPSEG] field PRESDIV is the value in
 * CTRL1[PRESDIV] field See Section "Arbitration process" and Section "Protocol
 * Timing" for more details.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL2_TASD field. */
#define CAN_RD_CTRL2_TASD(base) ((CAN_CTRL2_REG(base) & CAN_CTRL2_TASD_MASK) >> CAN_CTRL2_TASD_SHIFT)
#define CAN_BRD_CTRL2_TASD(base) (CAN_RD_CTRL2_TASD(base))

/*! @brief Set the TASD field to a new value. */
#define CAN_WR_CTRL2_TASD(base, value) (CAN_RMW_CTRL2(base, CAN_CTRL2_TASD_MASK, CAN_CTRL2_TASD(value)))
#define CAN_BWR_CTRL2_TASD(base, value) (CAN_WR_CTRL2_TASD(base, value))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field RFFN[27:24] (RW)
 *
 * This 4-bit field defines the number of Rx FIFO filters, as shown in the
 * following table. The maximum selectable number of filters is determined by the MCU.
 * This field can only be written in Freeze mode as it is blocked by hardware in
 * other modes. This field must not be programmed with values that make the
 * number of Message Buffers occupied by Rx FIFO and ID Filter exceed the number of
 * Mailboxes present, defined by MCR[MAXMB]. Each group of eight filters occupies
 * a memory space equivalent to two Message Buffers which means that the more
 * filters are implemented the less Mailboxes will be available. Considering that
 * the Rx FIFO occupies the memory space originally reserved for MB0-5, RFFN should
 * be programmed with a value correponding to a number of filters not greater
 * than the number of available memory words which can be calculated as follows:
 * (SETUP_MB - 6) * 4 where SETUP_MB is the least between NUMBER_OF_MB and MAXMB.
 * The number of remaining Mailboxes available will be: (SETUP_MB - 8) - (RFFN *
 * 2) If the Number of Rx FIFO Filters programmed through RFFN exceeds the
 * SETUP_MB value (memory space available) the exceeding ones will not be functional.
 * RFFN[3:0] Number of Rx FIFO filters Message Buffers occupied by Rx FIFO and ID
 * Filter Table Remaining Available MailboxesThe number of the last remaining
 * available mailboxes is defined by the least value between the parameter
 * NUMBER_OF_MB minus 1 and the MCR[MAXMB] field. Rx FIFO ID Filter Table Elements Affected
 * by Rx Individual MasksIf Rx Individual Mask Registers are not enabled then
 * all Rx FIFO filters are affected by the Rx FIFO Global Mask. Rx FIFO ID Filter
 * Table Elements Affected by Rx FIFO Global Mask #rxfgmask-note 0x0 8 MB 0-7 MB
 * 8-63 Elements 0-7 none 0x1 16 MB 0-9 MB 10-63 Elements 0-9 Elements 10-15 0x2
 * 24 MB 0-11 MB 12-63 Elements 0-11 Elements 12-23 0x3 32 MB 0-13 MB 14-63
 * Elements 0-13 Elements 14-31 0x4 40 MB 0-15 MB 16-63 Elements 0-15 Elements 16-39
 * 0x5 48 MB 0-17 MB 18-63 Elements 0-17 Elements 18-47 0x6 56 MB 0-19 MB 20-63
 * Elements 0-19 Elements 20-55 0x7 64 MB 0-21 MB 22-63 Elements 0-21 Elements 22-63
 * 0x8 72 MB 0-23 MB 24-63 Elements 0-23 Elements 24-71 0x9 80 MB 0-25 MB 26-63
 * Elements 0-25 Elements 26-79 0xA 88 MB 0-27 MB 28-63 Elements 0-27 Elements
 * 28-87 0xB 96 MB 0-29 MB 30-63 Elements 0-29 Elements 30-95 0xC 104 MB 0-31 MB
 * 32-63 Elements 0-31 Elements 32-103 0xD 112 MB 0-33 MB 34-63 Elements 0-31
 * Elements 32-111 0xE 120 MB 0-35 MB 36-63 Elements 0-31 Elements 32-119 0xF 128 MB
 * 0-37 MB 38-63 Elements 0-31 Elements 32-127
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL2_RFFN field. */
#define CAN_RD_CTRL2_RFFN(base) ((CAN_CTRL2_REG(base) & CAN_CTRL2_RFFN_MASK) >> CAN_CTRL2_RFFN_SHIFT)
#define CAN_BRD_CTRL2_RFFN(base) (CAN_RD_CTRL2_RFFN(base))

/*! @brief Set the RFFN field to a new value. */
#define CAN_WR_CTRL2_RFFN(base, value) (CAN_RMW_CTRL2(base, CAN_CTRL2_RFFN_MASK, CAN_CTRL2_RFFN(value)))
#define CAN_BWR_CTRL2_RFFN(base, value) (CAN_WR_CTRL2_RFFN(base, value))
/*@}*/

/*!
 * @name Register CAN_CTRL2, field WRMFRZ[28] (RW)
 *
 * Enable unrestricted write access to FlexCAN memory in Freeze mode. This bit
 * can only be written in Freeze mode and has no effect out of Freeze mode.
 *
 * Values:
 * - 0b0 - Maintain the write access restrictions.
 * - 0b1 - Enable unrestricted write access to FlexCAN memory.
 */
/*@{*/
/*! @brief Read current value of the CAN_CTRL2_WRMFRZ field. */
#define CAN_RD_CTRL2_WRMFRZ(base) ((CAN_CTRL2_REG(base) & CAN_CTRL2_WRMFRZ_MASK) >> CAN_CTRL2_WRMFRZ_SHIFT)
#define CAN_BRD_CTRL2_WRMFRZ(base) (BITBAND_ACCESS32(&CAN_CTRL2_REG(base), CAN_CTRL2_WRMFRZ_SHIFT))

/*! @brief Set the WRMFRZ field to a new value. */
#define CAN_WR_CTRL2_WRMFRZ(base, value) (CAN_RMW_CTRL2(base, CAN_CTRL2_WRMFRZ_MASK, CAN_CTRL2_WRMFRZ(value)))
#define CAN_BWR_CTRL2_WRMFRZ(base, value) (BITBAND_ACCESS32(&CAN_CTRL2_REG(base), CAN_CTRL2_WRMFRZ_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * CAN_ESR2 - Error and Status 2 register
 ******************************************************************************/

/*!
 * @brief CAN_ESR2 - Error and Status 2 register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register reflects various interrupt flags and some general status.
 */
/*!
 * @name Constants and macros for entire CAN_ESR2 register
 */
/*@{*/
#define CAN_RD_ESR2(base)        (CAN_ESR2_REG(base))
/*@}*/

/*
 * Constants & macros for individual CAN_ESR2 bitfields
 */

/*!
 * @name Register CAN_ESR2, field IMB[13] (RO)
 *
 * If ESR2[VPS] is asserted, this bit indicates whether there is any inactive
 * Mailbox (CODE field is either 0b1000 or 0b0000). This bit is asserted in the
 * following cases: During arbitration, if an LPTM is found and it is inactive. If
 * IMB is not asserted and a frame is transmitted successfully. This bit is
 * cleared in all start of arbitration (see Section "Arbitration process"). LPTM
 * mechanism have the following behavior: if an MB is successfully transmitted and
 * ESR2[IMB]=0 (no inactive Mailbox), then ESR2[VPS] and ESR2[IMB] are asserted and
 * the index related to the MB just transmitted is loaded into ESR2[LPTM].
 *
 * Values:
 * - 0b0 - If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive Mailbox.
 * - 0b1 - If ESR2[VPS] is asserted, there is at least one inactive Mailbox.
 *     LPTM content is the number of the first one.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR2_IMB field. */
#define CAN_RD_ESR2_IMB(base) ((CAN_ESR2_REG(base) & CAN_ESR2_IMB_MASK) >> CAN_ESR2_IMB_SHIFT)
#define CAN_BRD_ESR2_IMB(base) (BITBAND_ACCESS32(&CAN_ESR2_REG(base), CAN_ESR2_IMB_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR2, field VPS[14] (RO)
 *
 * This bit indicates whether IMB and LPTM contents are currently valid or not.
 * VPS is asserted upon every complete Tx arbitration process unless the CPU
 * writes to Control and Status word of a Mailbox that has already been scanned, that
 * is, it is behind Tx Arbitration Pointer, during the Tx arbitration process.
 * If there is no inactive Mailbox and only one Tx Mailbox that is being
 * transmitted then VPS is not asserted. VPS is negated upon the start of every Tx
 * arbitration process or upon a write to Control and Status word of any Mailbox.
 * ESR2[VPS] is not affected by any CPU write into Control Status (C/S) of a MB that is
 * blocked by abort mechanism. When MCR[AEN] is asserted, the abort code write
 * in C/S of a MB that is being transmitted (pending abort), or any write attempt
 * into a Tx MB with IFLAG set is blocked.
 *
 * Values:
 * - 0b0 - Contents of IMB and LPTM are invalid.
 * - 0b1 - Contents of IMB and LPTM are valid.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR2_VPS field. */
#define CAN_RD_ESR2_VPS(base) ((CAN_ESR2_REG(base) & CAN_ESR2_VPS_MASK) >> CAN_ESR2_VPS_SHIFT)
#define CAN_BRD_ESR2_VPS(base) (BITBAND_ACCESS32(&CAN_ESR2_REG(base), CAN_ESR2_VPS_SHIFT))
/*@}*/

/*!
 * @name Register CAN_ESR2, field LPTM[22:16] (RO)
 *
 * If ESR2[VPS] is asserted, this field indicates the lowest number inactive
 * Mailbox (see the IMB bit description). If there is no inactive Mailbox then the
 * Mailbox indicated depends on CTRL1[LBUF] bit value. If CTRL1[LBUF] bit is
 * negated then the Mailbox indicated is the one that has the greatest arbitration
 * value (see the "Highest priority Mailbox first" section). If CTRL1[LBUF] bit is
 * asserted then the Mailbox indicated is the highest number active Tx Mailbox. If
 * a Tx Mailbox is being transmitted it is not considered in LPTM calculation.
 * If ESR2[IMB] is not asserted and a frame is transmitted successfully, LPTM is
 * updated with its Mailbox number.
 */
/*@{*/
/*! @brief Read current value of the CAN_ESR2_LPTM field. */
#define CAN_RD_ESR2_LPTM(base) ((CAN_ESR2_REG(base) & CAN_ESR2_LPTM_MASK) >> CAN_ESR2_LPTM_SHIFT)
#define CAN_BRD_ESR2_LPTM(base) (CAN_RD_ESR2_LPTM(base))
/*@}*/

/*******************************************************************************
 * CAN_CRCR - CRC Register
 ******************************************************************************/

/*!
 * @brief CAN_CRCR - CRC Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * This register provides information about the CRC of transmitted messages.
 */
/*!
 * @name Constants and macros for entire CAN_CRCR register
 */
/*@{*/
#define CAN_RD_CRCR(base)        (CAN_CRCR_REG(base))
/*@}*/

/*
 * Constants & macros for individual CAN_CRCR bitfields
 */

/*!
 * @name Register CAN_CRCR, field TXCRC[14:0] (RO)
 *
 * This field indicates the CRC value of the last message transmitted. This
 * field is updated at the same time the Tx Interrupt Flag is asserted.
 */
/*@{*/
/*! @brief Read current value of the CAN_CRCR_TXCRC field. */
#define CAN_RD_CRCR_TXCRC(base) ((CAN_CRCR_REG(base) & CAN_CRCR_TXCRC_MASK) >> CAN_CRCR_TXCRC_SHIFT)
#define CAN_BRD_CRCR_TXCRC(base) (CAN_RD_CRCR_TXCRC(base))
/*@}*/

/*!
 * @name Register CAN_CRCR, field MBCRC[22:16] (RO)
 *
 * This field indicates the number of the Mailbox corresponding to the value in
 * TXCRC field.
 */
/*@{*/
/*! @brief Read current value of the CAN_CRCR_MBCRC field. */
#define CAN_RD_CRCR_MBCRC(base) ((CAN_CRCR_REG(base) & CAN_CRCR_MBCRC_MASK) >> CAN_CRCR_MBCRC_SHIFT)
#define CAN_BRD_CRCR_MBCRC(base) (CAN_RD_CRCR_MBCRC(base))
/*@}*/

/*******************************************************************************
 * CAN_RXFGMASK - Rx FIFO Global Mask register
 ******************************************************************************/

/*!
 * @brief CAN_RXFGMASK - Rx FIFO Global Mask register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * This register is located in RAM. If Rx FIFO is enabled RXFGMASK is used to
 * mask the Rx FIFO ID Filter Table elements that do not have a corresponding RXIMR
 * according to CTRL2[RFFN] field setting. This register can only be written in
 * Freeze mode as it is blocked by hardware in other modes.
 */
/*!
 * @name Constants and macros for entire CAN_RXFGMASK register
 */
/*@{*/
#define CAN_RD_RXFGMASK(base)    (CAN_RXFGMASK_REG(base))
#define CAN_WR_RXFGMASK(base, value) (CAN_RXFGMASK_REG(base) = (value))
#define CAN_RMW_RXFGMASK(base, mask, value) (CAN_WR_RXFGMASK(base, (CAN_RD_RXFGMASK(base) & ~(mask)) | (value)))
#define CAN_SET_RXFGMASK(base, value) (CAN_WR_RXFGMASK(base, CAN_RD_RXFGMASK(base) |  (value)))
#define CAN_CLR_RXFGMASK(base, value) (CAN_WR_RXFGMASK(base, CAN_RD_RXFGMASK(base) & ~(value)))
#define CAN_TOG_RXFGMASK(base, value) (CAN_WR_RXFGMASK(base, CAN_RD_RXFGMASK(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CAN_RXFIR - Rx FIFO Information Register
 ******************************************************************************/

/*!
 * @brief CAN_RXFIR - Rx FIFO Information Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * RXFIR provides information on Rx FIFO. This register is the port through
 * which the CPU accesses the output of the RXFIR FIFO located in RAM. The RXFIR FIFO
 * is written by the FlexCAN whenever a new message is moved into the Rx FIFO as
 * well as its output is updated whenever the output of the Rx FIFO is updated
 * with the next message. See Section "Rx FIFO" for instructions on reading this
 * register.
 */
/*!
 * @name Constants and macros for entire CAN_RXFIR register
 */
/*@{*/
#define CAN_RD_RXFIR(base)       (CAN_RXFIR_REG(base))
/*@}*/

/*
 * Constants & macros for individual CAN_RXFIR bitfields
 */

/*!
 * @name Register CAN_RXFIR, field IDHIT[8:0] (RO)
 *
 * This field indicates which Identifier Acceptance Filter was hit by the
 * received message that is in the output of the Rx FIFO. If multiple filters match the
 * incoming message ID then the first matching IDAF found (lowest number) by the
 * matching process is indicated. This field is valid only while the
 * IFLAG[BUF5I] is asserted.
 */
/*@{*/
/*! @brief Read current value of the CAN_RXFIR_IDHIT field. */
#define CAN_RD_RXFIR_IDHIT(base) ((CAN_RXFIR_REG(base) & CAN_RXFIR_IDHIT_MASK) >> CAN_RXFIR_IDHIT_SHIFT)
#define CAN_BRD_RXFIR_IDHIT(base) (CAN_RD_RXFIR_IDHIT(base))
/*@}*/

/*******************************************************************************
 * CAN_CS - Message Buffer 0 CS Register
 ******************************************************************************/

/*!
 * @brief CAN_CS - Message Buffer 0 CS Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAN_CS register
 */
/*@{*/
#define CAN_RD_CS(base, index)   (CAN_CS_REG(base, index))
#define CAN_WR_CS(base, index, value) (CAN_CS_REG(base, index) = (value))
#define CAN_RMW_CS(base, index, mask, value) (CAN_WR_CS(base, index, (CAN_RD_CS(base, index) & ~(mask)) | (value)))
#define CAN_SET_CS(base, index, value) (CAN_WR_CS(base, index, CAN_RD_CS(base, index) |  (value)))
#define CAN_CLR_CS(base, index, value) (CAN_WR_CS(base, index, CAN_RD_CS(base, index) & ~(value)))
#define CAN_TOG_CS(base, index, value) (CAN_WR_CS(base, index, CAN_RD_CS(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_CS bitfields
 */

/*!
 * @name Register CAN_CS, field TIME_STAMP[15:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_CS_TIME_STAMP field. */
#define CAN_RD_CS_TIME_STAMP(base, index) ((CAN_CS_REG(base, index) & CAN_CS_TIME_STAMP_MASK) >> CAN_CS_TIME_STAMP_SHIFT)
#define CAN_BRD_CS_TIME_STAMP(base, index) (CAN_RD_CS_TIME_STAMP(base, index))

/*! @brief Set the TIME_STAMP field to a new value. */
#define CAN_WR_CS_TIME_STAMP(base, index, value) (CAN_RMW_CS(base, index, CAN_CS_TIME_STAMP_MASK, CAN_CS_TIME_STAMP(value)))
#define CAN_BWR_CS_TIME_STAMP(base, index, value) (CAN_WR_CS_TIME_STAMP(base, index, value))
/*@}*/

/*!
 * @name Register CAN_CS, field DLC[19:16] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_CS_DLC field. */
#define CAN_RD_CS_DLC(base, index) ((CAN_CS_REG(base, index) & CAN_CS_DLC_MASK) >> CAN_CS_DLC_SHIFT)
#define CAN_BRD_CS_DLC(base, index) (CAN_RD_CS_DLC(base, index))

/*! @brief Set the DLC field to a new value. */
#define CAN_WR_CS_DLC(base, index, value) (CAN_RMW_CS(base, index, CAN_CS_DLC_MASK, CAN_CS_DLC(value)))
#define CAN_BWR_CS_DLC(base, index, value) (CAN_WR_CS_DLC(base, index, value))
/*@}*/

/*!
 * @name Register CAN_CS, field RTR[20] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_CS_RTR field. */
#define CAN_RD_CS_RTR(base, index) ((CAN_CS_REG(base, index) & CAN_CS_RTR_MASK) >> CAN_CS_RTR_SHIFT)
#define CAN_BRD_CS_RTR(base, index) (BITBAND_ACCESS32(&CAN_CS_REG(base, index), CAN_CS_RTR_SHIFT))

/*! @brief Set the RTR field to a new value. */
#define CAN_WR_CS_RTR(base, index, value) (CAN_RMW_CS(base, index, CAN_CS_RTR_MASK, CAN_CS_RTR(value)))
#define CAN_BWR_CS_RTR(base, index, value) (BITBAND_ACCESS32(&CAN_CS_REG(base, index), CAN_CS_RTR_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CS, field IDE[21] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_CS_IDE field. */
#define CAN_RD_CS_IDE(base, index) ((CAN_CS_REG(base, index) & CAN_CS_IDE_MASK) >> CAN_CS_IDE_SHIFT)
#define CAN_BRD_CS_IDE(base, index) (BITBAND_ACCESS32(&CAN_CS_REG(base, index), CAN_CS_IDE_SHIFT))

/*! @brief Set the IDE field to a new value. */
#define CAN_WR_CS_IDE(base, index, value) (CAN_RMW_CS(base, index, CAN_CS_IDE_MASK, CAN_CS_IDE(value)))
#define CAN_BWR_CS_IDE(base, index, value) (BITBAND_ACCESS32(&CAN_CS_REG(base, index), CAN_CS_IDE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CS, field SRR[22] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_CS_SRR field. */
#define CAN_RD_CS_SRR(base, index) ((CAN_CS_REG(base, index) & CAN_CS_SRR_MASK) >> CAN_CS_SRR_SHIFT)
#define CAN_BRD_CS_SRR(base, index) (BITBAND_ACCESS32(&CAN_CS_REG(base, index), CAN_CS_SRR_SHIFT))

/*! @brief Set the SRR field to a new value. */
#define CAN_WR_CS_SRR(base, index, value) (CAN_RMW_CS(base, index, CAN_CS_SRR_MASK, CAN_CS_SRR(value)))
#define CAN_BWR_CS_SRR(base, index, value) (BITBAND_ACCESS32(&CAN_CS_REG(base, index), CAN_CS_SRR_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CAN_CS, field CODE[27:24] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_CS_CODE field. */
#define CAN_RD_CS_CODE(base, index) ((CAN_CS_REG(base, index) & CAN_CS_CODE_MASK) >> CAN_CS_CODE_SHIFT)
#define CAN_BRD_CS_CODE(base, index) (CAN_RD_CS_CODE(base, index))

/*! @brief Set the CODE field to a new value. */
#define CAN_WR_CS_CODE(base, index, value) (CAN_RMW_CS(base, index, CAN_CS_CODE_MASK, CAN_CS_CODE(value)))
#define CAN_BWR_CS_CODE(base, index, value) (CAN_WR_CS_CODE(base, index, value))
/*@}*/

/*******************************************************************************
 * CAN_ID - Message Buffer 0 ID Register
 ******************************************************************************/

/*!
 * @brief CAN_ID - Message Buffer 0 ID Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAN_ID register
 */
/*@{*/
#define CAN_RD_ID(base, index)   (CAN_ID_REG(base, index))
#define CAN_WR_ID(base, index, value) (CAN_ID_REG(base, index) = (value))
#define CAN_RMW_ID(base, index, mask, value) (CAN_WR_ID(base, index, (CAN_RD_ID(base, index) & ~(mask)) | (value)))
#define CAN_SET_ID(base, index, value) (CAN_WR_ID(base, index, CAN_RD_ID(base, index) |  (value)))
#define CAN_CLR_ID(base, index, value) (CAN_WR_ID(base, index, CAN_RD_ID(base, index) & ~(value)))
#define CAN_TOG_ID(base, index, value) (CAN_WR_ID(base, index, CAN_RD_ID(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_ID bitfields
 */

/*!
 * @name Register CAN_ID, field EXT[17:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_ID_EXT field. */
#define CAN_RD_ID_EXT(base, index) ((CAN_ID_REG(base, index) & CAN_ID_EXT_MASK) >> CAN_ID_EXT_SHIFT)
#define CAN_BRD_ID_EXT(base, index) (CAN_RD_ID_EXT(base, index))

/*! @brief Set the EXT field to a new value. */
#define CAN_WR_ID_EXT(base, index, value) (CAN_RMW_ID(base, index, CAN_ID_EXT_MASK, CAN_ID_EXT(value)))
#define CAN_BWR_ID_EXT(base, index, value) (CAN_WR_ID_EXT(base, index, value))
/*@}*/

/*!
 * @name Register CAN_ID, field STD[28:18] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_ID_STD field. */
#define CAN_RD_ID_STD(base, index) ((CAN_ID_REG(base, index) & CAN_ID_STD_MASK) >> CAN_ID_STD_SHIFT)
#define CAN_BRD_ID_STD(base, index) (CAN_RD_ID_STD(base, index))

/*! @brief Set the STD field to a new value. */
#define CAN_WR_ID_STD(base, index, value) (CAN_RMW_ID(base, index, CAN_ID_STD_MASK, CAN_ID_STD(value)))
#define CAN_BWR_ID_STD(base, index, value) (CAN_WR_ID_STD(base, index, value))
/*@}*/

/*!
 * @name Register CAN_ID, field PRIO[31:29] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_ID_PRIO field. */
#define CAN_RD_ID_PRIO(base, index) ((CAN_ID_REG(base, index) & CAN_ID_PRIO_MASK) >> CAN_ID_PRIO_SHIFT)
#define CAN_BRD_ID_PRIO(base, index) (CAN_RD_ID_PRIO(base, index))

/*! @brief Set the PRIO field to a new value. */
#define CAN_WR_ID_PRIO(base, index, value) (CAN_RMW_ID(base, index, CAN_ID_PRIO_MASK, CAN_ID_PRIO(value)))
#define CAN_BWR_ID_PRIO(base, index, value) (CAN_WR_ID_PRIO(base, index, value))
/*@}*/

/*******************************************************************************
 * CAN_WORD0 - Message Buffer 0 WORD0 Register
 ******************************************************************************/

/*!
 * @brief CAN_WORD0 - Message Buffer 0 WORD0 Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAN_WORD0 register
 */
/*@{*/
#define CAN_RD_WORD0(base, index) (CAN_WORD0_REG(base, index))
#define CAN_WR_WORD0(base, index, value) (CAN_WORD0_REG(base, index) = (value))
#define CAN_RMW_WORD0(base, index, mask, value) (CAN_WR_WORD0(base, index, (CAN_RD_WORD0(base, index) & ~(mask)) | (value)))
#define CAN_SET_WORD0(base, index, value) (CAN_WR_WORD0(base, index, CAN_RD_WORD0(base, index) |  (value)))
#define CAN_CLR_WORD0(base, index, value) (CAN_WR_WORD0(base, index, CAN_RD_WORD0(base, index) & ~(value)))
#define CAN_TOG_WORD0(base, index, value) (CAN_WR_WORD0(base, index, CAN_RD_WORD0(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_WORD0 bitfields
 */

/*!
 * @name Register CAN_WORD0, field DATA_BYTE_3[7:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_WORD0_DATA_BYTE_3 field. */
#define CAN_RD_WORD0_DATA_BYTE_3(base, index) ((CAN_WORD0_REG(base, index) & CAN_WORD0_DATA_BYTE_3_MASK) >> CAN_WORD0_DATA_BYTE_3_SHIFT)
#define CAN_BRD_WORD0_DATA_BYTE_3(base, index) (CAN_RD_WORD0_DATA_BYTE_3(base, index))

/*! @brief Set the DATA_BYTE_3 field to a new value. */
#define CAN_WR_WORD0_DATA_BYTE_3(base, index, value) (CAN_RMW_WORD0(base, index, CAN_WORD0_DATA_BYTE_3_MASK, CAN_WORD0_DATA_BYTE_3(value)))
#define CAN_BWR_WORD0_DATA_BYTE_3(base, index, value) (CAN_WR_WORD0_DATA_BYTE_3(base, index, value))
/*@}*/

/*!
 * @name Register CAN_WORD0, field DATA_BYTE_2[15:8] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_WORD0_DATA_BYTE_2 field. */
#define CAN_RD_WORD0_DATA_BYTE_2(base, index) ((CAN_WORD0_REG(base, index) & CAN_WORD0_DATA_BYTE_2_MASK) >> CAN_WORD0_DATA_BYTE_2_SHIFT)
#define CAN_BRD_WORD0_DATA_BYTE_2(base, index) (CAN_RD_WORD0_DATA_BYTE_2(base, index))

/*! @brief Set the DATA_BYTE_2 field to a new value. */
#define CAN_WR_WORD0_DATA_BYTE_2(base, index, value) (CAN_RMW_WORD0(base, index, CAN_WORD0_DATA_BYTE_2_MASK, CAN_WORD0_DATA_BYTE_2(value)))
#define CAN_BWR_WORD0_DATA_BYTE_2(base, index, value) (CAN_WR_WORD0_DATA_BYTE_2(base, index, value))
/*@}*/

/*!
 * @name Register CAN_WORD0, field DATA_BYTE_1[23:16] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_WORD0_DATA_BYTE_1 field. */
#define CAN_RD_WORD0_DATA_BYTE_1(base, index) ((CAN_WORD0_REG(base, index) & CAN_WORD0_DATA_BYTE_1_MASK) >> CAN_WORD0_DATA_BYTE_1_SHIFT)
#define CAN_BRD_WORD0_DATA_BYTE_1(base, index) (CAN_RD_WORD0_DATA_BYTE_1(base, index))

/*! @brief Set the DATA_BYTE_1 field to a new value. */
#define CAN_WR_WORD0_DATA_BYTE_1(base, index, value) (CAN_RMW_WORD0(base, index, CAN_WORD0_DATA_BYTE_1_MASK, CAN_WORD0_DATA_BYTE_1(value)))
#define CAN_BWR_WORD0_DATA_BYTE_1(base, index, value) (CAN_WR_WORD0_DATA_BYTE_1(base, index, value))
/*@}*/

/*!
 * @name Register CAN_WORD0, field DATA_BYTE_0[31:24] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_WORD0_DATA_BYTE_0 field. */
#define CAN_RD_WORD0_DATA_BYTE_0(base, index) ((CAN_WORD0_REG(base, index) & CAN_WORD0_DATA_BYTE_0_MASK) >> CAN_WORD0_DATA_BYTE_0_SHIFT)
#define CAN_BRD_WORD0_DATA_BYTE_0(base, index) (CAN_RD_WORD0_DATA_BYTE_0(base, index))

/*! @brief Set the DATA_BYTE_0 field to a new value. */
#define CAN_WR_WORD0_DATA_BYTE_0(base, index, value) (CAN_RMW_WORD0(base, index, CAN_WORD0_DATA_BYTE_0_MASK, CAN_WORD0_DATA_BYTE_0(value)))
#define CAN_BWR_WORD0_DATA_BYTE_0(base, index, value) (CAN_WR_WORD0_DATA_BYTE_0(base, index, value))
/*@}*/

/*******************************************************************************
 * CAN_WORD1 - Message Buffer 0 WORD1 Register
 ******************************************************************************/

/*!
 * @brief CAN_WORD1 - Message Buffer 0 WORD1 Register (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAN_WORD1 register
 */
/*@{*/
#define CAN_RD_WORD1(base, index) (CAN_WORD1_REG(base, index))
#define CAN_WR_WORD1(base, index, value) (CAN_WORD1_REG(base, index) = (value))
#define CAN_RMW_WORD1(base, index, mask, value) (CAN_WR_WORD1(base, index, (CAN_RD_WORD1(base, index) & ~(mask)) | (value)))
#define CAN_SET_WORD1(base, index, value) (CAN_WR_WORD1(base, index, CAN_RD_WORD1(base, index) |  (value)))
#define CAN_CLR_WORD1(base, index, value) (CAN_WR_WORD1(base, index, CAN_RD_WORD1(base, index) & ~(value)))
#define CAN_TOG_WORD1(base, index, value) (CAN_WR_WORD1(base, index, CAN_RD_WORD1(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CAN_WORD1 bitfields
 */

/*!
 * @name Register CAN_WORD1, field DATA_BYTE_7[7:0] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_WORD1_DATA_BYTE_7 field. */
#define CAN_RD_WORD1_DATA_BYTE_7(base, index) ((CAN_WORD1_REG(base, index) & CAN_WORD1_DATA_BYTE_7_MASK) >> CAN_WORD1_DATA_BYTE_7_SHIFT)
#define CAN_BRD_WORD1_DATA_BYTE_7(base, index) (CAN_RD_WORD1_DATA_BYTE_7(base, index))

/*! @brief Set the DATA_BYTE_7 field to a new value. */
#define CAN_WR_WORD1_DATA_BYTE_7(base, index, value) (CAN_RMW_WORD1(base, index, CAN_WORD1_DATA_BYTE_7_MASK, CAN_WORD1_DATA_BYTE_7(value)))
#define CAN_BWR_WORD1_DATA_BYTE_7(base, index, value) (CAN_WR_WORD1_DATA_BYTE_7(base, index, value))
/*@}*/

/*!
 * @name Register CAN_WORD1, field DATA_BYTE_6[15:8] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_WORD1_DATA_BYTE_6 field. */
#define CAN_RD_WORD1_DATA_BYTE_6(base, index) ((CAN_WORD1_REG(base, index) & CAN_WORD1_DATA_BYTE_6_MASK) >> CAN_WORD1_DATA_BYTE_6_SHIFT)
#define CAN_BRD_WORD1_DATA_BYTE_6(base, index) (CAN_RD_WORD1_DATA_BYTE_6(base, index))

/*! @brief Set the DATA_BYTE_6 field to a new value. */
#define CAN_WR_WORD1_DATA_BYTE_6(base, index, value) (CAN_RMW_WORD1(base, index, CAN_WORD1_DATA_BYTE_6_MASK, CAN_WORD1_DATA_BYTE_6(value)))
#define CAN_BWR_WORD1_DATA_BYTE_6(base, index, value) (CAN_WR_WORD1_DATA_BYTE_6(base, index, value))
/*@}*/

/*!
 * @name Register CAN_WORD1, field DATA_BYTE_5[23:16] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_WORD1_DATA_BYTE_5 field. */
#define CAN_RD_WORD1_DATA_BYTE_5(base, index) ((CAN_WORD1_REG(base, index) & CAN_WORD1_DATA_BYTE_5_MASK) >> CAN_WORD1_DATA_BYTE_5_SHIFT)
#define CAN_BRD_WORD1_DATA_BYTE_5(base, index) (CAN_RD_WORD1_DATA_BYTE_5(base, index))

/*! @brief Set the DATA_BYTE_5 field to a new value. */
#define CAN_WR_WORD1_DATA_BYTE_5(base, index, value) (CAN_RMW_WORD1(base, index, CAN_WORD1_DATA_BYTE_5_MASK, CAN_WORD1_DATA_BYTE_5(value)))
#define CAN_BWR_WORD1_DATA_BYTE_5(base, index, value) (CAN_WR_WORD1_DATA_BYTE_5(base, index, value))
/*@}*/

/*!
 * @name Register CAN_WORD1, field DATA_BYTE_4[31:24] (RW)
 */
/*@{*/
/*! @brief Read current value of the CAN_WORD1_DATA_BYTE_4 field. */
#define CAN_RD_WORD1_DATA_BYTE_4(base, index) ((CAN_WORD1_REG(base, index) & CAN_WORD1_DATA_BYTE_4_MASK) >> CAN_WORD1_DATA_BYTE_4_SHIFT)
#define CAN_BRD_WORD1_DATA_BYTE_4(base, index) (CAN_RD_WORD1_DATA_BYTE_4(base, index))

/*! @brief Set the DATA_BYTE_4 field to a new value. */
#define CAN_WR_WORD1_DATA_BYTE_4(base, index, value) (CAN_RMW_WORD1(base, index, CAN_WORD1_DATA_BYTE_4_MASK, CAN_WORD1_DATA_BYTE_4(value)))
#define CAN_BWR_WORD1_DATA_BYTE_4(base, index, value) (CAN_WR_WORD1_DATA_BYTE_4(base, index, value))
/*@}*/

/*******************************************************************************
 * CAN_RXIMR - Rx Individual Mask Registers
 ******************************************************************************/

/*!
 * @brief CAN_RXIMR - Rx Individual Mask Registers (RW)
 *
 * Reset value: 0x00000000U
 *
 * These registers are located in RAM. RXIMR are used as acceptance masks for ID
 * filtering in Rx MBs and the Rx FIFO. If the Rx FIFO is not enabled, one mask
 * register is provided for each available Mailbox, providing ID masking
 * capability on a per Mailbox basis. When the Rx FIFO is enabled (MCR[RFEN] bit is
 * asserted), up to 32 Rx Individual Mask Registers can apply to the Rx FIFO ID Filter
 * Table elements on a one-to-one correspondence depending on the setting of
 * CTRL2[RFFN]. RXIMR can only be written by the CPU while the module is in Freeze
 * mode; otherwise, they are blocked by hardware. The Individual Rx Mask Registers
 * are not affected by reset and must be explicitly initialized prior to any
 * reception.
 */
/*!
 * @name Constants and macros for entire CAN_RXIMR register
 */
/*@{*/
#define CAN_RD_RXIMR(base, index) (CAN_RXIMR_REG(base, index))
#define CAN_WR_RXIMR(base, index, value) (CAN_RXIMR_REG(base, index) = (value))
#define CAN_RMW_RXIMR(base, index, mask, value) (CAN_WR_RXIMR(base, index, (CAN_RD_RXIMR(base, index) & ~(mask)) | (value)))
#define CAN_SET_RXIMR(base, index, value) (CAN_WR_RXIMR(base, index, CAN_RD_RXIMR(base, index) |  (value)))
#define CAN_CLR_RXIMR(base, index, value) (CAN_WR_RXIMR(base, index, CAN_RD_RXIMR(base, index) & ~(value)))
#define CAN_TOG_RXIMR(base, index, value) (CAN_WR_RXIMR(base, index, CAN_RD_RXIMR(base, index) ^  (value)))
/*@}*/

/*
 * MK64F12 CAU
 *
 * Memory Mapped Cryptographic Acceleration Unit (MMCAU)
 *
 * Registers defined in this header file:
 * - CAU_DIRECT - Direct access register 0
 * - CAU_LDR_CASR - Status register - Load Register command
 * - CAU_LDR_CAA - Accumulator register - Load Register command
 * - CAU_LDR_CA - General Purpose Register 0 - Load Register command
 * - CAU_STR_CASR - Status register - Store Register command
 * - CAU_STR_CAA - Accumulator register - Store Register command
 * - CAU_STR_CA - General Purpose Register 0 - Store Register command
 * - CAU_ADR_CASR - Status register - Add Register command
 * - CAU_ADR_CAA - Accumulator register - Add to register command
 * - CAU_ADR_CA - General Purpose Register 0 - Add to register command
 * - CAU_RADR_CASR - Status register - Reverse and Add to Register command
 * - CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command
 * - CAU_RADR_CA - General Purpose Register 0 - Reverse and Add to Register command
 * - CAU_XOR_CASR - Status register - Exclusive Or command
 * - CAU_XOR_CAA - Accumulator register - Exclusive Or command
 * - CAU_XOR_CA - General Purpose Register 0 - Exclusive Or command
 * - CAU_ROTL_CASR - Status register - Rotate Left command
 * - CAU_ROTL_CAA - Accumulator register - Rotate Left command
 * - CAU_ROTL_CA - General Purpose Register 0 - Rotate Left command
 * - CAU_AESC_CASR - Status register - AES Column Operation command
 * - CAU_AESC_CAA - Accumulator register - AES Column Operation command
 * - CAU_AESC_CA - General Purpose Register 0 - AES Column Operation command
 * - CAU_AESIC_CASR - Status register - AES Inverse Column Operation command
 * - CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command
 * - CAU_AESIC_CA - General Purpose Register 0 - AES Inverse Column Operation command
 */

#define CAU_INSTANCE_COUNT (1U) /*!< Number of instances of the CAU module. */
#define CAU_IDX (0U) /*!< Instance number for CAU. */

/*******************************************************************************
 * CAU_DIRECT - Direct access register 0
 ******************************************************************************/

/*!
 * @brief CAU_DIRECT - Direct access register 0 (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_DIRECT register
 */
/*@{*/
#define CAU_WR_DIRECT(base, index, value) (CAU_DIRECT_REG(base, index) = (value))
/*@}*/

/*******************************************************************************
 * CAU_LDR_CASR - Status register - Load Register command
 ******************************************************************************/

/*!
 * @brief CAU_LDR_CASR - Status register - Load Register command (WO)
 *
 * Reset value: 0x20000000U
 */
/*!
 * @name Constants and macros for entire CAU_LDR_CASR register
 */
/*@{*/
#define CAU_WR_LDR_CASR(base, value) (CAU_LDR_CASR_REG(base) = (value))
/*@}*/

/*
 * Constants & macros for individual CAU_LDR_CASR bitfields
 */

/*!
 * @name Register CAU_LDR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0b0 - No illegal commands issued
 * - 0b1 - Illegal command issued
 */
/*@{*/
/*! @brief Set the IC field to a new value. */
#define CAU_WR_LDR_CASR_IC(base, value) (CAU_WR_LDR_CASR(base, CAU_LDR_CASR_IC(value)))
#define CAU_BWR_LDR_CASR_IC(base, value) (CAU_WR_LDR_CASR_IC(base, value))
/*@}*/

/*!
 * @name Register CAU_LDR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0b0 - No error detected
 * - 0b1 - DES key parity error detected
 */
/*@{*/
/*! @brief Set the DPE field to a new value. */
#define CAU_WR_LDR_CASR_DPE(base, value) (CAU_WR_LDR_CASR(base, CAU_LDR_CASR_DPE(value)))
#define CAU_BWR_LDR_CASR_DPE(base, value) (CAU_WR_LDR_CASR_DPE(base, value))
/*@}*/

/*!
 * @name Register CAU_LDR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0b0001 - Initial CAU version
 * - 0b0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
/*! @brief Set the VER field to a new value. */
#define CAU_WR_LDR_CASR_VER(base, value) (CAU_WR_LDR_CASR(base, CAU_LDR_CASR_VER(value)))
#define CAU_BWR_LDR_CASR_VER(base, value) (CAU_WR_LDR_CASR_VER(base, value))
/*@}*/

/*******************************************************************************
 * CAU_LDR_CAA - Accumulator register - Load Register command
 ******************************************************************************/

/*!
 * @brief CAU_LDR_CAA - Accumulator register - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_LDR_CAA register
 */
/*@{*/
#define CAU_WR_LDR_CAA(base, value) (CAU_LDR_CAA_REG(base) = (value))
/*@}*/

/*******************************************************************************
 * CAU_LDR_CA - General Purpose Register 0 - Load Register command
 ******************************************************************************/

/*!
 * @brief CAU_LDR_CA - General Purpose Register 0 - Load Register command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_LDR_CA register
 */
/*@{*/
#define CAU_WR_LDR_CA(base, index, value) (CAU_LDR_CA_REG(base, index) = (value))
/*@}*/

/*******************************************************************************
 * CAU_STR_CASR - Status register - Store Register command
 ******************************************************************************/

/*!
 * @brief CAU_STR_CASR - Status register - Store Register command (RO)
 *
 * Reset value: 0x20000000U
 */
/*!
 * @name Constants and macros for entire CAU_STR_CASR register
 */
/*@{*/
#define CAU_RD_STR_CASR(base)    (CAU_STR_CASR_REG(base))
/*@}*/

/*
 * Constants & macros for individual CAU_STR_CASR bitfields
 */

/*!
 * @name Register CAU_STR_CASR, field IC[0] (RO)
 *
 * Values:
 * - 0b0 - No illegal commands issued
 * - 0b1 - Illegal command issued
 */
/*@{*/
/*! @brief Read current value of the CAU_STR_CASR_IC field. */
#define CAU_RD_STR_CASR_IC(base) ((CAU_STR_CASR_REG(base) & CAU_STR_CASR_IC_MASK) >> CAU_STR_CASR_IC_SHIFT)
#define CAU_BRD_STR_CASR_IC(base) (CAU_RD_STR_CASR_IC(base))
/*@}*/

/*!
 * @name Register CAU_STR_CASR, field DPE[1] (RO)
 *
 * Values:
 * - 0b0 - No error detected
 * - 0b1 - DES key parity error detected
 */
/*@{*/
/*! @brief Read current value of the CAU_STR_CASR_DPE field. */
#define CAU_RD_STR_CASR_DPE(base) ((CAU_STR_CASR_REG(base) & CAU_STR_CASR_DPE_MASK) >> CAU_STR_CASR_DPE_SHIFT)
#define CAU_BRD_STR_CASR_DPE(base) (CAU_RD_STR_CASR_DPE(base))
/*@}*/

/*!
 * @name Register CAU_STR_CASR, field VER[31:28] (RO)
 *
 * Values:
 * - 0b0001 - Initial CAU version
 * - 0b0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
/*! @brief Read current value of the CAU_STR_CASR_VER field. */
#define CAU_RD_STR_CASR_VER(base) ((CAU_STR_CASR_REG(base) & CAU_STR_CASR_VER_MASK) >> CAU_STR_CASR_VER_SHIFT)
#define CAU_BRD_STR_CASR_VER(base) (CAU_RD_STR_CASR_VER(base))
/*@}*/

/*******************************************************************************
 * CAU_STR_CAA - Accumulator register - Store Register command
 ******************************************************************************/

/*!
 * @brief CAU_STR_CAA - Accumulator register - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_STR_CAA register
 */
/*@{*/
#define CAU_RD_STR_CAA(base)     (CAU_STR_CAA_REG(base))
/*@}*/

/*******************************************************************************
 * CAU_STR_CA - General Purpose Register 0 - Store Register command
 ******************************************************************************/

/*!
 * @brief CAU_STR_CA - General Purpose Register 0 - Store Register command (RO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_STR_CA register
 */
/*@{*/
#define CAU_RD_STR_CA(base, index) (CAU_STR_CA_REG(base, index))
/*@}*/

/*******************************************************************************
 * CAU_ADR_CASR - Status register - Add Register command
 ******************************************************************************/

/*!
 * @brief CAU_ADR_CASR - Status register - Add Register command (WO)
 *
 * Reset value: 0x20000000U
 */
/*!
 * @name Constants and macros for entire CAU_ADR_CASR register
 */
/*@{*/
#define CAU_WR_ADR_CASR(base, value) (CAU_ADR_CASR_REG(base) = (value))
/*@}*/

/*
 * Constants & macros for individual CAU_ADR_CASR bitfields
 */

/*!
 * @name Register CAU_ADR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0b0 - No illegal commands issued
 * - 0b1 - Illegal command issued
 */
/*@{*/
/*! @brief Set the IC field to a new value. */
#define CAU_WR_ADR_CASR_IC(base, value) (CAU_WR_ADR_CASR(base, CAU_ADR_CASR_IC(value)))
#define CAU_BWR_ADR_CASR_IC(base, value) (CAU_WR_ADR_CASR_IC(base, value))
/*@}*/

/*!
 * @name Register CAU_ADR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0b0 - No error detected
 * - 0b1 - DES key parity error detected
 */
/*@{*/
/*! @brief Set the DPE field to a new value. */
#define CAU_WR_ADR_CASR_DPE(base, value) (CAU_WR_ADR_CASR(base, CAU_ADR_CASR_DPE(value)))
#define CAU_BWR_ADR_CASR_DPE(base, value) (CAU_WR_ADR_CASR_DPE(base, value))
/*@}*/

/*!
 * @name Register CAU_ADR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0b0001 - Initial CAU version
 * - 0b0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
/*! @brief Set the VER field to a new value. */
#define CAU_WR_ADR_CASR_VER(base, value) (CAU_WR_ADR_CASR(base, CAU_ADR_CASR_VER(value)))
#define CAU_BWR_ADR_CASR_VER(base, value) (CAU_WR_ADR_CASR_VER(base, value))
/*@}*/

/*******************************************************************************
 * CAU_ADR_CAA - Accumulator register - Add to register command
 ******************************************************************************/

/*!
 * @brief CAU_ADR_CAA - Accumulator register - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_ADR_CAA register
 */
/*@{*/
#define CAU_WR_ADR_CAA(base, value) (CAU_ADR_CAA_REG(base) = (value))
/*@}*/

/*******************************************************************************
 * CAU_ADR_CA - General Purpose Register 0 - Add to register command
 ******************************************************************************/

/*!
 * @brief CAU_ADR_CA - General Purpose Register 0 - Add to register command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_ADR_CA register
 */
/*@{*/
#define CAU_WR_ADR_CA(base, index, value) (CAU_ADR_CA_REG(base, index) = (value))
/*@}*/

/*******************************************************************************
 * CAU_RADR_CASR - Status register - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief CAU_RADR_CASR - Status register - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x20000000U
 */
/*!
 * @name Constants and macros for entire CAU_RADR_CASR register
 */
/*@{*/
#define CAU_WR_RADR_CASR(base, value) (CAU_RADR_CASR_REG(base) = (value))
/*@}*/

/*
 * Constants & macros for individual CAU_RADR_CASR bitfields
 */

/*!
 * @name Register CAU_RADR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0b0 - No illegal commands issued
 * - 0b1 - Illegal command issued
 */
/*@{*/
/*! @brief Set the IC field to a new value. */
#define CAU_WR_RADR_CASR_IC(base, value) (CAU_WR_RADR_CASR(base, CAU_RADR_CASR_IC(value)))
#define CAU_BWR_RADR_CASR_IC(base, value) (CAU_WR_RADR_CASR_IC(base, value))
/*@}*/

/*!
 * @name Register CAU_RADR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0b0 - No error detected
 * - 0b1 - DES key parity error detected
 */
/*@{*/
/*! @brief Set the DPE field to a new value. */
#define CAU_WR_RADR_CASR_DPE(base, value) (CAU_WR_RADR_CASR(base, CAU_RADR_CASR_DPE(value)))
#define CAU_BWR_RADR_CASR_DPE(base, value) (CAU_WR_RADR_CASR_DPE(base, value))
/*@}*/

/*!
 * @name Register CAU_RADR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0b0001 - Initial CAU version
 * - 0b0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
/*! @brief Set the VER field to a new value. */
#define CAU_WR_RADR_CASR_VER(base, value) (CAU_WR_RADR_CASR(base, CAU_RADR_CASR_VER(value)))
#define CAU_BWR_RADR_CASR_VER(base, value) (CAU_WR_RADR_CASR_VER(base, value))
/*@}*/

/*******************************************************************************
 * CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief CAU_RADR_CAA - Accumulator register - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_RADR_CAA register
 */
/*@{*/
#define CAU_WR_RADR_CAA(base, value) (CAU_RADR_CAA_REG(base) = (value))
/*@}*/

/*******************************************************************************
 * CAU_RADR_CA - General Purpose Register 0 - Reverse and Add to Register command
 ******************************************************************************/

/*!
 * @brief CAU_RADR_CA - General Purpose Register 0 - Reverse and Add to Register command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_RADR_CA register
 */
/*@{*/
#define CAU_WR_RADR_CA(base, index, value) (CAU_RADR_CA_REG(base, index) = (value))
/*@}*/

/*******************************************************************************
 * CAU_XOR_CASR - Status register - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief CAU_XOR_CASR - Status register - Exclusive Or command (WO)
 *
 * Reset value: 0x20000000U
 */
/*!
 * @name Constants and macros for entire CAU_XOR_CASR register
 */
/*@{*/
#define CAU_WR_XOR_CASR(base, value) (CAU_XOR_CASR_REG(base) = (value))
/*@}*/

/*
 * Constants & macros for individual CAU_XOR_CASR bitfields
 */

/*!
 * @name Register CAU_XOR_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0b0 - No illegal commands issued
 * - 0b1 - Illegal command issued
 */
/*@{*/
/*! @brief Set the IC field to a new value. */
#define CAU_WR_XOR_CASR_IC(base, value) (CAU_WR_XOR_CASR(base, CAU_XOR_CASR_IC(value)))
#define CAU_BWR_XOR_CASR_IC(base, value) (CAU_WR_XOR_CASR_IC(base, value))
/*@}*/

/*!
 * @name Register CAU_XOR_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0b0 - No error detected
 * - 0b1 - DES key parity error detected
 */
/*@{*/
/*! @brief Set the DPE field to a new value. */
#define CAU_WR_XOR_CASR_DPE(base, value) (CAU_WR_XOR_CASR(base, CAU_XOR_CASR_DPE(value)))
#define CAU_BWR_XOR_CASR_DPE(base, value) (CAU_WR_XOR_CASR_DPE(base, value))
/*@}*/

/*!
 * @name Register CAU_XOR_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0b0001 - Initial CAU version
 * - 0b0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
/*! @brief Set the VER field to a new value. */
#define CAU_WR_XOR_CASR_VER(base, value) (CAU_WR_XOR_CASR(base, CAU_XOR_CASR_VER(value)))
#define CAU_BWR_XOR_CASR_VER(base, value) (CAU_WR_XOR_CASR_VER(base, value))
/*@}*/

/*******************************************************************************
 * CAU_XOR_CAA - Accumulator register - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief CAU_XOR_CAA - Accumulator register - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_XOR_CAA register
 */
/*@{*/
#define CAU_WR_XOR_CAA(base, value) (CAU_XOR_CAA_REG(base) = (value))
/*@}*/

/*******************************************************************************
 * CAU_XOR_CA - General Purpose Register 0 - Exclusive Or command
 ******************************************************************************/

/*!
 * @brief CAU_XOR_CA - General Purpose Register 0 - Exclusive Or command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_XOR_CA register
 */
/*@{*/
#define CAU_WR_XOR_CA(base, index, value) (CAU_XOR_CA_REG(base, index) = (value))
/*@}*/

/*******************************************************************************
 * CAU_ROTL_CASR - Status register - Rotate Left command
 ******************************************************************************/

/*!
 * @brief CAU_ROTL_CASR - Status register - Rotate Left command (WO)
 *
 * Reset value: 0x20000000U
 */
/*!
 * @name Constants and macros for entire CAU_ROTL_CASR register
 */
/*@{*/
#define CAU_WR_ROTL_CASR(base, value) (CAU_ROTL_CASR_REG(base) = (value))
/*@}*/

/*
 * Constants & macros for individual CAU_ROTL_CASR bitfields
 */

/*!
 * @name Register CAU_ROTL_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0b0 - No illegal commands issued
 * - 0b1 - Illegal command issued
 */
/*@{*/
/*! @brief Set the IC field to a new value. */
#define CAU_WR_ROTL_CASR_IC(base, value) (CAU_WR_ROTL_CASR(base, CAU_ROTL_CASR_IC(value)))
#define CAU_BWR_ROTL_CASR_IC(base, value) (CAU_WR_ROTL_CASR_IC(base, value))
/*@}*/

/*!
 * @name Register CAU_ROTL_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0b0 - No error detected
 * - 0b1 - DES key parity error detected
 */
/*@{*/
/*! @brief Set the DPE field to a new value. */
#define CAU_WR_ROTL_CASR_DPE(base, value) (CAU_WR_ROTL_CASR(base, CAU_ROTL_CASR_DPE(value)))
#define CAU_BWR_ROTL_CASR_DPE(base, value) (CAU_WR_ROTL_CASR_DPE(base, value))
/*@}*/

/*!
 * @name Register CAU_ROTL_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0b0001 - Initial CAU version
 * - 0b0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
/*! @brief Set the VER field to a new value. */
#define CAU_WR_ROTL_CASR_VER(base, value) (CAU_WR_ROTL_CASR(base, CAU_ROTL_CASR_VER(value)))
#define CAU_BWR_ROTL_CASR_VER(base, value) (CAU_WR_ROTL_CASR_VER(base, value))
/*@}*/

/*******************************************************************************
 * CAU_ROTL_CAA - Accumulator register - Rotate Left command
 ******************************************************************************/

/*!
 * @brief CAU_ROTL_CAA - Accumulator register - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_ROTL_CAA register
 */
/*@{*/
#define CAU_WR_ROTL_CAA(base, value) (CAU_ROTL_CAA_REG(base) = (value))
/*@}*/

/*******************************************************************************
 * CAU_ROTL_CA - General Purpose Register 0 - Rotate Left command
 ******************************************************************************/

/*!
 * @brief CAU_ROTL_CA - General Purpose Register 0 - Rotate Left command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_ROTL_CA register
 */
/*@{*/
#define CAU_WR_ROTL_CA(base, index, value) (CAU_ROTL_CA_REG(base, index) = (value))
/*@}*/

/*******************************************************************************
 * CAU_AESC_CASR - Status register - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief CAU_AESC_CASR - Status register - AES Column Operation command (WO)
 *
 * Reset value: 0x20000000U
 */
/*!
 * @name Constants and macros for entire CAU_AESC_CASR register
 */
/*@{*/
#define CAU_WR_AESC_CASR(base, value) (CAU_AESC_CASR_REG(base) = (value))
/*@}*/

/*
 * Constants & macros for individual CAU_AESC_CASR bitfields
 */

/*!
 * @name Register CAU_AESC_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0b0 - No illegal commands issued
 * - 0b1 - Illegal command issued
 */
/*@{*/
/*! @brief Set the IC field to a new value. */
#define CAU_WR_AESC_CASR_IC(base, value) (CAU_WR_AESC_CASR(base, CAU_AESC_CASR_IC(value)))
#define CAU_BWR_AESC_CASR_IC(base, value) (CAU_WR_AESC_CASR_IC(base, value))
/*@}*/

/*!
 * @name Register CAU_AESC_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0b0 - No error detected
 * - 0b1 - DES key parity error detected
 */
/*@{*/
/*! @brief Set the DPE field to a new value. */
#define CAU_WR_AESC_CASR_DPE(base, value) (CAU_WR_AESC_CASR(base, CAU_AESC_CASR_DPE(value)))
#define CAU_BWR_AESC_CASR_DPE(base, value) (CAU_WR_AESC_CASR_DPE(base, value))
/*@}*/

/*!
 * @name Register CAU_AESC_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0b0001 - Initial CAU version
 * - 0b0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
/*! @brief Set the VER field to a new value. */
#define CAU_WR_AESC_CASR_VER(base, value) (CAU_WR_AESC_CASR(base, CAU_AESC_CASR_VER(value)))
#define CAU_BWR_AESC_CASR_VER(base, value) (CAU_WR_AESC_CASR_VER(base, value))
/*@}*/

/*******************************************************************************
 * CAU_AESC_CAA - Accumulator register - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief CAU_AESC_CAA - Accumulator register - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_AESC_CAA register
 */
/*@{*/
#define CAU_WR_AESC_CAA(base, value) (CAU_AESC_CAA_REG(base) = (value))
/*@}*/

/*******************************************************************************
 * CAU_AESC_CA - General Purpose Register 0 - AES Column Operation command
 ******************************************************************************/

/*!
 * @brief CAU_AESC_CA - General Purpose Register 0 - AES Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_AESC_CA register
 */
/*@{*/
#define CAU_WR_AESC_CA(base, index, value) (CAU_AESC_CA_REG(base, index) = (value))
/*@}*/

/*******************************************************************************
 * CAU_AESIC_CASR - Status register - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief CAU_AESIC_CASR - Status register - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x20000000U
 */
/*!
 * @name Constants and macros for entire CAU_AESIC_CASR register
 */
/*@{*/
#define CAU_WR_AESIC_CASR(base, value) (CAU_AESIC_CASR_REG(base) = (value))
/*@}*/

/*
 * Constants & macros for individual CAU_AESIC_CASR bitfields
 */

/*!
 * @name Register CAU_AESIC_CASR, field IC[0] (WO)
 *
 * Values:
 * - 0b0 - No illegal commands issued
 * - 0b1 - Illegal command issued
 */
/*@{*/
/*! @brief Set the IC field to a new value. */
#define CAU_WR_AESIC_CASR_IC(base, value) (CAU_WR_AESIC_CASR(base, CAU_AESIC_CASR_IC(value)))
#define CAU_BWR_AESIC_CASR_IC(base, value) (CAU_WR_AESIC_CASR_IC(base, value))
/*@}*/

/*!
 * @name Register CAU_AESIC_CASR, field DPE[1] (WO)
 *
 * Values:
 * - 0b0 - No error detected
 * - 0b1 - DES key parity error detected
 */
/*@{*/
/*! @brief Set the DPE field to a new value. */
#define CAU_WR_AESIC_CASR_DPE(base, value) (CAU_WR_AESIC_CASR(base, CAU_AESIC_CASR_DPE(value)))
#define CAU_BWR_AESIC_CASR_DPE(base, value) (CAU_WR_AESIC_CASR_DPE(base, value))
/*@}*/

/*!
 * @name Register CAU_AESIC_CASR, field VER[31:28] (WO)
 *
 * Values:
 * - 0b0001 - Initial CAU version
 * - 0b0010 - Second version, added support for SHA-256 algorithm.(This is the
 *     value on this device)
 */
/*@{*/
/*! @brief Set the VER field to a new value. */
#define CAU_WR_AESIC_CASR_VER(base, value) (CAU_WR_AESIC_CASR(base, CAU_AESIC_CASR_VER(value)))
#define CAU_BWR_AESIC_CASR_VER(base, value) (CAU_WR_AESIC_CASR_VER(base, value))
/*@}*/

/*******************************************************************************
 * CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief CAU_AESIC_CAA - Accumulator register - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_AESIC_CAA register
 */
/*@{*/
#define CAU_WR_AESIC_CAA(base, value) (CAU_AESIC_CAA_REG(base) = (value))
/*@}*/

/*******************************************************************************
 * CAU_AESIC_CA - General Purpose Register 0 - AES Inverse Column Operation command
 ******************************************************************************/

/*!
 * @brief CAU_AESIC_CA - General Purpose Register 0 - AES Inverse Column Operation command (WO)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire CAU_AESIC_CA register
 */
/*@{*/
#define CAU_WR_AESIC_CA(base, index, value) (CAU_AESIC_CA_REG(base, index) = (value))
/*@}*/

/*
 * MK64F12 CMP
 *
 * High-Speed Comparator (CMP), Voltage Reference (VREF) Digital-to-Analog Converter (DAC), and Analog Mux (ANMUX)
 *
 * Registers defined in this header file:
 * - CMP_CR0 - CMP Control Register 0
 * - CMP_CR1 - CMP Control Register 1
 * - CMP_FPR - CMP Filter Period Register
 * - CMP_SCR - CMP Status and Control Register
 * - CMP_DACCR - DAC Control Register
 * - CMP_MUXCR - MUX Control Register
 */

#define CMP_INSTANCE_COUNT (3U) /*!< Number of instances of the CMP module. */
#define CMP0_IDX (0U) /*!< Instance number for CMP0. */
#define CMP1_IDX (1U) /*!< Instance number for CMP1. */
#define CMP2_IDX (2U) /*!< Instance number for CMP2. */

/*******************************************************************************
 * CMP_CR0 - CMP Control Register 0
 ******************************************************************************/

/*!
 * @brief CMP_CR0 - CMP Control Register 0 (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_CR0 register
 */
/*@{*/
#define CMP_RD_CR0(base)         (CMP_CR0_REG(base))
#define CMP_WR_CR0(base, value)  (CMP_CR0_REG(base) = (value))
#define CMP_RMW_CR0(base, mask, value) (CMP_WR_CR0(base, (CMP_RD_CR0(base) & ~(mask)) | (value)))
#define CMP_SET_CR0(base, value) (CMP_WR_CR0(base, CMP_RD_CR0(base) |  (value)))
#define CMP_CLR_CR0(base, value) (CMP_WR_CR0(base, CMP_RD_CR0(base) & ~(value)))
#define CMP_TOG_CR0(base, value) (CMP_WR_CR0(base, CMP_RD_CR0(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMP_CR0 bitfields
 */

/*!
 * @name Register CMP_CR0, field HYSTCTR[1:0] (RW)
 *
 * Defines the programmable hysteresis level. The hysteresis values associated
 * with each level are device-specific. See the Data Sheet of the device for the
 * exact values.
 *
 * Values:
 * - 0b00 - Level 0
 * - 0b01 - Level 1
 * - 0b10 - Level 2
 * - 0b11 - Level 3
 */
/*@{*/
/*! @brief Read current value of the CMP_CR0_HYSTCTR field. */
#define CMP_RD_CR0_HYSTCTR(base) ((CMP_CR0_REG(base) & CMP_CR0_HYSTCTR_MASK) >> CMP_CR0_HYSTCTR_SHIFT)
#define CMP_BRD_CR0_HYSTCTR(base) (CMP_RD_CR0_HYSTCTR(base))

/*! @brief Set the HYSTCTR field to a new value. */
#define CMP_WR_CR0_HYSTCTR(base, value) (CMP_RMW_CR0(base, CMP_CR0_HYSTCTR_MASK, CMP_CR0_HYSTCTR(value)))
#define CMP_BWR_CR0_HYSTCTR(base, value) (CMP_WR_CR0_HYSTCTR(base, value))
/*@}*/

/*!
 * @name Register CMP_CR0, field FILTER_CNT[6:4] (RW)
 *
 * Represents the number of consecutive samples that must agree prior to the
 * comparator ouput filter accepting a new output state. For information regarding
 * filter programming and latency, see the Functional descriptionThe CMP module
 * can be used to compare two analog input voltages applied to INP and INM. .
 *
 * Values:
 * - 0b000 - Filter is disabled. If SE = 1, then COUT is a logic 0. This is not
 *     a legal state, and is not recommended. If SE = 0, COUT = COUTA.
 * - 0b001 - One sample must agree. The comparator output is simply sampled.
 * - 0b010 - 2 consecutive samples must agree.
 * - 0b011 - 3 consecutive samples must agree.
 * - 0b100 - 4 consecutive samples must agree.
 * - 0b101 - 5 consecutive samples must agree.
 * - 0b110 - 6 consecutive samples must agree.
 * - 0b111 - 7 consecutive samples must agree.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR0_FILTER_CNT field. */
#define CMP_RD_CR0_FILTER_CNT(base) ((CMP_CR0_REG(base) & CMP_CR0_FILTER_CNT_MASK) >> CMP_CR0_FILTER_CNT_SHIFT)
#define CMP_BRD_CR0_FILTER_CNT(base) (CMP_RD_CR0_FILTER_CNT(base))

/*! @brief Set the FILTER_CNT field to a new value. */
#define CMP_WR_CR0_FILTER_CNT(base, value) (CMP_RMW_CR0(base, CMP_CR0_FILTER_CNT_MASK, CMP_CR0_FILTER_CNT(value)))
#define CMP_BWR_CR0_FILTER_CNT(base, value) (CMP_WR_CR0_FILTER_CNT(base, value))
/*@}*/

/*******************************************************************************
 * CMP_CR1 - CMP Control Register 1
 ******************************************************************************/

/*!
 * @brief CMP_CR1 - CMP Control Register 1 (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_CR1 register
 */
/*@{*/
#define CMP_RD_CR1(base)         (CMP_CR1_REG(base))
#define CMP_WR_CR1(base, value)  (CMP_CR1_REG(base) = (value))
#define CMP_RMW_CR1(base, mask, value) (CMP_WR_CR1(base, (CMP_RD_CR1(base) & ~(mask)) | (value)))
#define CMP_SET_CR1(base, value) (CMP_WR_CR1(base, CMP_RD_CR1(base) |  (value)))
#define CMP_CLR_CR1(base, value) (CMP_WR_CR1(base, CMP_RD_CR1(base) & ~(value)))
#define CMP_TOG_CR1(base, value) (CMP_WR_CR1(base, CMP_RD_CR1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMP_CR1 bitfields
 */

/*!
 * @name Register CMP_CR1, field EN[0] (RW)
 *
 * Enables the Analog Comparator module. When the module is not enabled, it
 * remains in the off state, and consumes no power. When the user selects the same
 * input from analog mux to the positive and negative port, the comparator is
 * disabled automatically.
 *
 * Values:
 * - 0b0 - Analog Comparator is disabled.
 * - 0b1 - Analog Comparator is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_EN field. */
#define CMP_RD_CR1_EN(base)  ((CMP_CR1_REG(base) & CMP_CR1_EN_MASK) >> CMP_CR1_EN_SHIFT)
#define CMP_BRD_CR1_EN(base) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_EN_SHIFT))

/*! @brief Set the EN field to a new value. */
#define CMP_WR_CR1_EN(base, value) (CMP_RMW_CR1(base, CMP_CR1_EN_MASK, CMP_CR1_EN(value)))
#define CMP_BWR_CR1_EN(base, value) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_EN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_CR1, field OPE[1] (RW)
 *
 * Values:
 * - 0b0 - CMPO is not available on the associated CMPO output pin. If the
 *     comparator does not own the pin, this field has no effect.
 * - 0b1 - CMPO is available on the associated CMPO output pin. The comparator
 *     output (CMPO) is driven out on the associated CMPO output pin if the
 *     comparator owns the pin. If the comparator does not own the field, this bit has
 *     no effect.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_OPE field. */
#define CMP_RD_CR1_OPE(base) ((CMP_CR1_REG(base) & CMP_CR1_OPE_MASK) >> CMP_CR1_OPE_SHIFT)
#define CMP_BRD_CR1_OPE(base) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_OPE_SHIFT))

/*! @brief Set the OPE field to a new value. */
#define CMP_WR_CR1_OPE(base, value) (CMP_RMW_CR1(base, CMP_CR1_OPE_MASK, CMP_CR1_OPE(value)))
#define CMP_BWR_CR1_OPE(base, value) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_OPE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_CR1, field COS[2] (RW)
 *
 * Values:
 * - 0b0 - Set the filtered comparator output (CMPO) to equal COUT.
 * - 0b1 - Set the unfiltered comparator output (CMPO) to equal COUTA.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_COS field. */
#define CMP_RD_CR1_COS(base) ((CMP_CR1_REG(base) & CMP_CR1_COS_MASK) >> CMP_CR1_COS_SHIFT)
#define CMP_BRD_CR1_COS(base) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_COS_SHIFT))

/*! @brief Set the COS field to a new value. */
#define CMP_WR_CR1_COS(base, value) (CMP_RMW_CR1(base, CMP_CR1_COS_MASK, CMP_CR1_COS(value)))
#define CMP_BWR_CR1_COS(base, value) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_COS_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_CR1, field INV[3] (RW)
 *
 * Allows selection of the polarity of the analog comparator function. It is
 * also driven to the COUT output, on both the device pin and as SCR[COUT], when
 * OPE=0.
 *
 * Values:
 * - 0b0 - Does not invert the comparator output.
 * - 0b1 - Inverts the comparator output.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_INV field. */
#define CMP_RD_CR1_INV(base) ((CMP_CR1_REG(base) & CMP_CR1_INV_MASK) >> CMP_CR1_INV_SHIFT)
#define CMP_BRD_CR1_INV(base) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_INV_SHIFT))

/*! @brief Set the INV field to a new value. */
#define CMP_WR_CR1_INV(base, value) (CMP_RMW_CR1(base, CMP_CR1_INV_MASK, CMP_CR1_INV(value)))
#define CMP_BWR_CR1_INV(base, value) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_INV_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_CR1, field PMODE[4] (RW)
 *
 * See the electrical specifications table in the device Data Sheet for details.
 *
 * Values:
 * - 0b0 - Low-Speed (LS) Comparison mode selected. In this mode, CMP has slower
 *     output propagation delay and lower current consumption.
 * - 0b1 - High-Speed (HS) Comparison mode selected. In this mode, CMP has
 *     faster output propagation delay and higher current consumption.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_PMODE field. */
#define CMP_RD_CR1_PMODE(base) ((CMP_CR1_REG(base) & CMP_CR1_PMODE_MASK) >> CMP_CR1_PMODE_SHIFT)
#define CMP_BRD_CR1_PMODE(base) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_PMODE_SHIFT))

/*! @brief Set the PMODE field to a new value. */
#define CMP_WR_CR1_PMODE(base, value) (CMP_RMW_CR1(base, CMP_CR1_PMODE_MASK, CMP_CR1_PMODE(value)))
#define CMP_BWR_CR1_PMODE(base, value) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_PMODE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_CR1, field WE[6] (RW)
 *
 * At any given time, either SE or WE can be set. If a write to this register
 * attempts to set both, then SE is set and WE is cleared. However, avoid writing
 * 1s to both field locations because this "11" case is reserved and may change in
 * future implementations.
 *
 * Values:
 * - 0b0 - Windowing mode is not selected.
 * - 0b1 - Windowing mode is selected.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_WE field. */
#define CMP_RD_CR1_WE(base)  ((CMP_CR1_REG(base) & CMP_CR1_WE_MASK) >> CMP_CR1_WE_SHIFT)
#define CMP_BRD_CR1_WE(base) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_WE_SHIFT))

/*! @brief Set the WE field to a new value. */
#define CMP_WR_CR1_WE(base, value) (CMP_RMW_CR1(base, CMP_CR1_WE_MASK, CMP_CR1_WE(value)))
#define CMP_BWR_CR1_WE(base, value) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_WE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_CR1, field SE[7] (RW)
 *
 * At any given time, either SE or WE can be set. If a write to this register
 * attempts to set both, then SE is set and WE is cleared. However, avoid writing
 * 1s to both field locations because this "11" case is reserved and may change in
 * future implementations.
 *
 * Values:
 * - 0b0 - Sampling mode is not selected.
 * - 0b1 - Sampling mode is selected.
 */
/*@{*/
/*! @brief Read current value of the CMP_CR1_SE field. */
#define CMP_RD_CR1_SE(base)  ((CMP_CR1_REG(base) & CMP_CR1_SE_MASK) >> CMP_CR1_SE_SHIFT)
#define CMP_BRD_CR1_SE(base) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_SE_SHIFT))

/*! @brief Set the SE field to a new value. */
#define CMP_WR_CR1_SE(base, value) (CMP_RMW_CR1(base, CMP_CR1_SE_MASK, CMP_CR1_SE(value)))
#define CMP_BWR_CR1_SE(base, value) (BITBAND_ACCESS8(&CMP_CR1_REG(base), CMP_CR1_SE_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * CMP_FPR - CMP Filter Period Register
 ******************************************************************************/

/*!
 * @brief CMP_FPR - CMP Filter Period Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_FPR register
 */
/*@{*/
#define CMP_RD_FPR(base)         (CMP_FPR_REG(base))
#define CMP_WR_FPR(base, value)  (CMP_FPR_REG(base) = (value))
#define CMP_RMW_FPR(base, mask, value) (CMP_WR_FPR(base, (CMP_RD_FPR(base) & ~(mask)) | (value)))
#define CMP_SET_FPR(base, value) (CMP_WR_FPR(base, CMP_RD_FPR(base) |  (value)))
#define CMP_CLR_FPR(base, value) (CMP_WR_FPR(base, CMP_RD_FPR(base) & ~(value)))
#define CMP_TOG_FPR(base, value) (CMP_WR_FPR(base, CMP_RD_FPR(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMP_SCR - CMP Status and Control Register
 ******************************************************************************/

/*!
 * @brief CMP_SCR - CMP Status and Control Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_SCR register
 */
/*@{*/
#define CMP_RD_SCR(base)         (CMP_SCR_REG(base))
#define CMP_WR_SCR(base, value)  (CMP_SCR_REG(base) = (value))
#define CMP_RMW_SCR(base, mask, value) (CMP_WR_SCR(base, (CMP_RD_SCR(base) & ~(mask)) | (value)))
#define CMP_SET_SCR(base, value) (CMP_WR_SCR(base, CMP_RD_SCR(base) |  (value)))
#define CMP_CLR_SCR(base, value) (CMP_WR_SCR(base, CMP_RD_SCR(base) & ~(value)))
#define CMP_TOG_SCR(base, value) (CMP_WR_SCR(base, CMP_RD_SCR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMP_SCR bitfields
 */

/*!
 * @name Register CMP_SCR, field COUT[0] (RO)
 *
 * Returns the current value of the Analog Comparator output, when read. The
 * field is reset to 0 and will read as CR1[INV] when the Analog Comparator module
 * is disabled, that is, when CR1[EN] = 0. Writes to this field are ignored.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_COUT field. */
#define CMP_RD_SCR_COUT(base) ((CMP_SCR_REG(base) & CMP_SCR_COUT_MASK) >> CMP_SCR_COUT_SHIFT)
#define CMP_BRD_SCR_COUT(base) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_COUT_SHIFT))
/*@}*/

/*!
 * @name Register CMP_SCR, field CFF[1] (W1C)
 *
 * Detects a falling-edge on COUT, when set, during normal operation. CFF is
 * cleared by writing 1 to it. During Stop modes, CFF is level sensitive is edge
 * sensitive .
 *
 * Values:
 * - 0b0 - Falling-edge on COUT has not been detected.
 * - 0b1 - Falling-edge on COUT has occurred.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_CFF field. */
#define CMP_RD_SCR_CFF(base) ((CMP_SCR_REG(base) & CMP_SCR_CFF_MASK) >> CMP_SCR_CFF_SHIFT)
#define CMP_BRD_SCR_CFF(base) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_CFF_SHIFT))

/*! @brief Set the CFF field to a new value. */
#define CMP_WR_SCR_CFF(base, value) (CMP_RMW_SCR(base, (CMP_SCR_CFF_MASK | CMP_SCR_CFR_MASK), CMP_SCR_CFF(value)))
#define CMP_BWR_SCR_CFF(base, value) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_CFF_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_SCR, field CFR[2] (W1C)
 *
 * Detects a rising-edge on COUT, when set, during normal operation. CFR is
 * cleared by writing 1 to it. During Stop modes, CFR is level sensitive is edge
 * sensitive .
 *
 * Values:
 * - 0b0 - Rising-edge on COUT has not been detected.
 * - 0b1 - Rising-edge on COUT has occurred.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_CFR field. */
#define CMP_RD_SCR_CFR(base) ((CMP_SCR_REG(base) & CMP_SCR_CFR_MASK) >> CMP_SCR_CFR_SHIFT)
#define CMP_BRD_SCR_CFR(base) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_CFR_SHIFT))

/*! @brief Set the CFR field to a new value. */
#define CMP_WR_SCR_CFR(base, value) (CMP_RMW_SCR(base, (CMP_SCR_CFR_MASK | CMP_SCR_CFF_MASK), CMP_SCR_CFR(value)))
#define CMP_BWR_SCR_CFR(base, value) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_CFR_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_SCR, field IEF[3] (RW)
 *
 * Enables the CFF interrupt from the CMP. When this field is set, an interrupt
 * will be asserted when CFF is set.
 *
 * Values:
 * - 0b0 - Interrupt is disabled.
 * - 0b1 - Interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_IEF field. */
#define CMP_RD_SCR_IEF(base) ((CMP_SCR_REG(base) & CMP_SCR_IEF_MASK) >> CMP_SCR_IEF_SHIFT)
#define CMP_BRD_SCR_IEF(base) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_IEF_SHIFT))

/*! @brief Set the IEF field to a new value. */
#define CMP_WR_SCR_IEF(base, value) (CMP_RMW_SCR(base, (CMP_SCR_IEF_MASK | CMP_SCR_CFF_MASK | CMP_SCR_CFR_MASK), CMP_SCR_IEF(value)))
#define CMP_BWR_SCR_IEF(base, value) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_IEF_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_SCR, field IER[4] (RW)
 *
 * Enables the CFR interrupt from the CMP. When this field is set, an interrupt
 * will be asserted when CFR is set.
 *
 * Values:
 * - 0b0 - Interrupt is disabled.
 * - 0b1 - Interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_IER field. */
#define CMP_RD_SCR_IER(base) ((CMP_SCR_REG(base) & CMP_SCR_IER_MASK) >> CMP_SCR_IER_SHIFT)
#define CMP_BRD_SCR_IER(base) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_IER_SHIFT))

/*! @brief Set the IER field to a new value. */
#define CMP_WR_SCR_IER(base, value) (CMP_RMW_SCR(base, (CMP_SCR_IER_MASK | CMP_SCR_CFF_MASK | CMP_SCR_CFR_MASK), CMP_SCR_IER(value)))
#define CMP_BWR_SCR_IER(base, value) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_IER_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_SCR, field DMAEN[6] (RW)
 *
 * Enables the DMA transfer triggered from the CMP module. When this field is
 * set, a DMA request is asserted when CFR or CFF is set.
 *
 * Values:
 * - 0b0 - DMA is disabled.
 * - 0b1 - DMA is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_SCR_DMAEN field. */
#define CMP_RD_SCR_DMAEN(base) ((CMP_SCR_REG(base) & CMP_SCR_DMAEN_MASK) >> CMP_SCR_DMAEN_SHIFT)
#define CMP_BRD_SCR_DMAEN(base) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_DMAEN_SHIFT))

/*! @brief Set the DMAEN field to a new value. */
#define CMP_WR_SCR_DMAEN(base, value) (CMP_RMW_SCR(base, (CMP_SCR_DMAEN_MASK | CMP_SCR_CFF_MASK | CMP_SCR_CFR_MASK), CMP_SCR_DMAEN(value)))
#define CMP_BWR_SCR_DMAEN(base, value) (BITBAND_ACCESS8(&CMP_SCR_REG(base), CMP_SCR_DMAEN_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * CMP_DACCR - DAC Control Register
 ******************************************************************************/

/*!
 * @brief CMP_DACCR - DAC Control Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_DACCR register
 */
/*@{*/
#define CMP_RD_DACCR(base)       (CMP_DACCR_REG(base))
#define CMP_WR_DACCR(base, value) (CMP_DACCR_REG(base) = (value))
#define CMP_RMW_DACCR(base, mask, value) (CMP_WR_DACCR(base, (CMP_RD_DACCR(base) & ~(mask)) | (value)))
#define CMP_SET_DACCR(base, value) (CMP_WR_DACCR(base, CMP_RD_DACCR(base) |  (value)))
#define CMP_CLR_DACCR(base, value) (CMP_WR_DACCR(base, CMP_RD_DACCR(base) & ~(value)))
#define CMP_TOG_DACCR(base, value) (CMP_WR_DACCR(base, CMP_RD_DACCR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMP_DACCR bitfields
 */

/*!
 * @name Register CMP_DACCR, field VOSEL[5:0] (RW)
 *
 * Selects an output voltage from one of 64 distinct levels. DACO = (V in /64) *
 * (VOSEL[5:0] + 1) , so the DACO range is from V in /64 to V in .
 */
/*@{*/
/*! @brief Read current value of the CMP_DACCR_VOSEL field. */
#define CMP_RD_DACCR_VOSEL(base) ((CMP_DACCR_REG(base) & CMP_DACCR_VOSEL_MASK) >> CMP_DACCR_VOSEL_SHIFT)
#define CMP_BRD_DACCR_VOSEL(base) (CMP_RD_DACCR_VOSEL(base))

/*! @brief Set the VOSEL field to a new value. */
#define CMP_WR_DACCR_VOSEL(base, value) (CMP_RMW_DACCR(base, CMP_DACCR_VOSEL_MASK, CMP_DACCR_VOSEL(value)))
#define CMP_BWR_DACCR_VOSEL(base, value) (CMP_WR_DACCR_VOSEL(base, value))
/*@}*/

/*!
 * @name Register CMP_DACCR, field VRSEL[6] (RW)
 *
 * Values:
 * - 0b0 - V is selected as resistor ladder network supply reference V. in1 in
 * - 0b1 - V is selected as resistor ladder network supply reference V. in2 in
 */
/*@{*/
/*! @brief Read current value of the CMP_DACCR_VRSEL field. */
#define CMP_RD_DACCR_VRSEL(base) ((CMP_DACCR_REG(base) & CMP_DACCR_VRSEL_MASK) >> CMP_DACCR_VRSEL_SHIFT)
#define CMP_BRD_DACCR_VRSEL(base) (BITBAND_ACCESS8(&CMP_DACCR_REG(base), CMP_DACCR_VRSEL_SHIFT))

/*! @brief Set the VRSEL field to a new value. */
#define CMP_WR_DACCR_VRSEL(base, value) (CMP_RMW_DACCR(base, CMP_DACCR_VRSEL_MASK, CMP_DACCR_VRSEL(value)))
#define CMP_BWR_DACCR_VRSEL(base, value) (BITBAND_ACCESS8(&CMP_DACCR_REG(base), CMP_DACCR_VRSEL_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMP_DACCR, field DACEN[7] (RW)
 *
 * Enables the DAC. When the DAC is disabled, it is powered down to conserve
 * power.
 *
 * Values:
 * - 0b0 - DAC is disabled.
 * - 0b1 - DAC is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_DACCR_DACEN field. */
#define CMP_RD_DACCR_DACEN(base) ((CMP_DACCR_REG(base) & CMP_DACCR_DACEN_MASK) >> CMP_DACCR_DACEN_SHIFT)
#define CMP_BRD_DACCR_DACEN(base) (BITBAND_ACCESS8(&CMP_DACCR_REG(base), CMP_DACCR_DACEN_SHIFT))

/*! @brief Set the DACEN field to a new value. */
#define CMP_WR_DACCR_DACEN(base, value) (CMP_RMW_DACCR(base, CMP_DACCR_DACEN_MASK, CMP_DACCR_DACEN(value)))
#define CMP_BWR_DACCR_DACEN(base, value) (BITBAND_ACCESS8(&CMP_DACCR_REG(base), CMP_DACCR_DACEN_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * CMP_MUXCR - MUX Control Register
 ******************************************************************************/

/*!
 * @brief CMP_MUXCR - MUX Control Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CMP_MUXCR register
 */
/*@{*/
#define CMP_RD_MUXCR(base)       (CMP_MUXCR_REG(base))
#define CMP_WR_MUXCR(base, value) (CMP_MUXCR_REG(base) = (value))
#define CMP_RMW_MUXCR(base, mask, value) (CMP_WR_MUXCR(base, (CMP_RD_MUXCR(base) & ~(mask)) | (value)))
#define CMP_SET_MUXCR(base, value) (CMP_WR_MUXCR(base, CMP_RD_MUXCR(base) |  (value)))
#define CMP_CLR_MUXCR(base, value) (CMP_WR_MUXCR(base, CMP_RD_MUXCR(base) & ~(value)))
#define CMP_TOG_MUXCR(base, value) (CMP_WR_MUXCR(base, CMP_RD_MUXCR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMP_MUXCR bitfields
 */

/*!
 * @name Register CMP_MUXCR, field MSEL[2:0] (RW)
 *
 * Determines which input is selected for the minus input of the comparator. For
 * INx inputs, see CMP, DAC, and ANMUX block diagrams. When an inappropriate
 * operation selects the same input for both muxes, the comparator automatically
 * shuts down to prevent itself from becoming a noise generator.
 *
 * Values:
 * - 0b000 - IN0
 * - 0b001 - IN1
 * - 0b010 - IN2
 * - 0b011 - IN3
 * - 0b100 - IN4
 * - 0b101 - IN5
 * - 0b110 - IN6
 * - 0b111 - IN7
 */
/*@{*/
/*! @brief Read current value of the CMP_MUXCR_MSEL field. */
#define CMP_RD_MUXCR_MSEL(base) ((CMP_MUXCR_REG(base) & CMP_MUXCR_MSEL_MASK) >> CMP_MUXCR_MSEL_SHIFT)
#define CMP_BRD_MUXCR_MSEL(base) (CMP_RD_MUXCR_MSEL(base))

/*! @brief Set the MSEL field to a new value. */
#define CMP_WR_MUXCR_MSEL(base, value) (CMP_RMW_MUXCR(base, CMP_MUXCR_MSEL_MASK, CMP_MUXCR_MSEL(value)))
#define CMP_BWR_MUXCR_MSEL(base, value) (CMP_WR_MUXCR_MSEL(base, value))
/*@}*/

/*!
 * @name Register CMP_MUXCR, field PSEL[5:3] (RW)
 *
 * Determines which input is selected for the plus input of the comparator. For
 * INx inputs, see CMP, DAC, and ANMUX block diagrams. When an inappropriate
 * operation selects the same input for both muxes, the comparator automatically
 * shuts down to prevent itself from becoming a noise generator.
 *
 * Values:
 * - 0b000 - IN0
 * - 0b001 - IN1
 * - 0b010 - IN2
 * - 0b011 - IN3
 * - 0b100 - IN4
 * - 0b101 - IN5
 * - 0b110 - IN6
 * - 0b111 - IN7
 */
/*@{*/
/*! @brief Read current value of the CMP_MUXCR_PSEL field. */
#define CMP_RD_MUXCR_PSEL(base) ((CMP_MUXCR_REG(base) & CMP_MUXCR_PSEL_MASK) >> CMP_MUXCR_PSEL_SHIFT)
#define CMP_BRD_MUXCR_PSEL(base) (CMP_RD_MUXCR_PSEL(base))

/*! @brief Set the PSEL field to a new value. */
#define CMP_WR_MUXCR_PSEL(base, value) (CMP_RMW_MUXCR(base, CMP_MUXCR_PSEL_MASK, CMP_MUXCR_PSEL(value)))
#define CMP_BWR_MUXCR_PSEL(base, value) (CMP_WR_MUXCR_PSEL(base, value))
/*@}*/

/*!
 * @name Register CMP_MUXCR, field PSTM[7] (RW)
 *
 * This bit is used to enable to MUX pass through mode. Pass through mode is
 * always available but for some devices this feature must be always disabled due to
 * the lack of package pins.
 *
 * Values:
 * - 0b0 - Pass Through Mode is disabled.
 * - 0b1 - Pass Through Mode is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMP_MUXCR_PSTM field. */
#define CMP_RD_MUXCR_PSTM(base) ((CMP_MUXCR_REG(base) & CMP_MUXCR_PSTM_MASK) >> CMP_MUXCR_PSTM_SHIFT)
#define CMP_BRD_MUXCR_PSTM(base) (BITBAND_ACCESS8(&CMP_MUXCR_REG(base), CMP_MUXCR_PSTM_SHIFT))

/*! @brief Set the PSTM field to a new value. */
#define CMP_WR_MUXCR_PSTM(base, value) (CMP_RMW_MUXCR(base, CMP_MUXCR_PSTM_MASK, CMP_MUXCR_PSTM(value)))
#define CMP_BWR_MUXCR_PSTM(base, value) (BITBAND_ACCESS8(&CMP_MUXCR_REG(base), CMP_MUXCR_PSTM_SHIFT) = (value))
/*@}*/

/*
 * MK64F12 CMT
 *
 * Carrier Modulator Transmitter
 *
 * Registers defined in this header file:
 * - CMT_CGH1 - CMT Carrier Generator High Data Register 1
 * - CMT_CGL1 - CMT Carrier Generator Low Data Register 1
 * - CMT_CGH2 - CMT Carrier Generator High Data Register 2
 * - CMT_CGL2 - CMT Carrier Generator Low Data Register 2
 * - CMT_OC - CMT Output Control Register
 * - CMT_MSC - CMT Modulator Status and Control Register
 * - CMT_CMD1 - CMT Modulator Data Register Mark High
 * - CMT_CMD2 - CMT Modulator Data Register Mark Low
 * - CMT_CMD3 - CMT Modulator Data Register Space High
 * - CMT_CMD4 - CMT Modulator Data Register Space Low
 * - CMT_PPS - CMT Primary Prescaler Register
 * - CMT_DMA - CMT Direct Memory Access Register
 */

#define CMT_INSTANCE_COUNT (1U) /*!< Number of instances of the CMT module. */
#define CMT_IDX (0U) /*!< Instance number for CMT. */

/*******************************************************************************
 * CMT_CGH1 - CMT Carrier Generator High Data Register 1
 ******************************************************************************/

/*!
 * @brief CMT_CGH1 - CMT Carrier Generator High Data Register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * This data register contains the primary high value for generating the carrier
 * output.
 */
/*!
 * @name Constants and macros for entire CMT_CGH1 register
 */
/*@{*/
#define CMT_RD_CGH1(base)        (CMT_CGH1_REG(base))
#define CMT_WR_CGH1(base, value) (CMT_CGH1_REG(base) = (value))
#define CMT_RMW_CGH1(base, mask, value) (CMT_WR_CGH1(base, (CMT_RD_CGH1(base) & ~(mask)) | (value)))
#define CMT_SET_CGH1(base, value) (CMT_WR_CGH1(base, CMT_RD_CGH1(base) |  (value)))
#define CMT_CLR_CGH1(base, value) (CMT_WR_CGH1(base, CMT_RD_CGH1(base) & ~(value)))
#define CMT_TOG_CGH1(base, value) (CMT_WR_CGH1(base, CMT_RD_CGH1(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMT_CGL1 - CMT Carrier Generator Low Data Register 1
 ******************************************************************************/

/*!
 * @brief CMT_CGL1 - CMT Carrier Generator Low Data Register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * This data register contains the primary low value for generating the carrier
 * output.
 */
/*!
 * @name Constants and macros for entire CMT_CGL1 register
 */
/*@{*/
#define CMT_RD_CGL1(base)        (CMT_CGL1_REG(base))
#define CMT_WR_CGL1(base, value) (CMT_CGL1_REG(base) = (value))
#define CMT_RMW_CGL1(base, mask, value) (CMT_WR_CGL1(base, (CMT_RD_CGL1(base) & ~(mask)) | (value)))
#define CMT_SET_CGL1(base, value) (CMT_WR_CGL1(base, CMT_RD_CGL1(base) |  (value)))
#define CMT_CLR_CGL1(base, value) (CMT_WR_CGL1(base, CMT_RD_CGL1(base) & ~(value)))
#define CMT_TOG_CGL1(base, value) (CMT_WR_CGL1(base, CMT_RD_CGL1(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMT_CGH2 - CMT Carrier Generator High Data Register 2
 ******************************************************************************/

/*!
 * @brief CMT_CGH2 - CMT Carrier Generator High Data Register 2 (RW)
 *
 * Reset value: 0x00U
 *
 * This data register contains the secondary high value for generating the
 * carrier output.
 */
/*!
 * @name Constants and macros for entire CMT_CGH2 register
 */
/*@{*/
#define CMT_RD_CGH2(base)        (CMT_CGH2_REG(base))
#define CMT_WR_CGH2(base, value) (CMT_CGH2_REG(base) = (value))
#define CMT_RMW_CGH2(base, mask, value) (CMT_WR_CGH2(base, (CMT_RD_CGH2(base) & ~(mask)) | (value)))
#define CMT_SET_CGH2(base, value) (CMT_WR_CGH2(base, CMT_RD_CGH2(base) |  (value)))
#define CMT_CLR_CGH2(base, value) (CMT_WR_CGH2(base, CMT_RD_CGH2(base) & ~(value)))
#define CMT_TOG_CGH2(base, value) (CMT_WR_CGH2(base, CMT_RD_CGH2(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMT_CGL2 - CMT Carrier Generator Low Data Register 2
 ******************************************************************************/

/*!
 * @brief CMT_CGL2 - CMT Carrier Generator Low Data Register 2 (RW)
 *
 * Reset value: 0x00U
 *
 * This data register contains the secondary low value for generating the
 * carrier output.
 */
/*!
 * @name Constants and macros for entire CMT_CGL2 register
 */
/*@{*/
#define CMT_RD_CGL2(base)        (CMT_CGL2_REG(base))
#define CMT_WR_CGL2(base, value) (CMT_CGL2_REG(base) = (value))
#define CMT_RMW_CGL2(base, mask, value) (CMT_WR_CGL2(base, (CMT_RD_CGL2(base) & ~(mask)) | (value)))
#define CMT_SET_CGL2(base, value) (CMT_WR_CGL2(base, CMT_RD_CGL2(base) |  (value)))
#define CMT_CLR_CGL2(base, value) (CMT_WR_CGL2(base, CMT_RD_CGL2(base) & ~(value)))
#define CMT_TOG_CGL2(base, value) (CMT_WR_CGL2(base, CMT_RD_CGL2(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMT_OC - CMT Output Control Register
 ******************************************************************************/

/*!
 * @brief CMT_OC - CMT Output Control Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register is used to control the IRO signal of the CMT module.
 */
/*!
 * @name Constants and macros for entire CMT_OC register
 */
/*@{*/
#define CMT_RD_OC(base)          (CMT_OC_REG(base))
#define CMT_WR_OC(base, value)   (CMT_OC_REG(base) = (value))
#define CMT_RMW_OC(base, mask, value) (CMT_WR_OC(base, (CMT_RD_OC(base) & ~(mask)) | (value)))
#define CMT_SET_OC(base, value)  (CMT_WR_OC(base, CMT_RD_OC(base) |  (value)))
#define CMT_CLR_OC(base, value)  (CMT_WR_OC(base, CMT_RD_OC(base) & ~(value)))
#define CMT_TOG_OC(base, value)  (CMT_WR_OC(base, CMT_RD_OC(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMT_OC bitfields
 */

/*!
 * @name Register CMT_OC, field IROPEN[5] (RW)
 *
 * Enables and disables the IRO signal. When the IRO signal is enabled, it is an
 * output that drives out either the CMT transmitter output or the state of IROL
 * depending on whether MSC[MCGEN] is set or not. Also, the state of output is
 * either inverted or non-inverted, depending on the state of CMTPOL. When the IRO
 * signal is disabled, it is in a high-impedance state and is unable to draw any
 * current. This signal is disabled during reset.
 *
 * Values:
 * - 0b0 - The IRO signal is disabled.
 * - 0b1 - The IRO signal is enabled as output.
 */
/*@{*/
/*! @brief Read current value of the CMT_OC_IROPEN field. */
#define CMT_RD_OC_IROPEN(base) ((CMT_OC_REG(base) & CMT_OC_IROPEN_MASK) >> CMT_OC_IROPEN_SHIFT)
#define CMT_BRD_OC_IROPEN(base) (BITBAND_ACCESS8(&CMT_OC_REG(base), CMT_OC_IROPEN_SHIFT))

/*! @brief Set the IROPEN field to a new value. */
#define CMT_WR_OC_IROPEN(base, value) (CMT_RMW_OC(base, CMT_OC_IROPEN_MASK, CMT_OC_IROPEN(value)))
#define CMT_BWR_OC_IROPEN(base, value) (BITBAND_ACCESS8(&CMT_OC_REG(base), CMT_OC_IROPEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMT_OC, field CMTPOL[6] (RW)
 *
 * Controls the polarity of the IRO signal.
 *
 * Values:
 * - 0b0 - The IRO signal is active-low.
 * - 0b1 - The IRO signal is active-high.
 */
/*@{*/
/*! @brief Read current value of the CMT_OC_CMTPOL field. */
#define CMT_RD_OC_CMTPOL(base) ((CMT_OC_REG(base) & CMT_OC_CMTPOL_MASK) >> CMT_OC_CMTPOL_SHIFT)
#define CMT_BRD_OC_CMTPOL(base) (BITBAND_ACCESS8(&CMT_OC_REG(base), CMT_OC_CMTPOL_SHIFT))

/*! @brief Set the CMTPOL field to a new value. */
#define CMT_WR_OC_CMTPOL(base, value) (CMT_RMW_OC(base, CMT_OC_CMTPOL_MASK, CMT_OC_CMTPOL(value)))
#define CMT_BWR_OC_CMTPOL(base, value) (BITBAND_ACCESS8(&CMT_OC_REG(base), CMT_OC_CMTPOL_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMT_OC, field IROL[7] (RW)
 *
 * Reads the state of the IRO latch. Writing to IROL changes the state of the
 * IRO signal when MSC[MCGEN] is cleared and IROPEN is set.
 */
/*@{*/
/*! @brief Read current value of the CMT_OC_IROL field. */
#define CMT_RD_OC_IROL(base) ((CMT_OC_REG(base) & CMT_OC_IROL_MASK) >> CMT_OC_IROL_SHIFT)
#define CMT_BRD_OC_IROL(base) (BITBAND_ACCESS8(&CMT_OC_REG(base), CMT_OC_IROL_SHIFT))

/*! @brief Set the IROL field to a new value. */
#define CMT_WR_OC_IROL(base, value) (CMT_RMW_OC(base, CMT_OC_IROL_MASK, CMT_OC_IROL(value)))
#define CMT_BWR_OC_IROL(base, value) (BITBAND_ACCESS8(&CMT_OC_REG(base), CMT_OC_IROL_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * CMT_MSC - CMT Modulator Status and Control Register
 ******************************************************************************/

/*!
 * @brief CMT_MSC - CMT Modulator Status and Control Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register contains the modulator and carrier generator enable (MCGEN),
 * end of cycle interrupt enable (EOCIE), FSK mode select (FSK), baseband enable
 * (BASE), extended space (EXSPC), prescaler (CMTDIV) bits, and the end of cycle
 * (EOCF) status bit.
 */
/*!
 * @name Constants and macros for entire CMT_MSC register
 */
/*@{*/
#define CMT_RD_MSC(base)         (CMT_MSC_REG(base))
#define CMT_WR_MSC(base, value)  (CMT_MSC_REG(base) = (value))
#define CMT_RMW_MSC(base, mask, value) (CMT_WR_MSC(base, (CMT_RD_MSC(base) & ~(mask)) | (value)))
#define CMT_SET_MSC(base, value) (CMT_WR_MSC(base, CMT_RD_MSC(base) |  (value)))
#define CMT_CLR_MSC(base, value) (CMT_WR_MSC(base, CMT_RD_MSC(base) & ~(value)))
#define CMT_TOG_MSC(base, value) (CMT_WR_MSC(base, CMT_RD_MSC(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMT_MSC bitfields
 */

/*!
 * @name Register CMT_MSC, field MCGEN[0] (RW)
 *
 * Setting MCGEN will initialize the carrier generator and modulator and will
 * enable all clocks. When enabled, the carrier generator and modulator will
 * function continuously. When MCGEN is cleared, the current modulator cycle will be
 * allowed to expire before all carrier and modulator clocks are disabled to save
 * power and the modulator output is forced low. To prevent spurious operation,
 * the user should initialize all data and control registers before enabling the
 * system.
 *
 * Values:
 * - 0b0 - Modulator and carrier generator disabled
 * - 0b1 - Modulator and carrier generator enabled
 */
/*@{*/
/*! @brief Read current value of the CMT_MSC_MCGEN field. */
#define CMT_RD_MSC_MCGEN(base) ((CMT_MSC_REG(base) & CMT_MSC_MCGEN_MASK) >> CMT_MSC_MCGEN_SHIFT)
#define CMT_BRD_MSC_MCGEN(base) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_MCGEN_SHIFT))

/*! @brief Set the MCGEN field to a new value. */
#define CMT_WR_MSC_MCGEN(base, value) (CMT_RMW_MSC(base, CMT_MSC_MCGEN_MASK, CMT_MSC_MCGEN(value)))
#define CMT_BWR_MSC_MCGEN(base, value) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_MCGEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMT_MSC, field EOCIE[1] (RW)
 *
 * Requests to enable a CPU interrupt when EOCF is set if EOCIE is high.
 *
 * Values:
 * - 0b0 - CPU interrupt is disabled.
 * - 0b1 - CPU interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMT_MSC_EOCIE field. */
#define CMT_RD_MSC_EOCIE(base) ((CMT_MSC_REG(base) & CMT_MSC_EOCIE_MASK) >> CMT_MSC_EOCIE_SHIFT)
#define CMT_BRD_MSC_EOCIE(base) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_EOCIE_SHIFT))

/*! @brief Set the EOCIE field to a new value. */
#define CMT_WR_MSC_EOCIE(base, value) (CMT_RMW_MSC(base, CMT_MSC_EOCIE_MASK, CMT_MSC_EOCIE(value)))
#define CMT_BWR_MSC_EOCIE(base, value) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_EOCIE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMT_MSC, field FSK[2] (RW)
 *
 * Enables FSK operation.
 *
 * Values:
 * - 0b0 - The CMT operates in Time or Baseband mode.
 * - 0b1 - The CMT operates in FSK mode.
 */
/*@{*/
/*! @brief Read current value of the CMT_MSC_FSK field. */
#define CMT_RD_MSC_FSK(base) ((CMT_MSC_REG(base) & CMT_MSC_FSK_MASK) >> CMT_MSC_FSK_SHIFT)
#define CMT_BRD_MSC_FSK(base) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_FSK_SHIFT))

/*! @brief Set the FSK field to a new value. */
#define CMT_WR_MSC_FSK(base, value) (CMT_RMW_MSC(base, CMT_MSC_FSK_MASK, CMT_MSC_FSK(value)))
#define CMT_BWR_MSC_FSK(base, value) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_FSK_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMT_MSC, field BASE[3] (RW)
 *
 * When set, BASE disables the carrier generator and forces the carrier output
 * high for generation of baseband protocols. When BASE is cleared, the carrier
 * generator is enabled and the carrier output toggles at the frequency determined
 * by values stored in the carrier data registers. This field is cleared by
 * reset. This field is not double-buffered and must not be written to during a
 * transmission.
 *
 * Values:
 * - 0b0 - Baseband mode is disabled.
 * - 0b1 - Baseband mode is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMT_MSC_BASE field. */
#define CMT_RD_MSC_BASE(base) ((CMT_MSC_REG(base) & CMT_MSC_BASE_MASK) >> CMT_MSC_BASE_SHIFT)
#define CMT_BRD_MSC_BASE(base) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_BASE_SHIFT))

/*! @brief Set the BASE field to a new value. */
#define CMT_WR_MSC_BASE(base, value) (CMT_RMW_MSC(base, CMT_MSC_BASE_MASK, CMT_MSC_BASE(value)))
#define CMT_BWR_MSC_BASE(base, value) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_BASE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMT_MSC, field EXSPC[4] (RW)
 *
 * Enables the extended space operation.
 *
 * Values:
 * - 0b0 - Extended space is disabled.
 * - 0b1 - Extended space is enabled.
 */
/*@{*/
/*! @brief Read current value of the CMT_MSC_EXSPC field. */
#define CMT_RD_MSC_EXSPC(base) ((CMT_MSC_REG(base) & CMT_MSC_EXSPC_MASK) >> CMT_MSC_EXSPC_SHIFT)
#define CMT_BRD_MSC_EXSPC(base) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_EXSPC_SHIFT))

/*! @brief Set the EXSPC field to a new value. */
#define CMT_WR_MSC_EXSPC(base, value) (CMT_RMW_MSC(base, CMT_MSC_EXSPC_MASK, CMT_MSC_EXSPC(value)))
#define CMT_BWR_MSC_EXSPC(base, value) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_EXSPC_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CMT_MSC, field CMTDIV[6:5] (RW)
 *
 * Causes the CMT to be clocked at the IF signal frequency, or the IF frequency
 * divided by 2 ,4, or 8 . This field must not be changed during a transmission
 * because it is not double-buffered.
 *
 * Values:
 * - 0b00 - IF * 1
 * - 0b01 - IF * 2
 * - 0b10 - IF * 4
 * - 0b11 - IF * 8
 */
/*@{*/
/*! @brief Read current value of the CMT_MSC_CMTDIV field. */
#define CMT_RD_MSC_CMTDIV(base) ((CMT_MSC_REG(base) & CMT_MSC_CMTDIV_MASK) >> CMT_MSC_CMTDIV_SHIFT)
#define CMT_BRD_MSC_CMTDIV(base) (CMT_RD_MSC_CMTDIV(base))

/*! @brief Set the CMTDIV field to a new value. */
#define CMT_WR_MSC_CMTDIV(base, value) (CMT_RMW_MSC(base, CMT_MSC_CMTDIV_MASK, CMT_MSC_CMTDIV(value)))
#define CMT_BWR_MSC_CMTDIV(base, value) (CMT_WR_MSC_CMTDIV(base, value))
/*@}*/

/*!
 * @name Register CMT_MSC, field EOCF[7] (RO)
 *
 * Sets when: The modulator is not currently active and MCGEN is set to begin
 * the initial CMT transmission. At the end of each modulation cycle while MCGEN is
 * set. This is recognized when a match occurs between the contents of the space
 * period register and the down counter. At this time, the counter is
 * initialized with, possibly new contents of the mark period buffer, CMD1 and CMD2, and
 * the space period register is loaded with, possibly new contents of the space
 * period buffer, CMD3 and CMD4. This flag is cleared by reading MSC followed by an
 * access of CMD2 or CMD4, or by the DMA transfer.
 *
 * Values:
 * - 0b0 - End of modulation cycle has not occured since the flag last cleared.
 * - 0b1 - End of modulator cycle has occurred.
 */
/*@{*/
/*! @brief Read current value of the CMT_MSC_EOCF field. */
#define CMT_RD_MSC_EOCF(base) ((CMT_MSC_REG(base) & CMT_MSC_EOCF_MASK) >> CMT_MSC_EOCF_SHIFT)
#define CMT_BRD_MSC_EOCF(base) (BITBAND_ACCESS8(&CMT_MSC_REG(base), CMT_MSC_EOCF_SHIFT))
/*@}*/

/*******************************************************************************
 * CMT_CMD1 - CMT Modulator Data Register Mark High
 ******************************************************************************/

/*!
 * @brief CMT_CMD1 - CMT Modulator Data Register Mark High (RW)
 *
 * Reset value: 0x00U
 *
 * The contents of this register are transferred to the modulator down counter
 * upon the completion of a modulation period.
 */
/*!
 * @name Constants and macros for entire CMT_CMD1 register
 */
/*@{*/
#define CMT_RD_CMD1(base)        (CMT_CMD1_REG(base))
#define CMT_WR_CMD1(base, value) (CMT_CMD1_REG(base) = (value))
#define CMT_RMW_CMD1(base, mask, value) (CMT_WR_CMD1(base, (CMT_RD_CMD1(base) & ~(mask)) | (value)))
#define CMT_SET_CMD1(base, value) (CMT_WR_CMD1(base, CMT_RD_CMD1(base) |  (value)))
#define CMT_CLR_CMD1(base, value) (CMT_WR_CMD1(base, CMT_RD_CMD1(base) & ~(value)))
#define CMT_TOG_CMD1(base, value) (CMT_WR_CMD1(base, CMT_RD_CMD1(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMT_CMD2 - CMT Modulator Data Register Mark Low
 ******************************************************************************/

/*!
 * @brief CMT_CMD2 - CMT Modulator Data Register Mark Low (RW)
 *
 * Reset value: 0x00U
 *
 * The contents of this register are transferred to the modulator down counter
 * upon the completion of a modulation period.
 */
/*!
 * @name Constants and macros for entire CMT_CMD2 register
 */
/*@{*/
#define CMT_RD_CMD2(base)        (CMT_CMD2_REG(base))
#define CMT_WR_CMD2(base, value) (CMT_CMD2_REG(base) = (value))
#define CMT_RMW_CMD2(base, mask, value) (CMT_WR_CMD2(base, (CMT_RD_CMD2(base) & ~(mask)) | (value)))
#define CMT_SET_CMD2(base, value) (CMT_WR_CMD2(base, CMT_RD_CMD2(base) |  (value)))
#define CMT_CLR_CMD2(base, value) (CMT_WR_CMD2(base, CMT_RD_CMD2(base) & ~(value)))
#define CMT_TOG_CMD2(base, value) (CMT_WR_CMD2(base, CMT_RD_CMD2(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMT_CMD3 - CMT Modulator Data Register Space High
 ******************************************************************************/

/*!
 * @brief CMT_CMD3 - CMT Modulator Data Register Space High (RW)
 *
 * Reset value: 0x00U
 *
 * The contents of this register are transferred to the space period register
 * upon the completion of a modulation period.
 */
/*!
 * @name Constants and macros for entire CMT_CMD3 register
 */
/*@{*/
#define CMT_RD_CMD3(base)        (CMT_CMD3_REG(base))
#define CMT_WR_CMD3(base, value) (CMT_CMD3_REG(base) = (value))
#define CMT_RMW_CMD3(base, mask, value) (CMT_WR_CMD3(base, (CMT_RD_CMD3(base) & ~(mask)) | (value)))
#define CMT_SET_CMD3(base, value) (CMT_WR_CMD3(base, CMT_RD_CMD3(base) |  (value)))
#define CMT_CLR_CMD3(base, value) (CMT_WR_CMD3(base, CMT_RD_CMD3(base) & ~(value)))
#define CMT_TOG_CMD3(base, value) (CMT_WR_CMD3(base, CMT_RD_CMD3(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMT_CMD4 - CMT Modulator Data Register Space Low
 ******************************************************************************/

/*!
 * @brief CMT_CMD4 - CMT Modulator Data Register Space Low (RW)
 *
 * Reset value: 0x00U
 *
 * The contents of this register are transferred to the space period register
 * upon the completion of a modulation period.
 */
/*!
 * @name Constants and macros for entire CMT_CMD4 register
 */
/*@{*/
#define CMT_RD_CMD4(base)        (CMT_CMD4_REG(base))
#define CMT_WR_CMD4(base, value) (CMT_CMD4_REG(base) = (value))
#define CMT_RMW_CMD4(base, mask, value) (CMT_WR_CMD4(base, (CMT_RD_CMD4(base) & ~(mask)) | (value)))
#define CMT_SET_CMD4(base, value) (CMT_WR_CMD4(base, CMT_RD_CMD4(base) |  (value)))
#define CMT_CLR_CMD4(base, value) (CMT_WR_CMD4(base, CMT_RD_CMD4(base) & ~(value)))
#define CMT_TOG_CMD4(base, value) (CMT_WR_CMD4(base, CMT_RD_CMD4(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CMT_PPS - CMT Primary Prescaler Register
 ******************************************************************************/

/*!
 * @brief CMT_PPS - CMT Primary Prescaler Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register is used to set the Primary Prescaler Divider field (PPSDIV).
 */
/*!
 * @name Constants and macros for entire CMT_PPS register
 */
/*@{*/
#define CMT_RD_PPS(base)         (CMT_PPS_REG(base))
#define CMT_WR_PPS(base, value)  (CMT_PPS_REG(base) = (value))
#define CMT_RMW_PPS(base, mask, value) (CMT_WR_PPS(base, (CMT_RD_PPS(base) & ~(mask)) | (value)))
#define CMT_SET_PPS(base, value) (CMT_WR_PPS(base, CMT_RD_PPS(base) |  (value)))
#define CMT_CLR_PPS(base, value) (CMT_WR_PPS(base, CMT_RD_PPS(base) & ~(value)))
#define CMT_TOG_PPS(base, value) (CMT_WR_PPS(base, CMT_RD_PPS(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMT_PPS bitfields
 */

/*!
 * @name Register CMT_PPS, field PPSDIV[3:0] (RW)
 *
 * Divides the CMT clock to generate the Intermediate Frequency clock enable to
 * the secondary prescaler.
 *
 * Values:
 * - 0b0000 - Bus clock * 1
 * - 0b0001 - Bus clock * 2
 * - 0b0010 - Bus clock * 3
 * - 0b0011 - Bus clock * 4
 * - 0b0100 - Bus clock * 5
 * - 0b0101 - Bus clock * 6
 * - 0b0110 - Bus clock * 7
 * - 0b0111 - Bus clock * 8
 * - 0b1000 - Bus clock * 9
 * - 0b1001 - Bus clock * 10
 * - 0b1010 - Bus clock * 11
 * - 0b1011 - Bus clock * 12
 * - 0b1100 - Bus clock * 13
 * - 0b1101 - Bus clock * 14
 * - 0b1110 - Bus clock * 15
 * - 0b1111 - Bus clock * 16
 */
/*@{*/
/*! @brief Read current value of the CMT_PPS_PPSDIV field. */
#define CMT_RD_PPS_PPSDIV(base) ((CMT_PPS_REG(base) & CMT_PPS_PPSDIV_MASK) >> CMT_PPS_PPSDIV_SHIFT)
#define CMT_BRD_PPS_PPSDIV(base) (CMT_RD_PPS_PPSDIV(base))

/*! @brief Set the PPSDIV field to a new value. */
#define CMT_WR_PPS_PPSDIV(base, value) (CMT_RMW_PPS(base, CMT_PPS_PPSDIV_MASK, CMT_PPS_PPSDIV(value)))
#define CMT_BWR_PPS_PPSDIV(base, value) (CMT_WR_PPS_PPSDIV(base, value))
/*@}*/

/*******************************************************************************
 * CMT_DMA - CMT Direct Memory Access Register
 ******************************************************************************/

/*!
 * @brief CMT_DMA - CMT Direct Memory Access Register (RW)
 *
 * Reset value: 0x00U
 *
 * This register is used to enable/disable direct memory access (DMA).
 */
/*!
 * @name Constants and macros for entire CMT_DMA register
 */
/*@{*/
#define CMT_RD_DMA(base)         (CMT_DMA_REG(base))
#define CMT_WR_DMA(base, value)  (CMT_DMA_REG(base) = (value))
#define CMT_RMW_DMA(base, mask, value) (CMT_WR_DMA(base, (CMT_RD_DMA(base) & ~(mask)) | (value)))
#define CMT_SET_DMA(base, value) (CMT_WR_DMA(base, CMT_RD_DMA(base) |  (value)))
#define CMT_CLR_DMA(base, value) (CMT_WR_DMA(base, CMT_RD_DMA(base) & ~(value)))
#define CMT_TOG_DMA(base, value) (CMT_WR_DMA(base, CMT_RD_DMA(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CMT_DMA bitfields
 */

/*!
 * @name Register CMT_DMA, field DMA[0] (RW)
 *
 * Enables the DMA protocol.
 *
 * Values:
 * - 0b0 - DMA transfer request and done are disabled.
 * - 0b1 - DMA transfer request and done are enabled.
 */
/*@{*/
/*! @brief Read current value of the CMT_DMA_DMA field. */
#define CMT_RD_DMA_DMA(base) ((CMT_DMA_REG(base) & CMT_DMA_DMA_MASK) >> CMT_DMA_DMA_SHIFT)
#define CMT_BRD_DMA_DMA(base) (BITBAND_ACCESS8(&CMT_DMA_REG(base), CMT_DMA_DMA_SHIFT))

/*! @brief Set the DMA field to a new value. */
#define CMT_WR_DMA_DMA(base, value) (CMT_RMW_DMA(base, CMT_DMA_DMA_MASK, CMT_DMA_DMA(value)))
#define CMT_BWR_DMA_DMA(base, value) (BITBAND_ACCESS8(&CMT_DMA_REG(base), CMT_DMA_DMA_SHIFT) = (value))
/*@}*/

/*
 * MK64F12 CRC
 *
 * Cyclic Redundancy Check
 *
 * Registers defined in this header file:
 * - CRC_DATAL - CRC_DATAL register.
 * - CRC_DATAH - CRC_DATAH register.
 * - CRC_DATALL - CRC_DATALL register.
 * - CRC_DATALU - CRC_DATALU register.
 * - CRC_DATAHL - CRC_DATAHL register.
 * - CRC_DATAHU - CRC_DATAHU register.
 * - CRC_DATA - CRC Data register
 * - CRC_GPOLY - CRC Polynomial register
 * - CRC_GPOLYL - CRC_GPOLYL register.
 * - CRC_GPOLYH - CRC_GPOLYH register.
 * - CRC_GPOLYLL - CRC_GPOLYLL register.
 * - CRC_GPOLYLU - CRC_GPOLYLU register.
 * - CRC_GPOLYHL - CRC_GPOLYHL register.
 * - CRC_GPOLYHU - CRC_GPOLYHU register.
 * - CRC_CTRL - CRC Control register
 * - CRC_CTRLHU - CRC_CTRLHU register.
 */

#define CRC_INSTANCE_COUNT (1U) /*!< Number of instances of the CRC module. */
#define CRC_IDX (0U) /*!< Instance number for CRC. */

/*******************************************************************************
 * CRC_DATALL - CRC_DATALL register.
 ******************************************************************************/

/*!
 * @brief CRC_DATALL - CRC_DATALL register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATALL register
 */
/*@{*/
#define CRC_RD_DATALL(base)      (CRC_DATALL_REG(base))
#define CRC_WR_DATALL(base, value) (CRC_DATALL_REG(base) = (value))
#define CRC_RMW_DATALL(base, mask, value) (CRC_WR_DATALL(base, (CRC_RD_DATALL(base) & ~(mask)) | (value)))
#define CRC_SET_DATALL(base, value) (CRC_WR_DATALL(base, CRC_RD_DATALL(base) |  (value)))
#define CRC_CLR_DATALL(base, value) (CRC_WR_DATALL(base, CRC_RD_DATALL(base) & ~(value)))
#define CRC_TOG_DATALL(base, value) (CRC_WR_DATALL(base, CRC_RD_DATALL(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_DATAL - CRC_DATAL register.
 ******************************************************************************/

/*!
 * @brief CRC_DATAL - CRC_DATAL register. (RW)
 *
 * Reset value: 0xFFFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATAL register
 */
/*@{*/
#define CRC_RD_DATAL(base)       (CRC_DATAL_REG(base))
#define CRC_WR_DATAL(base, value) (CRC_DATAL_REG(base) = (value))
#define CRC_RMW_DATAL(base, mask, value) (CRC_WR_DATAL(base, (CRC_RD_DATAL(base) & ~(mask)) | (value)))
#define CRC_SET_DATAL(base, value) (CRC_WR_DATAL(base, CRC_RD_DATAL(base) |  (value)))
#define CRC_CLR_DATAL(base, value) (CRC_WR_DATAL(base, CRC_RD_DATAL(base) & ~(value)))
#define CRC_TOG_DATAL(base, value) (CRC_WR_DATAL(base, CRC_RD_DATAL(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_DATA - CRC Data register
 ******************************************************************************/

/*!
 * @brief CRC_DATA - CRC Data register (RW)
 *
 * Reset value: 0xFFFFFFFFU
 *
 * The CRC Data register contains the value of the seed, data, and checksum.
 * When CTRL[WAS] is set, any write to the data register is regarded as the seed
 * value. When CTRL[WAS] is cleared, any write to the data register is regarded as
 * data for general CRC computation. In 16-bit CRC mode, the HU and HL fields are
 * not used for programming the seed value, and reads of these fields return an
 * indeterminate value. In 32-bit CRC mode, all fields are used for programming
 * the seed value. When programming data values, the values can be written 8 bits,
 * 16 bits, or 32 bits at a time, provided all bytes are contiguous; with MSB of
 * data value written first. After all data values are written, the CRC result
 * can be read from this data register. In 16-bit CRC mode, the CRC result is
 * available in the LU and LL fields. In 32-bit CRC mode, all fields contain the
 * result. Reads of this register at any time return the intermediate CRC value,
 * provided the CRC module is configured.
 */
/*!
 * @name Constants and macros for entire CRC_DATA register
 */
/*@{*/
#define CRC_RD_DATA(base)        (CRC_DATA_REG(base))
#define CRC_WR_DATA(base, value) (CRC_DATA_REG(base) = (value))
#define CRC_RMW_DATA(base, mask, value) (CRC_WR_DATA(base, (CRC_RD_DATA(base) & ~(mask)) | (value)))
#define CRC_SET_DATA(base, value) (CRC_WR_DATA(base, CRC_RD_DATA(base) |  (value)))
#define CRC_CLR_DATA(base, value) (CRC_WR_DATA(base, CRC_RD_DATA(base) & ~(value)))
#define CRC_TOG_DATA(base, value) (CRC_WR_DATA(base, CRC_RD_DATA(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CRC_DATA bitfields
 */

/*!
 * @name Register CRC_DATA, field LL[7:0] (RW)
 *
 * When CTRL[WAS] is 1, values written to this field are part of the seed value.
 * When CTRL[WAS] is 0, data written to this field is used for CRC checksum
 * generation.
 */
/*@{*/
/*! @brief Read current value of the CRC_DATA_LL field. */
#define CRC_RD_DATA_LL(base) ((CRC_DATA_REG(base) & CRC_DATA_LL_MASK) >> CRC_DATA_LL_SHIFT)
#define CRC_BRD_DATA_LL(base) (CRC_RD_DATA_LL(base))

/*! @brief Set the LL field to a new value. */
#define CRC_WR_DATA_LL(base, value) (CRC_RMW_DATA(base, CRC_DATA_LL_MASK, CRC_DATA_LL(value)))
#define CRC_BWR_DATA_LL(base, value) (CRC_WR_DATA_LL(base, value))
/*@}*/

/*!
 * @name Register CRC_DATA, field LU[15:8] (RW)
 *
 * When CTRL[WAS] is 1, values written to this field are part of the seed value.
 * When CTRL[WAS] is 0, data written to this field is used for CRC checksum
 * generation.
 */
/*@{*/
/*! @brief Read current value of the CRC_DATA_LU field. */
#define CRC_RD_DATA_LU(base) ((CRC_DATA_REG(base) & CRC_DATA_LU_MASK) >> CRC_DATA_LU_SHIFT)
#define CRC_BRD_DATA_LU(base) (CRC_RD_DATA_LU(base))

/*! @brief Set the LU field to a new value. */
#define CRC_WR_DATA_LU(base, value) (CRC_RMW_DATA(base, CRC_DATA_LU_MASK, CRC_DATA_LU(value)))
#define CRC_BWR_DATA_LU(base, value) (CRC_WR_DATA_LU(base, value))
/*@}*/

/*!
 * @name Register CRC_DATA, field HL[23:16] (RW)
 *
 * In 16-bit CRC mode (CTRL[TCRC] is 0), this field is not used for programming
 * a seed value. In 32-bit CRC mode (CTRL[TCRC] is 1), values written to this
 * field are part of the seed value when CTRL[WAS] is 1. When CTRL[WAS] is 0, data
 * written to this field is used for CRC checksum generation in both 16-bit and
 * 32-bit CRC modes.
 */
/*@{*/
/*! @brief Read current value of the CRC_DATA_HL field. */
#define CRC_RD_DATA_HL(base) ((CRC_DATA_REG(base) & CRC_DATA_HL_MASK) >> CRC_DATA_HL_SHIFT)
#define CRC_BRD_DATA_HL(base) (CRC_RD_DATA_HL(base))

/*! @brief Set the HL field to a new value. */
#define CRC_WR_DATA_HL(base, value) (CRC_RMW_DATA(base, CRC_DATA_HL_MASK, CRC_DATA_HL(value)))
#define CRC_BWR_DATA_HL(base, value) (CRC_WR_DATA_HL(base, value))
/*@}*/

/*!
 * @name Register CRC_DATA, field HU[31:24] (RW)
 *
 * In 16-bit CRC mode (CTRL[TCRC] is 0), this field is not used for programming
 * a seed value. In 32-bit CRC mode (CTRL[TCRC] is 1), values written to this
 * field are part of the seed value when CTRL[WAS] is 1. When CTRL[WAS] is 0, data
 * written to this field is used for CRC checksum generation in both 16-bit and
 * 32-bit CRC modes.
 */
/*@{*/
/*! @brief Read current value of the CRC_DATA_HU field. */
#define CRC_RD_DATA_HU(base) ((CRC_DATA_REG(base) & CRC_DATA_HU_MASK) >> CRC_DATA_HU_SHIFT)
#define CRC_BRD_DATA_HU(base) (CRC_RD_DATA_HU(base))

/*! @brief Set the HU field to a new value. */
#define CRC_WR_DATA_HU(base, value) (CRC_RMW_DATA(base, CRC_DATA_HU_MASK, CRC_DATA_HU(value)))
#define CRC_BWR_DATA_HU(base, value) (CRC_WR_DATA_HU(base, value))
/*@}*/

/*******************************************************************************
 * CRC_DATALU - CRC_DATALU register.
 ******************************************************************************/

/*!
 * @brief CRC_DATALU - CRC_DATALU register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATALU register
 */
/*@{*/
#define CRC_RD_DATALU(base)      (CRC_DATALU_REG(base))
#define CRC_WR_DATALU(base, value) (CRC_DATALU_REG(base) = (value))
#define CRC_RMW_DATALU(base, mask, value) (CRC_WR_DATALU(base, (CRC_RD_DATALU(base) & ~(mask)) | (value)))
#define CRC_SET_DATALU(base, value) (CRC_WR_DATALU(base, CRC_RD_DATALU(base) |  (value)))
#define CRC_CLR_DATALU(base, value) (CRC_WR_DATALU(base, CRC_RD_DATALU(base) & ~(value)))
#define CRC_TOG_DATALU(base, value) (CRC_WR_DATALU(base, CRC_RD_DATALU(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_DATAHL - CRC_DATAHL register.
 ******************************************************************************/

/*!
 * @brief CRC_DATAHL - CRC_DATAHL register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATAHL register
 */
/*@{*/
#define CRC_RD_DATAHL(base)      (CRC_DATAHL_REG(base))
#define CRC_WR_DATAHL(base, value) (CRC_DATAHL_REG(base) = (value))
#define CRC_RMW_DATAHL(base, mask, value) (CRC_WR_DATAHL(base, (CRC_RD_DATAHL(base) & ~(mask)) | (value)))
#define CRC_SET_DATAHL(base, value) (CRC_WR_DATAHL(base, CRC_RD_DATAHL(base) |  (value)))
#define CRC_CLR_DATAHL(base, value) (CRC_WR_DATAHL(base, CRC_RD_DATAHL(base) & ~(value)))
#define CRC_TOG_DATAHL(base, value) (CRC_WR_DATAHL(base, CRC_RD_DATAHL(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_DATAH - CRC_DATAH register.
 ******************************************************************************/

/*!
 * @brief CRC_DATAH - CRC_DATAH register. (RW)
 *
 * Reset value: 0xFFFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATAH register
 */
/*@{*/
#define CRC_RD_DATAH(base)       (CRC_DATAH_REG(base))
#define CRC_WR_DATAH(base, value) (CRC_DATAH_REG(base) = (value))
#define CRC_RMW_DATAH(base, mask, value) (CRC_WR_DATAH(base, (CRC_RD_DATAH(base) & ~(mask)) | (value)))
#define CRC_SET_DATAH(base, value) (CRC_WR_DATAH(base, CRC_RD_DATAH(base) |  (value)))
#define CRC_CLR_DATAH(base, value) (CRC_WR_DATAH(base, CRC_RD_DATAH(base) & ~(value)))
#define CRC_TOG_DATAH(base, value) (CRC_WR_DATAH(base, CRC_RD_DATAH(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_DATAHU - CRC_DATAHU register.
 ******************************************************************************/

/*!
 * @brief CRC_DATAHU - CRC_DATAHU register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_DATAHU register
 */
/*@{*/
#define CRC_RD_DATAHU(base)      (CRC_DATAHU_REG(base))
#define CRC_WR_DATAHU(base, value) (CRC_DATAHU_REG(base) = (value))
#define CRC_RMW_DATAHU(base, mask, value) (CRC_WR_DATAHU(base, (CRC_RD_DATAHU(base) & ~(mask)) | (value)))
#define CRC_SET_DATAHU(base, value) (CRC_WR_DATAHU(base, CRC_RD_DATAHU(base) |  (value)))
#define CRC_CLR_DATAHU(base, value) (CRC_WR_DATAHU(base, CRC_RD_DATAHU(base) & ~(value)))
#define CRC_TOG_DATAHU(base, value) (CRC_WR_DATAHU(base, CRC_RD_DATAHU(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYLL - CRC_GPOLYLL register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYLL - CRC_GPOLYLL register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYLL register
 */
/*@{*/
#define CRC_RD_GPOLYLL(base)     (CRC_GPOLYLL_REG(base))
#define CRC_WR_GPOLYLL(base, value) (CRC_GPOLYLL_REG(base) = (value))
#define CRC_RMW_GPOLYLL(base, mask, value) (CRC_WR_GPOLYLL(base, (CRC_RD_GPOLYLL(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYLL(base, value) (CRC_WR_GPOLYLL(base, CRC_RD_GPOLYLL(base) |  (value)))
#define CRC_CLR_GPOLYLL(base, value) (CRC_WR_GPOLYLL(base, CRC_RD_GPOLYLL(base) & ~(value)))
#define CRC_TOG_GPOLYLL(base, value) (CRC_WR_GPOLYLL(base, CRC_RD_GPOLYLL(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLY - CRC Polynomial register
 ******************************************************************************/

/*!
 * @brief CRC_GPOLY - CRC Polynomial register (RW)
 *
 * Reset value: 0x00001021U
 *
 * This register contains the value of the polynomial for the CRC calculation.
 * The HIGH field contains the upper 16 bits of the CRC polynomial, which are used
 * only in 32-bit CRC mode. Writes to the HIGH field are ignored in 16-bit CRC
 * mode. The LOW field contains the lower 16 bits of the CRC polynomial, which are
 * used in both 16- and 32-bit CRC modes.
 */
/*!
 * @name Constants and macros for entire CRC_GPOLY register
 */
/*@{*/
#define CRC_RD_GPOLY(base)       (CRC_GPOLY_REG(base))
#define CRC_WR_GPOLY(base, value) (CRC_GPOLY_REG(base) = (value))
#define CRC_RMW_GPOLY(base, mask, value) (CRC_WR_GPOLY(base, (CRC_RD_GPOLY(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLY(base, value) (CRC_WR_GPOLY(base, CRC_RD_GPOLY(base) |  (value)))
#define CRC_CLR_GPOLY(base, value) (CRC_WR_GPOLY(base, CRC_RD_GPOLY(base) & ~(value)))
#define CRC_TOG_GPOLY(base, value) (CRC_WR_GPOLY(base, CRC_RD_GPOLY(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CRC_GPOLY bitfields
 */

/*!
 * @name Register CRC_GPOLY, field LOW[15:0] (RW)
 *
 * Writable and readable in both 32-bit and 16-bit CRC modes.
 */
/*@{*/
/*! @brief Read current value of the CRC_GPOLY_LOW field. */
#define CRC_RD_GPOLY_LOW(base) ((CRC_GPOLY_REG(base) & CRC_GPOLY_LOW_MASK) >> CRC_GPOLY_LOW_SHIFT)
#define CRC_BRD_GPOLY_LOW(base) (CRC_RD_GPOLY_LOW(base))

/*! @brief Set the LOW field to a new value. */
#define CRC_WR_GPOLY_LOW(base, value) (CRC_RMW_GPOLY(base, CRC_GPOLY_LOW_MASK, CRC_GPOLY_LOW(value)))
#define CRC_BWR_GPOLY_LOW(base, value) (CRC_WR_GPOLY_LOW(base, value))
/*@}*/

/*!
 * @name Register CRC_GPOLY, field HIGH[31:16] (RW)
 *
 * Writable and readable in 32-bit CRC mode (CTRL[TCRC] is 1). This field is not
 * writable in 16-bit CRC mode (CTRL[TCRC] is 0).
 */
/*@{*/
/*! @brief Read current value of the CRC_GPOLY_HIGH field. */
#define CRC_RD_GPOLY_HIGH(base) ((CRC_GPOLY_REG(base) & CRC_GPOLY_HIGH_MASK) >> CRC_GPOLY_HIGH_SHIFT)
#define CRC_BRD_GPOLY_HIGH(base) (CRC_RD_GPOLY_HIGH(base))

/*! @brief Set the HIGH field to a new value. */
#define CRC_WR_GPOLY_HIGH(base, value) (CRC_RMW_GPOLY(base, CRC_GPOLY_HIGH_MASK, CRC_GPOLY_HIGH(value)))
#define CRC_BWR_GPOLY_HIGH(base, value) (CRC_WR_GPOLY_HIGH(base, value))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYL - CRC_GPOLYL register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYL - CRC_GPOLYL register. (RW)
 *
 * Reset value: 0xFFFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYL register
 */
/*@{*/
#define CRC_RD_GPOLYL(base)      (CRC_GPOLYL_REG(base))
#define CRC_WR_GPOLYL(base, value) (CRC_GPOLYL_REG(base) = (value))
#define CRC_RMW_GPOLYL(base, mask, value) (CRC_WR_GPOLYL(base, (CRC_RD_GPOLYL(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYL(base, value) (CRC_WR_GPOLYL(base, CRC_RD_GPOLYL(base) |  (value)))
#define CRC_CLR_GPOLYL(base, value) (CRC_WR_GPOLYL(base, CRC_RD_GPOLYL(base) & ~(value)))
#define CRC_TOG_GPOLYL(base, value) (CRC_WR_GPOLYL(base, CRC_RD_GPOLYL(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYLU - CRC_GPOLYLU register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYLU - CRC_GPOLYLU register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYLU register
 */
/*@{*/
#define CRC_RD_GPOLYLU(base)     (CRC_GPOLYLU_REG(base))
#define CRC_WR_GPOLYLU(base, value) (CRC_GPOLYLU_REG(base) = (value))
#define CRC_RMW_GPOLYLU(base, mask, value) (CRC_WR_GPOLYLU(base, (CRC_RD_GPOLYLU(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYLU(base, value) (CRC_WR_GPOLYLU(base, CRC_RD_GPOLYLU(base) |  (value)))
#define CRC_CLR_GPOLYLU(base, value) (CRC_WR_GPOLYLU(base, CRC_RD_GPOLYLU(base) & ~(value)))
#define CRC_TOG_GPOLYLU(base, value) (CRC_WR_GPOLYLU(base, CRC_RD_GPOLYLU(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYH - CRC_GPOLYH register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYH - CRC_GPOLYH register. (RW)
 *
 * Reset value: 0xFFFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYH register
 */
/*@{*/
#define CRC_RD_GPOLYH(base)      (CRC_GPOLYH_REG(base))
#define CRC_WR_GPOLYH(base, value) (CRC_GPOLYH_REG(base) = (value))
#define CRC_RMW_GPOLYH(base, mask, value) (CRC_WR_GPOLYH(base, (CRC_RD_GPOLYH(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYH(base, value) (CRC_WR_GPOLYH(base, CRC_RD_GPOLYH(base) |  (value)))
#define CRC_CLR_GPOLYH(base, value) (CRC_WR_GPOLYH(base, CRC_RD_GPOLYH(base) & ~(value)))
#define CRC_TOG_GPOLYH(base, value) (CRC_WR_GPOLYH(base, CRC_RD_GPOLYH(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYHL - CRC_GPOLYHL register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYHL - CRC_GPOLYHL register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYHL register
 */
/*@{*/
#define CRC_RD_GPOLYHL(base)     (CRC_GPOLYHL_REG(base))
#define CRC_WR_GPOLYHL(base, value) (CRC_GPOLYHL_REG(base) = (value))
#define CRC_RMW_GPOLYHL(base, mask, value) (CRC_WR_GPOLYHL(base, (CRC_RD_GPOLYHL(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYHL(base, value) (CRC_WR_GPOLYHL(base, CRC_RD_GPOLYHL(base) |  (value)))
#define CRC_CLR_GPOLYHL(base, value) (CRC_WR_GPOLYHL(base, CRC_RD_GPOLYHL(base) & ~(value)))
#define CRC_TOG_GPOLYHL(base, value) (CRC_WR_GPOLYHL(base, CRC_RD_GPOLYHL(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_GPOLYHU - CRC_GPOLYHU register.
 ******************************************************************************/

/*!
 * @brief CRC_GPOLYHU - CRC_GPOLYHU register. (RW)
 *
 * Reset value: 0xFFU
 */
/*!
 * @name Constants and macros for entire CRC_GPOLYHU register
 */
/*@{*/
#define CRC_RD_GPOLYHU(base)     (CRC_GPOLYHU_REG(base))
#define CRC_WR_GPOLYHU(base, value) (CRC_GPOLYHU_REG(base) = (value))
#define CRC_RMW_GPOLYHU(base, mask, value) (CRC_WR_GPOLYHU(base, (CRC_RD_GPOLYHU(base) & ~(mask)) | (value)))
#define CRC_SET_GPOLYHU(base, value) (CRC_WR_GPOLYHU(base, CRC_RD_GPOLYHU(base) |  (value)))
#define CRC_CLR_GPOLYHU(base, value) (CRC_WR_GPOLYHU(base, CRC_RD_GPOLYHU(base) & ~(value)))
#define CRC_TOG_GPOLYHU(base, value) (CRC_WR_GPOLYHU(base, CRC_RD_GPOLYHU(base) ^  (value)))
/*@}*/

/*******************************************************************************
 * CRC_CTRL - CRC Control register
 ******************************************************************************/

/*!
 * @brief CRC_CTRL - CRC Control register (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register controls the configuration and working of the CRC module.
 * Appropriate bits must be set before starting a new CRC calculation. A new CRC
 * calculation is initialized by asserting CTRL[WAS] and then writing the seed into
 * the CRC data register.
 */
/*!
 * @name Constants and macros for entire CRC_CTRL register
 */
/*@{*/
#define CRC_RD_CTRL(base)        (CRC_CTRL_REG(base))
#define CRC_WR_CTRL(base, value) (CRC_CTRL_REG(base) = (value))
#define CRC_RMW_CTRL(base, mask, value) (CRC_WR_CTRL(base, (CRC_RD_CTRL(base) & ~(mask)) | (value)))
#define CRC_SET_CTRL(base, value) (CRC_WR_CTRL(base, CRC_RD_CTRL(base) |  (value)))
#define CRC_CLR_CTRL(base, value) (CRC_WR_CTRL(base, CRC_RD_CTRL(base) & ~(value)))
#define CRC_TOG_CTRL(base, value) (CRC_WR_CTRL(base, CRC_RD_CTRL(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CRC_CTRL bitfields
 */

/*!
 * @name Register CRC_CTRL, field TCRC[24] (RW)
 *
 * Width of CRC protocol.
 *
 * Values:
 * - 0b0 - 16-bit CRC protocol.
 * - 0b1 - 32-bit CRC protocol.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_TCRC field. */
#define CRC_RD_CTRL_TCRC(base) ((CRC_CTRL_REG(base) & CRC_CTRL_TCRC_MASK) >> CRC_CTRL_TCRC_SHIFT)
#define CRC_BRD_CTRL_TCRC(base) (BITBAND_ACCESS32(&CRC_CTRL_REG(base), CRC_CTRL_TCRC_SHIFT))

/*! @brief Set the TCRC field to a new value. */
#define CRC_WR_CTRL_TCRC(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_TCRC_MASK, CRC_CTRL_TCRC(value)))
#define CRC_BWR_CTRL_TCRC(base, value) (BITBAND_ACCESS32(&CRC_CTRL_REG(base), CRC_CTRL_TCRC_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CRC_CTRL, field WAS[25] (RW)
 *
 * When asserted, a value written to the CRC data register is considered a seed
 * value. When deasserted, a value written to the CRC data register is taken as
 * data for CRC computation.
 *
 * Values:
 * - 0b0 - Writes to the CRC data register are data values.
 * - 0b1 - Writes to the CRC data register are seed values.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_WAS field. */
#define CRC_RD_CTRL_WAS(base) ((CRC_CTRL_REG(base) & CRC_CTRL_WAS_MASK) >> CRC_CTRL_WAS_SHIFT)
#define CRC_BRD_CTRL_WAS(base) (BITBAND_ACCESS32(&CRC_CTRL_REG(base), CRC_CTRL_WAS_SHIFT))

/*! @brief Set the WAS field to a new value. */
#define CRC_WR_CTRL_WAS(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_WAS_MASK, CRC_CTRL_WAS(value)))
#define CRC_BWR_CTRL_WAS(base, value) (BITBAND_ACCESS32(&CRC_CTRL_REG(base), CRC_CTRL_WAS_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CRC_CTRL, field FXOR[26] (RW)
 *
 * Some CRC protocols require the final checksum to be XORed with 0xFFFFFFFF or
 * 0xFFFF. Asserting this bit enables on the fly complementing of read data.
 *
 * Values:
 * - 0b0 - No XOR on reading.
 * - 0b1 - Invert or complement the read value of the CRC Data register.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_FXOR field. */
#define CRC_RD_CTRL_FXOR(base) ((CRC_CTRL_REG(base) & CRC_CTRL_FXOR_MASK) >> CRC_CTRL_FXOR_SHIFT)
#define CRC_BRD_CTRL_FXOR(base) (BITBAND_ACCESS32(&CRC_CTRL_REG(base), CRC_CTRL_FXOR_SHIFT))

/*! @brief Set the FXOR field to a new value. */
#define CRC_WR_CTRL_FXOR(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_FXOR_MASK, CRC_CTRL_FXOR(value)))
#define CRC_BWR_CTRL_FXOR(base, value) (BITBAND_ACCESS32(&CRC_CTRL_REG(base), CRC_CTRL_FXOR_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CRC_CTRL, field TOTR[29:28] (RW)
 *
 * Identifies the transpose configuration of the value read from the CRC Data
 * register. See the description of the transpose feature for the available
 * transpose options.
 *
 * Values:
 * - 0b00 - No transposition.
 * - 0b01 - Bits in bytes are transposed; bytes are not transposed.
 * - 0b10 - Both bits in bytes and bytes are transposed.
 * - 0b11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_TOTR field. */
#define CRC_RD_CTRL_TOTR(base) ((CRC_CTRL_REG(base) & CRC_CTRL_TOTR_MASK) >> CRC_CTRL_TOTR_SHIFT)
#define CRC_BRD_CTRL_TOTR(base) (CRC_RD_CTRL_TOTR(base))

/*! @brief Set the TOTR field to a new value. */
#define CRC_WR_CTRL_TOTR(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_TOTR_MASK, CRC_CTRL_TOTR(value)))
#define CRC_BWR_CTRL_TOTR(base, value) (CRC_WR_CTRL_TOTR(base, value))
/*@}*/

/*!
 * @name Register CRC_CTRL, field TOT[31:30] (RW)
 *
 * Defines the transpose configuration of the data written to the CRC data
 * register. See the description of the transpose feature for the available transpose
 * options.
 *
 * Values:
 * - 0b00 - No transposition.
 * - 0b01 - Bits in bytes are transposed; bytes are not transposed.
 * - 0b10 - Both bits in bytes and bytes are transposed.
 * - 0b11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRL_TOT field. */
#define CRC_RD_CTRL_TOT(base) ((CRC_CTRL_REG(base) & CRC_CTRL_TOT_MASK) >> CRC_CTRL_TOT_SHIFT)
#define CRC_BRD_CTRL_TOT(base) (CRC_RD_CTRL_TOT(base))

/*! @brief Set the TOT field to a new value. */
#define CRC_WR_CTRL_TOT(base, value) (CRC_RMW_CTRL(base, CRC_CTRL_TOT_MASK, CRC_CTRL_TOT(value)))
#define CRC_BWR_CTRL_TOT(base, value) (CRC_WR_CTRL_TOT(base, value))
/*@}*/

/*******************************************************************************
 * CRC_CTRLHU - CRC_CTRLHU register.
 ******************************************************************************/

/*!
 * @brief CRC_CTRLHU - CRC_CTRLHU register. (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire CRC_CTRLHU register
 */
/*@{*/
#define CRC_RD_CTRLHU(base)      (CRC_CTRLHU_REG(base))
#define CRC_WR_CTRLHU(base, value) (CRC_CTRLHU_REG(base) = (value))
#define CRC_RMW_CTRLHU(base, mask, value) (CRC_WR_CTRLHU(base, (CRC_RD_CTRLHU(base) & ~(mask)) | (value)))
#define CRC_SET_CTRLHU(base, value) (CRC_WR_CTRLHU(base, CRC_RD_CTRLHU(base) |  (value)))
#define CRC_CLR_CTRLHU(base, value) (CRC_WR_CTRLHU(base, CRC_RD_CTRLHU(base) & ~(value)))
#define CRC_TOG_CTRLHU(base, value) (CRC_WR_CTRLHU(base, CRC_RD_CTRLHU(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual CRC_CTRLHU bitfields
 */

/*!
 * @name Register CRC_CTRLHU, field TCRC[0] (RW)
 *
 * Values:
 * - 0b0 - 16-bit CRC protocol.
 * - 0b1 - 32-bit CRC protocol.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_TCRC field. */
#define CRC_RD_CTRLHU_TCRC(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_TCRC_MASK) >> CRC_CTRLHU_TCRC_SHIFT)
#define CRC_BRD_CTRLHU_TCRC(base) (BITBAND_ACCESS8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_TCRC_SHIFT))

/*! @brief Set the TCRC field to a new value. */
#define CRC_WR_CTRLHU_TCRC(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_TCRC_MASK, CRC_CTRLHU_TCRC(value)))
#define CRC_BWR_CTRLHU_TCRC(base, value) (BITBAND_ACCESS8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_TCRC_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field WAS[1] (RW)
 *
 * Values:
 * - 0b0 - Writes to CRC data register are data values.
 * - 0b1 - Writes to CRC data reguster are seed values.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_WAS field. */
#define CRC_RD_CTRLHU_WAS(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_WAS_MASK) >> CRC_CTRLHU_WAS_SHIFT)
#define CRC_BRD_CTRLHU_WAS(base) (BITBAND_ACCESS8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_WAS_SHIFT))

/*! @brief Set the WAS field to a new value. */
#define CRC_WR_CTRLHU_WAS(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_WAS_MASK, CRC_CTRLHU_WAS(value)))
#define CRC_BWR_CTRLHU_WAS(base, value) (BITBAND_ACCESS8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_WAS_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field FXOR[2] (RW)
 *
 * Values:
 * - 0b0 - No XOR on reading.
 * - 0b1 - Invert or complement the read value of CRC data register.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_FXOR field. */
#define CRC_RD_CTRLHU_FXOR(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_FXOR_MASK) >> CRC_CTRLHU_FXOR_SHIFT)
#define CRC_BRD_CTRLHU_FXOR(base) (BITBAND_ACCESS8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_FXOR_SHIFT))

/*! @brief Set the FXOR field to a new value. */
#define CRC_WR_CTRLHU_FXOR(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_FXOR_MASK, CRC_CTRLHU_FXOR(value)))
#define CRC_BWR_CTRLHU_FXOR(base, value) (BITBAND_ACCESS8(&CRC_CTRLHU_REG(base), CRC_CTRLHU_FXOR_SHIFT) = (value))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field TOTR[5:4] (RW)
 *
 * Values:
 * - 0b00 - No Transposition.
 * - 0b01 - Bits in bytes are transposed, bytes are not transposed.
 * - 0b10 - Both bits in bytes and bytes are transposed.
 * - 0b11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_TOTR field. */
#define CRC_RD_CTRLHU_TOTR(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_TOTR_MASK) >> CRC_CTRLHU_TOTR_SHIFT)
#define CRC_BRD_CTRLHU_TOTR(base) (CRC_RD_CTRLHU_TOTR(base))

/*! @brief Set the TOTR field to a new value. */
#define CRC_WR_CTRLHU_TOTR(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_TOTR_MASK, CRC_CTRLHU_TOTR(value)))
#define CRC_BWR_CTRLHU_TOTR(base, value) (CRC_WR_CTRLHU_TOTR(base, value))
/*@}*/

/*!
 * @name Register CRC_CTRLHU, field TOT[7:6] (RW)
 *
 * Values:
 * - 0b00 - No Transposition.
 * - 0b01 - Bits in bytes are transposed, bytes are not transposed.
 * - 0b10 - Both bits in bytes and bytes are transposed.
 * - 0b11 - Only bytes are transposed; no bits in a byte are transposed.
 */
/*@{*/
/*! @brief Read current value of the CRC_CTRLHU_TOT field. */
#define CRC_RD_CTRLHU_TOT(base) ((CRC_CTRLHU_REG(base) & CRC_CTRLHU_TOT_MASK) >> CRC_CTRLHU_TOT_SHIFT)
#define CRC_BRD_CTRLHU_TOT(base) (CRC_RD_CTRLHU_TOT(base))

/*! @brief Set the TOT field to a new value. */
#define CRC_WR_CTRLHU_TOT(base, value) (CRC_RMW_CTRLHU(base, CRC_CTRLHU_TOT_MASK, CRC_CTRLHU_TOT(value)))
#define CRC_BWR_CTRLHU_TOT(base, value) (CRC_WR_CTRLHU_TOT(base, value))
/*@}*/

/*
 * MK64F12 DAC
 *
 * 12-Bit Digital-to-Analog Converter
 *
 * Registers defined in this header file:
 * - DAC_DATL - DAC Data Low Register
 * - DAC_DATH - DAC Data High Register
 * - DAC_SR - DAC Status Register
 * - DAC_C0 - DAC Control Register
 * - DAC_C1 - DAC Control Register 1
 * - DAC_C2 - DAC Control Register 2
 */

#define DAC_INSTANCE_COUNT (2U) /*!< Number of instances of the DAC module. */
#define DAC0_IDX (0U) /*!< Instance number for DAC0. */
#define DAC1_IDX (1U) /*!< Instance number for DAC1. */

/*******************************************************************************
 * DAC_DATL - DAC Data Low Register
 ******************************************************************************/

/*!
 * @brief DAC_DATL - DAC Data Low Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire DAC_DATL register
 */
/*@{*/
#define DAC_RD_DATL(base, index) (DAC_DATL_REG(base, index))
#define DAC_WR_DATL(base, index, value) (DAC_DATL_REG(base, index) = (value))
#define DAC_RMW_DATL(base, index, mask, value) (DAC_WR_DATL(base, index, (DAC_RD_DATL(base, index) & ~(mask)) | (value)))
#define DAC_SET_DATL(base, index, value) (DAC_WR_DATL(base, index, DAC_RD_DATL(base, index) |  (value)))
#define DAC_CLR_DATL(base, index, value) (DAC_WR_DATL(base, index, DAC_RD_DATL(base, index) & ~(value)))
#define DAC_TOG_DATL(base, index, value) (DAC_WR_DATL(base, index, DAC_RD_DATL(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * DAC_DATH - DAC Data High Register
 ******************************************************************************/

/*!
 * @brief DAC_DATH - DAC Data High Register (RW)
 *
 * Reset value: 0x00U
 */
/*!
 * @name Constants and macros for entire DAC_DATH register
 */
/*@{*/
#define DAC_RD_DATH(base, index) (DAC_DATH_REG(base, index))
#define DAC_WR_DATH(base, index, value) (DAC_DATH_REG(base, index) = (value))
#define DAC_RMW_DATH(base, index, mask, value) (DAC_WR_DATH(base, index, (DAC_RD_DATH(base, index) & ~(mask)) | (value)))
#define DAC_SET_DATH(base, index, value) (DAC_WR_DATH(base, index, DAC_RD_DATH(base, index) |  (value)))
#define DAC_CLR_DATH(base, index, value) (DAC_WR_DATH(base, index, DAC_RD_DATH(base, index) & ~(value)))
#define DAC_TOG_DATH(base, index, value) (DAC_WR_DATH(base, index, DAC_RD_DATH(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DAC_DATH bitfields
 */

/*!
 * @name Register DAC_DATH, field DATA1[3:0] (RW)
 *
 * When the DAC Buffer is not enabled, DATA[11:0] controls the output voltage
 * based on the following formula. V out = V in * (1 + DACDAT0[11:0])/4096 When the
 * DAC buffer is enabled, DATA[11:0] is mapped to the 16-word buffer.
 */
/*@{*/
/*! @brief Read current value of the DAC_DATH_DATA1 field. */
#define DAC_RD_DATH_DATA1(base, index) ((DAC_DATH_REG(base, index) & DAC_DATH_DATA1_MASK) >> DAC_DATH_DATA1_SHIFT)
#define DAC_BRD_DATH_DATA1(base, index) (DAC_RD_DATH_DATA1(base, index))

/*! @brief Set the DATA1 field to a new value. */
#define DAC_WR_DATH_DATA1(base, index, value) (DAC_RMW_DATH(base, index, DAC_DATH_DATA1_MASK, DAC_DATH_DATA1(value)))
#define DAC_BWR_DATH_DATA1(base, index, value) (DAC_WR_DATH_DATA1(base, index, value))
/*@}*/

/*******************************************************************************
 * DAC_SR - DAC Status Register
 ******************************************************************************/

/*!
 * @brief DAC_SR - DAC Status Register (RW)
 *
 * Reset value: 0x02U
 *
 * If DMA is enabled, the flags can be cleared automatically by DMA when the DMA
 * request is done. Writing 0 to a field clears it whereas writing 1 has no
 * effect. After reset, DACBFRPTF is set and can be cleared by software, if needed.
 * The flags are set only when the data buffer status is changed. Do not use
 * 32/16-bit accesses to this register.
 */
/*!
 * @name Constants and macros for entire DAC_SR register
 */
/*@{*/
#define DAC_RD_SR(base)          (DAC_SR_REG(base))
#define DAC_WR_SR(base, value)   (DAC_SR_REG(base) = (value))
#define DAC_RMW_SR(base, mask, value) (DAC_WR_SR(base, (DAC_RD_SR(base) & ~(mask)) | (value)))
#define DAC_SET_SR(base, value)  (DAC_WR_SR(base, DAC_RD_SR(base) |  (value)))
#define DAC_CLR_SR(base, value)  (DAC_WR_SR(base, DAC_RD_SR(base) & ~(value)))
#define DAC_TOG_SR(base, value)  (DAC_WR_SR(base, DAC_RD_SR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DAC_SR bitfields
 */

/*!
 * @name Register DAC_SR, field DACBFRPBF[0] (RW)
 *
 * Values:
 * - 0b0 - The DAC buffer read pointer is not equal to C2[DACBFUP].
 * - 0b1 - The DAC buffer read pointer is equal to C2[DACBFUP].
 */
/*@{*/
/*! @brief Read current value of the DAC_SR_DACBFRPBF field. */
#define DAC_RD_SR_DACBFRPBF(base) ((DAC_SR_REG(base) & DAC_SR_DACBFRPBF_MASK) >> DAC_SR_DACBFRPBF_SHIFT)
#define DAC_BRD_SR_DACBFRPBF(base) (BITBAND_ACCESS8(&DAC_SR_REG(base), DAC_SR_DACBFRPBF_SHIFT))

/*! @brief Set the DACBFRPBF field to a new value. */
#define DAC_WR_SR_DACBFRPBF(base, value) (DAC_RMW_SR(base, DAC_SR_DACBFRPBF_MASK, DAC_SR_DACBFRPBF(value)))
#define DAC_BWR_SR_DACBFRPBF(base, value) (BITBAND_ACCESS8(&DAC_SR_REG(base), DAC_SR_DACBFRPBF_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_SR, field DACBFRPTF[1] (RW)
 *
 * Values:
 * - 0b0 - The DAC buffer read pointer is not zero.
 * - 0b1 - The DAC buffer read pointer is zero.
 */
/*@{*/
/*! @brief Read current value of the DAC_SR_DACBFRPTF field. */
#define DAC_RD_SR_DACBFRPTF(base) ((DAC_SR_REG(base) & DAC_SR_DACBFRPTF_MASK) >> DAC_SR_DACBFRPTF_SHIFT)
#define DAC_BRD_SR_DACBFRPTF(base) (BITBAND_ACCESS8(&DAC_SR_REG(base), DAC_SR_DACBFRPTF_SHIFT))

/*! @brief Set the DACBFRPTF field to a new value. */
#define DAC_WR_SR_DACBFRPTF(base, value) (DAC_RMW_SR(base, DAC_SR_DACBFRPTF_MASK, DAC_SR_DACBFRPTF(value)))
#define DAC_BWR_SR_DACBFRPTF(base, value) (BITBAND_ACCESS8(&DAC_SR_REG(base), DAC_SR_DACBFRPTF_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_SR, field DACBFWMF[2] (RW)
 *
 * Values:
 * - 0b0 - The DAC buffer read pointer has not reached the watermark level.
 * - 0b1 - The DAC buffer read pointer has reached the watermark level.
 */
/*@{*/
/*! @brief Read current value of the DAC_SR_DACBFWMF field. */
#define DAC_RD_SR_DACBFWMF(base) ((DAC_SR_REG(base) & DAC_SR_DACBFWMF_MASK) >> DAC_SR_DACBFWMF_SHIFT)
#define DAC_BRD_SR_DACBFWMF(base) (BITBAND_ACCESS8(&DAC_SR_REG(base), DAC_SR_DACBFWMF_SHIFT))

/*! @brief Set the DACBFWMF field to a new value. */
#define DAC_WR_SR_DACBFWMF(base, value) (DAC_RMW_SR(base, DAC_SR_DACBFWMF_MASK, DAC_SR_DACBFWMF(value)))
#define DAC_BWR_SR_DACBFWMF(base, value) (BITBAND_ACCESS8(&DAC_SR_REG(base), DAC_SR_DACBFWMF_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DAC_C0 - DAC Control Register
 ******************************************************************************/

/*!
 * @brief DAC_C0 - DAC Control Register (RW)
 *
 * Reset value: 0x00U
 *
 * Do not use 32- or 16-bit accesses to this register.
 */
/*!
 * @name Constants and macros for entire DAC_C0 register
 */
/*@{*/
#define DAC_RD_C0(base)          (DAC_C0_REG(base))
#define DAC_WR_C0(base, value)   (DAC_C0_REG(base) = (value))
#define DAC_RMW_C0(base, mask, value) (DAC_WR_C0(base, (DAC_RD_C0(base) & ~(mask)) | (value)))
#define DAC_SET_C0(base, value)  (DAC_WR_C0(base, DAC_RD_C0(base) |  (value)))
#define DAC_CLR_C0(base, value)  (DAC_WR_C0(base, DAC_RD_C0(base) & ~(value)))
#define DAC_TOG_C0(base, value)  (DAC_WR_C0(base, DAC_RD_C0(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DAC_C0 bitfields
 */

/*!
 * @name Register DAC_C0, field DACBBIEN[0] (RW)
 *
 * Values:
 * - 0b0 - The DAC buffer read pointer bottom flag interrupt is disabled.
 * - 0b1 - The DAC buffer read pointer bottom flag interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the DAC_C0_DACBBIEN field. */
#define DAC_RD_C0_DACBBIEN(base) ((DAC_C0_REG(base) & DAC_C0_DACBBIEN_MASK) >> DAC_C0_DACBBIEN_SHIFT)
#define DAC_BRD_C0_DACBBIEN(base) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACBBIEN_SHIFT))

/*! @brief Set the DACBBIEN field to a new value. */
#define DAC_WR_C0_DACBBIEN(base, value) (DAC_RMW_C0(base, DAC_C0_DACBBIEN_MASK, DAC_C0_DACBBIEN(value)))
#define DAC_BWR_C0_DACBBIEN(base, value) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACBBIEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_C0, field DACBTIEN[1] (RW)
 *
 * Values:
 * - 0b0 - The DAC buffer read pointer top flag interrupt is disabled.
 * - 0b1 - The DAC buffer read pointer top flag interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the DAC_C0_DACBTIEN field. */
#define DAC_RD_C0_DACBTIEN(base) ((DAC_C0_REG(base) & DAC_C0_DACBTIEN_MASK) >> DAC_C0_DACBTIEN_SHIFT)
#define DAC_BRD_C0_DACBTIEN(base) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACBTIEN_SHIFT))

/*! @brief Set the DACBTIEN field to a new value. */
#define DAC_WR_C0_DACBTIEN(base, value) (DAC_RMW_C0(base, DAC_C0_DACBTIEN_MASK, DAC_C0_DACBTIEN(value)))
#define DAC_BWR_C0_DACBTIEN(base, value) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACBTIEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_C0, field DACBWIEN[2] (RW)
 *
 * Values:
 * - 0b0 - The DAC buffer watermark interrupt is disabled.
 * - 0b1 - The DAC buffer watermark interrupt is enabled.
 */
/*@{*/
/*! @brief Read current value of the DAC_C0_DACBWIEN field. */
#define DAC_RD_C0_DACBWIEN(base) ((DAC_C0_REG(base) & DAC_C0_DACBWIEN_MASK) >> DAC_C0_DACBWIEN_SHIFT)
#define DAC_BRD_C0_DACBWIEN(base) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACBWIEN_SHIFT))

/*! @brief Set the DACBWIEN field to a new value. */
#define DAC_WR_C0_DACBWIEN(base, value) (DAC_RMW_C0(base, DAC_C0_DACBWIEN_MASK, DAC_C0_DACBWIEN(value)))
#define DAC_BWR_C0_DACBWIEN(base, value) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACBWIEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_C0, field LPEN[3] (RW)
 *
 * See the 12-bit DAC electrical characteristics of the device data sheet for
 * details on the impact of the modes below.
 *
 * Values:
 * - 0b0 - High-Power mode
 * - 0b1 - Low-Power mode
 */
/*@{*/
/*! @brief Read current value of the DAC_C0_LPEN field. */
#define DAC_RD_C0_LPEN(base) ((DAC_C0_REG(base) & DAC_C0_LPEN_MASK) >> DAC_C0_LPEN_SHIFT)
#define DAC_BRD_C0_LPEN(base) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_LPEN_SHIFT))

/*! @brief Set the LPEN field to a new value. */
#define DAC_WR_C0_LPEN(base, value) (DAC_RMW_C0(base, DAC_C0_LPEN_MASK, DAC_C0_LPEN(value)))
#define DAC_BWR_C0_LPEN(base, value) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_LPEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_C0, field DACSWTRG[4] (WORZ)
 *
 * Active high. This is a write-only field, which always reads 0. If DAC
 * software trigger is selected and buffer is enabled, writing 1 to this field will
 * advance the buffer read pointer once.
 *
 * Values:
 * - 0b0 - The DAC soft trigger is not valid.
 * - 0b1 - The DAC soft trigger is valid.
 */
/*@{*/
/*! @brief Set the DACSWTRG field to a new value. */
#define DAC_WR_C0_DACSWTRG(base, value) (DAC_RMW_C0(base, DAC_C0_DACSWTRG_MASK, DAC_C0_DACSWTRG(value)))
#define DAC_BWR_C0_DACSWTRG(base, value) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACSWTRG_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_C0, field DACTRGSEL[5] (RW)
 *
 * Values:
 * - 0b0 - The DAC hardware trigger is selected.
 * - 0b1 - The DAC software trigger is selected.
 */
/*@{*/
/*! @brief Read current value of the DAC_C0_DACTRGSEL field. */
#define DAC_RD_C0_DACTRGSEL(base) ((DAC_C0_REG(base) & DAC_C0_DACTRGSEL_MASK) >> DAC_C0_DACTRGSEL_SHIFT)
#define DAC_BRD_C0_DACTRGSEL(base) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACTRGSEL_SHIFT))

/*! @brief Set the DACTRGSEL field to a new value. */
#define DAC_WR_C0_DACTRGSEL(base, value) (DAC_RMW_C0(base, DAC_C0_DACTRGSEL_MASK, DAC_C0_DACTRGSEL(value)))
#define DAC_BWR_C0_DACTRGSEL(base, value) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACTRGSEL_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_C0, field DACRFS[6] (RW)
 *
 * Values:
 * - 0b0 - The DAC selects DACREF_1 as the reference voltage.
 * - 0b1 - The DAC selects DACREF_2 as the reference voltage.
 */
/*@{*/
/*! @brief Read current value of the DAC_C0_DACRFS field. */
#define DAC_RD_C0_DACRFS(base) ((DAC_C0_REG(base) & DAC_C0_DACRFS_MASK) >> DAC_C0_DACRFS_SHIFT)
#define DAC_BRD_C0_DACRFS(base) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACRFS_SHIFT))

/*! @brief Set the DACRFS field to a new value. */
#define DAC_WR_C0_DACRFS(base, value) (DAC_RMW_C0(base, DAC_C0_DACRFS_MASK, DAC_C0_DACRFS(value)))
#define DAC_BWR_C0_DACRFS(base, value) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACRFS_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_C0, field DACEN[7] (RW)
 *
 * Starts the Programmable Reference Generator operation.
 *
 * Values:
 * - 0b0 - The DAC system is disabled.
 * - 0b1 - The DAC system is enabled.
 */
/*@{*/
/*! @brief Read current value of the DAC_C0_DACEN field. */
#define DAC_RD_C0_DACEN(base) ((DAC_C0_REG(base) & DAC_C0_DACEN_MASK) >> DAC_C0_DACEN_SHIFT)
#define DAC_BRD_C0_DACEN(base) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACEN_SHIFT))

/*! @brief Set the DACEN field to a new value. */
#define DAC_WR_C0_DACEN(base, value) (DAC_RMW_C0(base, DAC_C0_DACEN_MASK, DAC_C0_DACEN(value)))
#define DAC_BWR_C0_DACEN(base, value) (BITBAND_ACCESS8(&DAC_C0_REG(base), DAC_C0_DACEN_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DAC_C1 - DAC Control Register 1
 ******************************************************************************/

/*!
 * @brief DAC_C1 - DAC Control Register 1 (RW)
 *
 * Reset value: 0x00U
 *
 * Do not use 32- or 16-bit accesses to this register.
 */
/*!
 * @name Constants and macros for entire DAC_C1 register
 */
/*@{*/
#define DAC_RD_C1(base)          (DAC_C1_REG(base))
#define DAC_WR_C1(base, value)   (DAC_C1_REG(base) = (value))
#define DAC_RMW_C1(base, mask, value) (DAC_WR_C1(base, (DAC_RD_C1(base) & ~(mask)) | (value)))
#define DAC_SET_C1(base, value)  (DAC_WR_C1(base, DAC_RD_C1(base) |  (value)))
#define DAC_CLR_C1(base, value)  (DAC_WR_C1(base, DAC_RD_C1(base) & ~(value)))
#define DAC_TOG_C1(base, value)  (DAC_WR_C1(base, DAC_RD_C1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DAC_C1 bitfields
 */

/*!
 * @name Register DAC_C1, field DACBFEN[0] (RW)
 *
 * Values:
 * - 0b0 - Buffer read pointer is disabled. The converted data is always the
 *     first word of the buffer.
 * - 0b1 - Buffer read pointer is enabled. The converted data is the word that
 *     the read pointer points to. It means converted data can be from any word of
 *     the buffer.
 */
/*@{*/
/*! @brief Read current value of the DAC_C1_DACBFEN field. */
#define DAC_RD_C1_DACBFEN(base) ((DAC_C1_REG(base) & DAC_C1_DACBFEN_MASK) >> DAC_C1_DACBFEN_SHIFT)
#define DAC_BRD_C1_DACBFEN(base) (BITBAND_ACCESS8(&DAC_C1_REG(base), DAC_C1_DACBFEN_SHIFT))

/*! @brief Set the DACBFEN field to a new value. */
#define DAC_WR_C1_DACBFEN(base, value) (DAC_RMW_C1(base, DAC_C1_DACBFEN_MASK, DAC_C1_DACBFEN(value)))
#define DAC_BWR_C1_DACBFEN(base, value) (BITBAND_ACCESS8(&DAC_C1_REG(base), DAC_C1_DACBFEN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DAC_C1, field DACBFMD[2:1] (RW)
 *
 * Values:
 * - 0b00 - Normal mode
 * - 0b01 - Swing mode
 * - 0b10 - One-Time Scan mode
 * - 0b11 - Reserved
 */
/*@{*/
/*! @brief Read current value of the DAC_C1_DACBFMD field. */
#define DAC_RD_C1_DACBFMD(base) ((DAC_C1_REG(base) & DAC_C1_DACBFMD_MASK) >> DAC_C1_DACBFMD_SHIFT)
#define DAC_BRD_C1_DACBFMD(base) (DAC_RD_C1_DACBFMD(base))

/*! @brief Set the DACBFMD field to a new value. */
#define DAC_WR_C1_DACBFMD(base, value) (DAC_RMW_C1(base, DAC_C1_DACBFMD_MASK, DAC_C1_DACBFMD(value)))
#define DAC_BWR_C1_DACBFMD(base, value) (DAC_WR_C1_DACBFMD(base, value))
/*@}*/

/*!
 * @name Register DAC_C1, field DACBFWM[4:3] (RW)
 *
 * Controls when SR[DACBFWMF] is set. When the DAC buffer read pointer reaches
 * the word defined by this field, which is 1-4 words away from the upper limit
 * (DACBUP), SR[DACBFWMF] will be set. This allows user configuration of the
 * watermark interrupt.
 *
 * Values:
 * - 0b00 - 1 word
 * - 0b01 - 2 words
 * - 0b10 - 3 words
 * - 0b11 - 4 words
 */
/*@{*/
/*! @brief Read current value of the DAC_C1_DACBFWM field. */
#define DAC_RD_C1_DACBFWM(base) ((DAC_C1_REG(base) & DAC_C1_DACBFWM_MASK) >> DAC_C1_DACBFWM_SHIFT)
#define DAC_BRD_C1_DACBFWM(base) (DAC_RD_C1_DACBFWM(base))

/*! @brief Set the DACBFWM field to a new value. */
#define DAC_WR_C1_DACBFWM(base, value) (DAC_RMW_C1(base, DAC_C1_DACBFWM_MASK, DAC_C1_DACBFWM(value)))
#define DAC_BWR_C1_DACBFWM(base, value) (DAC_WR_C1_DACBFWM(base, value))
/*@}*/

/*!
 * @name Register DAC_C1, field DMAEN[7] (RW)
 *
 * Values:
 * - 0b0 - DMA is disabled.
 * - 0b1 - DMA is enabled. When DMA is enabled, the DMA request will be
 *     generated by original interrupts. The interrupts will not be presented on this
 *     module at the same time.
 */
/*@{*/
/*! @brief Read current value of the DAC_C1_DMAEN field. */
#define DAC_RD_C1_DMAEN(base) ((DAC_C1_REG(base) & DAC_C1_DMAEN_MASK) >> DAC_C1_DMAEN_SHIFT)
#define DAC_BRD_C1_DMAEN(base) (BITBAND_ACCESS8(&DAC_C1_REG(base), DAC_C1_DMAEN_SHIFT))

/*! @brief Set the DMAEN field to a new value. */
#define DAC_WR_C1_DMAEN(base, value) (DAC_RMW_C1(base, DAC_C1_DMAEN_MASK, DAC_C1_DMAEN(value)))
#define DAC_BWR_C1_DMAEN(base, value) (BITBAND_ACCESS8(&DAC_C1_REG(base), DAC_C1_DMAEN_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DAC_C2 - DAC Control Register 2
 ******************************************************************************/

/*!
 * @brief DAC_C2 - DAC Control Register 2 (RW)
 *
 * Reset value: 0x0FU
 */
/*!
 * @name Constants and macros for entire DAC_C2 register
 */
/*@{*/
#define DAC_RD_C2(base)          (DAC_C2_REG(base))
#define DAC_WR_C2(base, value)   (DAC_C2_REG(base) = (value))
#define DAC_RMW_C2(base, mask, value) (DAC_WR_C2(base, (DAC_RD_C2(base) & ~(mask)) | (value)))
#define DAC_SET_C2(base, value)  (DAC_WR_C2(base, DAC_RD_C2(base) |  (value)))
#define DAC_CLR_C2(base, value)  (DAC_WR_C2(base, DAC_RD_C2(base) & ~(value)))
#define DAC_TOG_C2(base, value)  (DAC_WR_C2(base, DAC_RD_C2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DAC_C2 bitfields
 */

/*!
 * @name Register DAC_C2, field DACBFUP[3:0] (RW)
 *
 * Selects the upper limit of the DAC buffer. The buffer read pointer cannot
 * exceed it.
 */
/*@{*/
/*! @brief Read current value of the DAC_C2_DACBFUP field. */
#define DAC_RD_C2_DACBFUP(base) ((DAC_C2_REG(base) & DAC_C2_DACBFUP_MASK) >> DAC_C2_DACBFUP_SHIFT)
#define DAC_BRD_C2_DACBFUP(base) (DAC_RD_C2_DACBFUP(base))

/*! @brief Set the DACBFUP field to a new value. */
#define DAC_WR_C2_DACBFUP(base, value) (DAC_RMW_C2(base, DAC_C2_DACBFUP_MASK, DAC_C2_DACBFUP(value)))
#define DAC_BWR_C2_DACBFUP(base, value) (DAC_WR_C2_DACBFUP(base, value))
/*@}*/

/*!
 * @name Register DAC_C2, field DACBFRP[7:4] (RW)
 *
 * Keeps the current value of the buffer read pointer.
 */
/*@{*/
/*! @brief Read current value of the DAC_C2_DACBFRP field. */
#define DAC_RD_C2_DACBFRP(base) ((DAC_C2_REG(base) & DAC_C2_DACBFRP_MASK) >> DAC_C2_DACBFRP_SHIFT)
#define DAC_BRD_C2_DACBFRP(base) (DAC_RD_C2_DACBFRP(base))

/*! @brief Set the DACBFRP field to a new value. */
#define DAC_WR_C2_DACBFRP(base, value) (DAC_RMW_C2(base, DAC_C2_DACBFRP_MASK, DAC_C2_DACBFRP(value)))
#define DAC_BWR_C2_DACBFRP(base, value) (DAC_WR_C2_DACBFRP(base, value))
/*@}*/

/*
 * MK64F12 DMA
 *
 * Enhanced direct memory access controller
 *
 * Registers defined in this header file:
 * - DMA_CR - Control Register
 * - DMA_ES - Error Status Register
 * - DMA_ERQ - Enable Request Register
 * - DMA_EEI - Enable Error Interrupt Register
 * - DMA_CEEI - Clear Enable Error Interrupt Register
 * - DMA_SEEI - Set Enable Error Interrupt Register
 * - DMA_CERQ - Clear Enable Request Register
 * - DMA_SERQ - Set Enable Request Register
 * - DMA_CDNE - Clear DONE Status Bit Register
 * - DMA_SSRT - Set START Bit Register
 * - DMA_CERR - Clear Error Register
 * - DMA_CINT - Clear Interrupt Request Register
 * - DMA_INT - Interrupt Request Register
 * - DMA_ERR - Error Register
 * - DMA_HRS - Hardware Request Status Register
 * - DMA_DCHPRI3 - Channel n Priority Register
 * - DMA_DCHPRI2 - Channel n Priority Register
 * - DMA_DCHPRI1 - Channel n Priority Register
 * - DMA_DCHPRI0 - Channel n Priority Register
 * - DMA_DCHPRI7 - Channel n Priority Register
 * - DMA_DCHPRI6 - Channel n Priority Register
 * - DMA_DCHPRI5 - Channel n Priority Register
 * - DMA_DCHPRI4 - Channel n Priority Register
 * - DMA_DCHPRI11 - Channel n Priority Register
 * - DMA_DCHPRI10 - Channel n Priority Register
 * - DMA_DCHPRI9 - Channel n Priority Register
 * - DMA_DCHPRI8 - Channel n Priority Register
 * - DMA_DCHPRI15 - Channel n Priority Register
 * - DMA_DCHPRI14 - Channel n Priority Register
 * - DMA_DCHPRI13 - Channel n Priority Register
 * - DMA_DCHPRI12 - Channel n Priority Register
 * - DMA_SADDR - TCD Source Address
 * - DMA_SOFF - TCD Signed Source Address Offset
 * - DMA_ATTR - TCD Transfer Attributes
 * - DMA_NBYTES_MLNO - TCD Minor Byte Count (Minor Loop Disabled)
 * - DMA_NBYTES_MLOFFNO - TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled)
 * - DMA_NBYTES_MLOFFYES - TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled)
 * - DMA_SLAST - TCD Last Source Address Adjustment
 * - DMA_DADDR - TCD Destination Address
 * - DMA_DOFF - TCD Signed Destination Address Offset
 * - DMA_CITER_ELINKNO - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
 * - DMA_CITER_ELINKYES - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled)
 * - DMA_DLAST_SGA - TCD Last Destination Address Adjustment/Scatter Gather Address
 * - DMA_CSR - TCD Control and Status
 * - DMA_BITER_ELINKNO - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
 * - DMA_BITER_ELINKYES - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled)
 */

#define DMA_INSTANCE_COUNT (1U) /*!< Number of instances of the DMA module. */
#define DMA_IDX (0U) /*!< Instance number for DMA. */

/*******************************************************************************
 * DMA_CR - Control Register
 ******************************************************************************/

/*!
 * @brief DMA_CR - Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The CR defines the basic operating configuration of the DMA. Arbitration can
 * be configured to use either a fixed-priority or a round-robin scheme. For
 * fixed-priority arbitration, the highest priority channel requesting service is
 * selected to execute. The channel priority registers assign the priorities; see
 * the DCHPRIn registers. For round-robin arbitration, the channel priorities are
 * ignored and channels are cycled through (from high to low channel number)
 * without regard to priority. For correct operation, writes to the CR register must
 * be performed only when the DMA channels are inactive; that is, when
 * TCDn_CSR[ACTIVE] bits are cleared. Minor loop offsets are address offset values added to
 * the final source address (TCDn_SADDR) or destination address (TCDn_DADDR) upon
 * minor loop completion. When minor loop offsets are enabled, the minor loop
 * offset (MLOFF) is added to the final source address (TCDn_SADDR), to the final
 * destination address (TCDn_DADDR), or to both prior to the addresses being
 * written back into the TCD. If the major loop is complete, the minor loop offset is
 * ignored and the major loop address offsets (TCDn_SLAST and TCDn_DLAST_SGA) are
 * used to compute the next TCDn_SADDR and TCDn_DADDR values. When minor loop
 * mapping is enabled (EMLM is 1), TCDn word2 is redefined. A portion of TCDn word2
 * is used to specify multiple fields: a source enable bit (SMLOE) to specify
 * the minor loop offset should be applied to the source address (TCDn_SADDR) upon
 * minor loop completion, a destination enable bit (DMLOE) to specify the minor
 * loop offset should be applied to the destination address (TCDn_DADDR) upon
 * minor loop completion, and the sign extended minor loop offset value (MLOFF). The
 * same offset value (MLOFF) is used for both source and destination minor loop
 * offsets. When either minor loop offset is enabled (SMLOE set or DMLOE set), the
 * NBYTES field is reduced to 10 bits. When both minor loop offsets are disabled
 * (SMLOE cleared and DMLOE cleared), the NBYTES field is a 30-bit vector. When
 * minor loop mapping is disabled (EMLM is 0), all 32 bits of TCDn word2 are
 * assigned to the NBYTES field.
 */
/*!
 * @name Constants and macros for entire DMA_CR register
 */
/*@{*/
#define DMA_RD_CR(base)          (DMA_CR_REG(base))
#define DMA_WR_CR(base, value)   (DMA_CR_REG(base) = (value))
#define DMA_RMW_CR(base, mask, value) (DMA_WR_CR(base, (DMA_RD_CR(base) & ~(mask)) | (value)))
#define DMA_SET_CR(base, value)  (DMA_WR_CR(base, DMA_RD_CR(base) |  (value)))
#define DMA_CLR_CR(base, value)  (DMA_WR_CR(base, DMA_RD_CR(base) & ~(value)))
#define DMA_TOG_CR(base, value)  (DMA_WR_CR(base, DMA_RD_CR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CR bitfields
 */

/*!
 * @name Register DMA_CR, field EDBG[1] (RW)
 *
 * Values:
 * - 0b0 - When in debug mode, the DMA continues to operate.
 * - 0b1 - When in debug mode, the DMA stalls the start of a new channel.
 *     Executing channels are allowed to complete. Channel execution resumes when the
 *     system exits debug mode or the EDBG bit is cleared.
 */
/*@{*/
/*! @brief Read current value of the DMA_CR_EDBG field. */
#define DMA_RD_CR_EDBG(base) ((DMA_CR_REG(base) & DMA_CR_EDBG_MASK) >> DMA_CR_EDBG_SHIFT)
#define DMA_BRD_CR_EDBG(base) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_EDBG_SHIFT))

/*! @brief Set the EDBG field to a new value. */
#define DMA_WR_CR_EDBG(base, value) (DMA_RMW_CR(base, DMA_CR_EDBG_MASK, DMA_CR_EDBG(value)))
#define DMA_BWR_CR_EDBG(base, value) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_EDBG_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CR, field ERCA[2] (RW)
 *
 * Values:
 * - 0b0 - Fixed priority arbitration is used for channel selection .
 * - 0b1 - Round robin arbitration is used for channel selection .
 */
/*@{*/
/*! @brief Read current value of the DMA_CR_ERCA field. */
#define DMA_RD_CR_ERCA(base) ((DMA_CR_REG(base) & DMA_CR_ERCA_MASK) >> DMA_CR_ERCA_SHIFT)
#define DMA_BRD_CR_ERCA(base) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_ERCA_SHIFT))

/*! @brief Set the ERCA field to a new value. */
#define DMA_WR_CR_ERCA(base, value) (DMA_RMW_CR(base, DMA_CR_ERCA_MASK, DMA_CR_ERCA(value)))
#define DMA_BWR_CR_ERCA(base, value) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_ERCA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CR, field HOE[4] (RW)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - Any error causes the HALT bit to set. Subsequently, all service
 *     requests are ignored until the HALT bit is cleared.
 */
/*@{*/
/*! @brief Read current value of the DMA_CR_HOE field. */
#define DMA_RD_CR_HOE(base)  ((DMA_CR_REG(base) & DMA_CR_HOE_MASK) >> DMA_CR_HOE_SHIFT)
#define DMA_BRD_CR_HOE(base) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_HOE_SHIFT))

/*! @brief Set the HOE field to a new value. */
#define DMA_WR_CR_HOE(base, value) (DMA_RMW_CR(base, DMA_CR_HOE_MASK, DMA_CR_HOE(value)))
#define DMA_BWR_CR_HOE(base, value) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_HOE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CR, field HALT[5] (RW)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - Stall the start of any new channels. Executing channels are allowed
 *     to complete. Channel execution resumes when this bit is cleared.
 */
/*@{*/
/*! @brief Read current value of the DMA_CR_HALT field. */
#define DMA_RD_CR_HALT(base) ((DMA_CR_REG(base) & DMA_CR_HALT_MASK) >> DMA_CR_HALT_SHIFT)
#define DMA_BRD_CR_HALT(base) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_HALT_SHIFT))

/*! @brief Set the HALT field to a new value. */
#define DMA_WR_CR_HALT(base, value) (DMA_RMW_CR(base, DMA_CR_HALT_MASK, DMA_CR_HALT(value)))
#define DMA_BWR_CR_HALT(base, value) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_HALT_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CR, field CLM[6] (RW)
 *
 * Values:
 * - 0b0 - A minor loop channel link made to itself goes through channel
 *     arbitration before being activated again.
 * - 0b1 - A minor loop channel link made to itself does not go through channel
 *     arbitration before being activated again. Upon minor loop completion, the
 *     channel activates again if that channel has a minor loop channel link
 *     enabled and the link channel is itself. This effectively applies the minor
 *     loop offsets and restarts the next minor loop.
 */
/*@{*/
/*! @brief Read current value of the DMA_CR_CLM field. */
#define DMA_RD_CR_CLM(base)  ((DMA_CR_REG(base) & DMA_CR_CLM_MASK) >> DMA_CR_CLM_SHIFT)
#define DMA_BRD_CR_CLM(base) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_CLM_SHIFT))

/*! @brief Set the CLM field to a new value. */
#define DMA_WR_CR_CLM(base, value) (DMA_RMW_CR(base, DMA_CR_CLM_MASK, DMA_CR_CLM(value)))
#define DMA_BWR_CR_CLM(base, value) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_CLM_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CR, field EMLM[7] (RW)
 *
 * Values:
 * - 0b0 - Disabled. TCDn.word2 is defined as a 32-bit NBYTES field.
 * - 0b1 - Enabled. TCDn.word2 is redefined to include individual enable fields,
 *     an offset field, and the NBYTES field. The individual enable fields allow
 *     the minor loop offset to be applied to the source address, the
 *     destination address, or both. The NBYTES field is reduced when either offset is
 *     enabled.
 */
/*@{*/
/*! @brief Read current value of the DMA_CR_EMLM field. */
#define DMA_RD_CR_EMLM(base) ((DMA_CR_REG(base) & DMA_CR_EMLM_MASK) >> DMA_CR_EMLM_SHIFT)
#define DMA_BRD_CR_EMLM(base) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_EMLM_SHIFT))

/*! @brief Set the EMLM field to a new value. */
#define DMA_WR_CR_EMLM(base, value) (DMA_RMW_CR(base, DMA_CR_EMLM_MASK, DMA_CR_EMLM(value)))
#define DMA_BWR_CR_EMLM(base, value) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_EMLM_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CR, field ECX[16] (RW)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - Cancel the remaining data transfer in the same fashion as the CX bit.
 *     Stop the executing channel and force the minor loop to finish. The cancel
 *     takes effect after the last write of the current read/write sequence. The
 *     ECX bit clears itself after the cancel is honored. In addition to
 *     cancelling the transfer, ECX treats the cancel as an error condition, thus
 *     updating the Error Status register (DMAx_ES) and generating an optional error
 *     interrupt.
 */
/*@{*/
/*! @brief Read current value of the DMA_CR_ECX field. */
#define DMA_RD_CR_ECX(base)  ((DMA_CR_REG(base) & DMA_CR_ECX_MASK) >> DMA_CR_ECX_SHIFT)
#define DMA_BRD_CR_ECX(base) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_ECX_SHIFT))

/*! @brief Set the ECX field to a new value. */
#define DMA_WR_CR_ECX(base, value) (DMA_RMW_CR(base, DMA_CR_ECX_MASK, DMA_CR_ECX(value)))
#define DMA_BWR_CR_ECX(base, value) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_ECX_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CR, field CX[17] (RW)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - Cancel the remaining data transfer. Stop the executing channel and
 *     force the minor loop to finish. The cancel takes effect after the last write
 *     of the current read/write sequence. The CX bit clears itself after the
 *     cancel has been honored. This cancel retires the channel normally as if the
 *     minor loop was completed.
 */
/*@{*/
/*! @brief Read current value of the DMA_CR_CX field. */
#define DMA_RD_CR_CX(base)   ((DMA_CR_REG(base) & DMA_CR_CX_MASK) >> DMA_CR_CX_SHIFT)
#define DMA_BRD_CR_CX(base)  (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_CX_SHIFT))

/*! @brief Set the CX field to a new value. */
#define DMA_WR_CR_CX(base, value) (DMA_RMW_CR(base, DMA_CR_CX_MASK, DMA_CR_CX(value)))
#define DMA_BWR_CR_CX(base, value) (BITBAND_ACCESS32(&DMA_CR_REG(base), DMA_CR_CX_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_ES - Error Status Register
 ******************************************************************************/

/*!
 * @brief DMA_ES - Error Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The ES provides information concerning the last recorded channel error.
 * Channel errors can be caused by: A configuration error, that is: An illegal setting
 * in the transfer-control descriptor, or An illegal priority register setting
 * in fixed-arbitration An error termination to a bus master read or write cycle
 * See the Error Reporting and Handling section for more details.
 */
/*!
 * @name Constants and macros for entire DMA_ES register
 */
/*@{*/
#define DMA_RD_ES(base)          (DMA_ES_REG(base))
/*@}*/

/*
 * Constants & macros for individual DMA_ES bitfields
 */

/*!
 * @name Register DMA_ES, field DBE[0] (RO)
 *
 * Values:
 * - 0b0 - No destination bus error
 * - 0b1 - The last recorded error was a bus error on a destination write
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_DBE field. */
#define DMA_RD_ES_DBE(base)  ((DMA_ES_REG(base) & DMA_ES_DBE_MASK) >> DMA_ES_DBE_SHIFT)
#define DMA_BRD_ES_DBE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_DBE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field SBE[1] (RO)
 *
 * Values:
 * - 0b0 - No source bus error
 * - 0b1 - The last recorded error was a bus error on a source read
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_SBE field. */
#define DMA_RD_ES_SBE(base)  ((DMA_ES_REG(base) & DMA_ES_SBE_MASK) >> DMA_ES_SBE_SHIFT)
#define DMA_BRD_ES_SBE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_SBE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field SGE[2] (RO)
 *
 * Values:
 * - 0b0 - No scatter/gather configuration error
 * - 0b1 - The last recorded error was a configuration error detected in the
 *     TCDn_DLASTSGA field. This field is checked at the beginning of a
 *     scatter/gather operation after major loop completion if TCDn_CSR[ESG] is enabled.
 *     TCDn_DLASTSGA is not on a 32 byte boundary.
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_SGE field. */
#define DMA_RD_ES_SGE(base)  ((DMA_ES_REG(base) & DMA_ES_SGE_MASK) >> DMA_ES_SGE_SHIFT)
#define DMA_BRD_ES_SGE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_SGE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field NCE[3] (RO)
 *
 * Values:
 * - 0b0 - No NBYTES/CITER configuration error
 * - 0b1 - The last recorded error was a configuration error detected in the
 *     TCDn_NBYTES or TCDn_CITER fields. TCDn_NBYTES is not a multiple of
 *     TCDn_ATTR[SSIZE] and TCDn_ATTR[DSIZE], or TCDn_CITER[CITER] is equal to zero, or
 *     TCDn_CITER[ELINK] is not equal to TCDn_BITER[ELINK]
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_NCE field. */
#define DMA_RD_ES_NCE(base)  ((DMA_ES_REG(base) & DMA_ES_NCE_MASK) >> DMA_ES_NCE_SHIFT)
#define DMA_BRD_ES_NCE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_NCE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field DOE[4] (RO)
 *
 * Values:
 * - 0b0 - No destination offset configuration error
 * - 0b1 - The last recorded error was a configuration error detected in the
 *     TCDn_DOFF field. TCDn_DOFF is inconsistent with TCDn_ATTR[DSIZE].
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_DOE field. */
#define DMA_RD_ES_DOE(base)  ((DMA_ES_REG(base) & DMA_ES_DOE_MASK) >> DMA_ES_DOE_SHIFT)
#define DMA_BRD_ES_DOE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_DOE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field DAE[5] (RO)
 *
 * Values:
 * - 0b0 - No destination address configuration error
 * - 0b1 - The last recorded error was a configuration error detected in the
 *     TCDn_DADDR field. TCDn_DADDR is inconsistent with TCDn_ATTR[DSIZE].
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_DAE field. */
#define DMA_RD_ES_DAE(base)  ((DMA_ES_REG(base) & DMA_ES_DAE_MASK) >> DMA_ES_DAE_SHIFT)
#define DMA_BRD_ES_DAE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_DAE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field SOE[6] (RO)
 *
 * Values:
 * - 0b0 - No source offset configuration error
 * - 0b1 - The last recorded error was a configuration error detected in the
 *     TCDn_SOFF field. TCDn_SOFF is inconsistent with TCDn_ATTR[SSIZE].
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_SOE field. */
#define DMA_RD_ES_SOE(base)  ((DMA_ES_REG(base) & DMA_ES_SOE_MASK) >> DMA_ES_SOE_SHIFT)
#define DMA_BRD_ES_SOE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_SOE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field SAE[7] (RO)
 *
 * Values:
 * - 0b0 - No source address configuration error.
 * - 0b1 - The last recorded error was a configuration error detected in the
 *     TCDn_SADDR field. TCDn_SADDR is inconsistent with TCDn_ATTR[SSIZE].
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_SAE field. */
#define DMA_RD_ES_SAE(base)  ((DMA_ES_REG(base) & DMA_ES_SAE_MASK) >> DMA_ES_SAE_SHIFT)
#define DMA_BRD_ES_SAE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_SAE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field ERRCHN[11:8] (RO)
 *
 * The channel number of the last recorded error (excluding CPE errors) or last
 * recorded error canceled transfer.
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_ERRCHN field. */
#define DMA_RD_ES_ERRCHN(base) ((DMA_ES_REG(base) & DMA_ES_ERRCHN_MASK) >> DMA_ES_ERRCHN_SHIFT)
#define DMA_BRD_ES_ERRCHN(base) (DMA_RD_ES_ERRCHN(base))
/*@}*/

/*!
 * @name Register DMA_ES, field CPE[14] (RO)
 *
 * Values:
 * - 0b0 - No channel priority error
 * - 0b1 - The last recorded error was a configuration error in the channel
 *     priorities . Channel priorities are not unique.
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_CPE field. */
#define DMA_RD_ES_CPE(base)  ((DMA_ES_REG(base) & DMA_ES_CPE_MASK) >> DMA_ES_CPE_SHIFT)
#define DMA_BRD_ES_CPE(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_CPE_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field ECX[16] (RO)
 *
 * Values:
 * - 0b0 - No canceled transfers
 * - 0b1 - The last recorded entry was a canceled transfer by the error cancel
 *     transfer input
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_ECX field. */
#define DMA_RD_ES_ECX(base)  ((DMA_ES_REG(base) & DMA_ES_ECX_MASK) >> DMA_ES_ECX_SHIFT)
#define DMA_BRD_ES_ECX(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_ECX_SHIFT))
/*@}*/

/*!
 * @name Register DMA_ES, field VLD[31] (RO)
 *
 * Logical OR of all ERR status bits
 *
 * Values:
 * - 0b0 - No ERR bits are set
 * - 0b1 - At least one ERR bit is set indicating a valid error exists that has
 *     not been cleared
 */
/*@{*/
/*! @brief Read current value of the DMA_ES_VLD field. */
#define DMA_RD_ES_VLD(base)  ((DMA_ES_REG(base) & DMA_ES_VLD_MASK) >> DMA_ES_VLD_SHIFT)
#define DMA_BRD_ES_VLD(base) (BITBAND_ACCESS32(&DMA_ES_REG(base), DMA_ES_VLD_SHIFT))
/*@}*/

/*******************************************************************************
 * DMA_ERQ - Enable Request Register
 ******************************************************************************/

/*!
 * @brief DMA_ERQ - Enable Request Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ERQ register provides a bit map for the 16 implemented channels to enable
 * the request signal for each channel. The state of any given channel enable is
 * directly affected by writes to this register; it is also affected by writes
 * to the SERQ and CERQ. The {S,C}ERQ registers are provided so the request enable
 * for a single channel can easily be modified without needing to perform a
 * read-modify-write sequence to the ERQ. DMA request input signals and this enable
 * request flag must be asserted before a channel's hardware service request is
 * accepted. The state of the DMA enable request flag does not affect a channel
 * service request made explicitly through software or a linked channel request.
 */
/*!
 * @name Constants and macros for entire DMA_ERQ register
 */
/*@{*/
#define DMA_RD_ERQ(base)         (DMA_ERQ_REG(base))
#define DMA_WR_ERQ(base, value)  (DMA_ERQ_REG(base) = (value))
#define DMA_RMW_ERQ(base, mask, value) (DMA_WR_ERQ(base, (DMA_RD_ERQ(base) & ~(mask)) | (value)))
#define DMA_SET_ERQ(base, value) (DMA_WR_ERQ(base, DMA_RD_ERQ(base) |  (value)))
#define DMA_CLR_ERQ(base, value) (DMA_WR_ERQ(base, DMA_RD_ERQ(base) & ~(value)))
#define DMA_TOG_ERQ(base, value) (DMA_WR_ERQ(base, DMA_RD_ERQ(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_ERQ bitfields
 */

/*!
 * @name Register DMA_ERQ, field ERQ0[0] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ0 field. */
#define DMA_RD_ERQ_ERQ0(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ0_MASK) >> DMA_ERQ_ERQ0_SHIFT)
#define DMA_BRD_ERQ_ERQ0(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ0_SHIFT))

/*! @brief Set the ERQ0 field to a new value. */
#define DMA_WR_ERQ_ERQ0(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ0_MASK, DMA_ERQ_ERQ0(value)))
#define DMA_BWR_ERQ_ERQ0(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ1[1] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ1 field. */
#define DMA_RD_ERQ_ERQ1(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ1_MASK) >> DMA_ERQ_ERQ1_SHIFT)
#define DMA_BRD_ERQ_ERQ1(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ1_SHIFT))

/*! @brief Set the ERQ1 field to a new value. */
#define DMA_WR_ERQ_ERQ1(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ1_MASK, DMA_ERQ_ERQ1(value)))
#define DMA_BWR_ERQ_ERQ1(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ2[2] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ2 field. */
#define DMA_RD_ERQ_ERQ2(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ2_MASK) >> DMA_ERQ_ERQ2_SHIFT)
#define DMA_BRD_ERQ_ERQ2(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ2_SHIFT))

/*! @brief Set the ERQ2 field to a new value. */
#define DMA_WR_ERQ_ERQ2(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ2_MASK, DMA_ERQ_ERQ2(value)))
#define DMA_BWR_ERQ_ERQ2(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ3[3] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ3 field. */
#define DMA_RD_ERQ_ERQ3(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ3_MASK) >> DMA_ERQ_ERQ3_SHIFT)
#define DMA_BRD_ERQ_ERQ3(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ3_SHIFT))

/*! @brief Set the ERQ3 field to a new value. */
#define DMA_WR_ERQ_ERQ3(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ3_MASK, DMA_ERQ_ERQ3(value)))
#define DMA_BWR_ERQ_ERQ3(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ4[4] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ4 field. */
#define DMA_RD_ERQ_ERQ4(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ4_MASK) >> DMA_ERQ_ERQ4_SHIFT)
#define DMA_BRD_ERQ_ERQ4(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ4_SHIFT))

/*! @brief Set the ERQ4 field to a new value. */
#define DMA_WR_ERQ_ERQ4(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ4_MASK, DMA_ERQ_ERQ4(value)))
#define DMA_BWR_ERQ_ERQ4(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ5[5] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ5 field. */
#define DMA_RD_ERQ_ERQ5(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ5_MASK) >> DMA_ERQ_ERQ5_SHIFT)
#define DMA_BRD_ERQ_ERQ5(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ5_SHIFT))

/*! @brief Set the ERQ5 field to a new value. */
#define DMA_WR_ERQ_ERQ5(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ5_MASK, DMA_ERQ_ERQ5(value)))
#define DMA_BWR_ERQ_ERQ5(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ6[6] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ6 field. */
#define DMA_RD_ERQ_ERQ6(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ6_MASK) >> DMA_ERQ_ERQ6_SHIFT)
#define DMA_BRD_ERQ_ERQ6(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ6_SHIFT))

/*! @brief Set the ERQ6 field to a new value. */
#define DMA_WR_ERQ_ERQ6(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ6_MASK, DMA_ERQ_ERQ6(value)))
#define DMA_BWR_ERQ_ERQ6(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ7[7] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ7 field. */
#define DMA_RD_ERQ_ERQ7(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ7_MASK) >> DMA_ERQ_ERQ7_SHIFT)
#define DMA_BRD_ERQ_ERQ7(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ7_SHIFT))

/*! @brief Set the ERQ7 field to a new value. */
#define DMA_WR_ERQ_ERQ7(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ7_MASK, DMA_ERQ_ERQ7(value)))
#define DMA_BWR_ERQ_ERQ7(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ8[8] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ8 field. */
#define DMA_RD_ERQ_ERQ8(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ8_MASK) >> DMA_ERQ_ERQ8_SHIFT)
#define DMA_BRD_ERQ_ERQ8(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ8_SHIFT))

/*! @brief Set the ERQ8 field to a new value. */
#define DMA_WR_ERQ_ERQ8(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ8_MASK, DMA_ERQ_ERQ8(value)))
#define DMA_BWR_ERQ_ERQ8(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ8_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ9[9] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ9 field. */
#define DMA_RD_ERQ_ERQ9(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ9_MASK) >> DMA_ERQ_ERQ9_SHIFT)
#define DMA_BRD_ERQ_ERQ9(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ9_SHIFT))

/*! @brief Set the ERQ9 field to a new value. */
#define DMA_WR_ERQ_ERQ9(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ9_MASK, DMA_ERQ_ERQ9(value)))
#define DMA_BWR_ERQ_ERQ9(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ9_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ10[10] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ10 field. */
#define DMA_RD_ERQ_ERQ10(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ10_MASK) >> DMA_ERQ_ERQ10_SHIFT)
#define DMA_BRD_ERQ_ERQ10(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ10_SHIFT))

/*! @brief Set the ERQ10 field to a new value. */
#define DMA_WR_ERQ_ERQ10(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ10_MASK, DMA_ERQ_ERQ10(value)))
#define DMA_BWR_ERQ_ERQ10(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ10_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ11[11] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ11 field. */
#define DMA_RD_ERQ_ERQ11(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ11_MASK) >> DMA_ERQ_ERQ11_SHIFT)
#define DMA_BRD_ERQ_ERQ11(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ11_SHIFT))

/*! @brief Set the ERQ11 field to a new value. */
#define DMA_WR_ERQ_ERQ11(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ11_MASK, DMA_ERQ_ERQ11(value)))
#define DMA_BWR_ERQ_ERQ11(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ11_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ12[12] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ12 field. */
#define DMA_RD_ERQ_ERQ12(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ12_MASK) >> DMA_ERQ_ERQ12_SHIFT)
#define DMA_BRD_ERQ_ERQ12(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ12_SHIFT))

/*! @brief Set the ERQ12 field to a new value. */
#define DMA_WR_ERQ_ERQ12(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ12_MASK, DMA_ERQ_ERQ12(value)))
#define DMA_BWR_ERQ_ERQ12(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ12_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ13[13] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ13 field. */
#define DMA_RD_ERQ_ERQ13(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ13_MASK) >> DMA_ERQ_ERQ13_SHIFT)
#define DMA_BRD_ERQ_ERQ13(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ13_SHIFT))

/*! @brief Set the ERQ13 field to a new value. */
#define DMA_WR_ERQ_ERQ13(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ13_MASK, DMA_ERQ_ERQ13(value)))
#define DMA_BWR_ERQ_ERQ13(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ13_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ14[14] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ14 field. */
#define DMA_RD_ERQ_ERQ14(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ14_MASK) >> DMA_ERQ_ERQ14_SHIFT)
#define DMA_BRD_ERQ_ERQ14(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ14_SHIFT))

/*! @brief Set the ERQ14 field to a new value. */
#define DMA_WR_ERQ_ERQ14(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ14_MASK, DMA_ERQ_ERQ14(value)))
#define DMA_BWR_ERQ_ERQ14(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ14_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ15[15] (RW)
 *
 * Values:
 * - 0b0 - The DMA request signal for the corresponding channel is disabled
 * - 0b1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ERQ_ERQ15 field. */
#define DMA_RD_ERQ_ERQ15(base) ((DMA_ERQ_REG(base) & DMA_ERQ_ERQ15_MASK) >> DMA_ERQ_ERQ15_SHIFT)
#define DMA_BRD_ERQ_ERQ15(base) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ15_SHIFT))

/*! @brief Set the ERQ15 field to a new value. */
#define DMA_WR_ERQ_ERQ15(base, value) (DMA_RMW_ERQ(base, DMA_ERQ_ERQ15_MASK, DMA_ERQ_ERQ15(value)))
#define DMA_BWR_ERQ_ERQ15(base, value) (BITBAND_ACCESS32(&DMA_ERQ_REG(base), DMA_ERQ_ERQ15_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_EEI - Enable Error Interrupt Register
 ******************************************************************************/

/*!
 * @brief DMA_EEI - Enable Error Interrupt Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The EEI register provides a bit map for the 16 channels to enable the error
 * interrupt signal for each channel. The state of any given channel's error
 * interrupt enable is directly affected by writes to this register; it is also
 * affected by writes to the SEEI and CEEI. The {S,C}EEI are provided so the error
 * interrupt enable for a single channel can easily be modified without the need to
 * perform a read-modify-write sequence to the EEI register. The DMA error
 * indicator and the error interrupt enable flag must be asserted before an error
 * interrupt request for a given channel is asserted to the interrupt controller.
 */
/*!
 * @name Constants and macros for entire DMA_EEI register
 */
/*@{*/
#define DMA_RD_EEI(base)         (DMA_EEI_REG(base))
#define DMA_WR_EEI(base, value)  (DMA_EEI_REG(base) = (value))
#define DMA_RMW_EEI(base, mask, value) (DMA_WR_EEI(base, (DMA_RD_EEI(base) & ~(mask)) | (value)))
#define DMA_SET_EEI(base, value) (DMA_WR_EEI(base, DMA_RD_EEI(base) |  (value)))
#define DMA_CLR_EEI(base, value) (DMA_WR_EEI(base, DMA_RD_EEI(base) & ~(value)))
#define DMA_TOG_EEI(base, value) (DMA_WR_EEI(base, DMA_RD_EEI(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_EEI bitfields
 */

/*!
 * @name Register DMA_EEI, field EEI0[0] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI0 field. */
#define DMA_RD_EEI_EEI0(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI0_MASK) >> DMA_EEI_EEI0_SHIFT)
#define DMA_BRD_EEI_EEI0(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI0_SHIFT))

/*! @brief Set the EEI0 field to a new value. */
#define DMA_WR_EEI_EEI0(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI0_MASK, DMA_EEI_EEI0(value)))
#define DMA_BWR_EEI_EEI0(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI1[1] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI1 field. */
#define DMA_RD_EEI_EEI1(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI1_MASK) >> DMA_EEI_EEI1_SHIFT)
#define DMA_BRD_EEI_EEI1(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI1_SHIFT))

/*! @brief Set the EEI1 field to a new value. */
#define DMA_WR_EEI_EEI1(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI1_MASK, DMA_EEI_EEI1(value)))
#define DMA_BWR_EEI_EEI1(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI2[2] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI2 field. */
#define DMA_RD_EEI_EEI2(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI2_MASK) >> DMA_EEI_EEI2_SHIFT)
#define DMA_BRD_EEI_EEI2(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI2_SHIFT))

/*! @brief Set the EEI2 field to a new value. */
#define DMA_WR_EEI_EEI2(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI2_MASK, DMA_EEI_EEI2(value)))
#define DMA_BWR_EEI_EEI2(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI3[3] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI3 field. */
#define DMA_RD_EEI_EEI3(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI3_MASK) >> DMA_EEI_EEI3_SHIFT)
#define DMA_BRD_EEI_EEI3(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI3_SHIFT))

/*! @brief Set the EEI3 field to a new value. */
#define DMA_WR_EEI_EEI3(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI3_MASK, DMA_EEI_EEI3(value)))
#define DMA_BWR_EEI_EEI3(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI4[4] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI4 field. */
#define DMA_RD_EEI_EEI4(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI4_MASK) >> DMA_EEI_EEI4_SHIFT)
#define DMA_BRD_EEI_EEI4(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI4_SHIFT))

/*! @brief Set the EEI4 field to a new value. */
#define DMA_WR_EEI_EEI4(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI4_MASK, DMA_EEI_EEI4(value)))
#define DMA_BWR_EEI_EEI4(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI5[5] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI5 field. */
#define DMA_RD_EEI_EEI5(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI5_MASK) >> DMA_EEI_EEI5_SHIFT)
#define DMA_BRD_EEI_EEI5(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI5_SHIFT))

/*! @brief Set the EEI5 field to a new value. */
#define DMA_WR_EEI_EEI5(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI5_MASK, DMA_EEI_EEI5(value)))
#define DMA_BWR_EEI_EEI5(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI6[6] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI6 field. */
#define DMA_RD_EEI_EEI6(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI6_MASK) >> DMA_EEI_EEI6_SHIFT)
#define DMA_BRD_EEI_EEI6(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI6_SHIFT))

/*! @brief Set the EEI6 field to a new value. */
#define DMA_WR_EEI_EEI6(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI6_MASK, DMA_EEI_EEI6(value)))
#define DMA_BWR_EEI_EEI6(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI7[7] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI7 field. */
#define DMA_RD_EEI_EEI7(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI7_MASK) >> DMA_EEI_EEI7_SHIFT)
#define DMA_BRD_EEI_EEI7(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI7_SHIFT))

/*! @brief Set the EEI7 field to a new value. */
#define DMA_WR_EEI_EEI7(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI7_MASK, DMA_EEI_EEI7(value)))
#define DMA_BWR_EEI_EEI7(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI8[8] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI8 field. */
#define DMA_RD_EEI_EEI8(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI8_MASK) >> DMA_EEI_EEI8_SHIFT)
#define DMA_BRD_EEI_EEI8(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI8_SHIFT))

/*! @brief Set the EEI8 field to a new value. */
#define DMA_WR_EEI_EEI8(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI8_MASK, DMA_EEI_EEI8(value)))
#define DMA_BWR_EEI_EEI8(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI8_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI9[9] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI9 field. */
#define DMA_RD_EEI_EEI9(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI9_MASK) >> DMA_EEI_EEI9_SHIFT)
#define DMA_BRD_EEI_EEI9(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI9_SHIFT))

/*! @brief Set the EEI9 field to a new value. */
#define DMA_WR_EEI_EEI9(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI9_MASK, DMA_EEI_EEI9(value)))
#define DMA_BWR_EEI_EEI9(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI9_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI10[10] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI10 field. */
#define DMA_RD_EEI_EEI10(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI10_MASK) >> DMA_EEI_EEI10_SHIFT)
#define DMA_BRD_EEI_EEI10(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI10_SHIFT))

/*! @brief Set the EEI10 field to a new value. */
#define DMA_WR_EEI_EEI10(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI10_MASK, DMA_EEI_EEI10(value)))
#define DMA_BWR_EEI_EEI10(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI10_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI11[11] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI11 field. */
#define DMA_RD_EEI_EEI11(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI11_MASK) >> DMA_EEI_EEI11_SHIFT)
#define DMA_BRD_EEI_EEI11(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI11_SHIFT))

/*! @brief Set the EEI11 field to a new value. */
#define DMA_WR_EEI_EEI11(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI11_MASK, DMA_EEI_EEI11(value)))
#define DMA_BWR_EEI_EEI11(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI11_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI12[12] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI12 field. */
#define DMA_RD_EEI_EEI12(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI12_MASK) >> DMA_EEI_EEI12_SHIFT)
#define DMA_BRD_EEI_EEI12(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI12_SHIFT))

/*! @brief Set the EEI12 field to a new value. */
#define DMA_WR_EEI_EEI12(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI12_MASK, DMA_EEI_EEI12(value)))
#define DMA_BWR_EEI_EEI12(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI12_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI13[13] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI13 field. */
#define DMA_RD_EEI_EEI13(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI13_MASK) >> DMA_EEI_EEI13_SHIFT)
#define DMA_BRD_EEI_EEI13(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI13_SHIFT))

/*! @brief Set the EEI13 field to a new value. */
#define DMA_WR_EEI_EEI13(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI13_MASK, DMA_EEI_EEI13(value)))
#define DMA_BWR_EEI_EEI13(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI13_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI14[14] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI14 field. */
#define DMA_RD_EEI_EEI14(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI14_MASK) >> DMA_EEI_EEI14_SHIFT)
#define DMA_BRD_EEI_EEI14(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI14_SHIFT))

/*! @brief Set the EEI14 field to a new value. */
#define DMA_WR_EEI_EEI14(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI14_MASK, DMA_EEI_EEI14(value)))
#define DMA_BWR_EEI_EEI14(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI14_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI15[15] (RW)
 *
 * Values:
 * - 0b0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 0b1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
/*! @brief Read current value of the DMA_EEI_EEI15 field. */
#define DMA_RD_EEI_EEI15(base) ((DMA_EEI_REG(base) & DMA_EEI_EEI15_MASK) >> DMA_EEI_EEI15_SHIFT)
#define DMA_BRD_EEI_EEI15(base) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI15_SHIFT))

/*! @brief Set the EEI15 field to a new value. */
#define DMA_WR_EEI_EEI15(base, value) (DMA_RMW_EEI(base, DMA_EEI_EEI15_MASK, DMA_EEI_EEI15(value)))
#define DMA_BWR_EEI_EEI15(base, value) (BITBAND_ACCESS32(&DMA_EEI_REG(base), DMA_EEI_EEI15_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_CEEI - Clear Enable Error Interrupt Register
 ******************************************************************************/

/*!
 * @brief DMA_CEEI - Clear Enable Error Interrupt Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CEEI provides a simple memory-mapped mechanism to clear a given bit in
 * the EEI to disable the error interrupt for a given channel. The data value on a
 * register write causes the corresponding bit in the EEI to be cleared. Setting
 * the CAEE bit provides a global clear function, forcing the EEI contents to be
 * cleared, disabling all DMA request inputs. If the NOP bit is set, the command
 * is ignored. This allows you to write multiple-byte registers as a 32-bit word.
 * Reads of this register return all zeroes.
 */
/*!
 * @name Constants and macros for entire DMA_CEEI register
 */
/*@{*/
#define DMA_RD_CEEI(base)        (DMA_CEEI_REG(base))
#define DMA_WR_CEEI(base, value) (DMA_CEEI_REG(base) = (value))
#define DMA_RMW_CEEI(base, mask, value) (DMA_WR_CEEI(base, (DMA_RD_CEEI(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CEEI bitfields
 */

/*!
 * @name Register DMA_CEEI, field CEEI[3:0] (WORZ)
 *
 * Clears the corresponding bit in EEI
 */
/*@{*/
/*! @brief Set the CEEI field to a new value. */
#define DMA_WR_CEEI_CEEI(base, value) (DMA_RMW_CEEI(base, DMA_CEEI_CEEI_MASK, DMA_CEEI_CEEI(value)))
#define DMA_BWR_CEEI_CEEI(base, value) (DMA_WR_CEEI_CEEI(base, value))
/*@}*/

/*!
 * @name Register DMA_CEEI, field CAEE[6] (WORZ)
 *
 * Values:
 * - 0b0 - Clear only the EEI bit specified in the CEEI field
 * - 0b1 - Clear all bits in EEI
 */
/*@{*/
/*! @brief Set the CAEE field to a new value. */
#define DMA_WR_CEEI_CAEE(base, value) (DMA_RMW_CEEI(base, DMA_CEEI_CAEE_MASK, DMA_CEEI_CAEE(value)))
#define DMA_BWR_CEEI_CAEE(base, value) (BITBAND_ACCESS8(&DMA_CEEI_REG(base), DMA_CEEI_CAEE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CEEI, field NOP[7] (WORZ)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - No operation, ignore the other bits in this register
 */
/*@{*/
/*! @brief Set the NOP field to a new value. */
#define DMA_WR_CEEI_NOP(base, value) (DMA_RMW_CEEI(base, DMA_CEEI_NOP_MASK, DMA_CEEI_NOP(value)))
#define DMA_BWR_CEEI_NOP(base, value) (BITBAND_ACCESS8(&DMA_CEEI_REG(base), DMA_CEEI_NOP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_SEEI - Set Enable Error Interrupt Register
 ******************************************************************************/

/*!
 * @brief DMA_SEEI - Set Enable Error Interrupt Register (WO)
 *
 * Reset value: 0x00U
 *
 * The SEEI provides a simple memory-mapped mechanism to set a given bit in the
 * EEI to enable the error interrupt for a given channel. The data value on a
 * register write causes the corresponding bit in the EEI to be set. Setting the
 * SAEE bit provides a global set function, forcing the entire EEI contents to be
 * set. If the NOP bit is set, the command is ignored. This allows you to write
 * multiple-byte registers as a 32-bit word. Reads of this register return all
 * zeroes.
 */
/*!
 * @name Constants and macros for entire DMA_SEEI register
 */
/*@{*/
#define DMA_RD_SEEI(base)        (DMA_SEEI_REG(base))
#define DMA_WR_SEEI(base, value) (DMA_SEEI_REG(base) = (value))
#define DMA_RMW_SEEI(base, mask, value) (DMA_WR_SEEI(base, (DMA_RD_SEEI(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_SEEI bitfields
 */

/*!
 * @name Register DMA_SEEI, field SEEI[3:0] (WORZ)
 *
 * Sets the corresponding bit in EEI
 */
/*@{*/
/*! @brief Set the SEEI field to a new value. */
#define DMA_WR_SEEI_SEEI(base, value) (DMA_RMW_SEEI(base, DMA_SEEI_SEEI_MASK, DMA_SEEI_SEEI(value)))
#define DMA_BWR_SEEI_SEEI(base, value) (DMA_WR_SEEI_SEEI(base, value))
/*@}*/

/*!
 * @name Register DMA_SEEI, field SAEE[6] (WORZ)
 *
 * Values:
 * - 0b0 - Set only the EEI bit specified in the SEEI field.
 * - 0b1 - Sets all bits in EEI
 */
/*@{*/
/*! @brief Set the SAEE field to a new value. */
#define DMA_WR_SEEI_SAEE(base, value) (DMA_RMW_SEEI(base, DMA_SEEI_SAEE_MASK, DMA_SEEI_SAEE(value)))
#define DMA_BWR_SEEI_SAEE(base, value) (BITBAND_ACCESS8(&DMA_SEEI_REG(base), DMA_SEEI_SAEE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_SEEI, field NOP[7] (WORZ)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - No operation, ignore the other bits in this register
 */
/*@{*/
/*! @brief Set the NOP field to a new value. */
#define DMA_WR_SEEI_NOP(base, value) (DMA_RMW_SEEI(base, DMA_SEEI_NOP_MASK, DMA_SEEI_NOP(value)))
#define DMA_BWR_SEEI_NOP(base, value) (BITBAND_ACCESS8(&DMA_SEEI_REG(base), DMA_SEEI_NOP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_CERQ - Clear Enable Request Register
 ******************************************************************************/

/*!
 * @brief DMA_CERQ - Clear Enable Request Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CERQ provides a simple memory-mapped mechanism to clear a given bit in
 * the ERQ to disable the DMA request for a given channel. The data value on a
 * register write causes the corresponding bit in the ERQ to be cleared. Setting the
 * CAER bit provides a global clear function, forcing the entire contents of the
 * ERQ to be cleared, disabling all DMA request inputs. If NOP is set, the
 * command is ignored. This allows you to write multiple-byte registers as a 32-bit
 * word. Reads of this register return all zeroes.
 */
/*!
 * @name Constants and macros for entire DMA_CERQ register
 */
/*@{*/
#define DMA_RD_CERQ(base)        (DMA_CERQ_REG(base))
#define DMA_WR_CERQ(base, value) (DMA_CERQ_REG(base) = (value))
#define DMA_RMW_CERQ(base, mask, value) (DMA_WR_CERQ(base, (DMA_RD_CERQ(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CERQ bitfields
 */

/*!
 * @name Register DMA_CERQ, field CERQ[3:0] (WORZ)
 *
 * Clears the corresponding bit in ERQ
 */
/*@{*/
/*! @brief Set the CERQ field to a new value. */
#define DMA_WR_CERQ_CERQ(base, value) (DMA_RMW_CERQ(base, DMA_CERQ_CERQ_MASK, DMA_CERQ_CERQ(value)))
#define DMA_BWR_CERQ_CERQ(base, value) (DMA_WR_CERQ_CERQ(base, value))
/*@}*/

/*!
 * @name Register DMA_CERQ, field CAER[6] (WORZ)
 *
 * Values:
 * - 0b0 - Clear only the ERQ bit specified in the CERQ field
 * - 0b1 - Clear all bits in ERQ
 */
/*@{*/
/*! @brief Set the CAER field to a new value. */
#define DMA_WR_CERQ_CAER(base, value) (DMA_RMW_CERQ(base, DMA_CERQ_CAER_MASK, DMA_CERQ_CAER(value)))
#define DMA_BWR_CERQ_CAER(base, value) (BITBAND_ACCESS8(&DMA_CERQ_REG(base), DMA_CERQ_CAER_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CERQ, field NOP[7] (WORZ)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - No operation, ignore the other bits in this register
 */
/*@{*/
/*! @brief Set the NOP field to a new value. */
#define DMA_WR_CERQ_NOP(base, value) (DMA_RMW_CERQ(base, DMA_CERQ_NOP_MASK, DMA_CERQ_NOP(value)))
#define DMA_BWR_CERQ_NOP(base, value) (BITBAND_ACCESS8(&DMA_CERQ_REG(base), DMA_CERQ_NOP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_SERQ - Set Enable Request Register
 ******************************************************************************/

/*!
 * @brief DMA_SERQ - Set Enable Request Register (WO)
 *
 * Reset value: 0x00U
 *
 * The SERQ provides a simple memory-mapped mechanism to set a given bit in the
 * ERQ to enable the DMA request for a given channel. The data value on a
 * register write causes the corresponding bit in the ERQ to be set. Setting the SAER
 * bit provides a global set function, forcing the entire contents of ERQ to be
 * set. If the NOP bit is set, the command is ignored. This allows you to write
 * multiple-byte registers as a 32-bit word. Reads of this register return all zeroes.
 */
/*!
 * @name Constants and macros for entire DMA_SERQ register
 */
/*@{*/
#define DMA_RD_SERQ(base)        (DMA_SERQ_REG(base))
#define DMA_WR_SERQ(base, value) (DMA_SERQ_REG(base) = (value))
#define DMA_RMW_SERQ(base, mask, value) (DMA_WR_SERQ(base, (DMA_RD_SERQ(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_SERQ bitfields
 */

/*!
 * @name Register DMA_SERQ, field SERQ[3:0] (WORZ)
 *
 * Sets the corresponding bit in ERQ
 */
/*@{*/
/*! @brief Set the SERQ field to a new value. */
#define DMA_WR_SERQ_SERQ(base, value) (DMA_RMW_SERQ(base, DMA_SERQ_SERQ_MASK, DMA_SERQ_SERQ(value)))
#define DMA_BWR_SERQ_SERQ(base, value) (DMA_WR_SERQ_SERQ(base, value))
/*@}*/

/*!
 * @name Register DMA_SERQ, field SAER[6] (WORZ)
 *
 * Values:
 * - 0b0 - Set only the ERQ bit specified in the SERQ field
 * - 0b1 - Set all bits in ERQ
 */
/*@{*/
/*! @brief Set the SAER field to a new value. */
#define DMA_WR_SERQ_SAER(base, value) (DMA_RMW_SERQ(base, DMA_SERQ_SAER_MASK, DMA_SERQ_SAER(value)))
#define DMA_BWR_SERQ_SAER(base, value) (BITBAND_ACCESS8(&DMA_SERQ_REG(base), DMA_SERQ_SAER_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_SERQ, field NOP[7] (WORZ)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - No operation, ignore the other bits in this register
 */
/*@{*/
/*! @brief Set the NOP field to a new value. */
#define DMA_WR_SERQ_NOP(base, value) (DMA_RMW_SERQ(base, DMA_SERQ_NOP_MASK, DMA_SERQ_NOP(value)))
#define DMA_BWR_SERQ_NOP(base, value) (BITBAND_ACCESS8(&DMA_SERQ_REG(base), DMA_SERQ_NOP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_CDNE - Clear DONE Status Bit Register
 ******************************************************************************/

/*!
 * @brief DMA_CDNE - Clear DONE Status Bit Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CDNE provides a simple memory-mapped mechanism to clear the DONE bit in
 * the TCD of the given channel. The data value on a register write causes the
 * DONE bit in the corresponding transfer control descriptor to be cleared. Setting
 * the CADN bit provides a global clear function, forcing all DONE bits to be
 * cleared. If the NOP bit is set, the command is ignored. This allows you to write
 * multiple-byte registers as a 32-bit word. Reads of this register return all
 * zeroes.
 */
/*!
 * @name Constants and macros for entire DMA_CDNE register
 */
/*@{*/
#define DMA_RD_CDNE(base)        (DMA_CDNE_REG(base))
#define DMA_WR_CDNE(base, value) (DMA_CDNE_REG(base) = (value))
#define DMA_RMW_CDNE(base, mask, value) (DMA_WR_CDNE(base, (DMA_RD_CDNE(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CDNE bitfields
 */

/*!
 * @name Register DMA_CDNE, field CDNE[3:0] (WORZ)
 *
 * Clears the corresponding bit in TCDn_CSR[DONE]
 */
/*@{*/
/*! @brief Set the CDNE field to a new value. */
#define DMA_WR_CDNE_CDNE(base, value) (DMA_RMW_CDNE(base, DMA_CDNE_CDNE_MASK, DMA_CDNE_CDNE(value)))
#define DMA_BWR_CDNE_CDNE(base, value) (DMA_WR_CDNE_CDNE(base, value))
/*@}*/

/*!
 * @name Register DMA_CDNE, field CADN[6] (WORZ)
 *
 * Values:
 * - 0b0 - Clears only the TCDn_CSR[DONE] bit specified in the CDNE field
 * - 0b1 - Clears all bits in TCDn_CSR[DONE]
 */
/*@{*/
/*! @brief Set the CADN field to a new value. */
#define DMA_WR_CDNE_CADN(base, value) (DMA_RMW_CDNE(base, DMA_CDNE_CADN_MASK, DMA_CDNE_CADN(value)))
#define DMA_BWR_CDNE_CADN(base, value) (BITBAND_ACCESS8(&DMA_CDNE_REG(base), DMA_CDNE_CADN_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CDNE, field NOP[7] (WORZ)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - No operation, ignore the other bits in this register
 */
/*@{*/
/*! @brief Set the NOP field to a new value. */
#define DMA_WR_CDNE_NOP(base, value) (DMA_RMW_CDNE(base, DMA_CDNE_NOP_MASK, DMA_CDNE_NOP(value)))
#define DMA_BWR_CDNE_NOP(base, value) (BITBAND_ACCESS8(&DMA_CDNE_REG(base), DMA_CDNE_NOP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_SSRT - Set START Bit Register
 ******************************************************************************/

/*!
 * @brief DMA_SSRT - Set START Bit Register (WO)
 *
 * Reset value: 0x00U
 *
 * The SSRT provides a simple memory-mapped mechanism to set the START bit in
 * the TCD of the given channel. The data value on a register write causes the
 * START bit in the corresponding transfer control descriptor to be set. Setting the
 * SAST bit provides a global set function, forcing all START bits to be set. If
 * the NOP bit is set, the command is ignored. This allows you to write
 * multiple-byte registers as a 32-bit word. Reads of this register return all zeroes.
 */
/*!
 * @name Constants and macros for entire DMA_SSRT register
 */
/*@{*/
#define DMA_RD_SSRT(base)        (DMA_SSRT_REG(base))
#define DMA_WR_SSRT(base, value) (DMA_SSRT_REG(base) = (value))
#define DMA_RMW_SSRT(base, mask, value) (DMA_WR_SSRT(base, (DMA_RD_SSRT(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_SSRT bitfields
 */

/*!
 * @name Register DMA_SSRT, field SSRT[3:0] (WORZ)
 *
 * Sets the corresponding bit in TCDn_CSR[START]
 */
/*@{*/
/*! @brief Set the SSRT field to a new value. */
#define DMA_WR_SSRT_SSRT(base, value) (DMA_RMW_SSRT(base, DMA_SSRT_SSRT_MASK, DMA_SSRT_SSRT(value)))
#define DMA_BWR_SSRT_SSRT(base, value) (DMA_WR_SSRT_SSRT(base, value))
/*@}*/

/*!
 * @name Register DMA_SSRT, field SAST[6] (WORZ)
 *
 * Values:
 * - 0b0 - Set only the TCDn_CSR[START] bit specified in the SSRT field
 * - 0b1 - Set all bits in TCDn_CSR[START]
 */
/*@{*/
/*! @brief Set the SAST field to a new value. */
#define DMA_WR_SSRT_SAST(base, value) (DMA_RMW_SSRT(base, DMA_SSRT_SAST_MASK, DMA_SSRT_SAST(value)))
#define DMA_BWR_SSRT_SAST(base, value) (BITBAND_ACCESS8(&DMA_SSRT_REG(base), DMA_SSRT_SAST_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_SSRT, field NOP[7] (WORZ)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - No operation, ignore the other bits in this register
 */
/*@{*/
/*! @brief Set the NOP field to a new value. */
#define DMA_WR_SSRT_NOP(base, value) (DMA_RMW_SSRT(base, DMA_SSRT_NOP_MASK, DMA_SSRT_NOP(value)))
#define DMA_BWR_SSRT_NOP(base, value) (BITBAND_ACCESS8(&DMA_SSRT_REG(base), DMA_SSRT_NOP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_CERR - Clear Error Register
 ******************************************************************************/

/*!
 * @brief DMA_CERR - Clear Error Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CERR provides a simple memory-mapped mechanism to clear a given bit in
 * the ERR to disable the error condition flag for a given channel. The given value
 * on a register write causes the corresponding bit in the ERR to be cleared.
 * Setting the CAEI bit provides a global clear function, forcing the ERR contents
 * to be cleared, clearing all channel error indicators. If the NOP bit is set,
 * the command is ignored. This allows you to write multiple-byte registers as a
 * 32-bit word. Reads of this register return all zeroes.
 */
/*!
 * @name Constants and macros for entire DMA_CERR register
 */
/*@{*/
#define DMA_RD_CERR(base)        (DMA_CERR_REG(base))
#define DMA_WR_CERR(base, value) (DMA_CERR_REG(base) = (value))
#define DMA_RMW_CERR(base, mask, value) (DMA_WR_CERR(base, (DMA_RD_CERR(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CERR bitfields
 */

/*!
 * @name Register DMA_CERR, field CERR[3:0] (WORZ)
 *
 * Clears the corresponding bit in ERR
 */
/*@{*/
/*! @brief Set the CERR field to a new value. */
#define DMA_WR_CERR_CERR(base, value) (DMA_RMW_CERR(base, DMA_CERR_CERR_MASK, DMA_CERR_CERR(value)))
#define DMA_BWR_CERR_CERR(base, value) (DMA_WR_CERR_CERR(base, value))
/*@}*/

/*!
 * @name Register DMA_CERR, field CAEI[6] (WORZ)
 *
 * Values:
 * - 0b0 - Clear only the ERR bit specified in the CERR field
 * - 0b1 - Clear all bits in ERR
 */
/*@{*/
/*! @brief Set the CAEI field to a new value. */
#define DMA_WR_CERR_CAEI(base, value) (DMA_RMW_CERR(base, DMA_CERR_CAEI_MASK, DMA_CERR_CAEI(value)))
#define DMA_BWR_CERR_CAEI(base, value) (BITBAND_ACCESS8(&DMA_CERR_REG(base), DMA_CERR_CAEI_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CERR, field NOP[7] (WORZ)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - No operation, ignore the other bits in this register
 */
/*@{*/
/*! @brief Set the NOP field to a new value. */
#define DMA_WR_CERR_NOP(base, value) (DMA_RMW_CERR(base, DMA_CERR_NOP_MASK, DMA_CERR_NOP(value)))
#define DMA_BWR_CERR_NOP(base, value) (BITBAND_ACCESS8(&DMA_CERR_REG(base), DMA_CERR_NOP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_CINT - Clear Interrupt Request Register
 ******************************************************************************/

/*!
 * @brief DMA_CINT - Clear Interrupt Request Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CINT provides a simple, memory-mapped mechanism to clear a given bit in
 * the INT to disable the interrupt request for a given channel. The given value
 * on a register write causes the corresponding bit in the INT to be cleared.
 * Setting the CAIR bit provides a global clear function, forcing the entire contents
 * of the INT to be cleared, disabling all DMA interrupt requests. If the NOP
 * bit is set, the command is ignored. This allows you to write multiple-byte
 * registers as a 32-bit word. Reads of this register return all zeroes.
 */
/*!
 * @name Constants and macros for entire DMA_CINT register
 */
/*@{*/
#define DMA_RD_CINT(base)        (DMA_CINT_REG(base))
#define DMA_WR_CINT(base, value) (DMA_CINT_REG(base) = (value))
#define DMA_RMW_CINT(base, mask, value) (DMA_WR_CINT(base, (DMA_RD_CINT(base) & ~(mask)) | (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CINT bitfields
 */

/*!
 * @name Register DMA_CINT, field CINT[3:0] (WORZ)
 *
 * Clears the corresponding bit in INT
 */
/*@{*/
/*! @brief Set the CINT field to a new value. */
#define DMA_WR_CINT_CINT(base, value) (DMA_RMW_CINT(base, DMA_CINT_CINT_MASK, DMA_CINT_CINT(value)))
#define DMA_BWR_CINT_CINT(base, value) (DMA_WR_CINT_CINT(base, value))
/*@}*/

/*!
 * @name Register DMA_CINT, field CAIR[6] (WORZ)
 *
 * Values:
 * - 0b0 - Clear only the INT bit specified in the CINT field
 * - 0b1 - Clear all bits in INT
 */
/*@{*/
/*! @brief Set the CAIR field to a new value. */
#define DMA_WR_CINT_CAIR(base, value) (DMA_RMW_CINT(base, DMA_CINT_CAIR_MASK, DMA_CINT_CAIR(value)))
#define DMA_BWR_CINT_CAIR(base, value) (BITBAND_ACCESS8(&DMA_CINT_REG(base), DMA_CINT_CAIR_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CINT, field NOP[7] (WORZ)
 *
 * Values:
 * - 0b0 - Normal operation
 * - 0b1 - No operation, ignore the other bits in this register
 */
/*@{*/
/*! @brief Set the NOP field to a new value. */
#define DMA_WR_CINT_NOP(base, value) (DMA_RMW_CINT(base, DMA_CINT_NOP_MASK, DMA_CINT_NOP(value)))
#define DMA_BWR_CINT_NOP(base, value) (BITBAND_ACCESS8(&DMA_CINT_REG(base), DMA_CINT_NOP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_INT - Interrupt Request Register
 ******************************************************************************/

/*!
 * @brief DMA_INT - Interrupt Request Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The INT register provides a bit map for the 16 channels signaling the
 * presence of an interrupt request for each channel. Depending on the appropriate bit
 * setting in the transfer-control descriptors, the eDMA engine generates an
 * interrupt on data transfer completion. The outputs of this register are directly
 * routed to the interrupt controller (INTC). During the interrupt-service routine
 * associated with any given channel, it is the software's responsibility to
 * clear the appropriate bit, negating the interrupt request. Typically, a write to
 * the CINT register in the interrupt service routine is used for this purpose.
 * The state of any given channel's interrupt request is directly affected by
 * writes to this register; it is also affected by writes to the CINT register. On
 * writes to INT, a 1 in any bit position clears the corresponding channel's
 * interrupt request. A zero in any bit position has no affect on the corresponding
 * channel's current interrupt status. The CINT register is provided so the interrupt
 * request for a single channel can easily be cleared without the need to
 * perform a read-modify-write sequence to the INT register.
 */
/*!
 * @name Constants and macros for entire DMA_INT register
 */
/*@{*/
#define DMA_RD_INT(base)         (DMA_INT_REG(base))
#define DMA_WR_INT(base, value)  (DMA_INT_REG(base) = (value))
#define DMA_RMW_INT(base, mask, value) (DMA_WR_INT(base, (DMA_RD_INT(base) & ~(mask)) | (value)))
#define DMA_SET_INT(base, value) (DMA_WR_INT(base, DMA_RD_INT(base) |  (value)))
#define DMA_CLR_INT(base, value) (DMA_WR_INT(base, DMA_RD_INT(base) & ~(value)))
#define DMA_TOG_INT(base, value) (DMA_WR_INT(base, DMA_RD_INT(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_INT bitfields
 */

/*!
 * @name Register DMA_INT, field INT0[0] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT0 field. */
#define DMA_RD_INT_INT0(base) ((DMA_INT_REG(base) & DMA_INT_INT0_MASK) >> DMA_INT_INT0_SHIFT)
#define DMA_BRD_INT_INT0(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT0_SHIFT))

/*! @brief Set the INT0 field to a new value. */
#define DMA_WR_INT_INT0(base, value) (DMA_RMW_INT(base, (DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT0(value)))
#define DMA_BWR_INT_INT0(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT1[1] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT1 field. */
#define DMA_RD_INT_INT1(base) ((DMA_INT_REG(base) & DMA_INT_INT1_MASK) >> DMA_INT_INT1_SHIFT)
#define DMA_BRD_INT_INT1(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT1_SHIFT))

/*! @brief Set the INT1 field to a new value. */
#define DMA_WR_INT_INT1(base, value) (DMA_RMW_INT(base, (DMA_INT_INT1_MASK | DMA_INT_INT0_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT1(value)))
#define DMA_BWR_INT_INT1(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT2[2] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT2 field. */
#define DMA_RD_INT_INT2(base) ((DMA_INT_REG(base) & DMA_INT_INT2_MASK) >> DMA_INT_INT2_SHIFT)
#define DMA_BRD_INT_INT2(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT2_SHIFT))

/*! @brief Set the INT2 field to a new value. */
#define DMA_WR_INT_INT2(base, value) (DMA_RMW_INT(base, (DMA_INT_INT2_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT2(value)))
#define DMA_BWR_INT_INT2(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT3[3] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT3 field. */
#define DMA_RD_INT_INT3(base) ((DMA_INT_REG(base) & DMA_INT_INT3_MASK) >> DMA_INT_INT3_SHIFT)
#define DMA_BRD_INT_INT3(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT3_SHIFT))

/*! @brief Set the INT3 field to a new value. */
#define DMA_WR_INT_INT3(base, value) (DMA_RMW_INT(base, (DMA_INT_INT3_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT3(value)))
#define DMA_BWR_INT_INT3(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT4[4] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT4 field. */
#define DMA_RD_INT_INT4(base) ((DMA_INT_REG(base) & DMA_INT_INT4_MASK) >> DMA_INT_INT4_SHIFT)
#define DMA_BRD_INT_INT4(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT4_SHIFT))

/*! @brief Set the INT4 field to a new value. */
#define DMA_WR_INT_INT4(base, value) (DMA_RMW_INT(base, (DMA_INT_INT4_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT4(value)))
#define DMA_BWR_INT_INT4(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT5[5] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT5 field. */
#define DMA_RD_INT_INT5(base) ((DMA_INT_REG(base) & DMA_INT_INT5_MASK) >> DMA_INT_INT5_SHIFT)
#define DMA_BRD_INT_INT5(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT5_SHIFT))

/*! @brief Set the INT5 field to a new value. */
#define DMA_WR_INT_INT5(base, value) (DMA_RMW_INT(base, (DMA_INT_INT5_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT5(value)))
#define DMA_BWR_INT_INT5(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT6[6] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT6 field. */
#define DMA_RD_INT_INT6(base) ((DMA_INT_REG(base) & DMA_INT_INT6_MASK) >> DMA_INT_INT6_SHIFT)
#define DMA_BRD_INT_INT6(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT6_SHIFT))

/*! @brief Set the INT6 field to a new value. */
#define DMA_WR_INT_INT6(base, value) (DMA_RMW_INT(base, (DMA_INT_INT6_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT6(value)))
#define DMA_BWR_INT_INT6(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT7[7] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT7 field. */
#define DMA_RD_INT_INT7(base) ((DMA_INT_REG(base) & DMA_INT_INT7_MASK) >> DMA_INT_INT7_SHIFT)
#define DMA_BRD_INT_INT7(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT7_SHIFT))

/*! @brief Set the INT7 field to a new value. */
#define DMA_WR_INT_INT7(base, value) (DMA_RMW_INT(base, (DMA_INT_INT7_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT7(value)))
#define DMA_BWR_INT_INT7(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT8[8] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT8 field. */
#define DMA_RD_INT_INT8(base) ((DMA_INT_REG(base) & DMA_INT_INT8_MASK) >> DMA_INT_INT8_SHIFT)
#define DMA_BRD_INT_INT8(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT8_SHIFT))

/*! @brief Set the INT8 field to a new value. */
#define DMA_WR_INT_INT8(base, value) (DMA_RMW_INT(base, (DMA_INT_INT8_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT8(value)))
#define DMA_BWR_INT_INT8(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT8_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT9[9] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT9 field. */
#define DMA_RD_INT_INT9(base) ((DMA_INT_REG(base) & DMA_INT_INT9_MASK) >> DMA_INT_INT9_SHIFT)
#define DMA_BRD_INT_INT9(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT9_SHIFT))

/*! @brief Set the INT9 field to a new value. */
#define DMA_WR_INT_INT9(base, value) (DMA_RMW_INT(base, (DMA_INT_INT9_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT9(value)))
#define DMA_BWR_INT_INT9(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT9_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT10[10] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT10 field. */
#define DMA_RD_INT_INT10(base) ((DMA_INT_REG(base) & DMA_INT_INT10_MASK) >> DMA_INT_INT10_SHIFT)
#define DMA_BRD_INT_INT10(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT10_SHIFT))

/*! @brief Set the INT10 field to a new value. */
#define DMA_WR_INT_INT10(base, value) (DMA_RMW_INT(base, (DMA_INT_INT10_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT10(value)))
#define DMA_BWR_INT_INT10(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT10_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT11[11] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT11 field. */
#define DMA_RD_INT_INT11(base) ((DMA_INT_REG(base) & DMA_INT_INT11_MASK) >> DMA_INT_INT11_SHIFT)
#define DMA_BRD_INT_INT11(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT11_SHIFT))

/*! @brief Set the INT11 field to a new value. */
#define DMA_WR_INT_INT11(base, value) (DMA_RMW_INT(base, (DMA_INT_INT11_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT11(value)))
#define DMA_BWR_INT_INT11(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT11_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT12[12] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT12 field. */
#define DMA_RD_INT_INT12(base) ((DMA_INT_REG(base) & DMA_INT_INT12_MASK) >> DMA_INT_INT12_SHIFT)
#define DMA_BRD_INT_INT12(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT12_SHIFT))

/*! @brief Set the INT12 field to a new value. */
#define DMA_WR_INT_INT12(base, value) (DMA_RMW_INT(base, (DMA_INT_INT12_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT12(value)))
#define DMA_BWR_INT_INT12(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT12_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT13[13] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT13 field. */
#define DMA_RD_INT_INT13(base) ((DMA_INT_REG(base) & DMA_INT_INT13_MASK) >> DMA_INT_INT13_SHIFT)
#define DMA_BRD_INT_INT13(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT13_SHIFT))

/*! @brief Set the INT13 field to a new value. */
#define DMA_WR_INT_INT13(base, value) (DMA_RMW_INT(base, (DMA_INT_INT13_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT14_MASK | DMA_INT_INT15_MASK), DMA_INT_INT13(value)))
#define DMA_BWR_INT_INT13(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT13_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT14[14] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT14 field. */
#define DMA_RD_INT_INT14(base) ((DMA_INT_REG(base) & DMA_INT_INT14_MASK) >> DMA_INT_INT14_SHIFT)
#define DMA_BRD_INT_INT14(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT14_SHIFT))

/*! @brief Set the INT14 field to a new value. */
#define DMA_WR_INT_INT14(base, value) (DMA_RMW_INT(base, (DMA_INT_INT14_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT15_MASK), DMA_INT_INT14(value)))
#define DMA_BWR_INT_INT14(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT14_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_INT, field INT15[15] (W1C)
 *
 * Values:
 * - 0b0 - The interrupt request for corresponding channel is cleared
 * - 0b1 - The interrupt request for corresponding channel is active
 */
/*@{*/
/*! @brief Read current value of the DMA_INT_INT15 field. */
#define DMA_RD_INT_INT15(base) ((DMA_INT_REG(base) & DMA_INT_INT15_MASK) >> DMA_INT_INT15_SHIFT)
#define DMA_BRD_INT_INT15(base) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT15_SHIFT))

/*! @brief Set the INT15 field to a new value. */
#define DMA_WR_INT_INT15(base, value) (DMA_RMW_INT(base, (DMA_INT_INT15_MASK | DMA_INT_INT0_MASK | DMA_INT_INT1_MASK | DMA_INT_INT2_MASK | DMA_INT_INT3_MASK | DMA_INT_INT4_MASK | DMA_INT_INT5_MASK | DMA_INT_INT6_MASK | DMA_INT_INT7_MASK | DMA_INT_INT8_MASK | DMA_INT_INT9_MASK | DMA_INT_INT10_MASK | DMA_INT_INT11_MASK | DMA_INT_INT12_MASK | DMA_INT_INT13_MASK | DMA_INT_INT14_MASK), DMA_INT_INT15(value)))
#define DMA_BWR_INT_INT15(base, value) (BITBAND_ACCESS32(&DMA_INT_REG(base), DMA_INT_INT15_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_ERR - Error Register
 ******************************************************************************/

/*!
 * @brief DMA_ERR - Error Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ERR provides a bit map for the 16 channels, signaling the presence of an
 * error for each channel. The eDMA engine signals the occurrence of an error
 * condition by setting the appropriate bit in this register. The outputs of this
 * register are enabled by the contents of the EEI, and then routed to the
 * interrupt controller. During the execution of the interrupt-service routine associated
 * with any DMA errors, it is software's responsibility to clear the appropriate
 * bit, negating the error-interrupt request. Typically, a write to the CERR in
 * the interrupt-service routine is used for this purpose. The normal DMA channel
 * completion indicators (setting the transfer control descriptor DONE flag and
 * the possible assertion of an interrupt request) are not affected when an error
 * is detected. The contents of this register can also be polled because a
 * non-zero value indicates the presence of a channel error regardless of the state of
 * the EEI. The state of any given channel's error indicators is affected by
 * writes to this register; it is also affected by writes to the CERR. On writes to
 * the ERR, a one in any bit position clears the corresponding channel's error
 * status. A zero in any bit position has no affect on the corresponding channel's
 * current error status. The CERR is provided so the error indicator for a single
 * channel can easily be cleared.
 */
/*!
 * @name Constants and macros for entire DMA_ERR register
 */
/*@{*/
#define DMA_RD_ERR(base)         (DMA_ERR_REG(base))
#define DMA_WR_ERR(base, value)  (DMA_ERR_REG(base) = (value))
#define DMA_RMW_ERR(base, mask, value) (DMA_WR_ERR(base, (DMA_RD_ERR(base) & ~(mask)) | (value)))
#define DMA_SET_ERR(base, value) (DMA_WR_ERR(base, DMA_RD_ERR(base) |  (value)))
#define DMA_CLR_ERR(base, value) (DMA_WR_ERR(base, DMA_RD_ERR(base) & ~(value)))
#define DMA_TOG_ERR(base, value) (DMA_WR_ERR(base, DMA_RD_ERR(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_ERR bitfields
 */

/*!
 * @name Register DMA_ERR, field ERR0[0] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR0 field. */
#define DMA_RD_ERR_ERR0(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR0_MASK) >> DMA_ERR_ERR0_SHIFT)
#define DMA_BRD_ERR_ERR0(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR0_SHIFT))

/*! @brief Set the ERR0 field to a new value. */
#define DMA_WR_ERR_ERR0(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR0(value)))
#define DMA_BWR_ERR_ERR0(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR0_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR1[1] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR1 field. */
#define DMA_RD_ERR_ERR1(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR1_MASK) >> DMA_ERR_ERR1_SHIFT)
#define DMA_BRD_ERR_ERR1(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR1_SHIFT))

/*! @brief Set the ERR1 field to a new value. */
#define DMA_WR_ERR_ERR1(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR1_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR1(value)))
#define DMA_BWR_ERR_ERR1(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR1_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR2[2] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR2 field. */
#define DMA_RD_ERR_ERR2(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR2_MASK) >> DMA_ERR_ERR2_SHIFT)
#define DMA_BRD_ERR_ERR2(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR2_SHIFT))

/*! @brief Set the ERR2 field to a new value. */
#define DMA_WR_ERR_ERR2(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR2_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR2(value)))
#define DMA_BWR_ERR_ERR2(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR2_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR3[3] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR3 field. */
#define DMA_RD_ERR_ERR3(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR3_MASK) >> DMA_ERR_ERR3_SHIFT)
#define DMA_BRD_ERR_ERR3(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR3_SHIFT))

/*! @brief Set the ERR3 field to a new value. */
#define DMA_WR_ERR_ERR3(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR3_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR3(value)))
#define DMA_BWR_ERR_ERR3(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR3_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR4[4] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR4 field. */
#define DMA_RD_ERR_ERR4(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR4_MASK) >> DMA_ERR_ERR4_SHIFT)
#define DMA_BRD_ERR_ERR4(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR4_SHIFT))

/*! @brief Set the ERR4 field to a new value. */
#define DMA_WR_ERR_ERR4(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR4_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR4(value)))
#define DMA_BWR_ERR_ERR4(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR4_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR5[5] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR5 field. */
#define DMA_RD_ERR_ERR5(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR5_MASK) >> DMA_ERR_ERR5_SHIFT)
#define DMA_BRD_ERR_ERR5(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR5_SHIFT))

/*! @brief Set the ERR5 field to a new value. */
#define DMA_WR_ERR_ERR5(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR5_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR5(value)))
#define DMA_BWR_ERR_ERR5(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR5_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR6[6] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR6 field. */
#define DMA_RD_ERR_ERR6(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR6_MASK) >> DMA_ERR_ERR6_SHIFT)
#define DMA_BRD_ERR_ERR6(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR6_SHIFT))

/*! @brief Set the ERR6 field to a new value. */
#define DMA_WR_ERR_ERR6(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR6_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR6(value)))
#define DMA_BWR_ERR_ERR6(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR6_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR7[7] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR7 field. */
#define DMA_RD_ERR_ERR7(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR7_MASK) >> DMA_ERR_ERR7_SHIFT)
#define DMA_BRD_ERR_ERR7(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR7_SHIFT))

/*! @brief Set the ERR7 field to a new value. */
#define DMA_WR_ERR_ERR7(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR7_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR7(value)))
#define DMA_BWR_ERR_ERR7(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR7_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR8[8] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR8 field. */
#define DMA_RD_ERR_ERR8(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR8_MASK) >> DMA_ERR_ERR8_SHIFT)
#define DMA_BRD_ERR_ERR8(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR8_SHIFT))

/*! @brief Set the ERR8 field to a new value. */
#define DMA_WR_ERR_ERR8(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR8_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR8(value)))
#define DMA_BWR_ERR_ERR8(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR8_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR9[9] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR9 field. */
#define DMA_RD_ERR_ERR9(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR9_MASK) >> DMA_ERR_ERR9_SHIFT)
#define DMA_BRD_ERR_ERR9(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR9_SHIFT))

/*! @brief Set the ERR9 field to a new value. */
#define DMA_WR_ERR_ERR9(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR9_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR9(value)))
#define DMA_BWR_ERR_ERR9(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR9_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR10[10] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR10 field. */
#define DMA_RD_ERR_ERR10(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR10_MASK) >> DMA_ERR_ERR10_SHIFT)
#define DMA_BRD_ERR_ERR10(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR10_SHIFT))

/*! @brief Set the ERR10 field to a new value. */
#define DMA_WR_ERR_ERR10(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR10_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR10(value)))
#define DMA_BWR_ERR_ERR10(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR10_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR11[11] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR11 field. */
#define DMA_RD_ERR_ERR11(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR11_MASK) >> DMA_ERR_ERR11_SHIFT)
#define DMA_BRD_ERR_ERR11(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR11_SHIFT))

/*! @brief Set the ERR11 field to a new value. */
#define DMA_WR_ERR_ERR11(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR11_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR11(value)))
#define DMA_BWR_ERR_ERR11(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR11_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR12[12] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR12 field. */
#define DMA_RD_ERR_ERR12(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR12_MASK) >> DMA_ERR_ERR12_SHIFT)
#define DMA_BRD_ERR_ERR12(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR12_SHIFT))

/*! @brief Set the ERR12 field to a new value. */
#define DMA_WR_ERR_ERR12(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR12_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR12(value)))
#define DMA_BWR_ERR_ERR12(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR12_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR13[13] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR13 field. */
#define DMA_RD_ERR_ERR13(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR13_MASK) >> DMA_ERR_ERR13_SHIFT)
#define DMA_BRD_ERR_ERR13(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR13_SHIFT))

/*! @brief Set the ERR13 field to a new value. */
#define DMA_WR_ERR_ERR13(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR13_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR14_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR13(value)))
#define DMA_BWR_ERR_ERR13(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR13_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR14[14] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR14 field. */
#define DMA_RD_ERR_ERR14(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR14_MASK) >> DMA_ERR_ERR14_SHIFT)
#define DMA_BRD_ERR_ERR14(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR14_SHIFT))

/*! @brief Set the ERR14 field to a new value. */
#define DMA_WR_ERR_ERR14(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR14_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR15_MASK), DMA_ERR_ERR14(value)))
#define DMA_BWR_ERR_ERR14(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR14_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR15[15] (W1C)
 *
 * Values:
 * - 0b0 - An error in the corresponding channel has not occurred
 * - 0b1 - An error in the corresponding channel has occurred
 */
/*@{*/
/*! @brief Read current value of the DMA_ERR_ERR15 field. */
#define DMA_RD_ERR_ERR15(base) ((DMA_ERR_REG(base) & DMA_ERR_ERR15_MASK) >> DMA_ERR_ERR15_SHIFT)
#define DMA_BRD_ERR_ERR15(base) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR15_SHIFT))

/*! @brief Set the ERR15 field to a new value. */
#define DMA_WR_ERR_ERR15(base, value) (DMA_RMW_ERR(base, (DMA_ERR_ERR15_MASK | DMA_ERR_ERR0_MASK | DMA_ERR_ERR1_MASK | DMA_ERR_ERR2_MASK | DMA_ERR_ERR3_MASK | DMA_ERR_ERR4_MASK | DMA_ERR_ERR5_MASK | DMA_ERR_ERR6_MASK | DMA_ERR_ERR7_MASK | DMA_ERR_ERR8_MASK | DMA_ERR_ERR9_MASK | DMA_ERR_ERR10_MASK | DMA_ERR_ERR11_MASK | DMA_ERR_ERR12_MASK | DMA_ERR_ERR13_MASK | DMA_ERR_ERR14_MASK), DMA_ERR_ERR15(value)))
#define DMA_BWR_ERR_ERR15(base, value) (BITBAND_ACCESS32(&DMA_ERR_REG(base), DMA_ERR_ERR15_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_HRS - Hardware Request Status Register
 ******************************************************************************/

/*!
 * @brief DMA_HRS - Hardware Request Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The HRS register provides a bit map for the DMA channels, signaling the
 * presence of a hardware request for each channel. The hardware request status bits
 * reflect the current state of the register and qualified (via the ERQ fields)
 * DMA request signals as seen by the DMA's arbitration logic. This view into the
 * hardware request signals may be used for debug purposes. These bits reflect the
 * state of the request as seen by the arbitration logic. Therefore, this status
 * is affected by the ERQ bits.
 */
/*!
 * @name Constants and macros for entire DMA_HRS register
 */
/*@{*/
#define DMA_RD_HRS(base)         (DMA_HRS_REG(base))
/*@}*/

/*
 * Constants & macros for individual DMA_HRS bitfields
 */

/*!
 * @name Register DMA_HRS, field HRS0[0] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 0 is not present
 * - 0b1 - A hardware service request for channel 0 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS0 field. */
#define DMA_RD_HRS_HRS0(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS0_MASK) >> DMA_HRS_HRS0_SHIFT)
#define DMA_BRD_HRS_HRS0(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS0_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS1[1] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 1 is not present
 * - 0b1 - A hardware service request for channel 1 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS1 field. */
#define DMA_RD_HRS_HRS1(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS1_MASK) >> DMA_HRS_HRS1_SHIFT)
#define DMA_BRD_HRS_HRS1(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS1_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS2[2] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 2 is not present
 * - 0b1 - A hardware service request for channel 2 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS2 field. */
#define DMA_RD_HRS_HRS2(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS2_MASK) >> DMA_HRS_HRS2_SHIFT)
#define DMA_BRD_HRS_HRS2(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS2_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS3[3] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 3 is not present
 * - 0b1 - A hardware service request for channel 3 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS3 field. */
#define DMA_RD_HRS_HRS3(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS3_MASK) >> DMA_HRS_HRS3_SHIFT)
#define DMA_BRD_HRS_HRS3(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS3_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS4[4] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 4 is not present
 * - 0b1 - A hardware service request for channel 4 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS4 field. */
#define DMA_RD_HRS_HRS4(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS4_MASK) >> DMA_HRS_HRS4_SHIFT)
#define DMA_BRD_HRS_HRS4(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS4_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS5[5] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 5 is not present
 * - 0b1 - A hardware service request for channel 5 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS5 field. */
#define DMA_RD_HRS_HRS5(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS5_MASK) >> DMA_HRS_HRS5_SHIFT)
#define DMA_BRD_HRS_HRS5(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS5_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS6[6] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 6 is not present
 * - 0b1 - A hardware service request for channel 6 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS6 field. */
#define DMA_RD_HRS_HRS6(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS6_MASK) >> DMA_HRS_HRS6_SHIFT)
#define DMA_BRD_HRS_HRS6(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS6_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS7[7] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 7 is not present
 * - 0b1 - A hardware service request for channel 7 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS7 field. */
#define DMA_RD_HRS_HRS7(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS7_MASK) >> DMA_HRS_HRS7_SHIFT)
#define DMA_BRD_HRS_HRS7(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS7_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS8[8] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 8 is not present
 * - 0b1 - A hardware service request for channel 8 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS8 field. */
#define DMA_RD_HRS_HRS8(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS8_MASK) >> DMA_HRS_HRS8_SHIFT)
#define DMA_BRD_HRS_HRS8(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS8_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS9[9] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 9 is not present
 * - 0b1 - A hardware service request for channel 9 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS9 field. */
#define DMA_RD_HRS_HRS9(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS9_MASK) >> DMA_HRS_HRS9_SHIFT)
#define DMA_BRD_HRS_HRS9(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS9_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS10[10] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 10 is not present
 * - 0b1 - A hardware service request for channel 10 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS10 field. */
#define DMA_RD_HRS_HRS10(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS10_MASK) >> DMA_HRS_HRS10_SHIFT)
#define DMA_BRD_HRS_HRS10(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS10_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS11[11] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 11 is not present
 * - 0b1 - A hardware service request for channel 11 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS11 field. */
#define DMA_RD_HRS_HRS11(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS11_MASK) >> DMA_HRS_HRS11_SHIFT)
#define DMA_BRD_HRS_HRS11(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS11_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS12[12] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 12 is not present
 * - 0b1 - A hardware service request for channel 12 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS12 field. */
#define DMA_RD_HRS_HRS12(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS12_MASK) >> DMA_HRS_HRS12_SHIFT)
#define DMA_BRD_HRS_HRS12(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS12_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS13[13] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 13 is not present
 * - 0b1 - A hardware service request for channel 13 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS13 field. */
#define DMA_RD_HRS_HRS13(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS13_MASK) >> DMA_HRS_HRS13_SHIFT)
#define DMA_BRD_HRS_HRS13(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS13_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS14[14] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 14 is not present
 * - 0b1 - A hardware service request for channel 14 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS14 field. */
#define DMA_RD_HRS_HRS14(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS14_MASK) >> DMA_HRS_HRS14_SHIFT)
#define DMA_BRD_HRS_HRS14(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS14_SHIFT))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS15[15] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0b0 - A hardware service request for channel 15 is not present
 * - 0b1 - A hardware service request for channel 15 is present
 */
/*@{*/
/*! @brief Read current value of the DMA_HRS_HRS15 field. */
#define DMA_RD_HRS_HRS15(base) ((DMA_HRS_REG(base) & DMA_HRS_HRS15_MASK) >> DMA_HRS_HRS15_SHIFT)
#define DMA_BRD_HRS_HRS15(base) (BITBAND_ACCESS32(&DMA_HRS_REG(base), DMA_HRS_HRS15_SHIFT))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI3 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI3 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI3 register
 */
/*@{*/
#define DMA_RD_DCHPRI3(base)     (DMA_DCHPRI3_REG(base))
#define DMA_WR_DCHPRI3(base, value) (DMA_DCHPRI3_REG(base) = (value))
#define DMA_RMW_DCHPRI3(base, mask, value) (DMA_WR_DCHPRI3(base, (DMA_RD_DCHPRI3(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI3(base, value) (DMA_WR_DCHPRI3(base, DMA_RD_DCHPRI3(base) |  (value)))
#define DMA_CLR_DCHPRI3(base, value) (DMA_WR_DCHPRI3(base, DMA_RD_DCHPRI3(base) & ~(value)))
#define DMA_TOG_DCHPRI3(base, value) (DMA_WR_DCHPRI3(base, DMA_RD_DCHPRI3(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI3 bitfields
 */

/*!
 * @name Register DMA_DCHPRI3, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI3_CHPRI field. */
#define DMA_RD_DCHPRI3_CHPRI(base) ((DMA_DCHPRI3_REG(base) & DMA_DCHPRI3_CHPRI_MASK) >> DMA_DCHPRI3_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI3_CHPRI(base) (DMA_RD_DCHPRI3_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI3_CHPRI(base, value) (DMA_RMW_DCHPRI3(base, DMA_DCHPRI3_CHPRI_MASK, DMA_DCHPRI3_CHPRI(value)))
#define DMA_BWR_DCHPRI3_CHPRI(base, value) (DMA_WR_DCHPRI3_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI3, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI3_DPA field. */
#define DMA_RD_DCHPRI3_DPA(base) ((DMA_DCHPRI3_REG(base) & DMA_DCHPRI3_DPA_MASK) >> DMA_DCHPRI3_DPA_SHIFT)
#define DMA_BRD_DCHPRI3_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI3_REG(base), DMA_DCHPRI3_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI3_DPA(base, value) (DMA_RMW_DCHPRI3(base, DMA_DCHPRI3_DPA_MASK, DMA_DCHPRI3_DPA(value)))
#define DMA_BWR_DCHPRI3_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI3_REG(base), DMA_DCHPRI3_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI3, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI3_ECP field. */
#define DMA_RD_DCHPRI3_ECP(base) ((DMA_DCHPRI3_REG(base) & DMA_DCHPRI3_ECP_MASK) >> DMA_DCHPRI3_ECP_SHIFT)
#define DMA_BRD_DCHPRI3_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI3_REG(base), DMA_DCHPRI3_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI3_ECP(base, value) (DMA_RMW_DCHPRI3(base, DMA_DCHPRI3_ECP_MASK, DMA_DCHPRI3_ECP(value)))
#define DMA_BWR_DCHPRI3_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI3_REG(base), DMA_DCHPRI3_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI2 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI2 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI2 register
 */
/*@{*/
#define DMA_RD_DCHPRI2(base)     (DMA_DCHPRI2_REG(base))
#define DMA_WR_DCHPRI2(base, value) (DMA_DCHPRI2_REG(base) = (value))
#define DMA_RMW_DCHPRI2(base, mask, value) (DMA_WR_DCHPRI2(base, (DMA_RD_DCHPRI2(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI2(base, value) (DMA_WR_DCHPRI2(base, DMA_RD_DCHPRI2(base) |  (value)))
#define DMA_CLR_DCHPRI2(base, value) (DMA_WR_DCHPRI2(base, DMA_RD_DCHPRI2(base) & ~(value)))
#define DMA_TOG_DCHPRI2(base, value) (DMA_WR_DCHPRI2(base, DMA_RD_DCHPRI2(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI2 bitfields
 */

/*!
 * @name Register DMA_DCHPRI2, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI2_CHPRI field. */
#define DMA_RD_DCHPRI2_CHPRI(base) ((DMA_DCHPRI2_REG(base) & DMA_DCHPRI2_CHPRI_MASK) >> DMA_DCHPRI2_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI2_CHPRI(base) (DMA_RD_DCHPRI2_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI2_CHPRI(base, value) (DMA_RMW_DCHPRI2(base, DMA_DCHPRI2_CHPRI_MASK, DMA_DCHPRI2_CHPRI(value)))
#define DMA_BWR_DCHPRI2_CHPRI(base, value) (DMA_WR_DCHPRI2_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI2, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI2_DPA field. */
#define DMA_RD_DCHPRI2_DPA(base) ((DMA_DCHPRI2_REG(base) & DMA_DCHPRI2_DPA_MASK) >> DMA_DCHPRI2_DPA_SHIFT)
#define DMA_BRD_DCHPRI2_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI2_REG(base), DMA_DCHPRI2_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI2_DPA(base, value) (DMA_RMW_DCHPRI2(base, DMA_DCHPRI2_DPA_MASK, DMA_DCHPRI2_DPA(value)))
#define DMA_BWR_DCHPRI2_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI2_REG(base), DMA_DCHPRI2_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI2, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI2_ECP field. */
#define DMA_RD_DCHPRI2_ECP(base) ((DMA_DCHPRI2_REG(base) & DMA_DCHPRI2_ECP_MASK) >> DMA_DCHPRI2_ECP_SHIFT)
#define DMA_BRD_DCHPRI2_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI2_REG(base), DMA_DCHPRI2_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI2_ECP(base, value) (DMA_RMW_DCHPRI2(base, DMA_DCHPRI2_ECP_MASK, DMA_DCHPRI2_ECP(value)))
#define DMA_BWR_DCHPRI2_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI2_REG(base), DMA_DCHPRI2_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI1 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI1 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI1 register
 */
/*@{*/
#define DMA_RD_DCHPRI1(base)     (DMA_DCHPRI1_REG(base))
#define DMA_WR_DCHPRI1(base, value) (DMA_DCHPRI1_REG(base) = (value))
#define DMA_RMW_DCHPRI1(base, mask, value) (DMA_WR_DCHPRI1(base, (DMA_RD_DCHPRI1(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI1(base, value) (DMA_WR_DCHPRI1(base, DMA_RD_DCHPRI1(base) |  (value)))
#define DMA_CLR_DCHPRI1(base, value) (DMA_WR_DCHPRI1(base, DMA_RD_DCHPRI1(base) & ~(value)))
#define DMA_TOG_DCHPRI1(base, value) (DMA_WR_DCHPRI1(base, DMA_RD_DCHPRI1(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI1 bitfields
 */

/*!
 * @name Register DMA_DCHPRI1, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI1_CHPRI field. */
#define DMA_RD_DCHPRI1_CHPRI(base) ((DMA_DCHPRI1_REG(base) & DMA_DCHPRI1_CHPRI_MASK) >> DMA_DCHPRI1_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI1_CHPRI(base) (DMA_RD_DCHPRI1_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI1_CHPRI(base, value) (DMA_RMW_DCHPRI1(base, DMA_DCHPRI1_CHPRI_MASK, DMA_DCHPRI1_CHPRI(value)))
#define DMA_BWR_DCHPRI1_CHPRI(base, value) (DMA_WR_DCHPRI1_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI1, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI1_DPA field. */
#define DMA_RD_DCHPRI1_DPA(base) ((DMA_DCHPRI1_REG(base) & DMA_DCHPRI1_DPA_MASK) >> DMA_DCHPRI1_DPA_SHIFT)
#define DMA_BRD_DCHPRI1_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI1_REG(base), DMA_DCHPRI1_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI1_DPA(base, value) (DMA_RMW_DCHPRI1(base, DMA_DCHPRI1_DPA_MASK, DMA_DCHPRI1_DPA(value)))
#define DMA_BWR_DCHPRI1_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI1_REG(base), DMA_DCHPRI1_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI1, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI1_ECP field. */
#define DMA_RD_DCHPRI1_ECP(base) ((DMA_DCHPRI1_REG(base) & DMA_DCHPRI1_ECP_MASK) >> DMA_DCHPRI1_ECP_SHIFT)
#define DMA_BRD_DCHPRI1_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI1_REG(base), DMA_DCHPRI1_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI1_ECP(base, value) (DMA_RMW_DCHPRI1(base, DMA_DCHPRI1_ECP_MASK, DMA_DCHPRI1_ECP(value)))
#define DMA_BWR_DCHPRI1_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI1_REG(base), DMA_DCHPRI1_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI0 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI0 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI0 register
 */
/*@{*/
#define DMA_RD_DCHPRI0(base)     (DMA_DCHPRI0_REG(base))
#define DMA_WR_DCHPRI0(base, value) (DMA_DCHPRI0_REG(base) = (value))
#define DMA_RMW_DCHPRI0(base, mask, value) (DMA_WR_DCHPRI0(base, (DMA_RD_DCHPRI0(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI0(base, value) (DMA_WR_DCHPRI0(base, DMA_RD_DCHPRI0(base) |  (value)))
#define DMA_CLR_DCHPRI0(base, value) (DMA_WR_DCHPRI0(base, DMA_RD_DCHPRI0(base) & ~(value)))
#define DMA_TOG_DCHPRI0(base, value) (DMA_WR_DCHPRI0(base, DMA_RD_DCHPRI0(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI0 bitfields
 */

/*!
 * @name Register DMA_DCHPRI0, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI0_CHPRI field. */
#define DMA_RD_DCHPRI0_CHPRI(base) ((DMA_DCHPRI0_REG(base) & DMA_DCHPRI0_CHPRI_MASK) >> DMA_DCHPRI0_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI0_CHPRI(base) (DMA_RD_DCHPRI0_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI0_CHPRI(base, value) (DMA_RMW_DCHPRI0(base, DMA_DCHPRI0_CHPRI_MASK, DMA_DCHPRI0_CHPRI(value)))
#define DMA_BWR_DCHPRI0_CHPRI(base, value) (DMA_WR_DCHPRI0_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI0, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI0_DPA field. */
#define DMA_RD_DCHPRI0_DPA(base) ((DMA_DCHPRI0_REG(base) & DMA_DCHPRI0_DPA_MASK) >> DMA_DCHPRI0_DPA_SHIFT)
#define DMA_BRD_DCHPRI0_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI0_REG(base), DMA_DCHPRI0_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI0_DPA(base, value) (DMA_RMW_DCHPRI0(base, DMA_DCHPRI0_DPA_MASK, DMA_DCHPRI0_DPA(value)))
#define DMA_BWR_DCHPRI0_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI0_REG(base), DMA_DCHPRI0_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI0, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI0_ECP field. */
#define DMA_RD_DCHPRI0_ECP(base) ((DMA_DCHPRI0_REG(base) & DMA_DCHPRI0_ECP_MASK) >> DMA_DCHPRI0_ECP_SHIFT)
#define DMA_BRD_DCHPRI0_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI0_REG(base), DMA_DCHPRI0_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI0_ECP(base, value) (DMA_RMW_DCHPRI0(base, DMA_DCHPRI0_ECP_MASK, DMA_DCHPRI0_ECP(value)))
#define DMA_BWR_DCHPRI0_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI0_REG(base), DMA_DCHPRI0_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI7 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI7 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI7 register
 */
/*@{*/
#define DMA_RD_DCHPRI7(base)     (DMA_DCHPRI7_REG(base))
#define DMA_WR_DCHPRI7(base, value) (DMA_DCHPRI7_REG(base) = (value))
#define DMA_RMW_DCHPRI7(base, mask, value) (DMA_WR_DCHPRI7(base, (DMA_RD_DCHPRI7(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI7(base, value) (DMA_WR_DCHPRI7(base, DMA_RD_DCHPRI7(base) |  (value)))
#define DMA_CLR_DCHPRI7(base, value) (DMA_WR_DCHPRI7(base, DMA_RD_DCHPRI7(base) & ~(value)))
#define DMA_TOG_DCHPRI7(base, value) (DMA_WR_DCHPRI7(base, DMA_RD_DCHPRI7(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI7 bitfields
 */

/*!
 * @name Register DMA_DCHPRI7, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI7_CHPRI field. */
#define DMA_RD_DCHPRI7_CHPRI(base) ((DMA_DCHPRI7_REG(base) & DMA_DCHPRI7_CHPRI_MASK) >> DMA_DCHPRI7_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI7_CHPRI(base) (DMA_RD_DCHPRI7_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI7_CHPRI(base, value) (DMA_RMW_DCHPRI7(base, DMA_DCHPRI7_CHPRI_MASK, DMA_DCHPRI7_CHPRI(value)))
#define DMA_BWR_DCHPRI7_CHPRI(base, value) (DMA_WR_DCHPRI7_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI7, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI7_DPA field. */
#define DMA_RD_DCHPRI7_DPA(base) ((DMA_DCHPRI7_REG(base) & DMA_DCHPRI7_DPA_MASK) >> DMA_DCHPRI7_DPA_SHIFT)
#define DMA_BRD_DCHPRI7_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI7_REG(base), DMA_DCHPRI7_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI7_DPA(base, value) (DMA_RMW_DCHPRI7(base, DMA_DCHPRI7_DPA_MASK, DMA_DCHPRI7_DPA(value)))
#define DMA_BWR_DCHPRI7_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI7_REG(base), DMA_DCHPRI7_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI7, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI7_ECP field. */
#define DMA_RD_DCHPRI7_ECP(base) ((DMA_DCHPRI7_REG(base) & DMA_DCHPRI7_ECP_MASK) >> DMA_DCHPRI7_ECP_SHIFT)
#define DMA_BRD_DCHPRI7_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI7_REG(base), DMA_DCHPRI7_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI7_ECP(base, value) (DMA_RMW_DCHPRI7(base, DMA_DCHPRI7_ECP_MASK, DMA_DCHPRI7_ECP(value)))
#define DMA_BWR_DCHPRI7_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI7_REG(base), DMA_DCHPRI7_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI6 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI6 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI6 register
 */
/*@{*/
#define DMA_RD_DCHPRI6(base)     (DMA_DCHPRI6_REG(base))
#define DMA_WR_DCHPRI6(base, value) (DMA_DCHPRI6_REG(base) = (value))
#define DMA_RMW_DCHPRI6(base, mask, value) (DMA_WR_DCHPRI6(base, (DMA_RD_DCHPRI6(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI6(base, value) (DMA_WR_DCHPRI6(base, DMA_RD_DCHPRI6(base) |  (value)))
#define DMA_CLR_DCHPRI6(base, value) (DMA_WR_DCHPRI6(base, DMA_RD_DCHPRI6(base) & ~(value)))
#define DMA_TOG_DCHPRI6(base, value) (DMA_WR_DCHPRI6(base, DMA_RD_DCHPRI6(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI6 bitfields
 */

/*!
 * @name Register DMA_DCHPRI6, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI6_CHPRI field. */
#define DMA_RD_DCHPRI6_CHPRI(base) ((DMA_DCHPRI6_REG(base) & DMA_DCHPRI6_CHPRI_MASK) >> DMA_DCHPRI6_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI6_CHPRI(base) (DMA_RD_DCHPRI6_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI6_CHPRI(base, value) (DMA_RMW_DCHPRI6(base, DMA_DCHPRI6_CHPRI_MASK, DMA_DCHPRI6_CHPRI(value)))
#define DMA_BWR_DCHPRI6_CHPRI(base, value) (DMA_WR_DCHPRI6_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI6, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI6_DPA field. */
#define DMA_RD_DCHPRI6_DPA(base) ((DMA_DCHPRI6_REG(base) & DMA_DCHPRI6_DPA_MASK) >> DMA_DCHPRI6_DPA_SHIFT)
#define DMA_BRD_DCHPRI6_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI6_REG(base), DMA_DCHPRI6_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI6_DPA(base, value) (DMA_RMW_DCHPRI6(base, DMA_DCHPRI6_DPA_MASK, DMA_DCHPRI6_DPA(value)))
#define DMA_BWR_DCHPRI6_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI6_REG(base), DMA_DCHPRI6_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI6, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI6_ECP field. */
#define DMA_RD_DCHPRI6_ECP(base) ((DMA_DCHPRI6_REG(base) & DMA_DCHPRI6_ECP_MASK) >> DMA_DCHPRI6_ECP_SHIFT)
#define DMA_BRD_DCHPRI6_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI6_REG(base), DMA_DCHPRI6_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI6_ECP(base, value) (DMA_RMW_DCHPRI6(base, DMA_DCHPRI6_ECP_MASK, DMA_DCHPRI6_ECP(value)))
#define DMA_BWR_DCHPRI6_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI6_REG(base), DMA_DCHPRI6_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI5 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI5 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI5 register
 */
/*@{*/
#define DMA_RD_DCHPRI5(base)     (DMA_DCHPRI5_REG(base))
#define DMA_WR_DCHPRI5(base, value) (DMA_DCHPRI5_REG(base) = (value))
#define DMA_RMW_DCHPRI5(base, mask, value) (DMA_WR_DCHPRI5(base, (DMA_RD_DCHPRI5(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI5(base, value) (DMA_WR_DCHPRI5(base, DMA_RD_DCHPRI5(base) |  (value)))
#define DMA_CLR_DCHPRI5(base, value) (DMA_WR_DCHPRI5(base, DMA_RD_DCHPRI5(base) & ~(value)))
#define DMA_TOG_DCHPRI5(base, value) (DMA_WR_DCHPRI5(base, DMA_RD_DCHPRI5(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI5 bitfields
 */

/*!
 * @name Register DMA_DCHPRI5, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI5_CHPRI field. */
#define DMA_RD_DCHPRI5_CHPRI(base) ((DMA_DCHPRI5_REG(base) & DMA_DCHPRI5_CHPRI_MASK) >> DMA_DCHPRI5_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI5_CHPRI(base) (DMA_RD_DCHPRI5_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI5_CHPRI(base, value) (DMA_RMW_DCHPRI5(base, DMA_DCHPRI5_CHPRI_MASK, DMA_DCHPRI5_CHPRI(value)))
#define DMA_BWR_DCHPRI5_CHPRI(base, value) (DMA_WR_DCHPRI5_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI5, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI5_DPA field. */
#define DMA_RD_DCHPRI5_DPA(base) ((DMA_DCHPRI5_REG(base) & DMA_DCHPRI5_DPA_MASK) >> DMA_DCHPRI5_DPA_SHIFT)
#define DMA_BRD_DCHPRI5_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI5_REG(base), DMA_DCHPRI5_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI5_DPA(base, value) (DMA_RMW_DCHPRI5(base, DMA_DCHPRI5_DPA_MASK, DMA_DCHPRI5_DPA(value)))
#define DMA_BWR_DCHPRI5_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI5_REG(base), DMA_DCHPRI5_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI5, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI5_ECP field. */
#define DMA_RD_DCHPRI5_ECP(base) ((DMA_DCHPRI5_REG(base) & DMA_DCHPRI5_ECP_MASK) >> DMA_DCHPRI5_ECP_SHIFT)
#define DMA_BRD_DCHPRI5_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI5_REG(base), DMA_DCHPRI5_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI5_ECP(base, value) (DMA_RMW_DCHPRI5(base, DMA_DCHPRI5_ECP_MASK, DMA_DCHPRI5_ECP(value)))
#define DMA_BWR_DCHPRI5_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI5_REG(base), DMA_DCHPRI5_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI4 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI4 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI4 register
 */
/*@{*/
#define DMA_RD_DCHPRI4(base)     (DMA_DCHPRI4_REG(base))
#define DMA_WR_DCHPRI4(base, value) (DMA_DCHPRI4_REG(base) = (value))
#define DMA_RMW_DCHPRI4(base, mask, value) (DMA_WR_DCHPRI4(base, (DMA_RD_DCHPRI4(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI4(base, value) (DMA_WR_DCHPRI4(base, DMA_RD_DCHPRI4(base) |  (value)))
#define DMA_CLR_DCHPRI4(base, value) (DMA_WR_DCHPRI4(base, DMA_RD_DCHPRI4(base) & ~(value)))
#define DMA_TOG_DCHPRI4(base, value) (DMA_WR_DCHPRI4(base, DMA_RD_DCHPRI4(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI4 bitfields
 */

/*!
 * @name Register DMA_DCHPRI4, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI4_CHPRI field. */
#define DMA_RD_DCHPRI4_CHPRI(base) ((DMA_DCHPRI4_REG(base) & DMA_DCHPRI4_CHPRI_MASK) >> DMA_DCHPRI4_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI4_CHPRI(base) (DMA_RD_DCHPRI4_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI4_CHPRI(base, value) (DMA_RMW_DCHPRI4(base, DMA_DCHPRI4_CHPRI_MASK, DMA_DCHPRI4_CHPRI(value)))
#define DMA_BWR_DCHPRI4_CHPRI(base, value) (DMA_WR_DCHPRI4_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI4, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI4_DPA field. */
#define DMA_RD_DCHPRI4_DPA(base) ((DMA_DCHPRI4_REG(base) & DMA_DCHPRI4_DPA_MASK) >> DMA_DCHPRI4_DPA_SHIFT)
#define DMA_BRD_DCHPRI4_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI4_REG(base), DMA_DCHPRI4_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI4_DPA(base, value) (DMA_RMW_DCHPRI4(base, DMA_DCHPRI4_DPA_MASK, DMA_DCHPRI4_DPA(value)))
#define DMA_BWR_DCHPRI4_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI4_REG(base), DMA_DCHPRI4_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI4, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI4_ECP field. */
#define DMA_RD_DCHPRI4_ECP(base) ((DMA_DCHPRI4_REG(base) & DMA_DCHPRI4_ECP_MASK) >> DMA_DCHPRI4_ECP_SHIFT)
#define DMA_BRD_DCHPRI4_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI4_REG(base), DMA_DCHPRI4_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI4_ECP(base, value) (DMA_RMW_DCHPRI4(base, DMA_DCHPRI4_ECP_MASK, DMA_DCHPRI4_ECP(value)))
#define DMA_BWR_DCHPRI4_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI4_REG(base), DMA_DCHPRI4_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI11 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI11 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI11 register
 */
/*@{*/
#define DMA_RD_DCHPRI11(base)    (DMA_DCHPRI11_REG(base))
#define DMA_WR_DCHPRI11(base, value) (DMA_DCHPRI11_REG(base) = (value))
#define DMA_RMW_DCHPRI11(base, mask, value) (DMA_WR_DCHPRI11(base, (DMA_RD_DCHPRI11(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI11(base, value) (DMA_WR_DCHPRI11(base, DMA_RD_DCHPRI11(base) |  (value)))
#define DMA_CLR_DCHPRI11(base, value) (DMA_WR_DCHPRI11(base, DMA_RD_DCHPRI11(base) & ~(value)))
#define DMA_TOG_DCHPRI11(base, value) (DMA_WR_DCHPRI11(base, DMA_RD_DCHPRI11(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI11 bitfields
 */

/*!
 * @name Register DMA_DCHPRI11, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI11_CHPRI field. */
#define DMA_RD_DCHPRI11_CHPRI(base) ((DMA_DCHPRI11_REG(base) & DMA_DCHPRI11_CHPRI_MASK) >> DMA_DCHPRI11_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI11_CHPRI(base) (DMA_RD_DCHPRI11_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI11_CHPRI(base, value) (DMA_RMW_DCHPRI11(base, DMA_DCHPRI11_CHPRI_MASK, DMA_DCHPRI11_CHPRI(value)))
#define DMA_BWR_DCHPRI11_CHPRI(base, value) (DMA_WR_DCHPRI11_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI11, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI11_DPA field. */
#define DMA_RD_DCHPRI11_DPA(base) ((DMA_DCHPRI11_REG(base) & DMA_DCHPRI11_DPA_MASK) >> DMA_DCHPRI11_DPA_SHIFT)
#define DMA_BRD_DCHPRI11_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI11_REG(base), DMA_DCHPRI11_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI11_DPA(base, value) (DMA_RMW_DCHPRI11(base, DMA_DCHPRI11_DPA_MASK, DMA_DCHPRI11_DPA(value)))
#define DMA_BWR_DCHPRI11_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI11_REG(base), DMA_DCHPRI11_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI11, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI11_ECP field. */
#define DMA_RD_DCHPRI11_ECP(base) ((DMA_DCHPRI11_REG(base) & DMA_DCHPRI11_ECP_MASK) >> DMA_DCHPRI11_ECP_SHIFT)
#define DMA_BRD_DCHPRI11_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI11_REG(base), DMA_DCHPRI11_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI11_ECP(base, value) (DMA_RMW_DCHPRI11(base, DMA_DCHPRI11_ECP_MASK, DMA_DCHPRI11_ECP(value)))
#define DMA_BWR_DCHPRI11_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI11_REG(base), DMA_DCHPRI11_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI10 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI10 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI10 register
 */
/*@{*/
#define DMA_RD_DCHPRI10(base)    (DMA_DCHPRI10_REG(base))
#define DMA_WR_DCHPRI10(base, value) (DMA_DCHPRI10_REG(base) = (value))
#define DMA_RMW_DCHPRI10(base, mask, value) (DMA_WR_DCHPRI10(base, (DMA_RD_DCHPRI10(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI10(base, value) (DMA_WR_DCHPRI10(base, DMA_RD_DCHPRI10(base) |  (value)))
#define DMA_CLR_DCHPRI10(base, value) (DMA_WR_DCHPRI10(base, DMA_RD_DCHPRI10(base) & ~(value)))
#define DMA_TOG_DCHPRI10(base, value) (DMA_WR_DCHPRI10(base, DMA_RD_DCHPRI10(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI10 bitfields
 */

/*!
 * @name Register DMA_DCHPRI10, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI10_CHPRI field. */
#define DMA_RD_DCHPRI10_CHPRI(base) ((DMA_DCHPRI10_REG(base) & DMA_DCHPRI10_CHPRI_MASK) >> DMA_DCHPRI10_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI10_CHPRI(base) (DMA_RD_DCHPRI10_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI10_CHPRI(base, value) (DMA_RMW_DCHPRI10(base, DMA_DCHPRI10_CHPRI_MASK, DMA_DCHPRI10_CHPRI(value)))
#define DMA_BWR_DCHPRI10_CHPRI(base, value) (DMA_WR_DCHPRI10_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI10, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI10_DPA field. */
#define DMA_RD_DCHPRI10_DPA(base) ((DMA_DCHPRI10_REG(base) & DMA_DCHPRI10_DPA_MASK) >> DMA_DCHPRI10_DPA_SHIFT)
#define DMA_BRD_DCHPRI10_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI10_REG(base), DMA_DCHPRI10_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI10_DPA(base, value) (DMA_RMW_DCHPRI10(base, DMA_DCHPRI10_DPA_MASK, DMA_DCHPRI10_DPA(value)))
#define DMA_BWR_DCHPRI10_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI10_REG(base), DMA_DCHPRI10_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI10, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI10_ECP field. */
#define DMA_RD_DCHPRI10_ECP(base) ((DMA_DCHPRI10_REG(base) & DMA_DCHPRI10_ECP_MASK) >> DMA_DCHPRI10_ECP_SHIFT)
#define DMA_BRD_DCHPRI10_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI10_REG(base), DMA_DCHPRI10_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI10_ECP(base, value) (DMA_RMW_DCHPRI10(base, DMA_DCHPRI10_ECP_MASK, DMA_DCHPRI10_ECP(value)))
#define DMA_BWR_DCHPRI10_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI10_REG(base), DMA_DCHPRI10_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI9 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI9 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI9 register
 */
/*@{*/
#define DMA_RD_DCHPRI9(base)     (DMA_DCHPRI9_REG(base))
#define DMA_WR_DCHPRI9(base, value) (DMA_DCHPRI9_REG(base) = (value))
#define DMA_RMW_DCHPRI9(base, mask, value) (DMA_WR_DCHPRI9(base, (DMA_RD_DCHPRI9(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI9(base, value) (DMA_WR_DCHPRI9(base, DMA_RD_DCHPRI9(base) |  (value)))
#define DMA_CLR_DCHPRI9(base, value) (DMA_WR_DCHPRI9(base, DMA_RD_DCHPRI9(base) & ~(value)))
#define DMA_TOG_DCHPRI9(base, value) (DMA_WR_DCHPRI9(base, DMA_RD_DCHPRI9(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI9 bitfields
 */

/*!
 * @name Register DMA_DCHPRI9, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI9_CHPRI field. */
#define DMA_RD_DCHPRI9_CHPRI(base) ((DMA_DCHPRI9_REG(base) & DMA_DCHPRI9_CHPRI_MASK) >> DMA_DCHPRI9_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI9_CHPRI(base) (DMA_RD_DCHPRI9_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI9_CHPRI(base, value) (DMA_RMW_DCHPRI9(base, DMA_DCHPRI9_CHPRI_MASK, DMA_DCHPRI9_CHPRI(value)))
#define DMA_BWR_DCHPRI9_CHPRI(base, value) (DMA_WR_DCHPRI9_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI9, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI9_DPA field. */
#define DMA_RD_DCHPRI9_DPA(base) ((DMA_DCHPRI9_REG(base) & DMA_DCHPRI9_DPA_MASK) >> DMA_DCHPRI9_DPA_SHIFT)
#define DMA_BRD_DCHPRI9_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI9_REG(base), DMA_DCHPRI9_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI9_DPA(base, value) (DMA_RMW_DCHPRI9(base, DMA_DCHPRI9_DPA_MASK, DMA_DCHPRI9_DPA(value)))
#define DMA_BWR_DCHPRI9_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI9_REG(base), DMA_DCHPRI9_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI9, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI9_ECP field. */
#define DMA_RD_DCHPRI9_ECP(base) ((DMA_DCHPRI9_REG(base) & DMA_DCHPRI9_ECP_MASK) >> DMA_DCHPRI9_ECP_SHIFT)
#define DMA_BRD_DCHPRI9_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI9_REG(base), DMA_DCHPRI9_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI9_ECP(base, value) (DMA_RMW_DCHPRI9(base, DMA_DCHPRI9_ECP_MASK, DMA_DCHPRI9_ECP(value)))
#define DMA_BWR_DCHPRI9_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI9_REG(base), DMA_DCHPRI9_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI8 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI8 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI8 register
 */
/*@{*/
#define DMA_RD_DCHPRI8(base)     (DMA_DCHPRI8_REG(base))
#define DMA_WR_DCHPRI8(base, value) (DMA_DCHPRI8_REG(base) = (value))
#define DMA_RMW_DCHPRI8(base, mask, value) (DMA_WR_DCHPRI8(base, (DMA_RD_DCHPRI8(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI8(base, value) (DMA_WR_DCHPRI8(base, DMA_RD_DCHPRI8(base) |  (value)))
#define DMA_CLR_DCHPRI8(base, value) (DMA_WR_DCHPRI8(base, DMA_RD_DCHPRI8(base) & ~(value)))
#define DMA_TOG_DCHPRI8(base, value) (DMA_WR_DCHPRI8(base, DMA_RD_DCHPRI8(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI8 bitfields
 */

/*!
 * @name Register DMA_DCHPRI8, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI8_CHPRI field. */
#define DMA_RD_DCHPRI8_CHPRI(base) ((DMA_DCHPRI8_REG(base) & DMA_DCHPRI8_CHPRI_MASK) >> DMA_DCHPRI8_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI8_CHPRI(base) (DMA_RD_DCHPRI8_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI8_CHPRI(base, value) (DMA_RMW_DCHPRI8(base, DMA_DCHPRI8_CHPRI_MASK, DMA_DCHPRI8_CHPRI(value)))
#define DMA_BWR_DCHPRI8_CHPRI(base, value) (DMA_WR_DCHPRI8_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI8, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI8_DPA field. */
#define DMA_RD_DCHPRI8_DPA(base) ((DMA_DCHPRI8_REG(base) & DMA_DCHPRI8_DPA_MASK) >> DMA_DCHPRI8_DPA_SHIFT)
#define DMA_BRD_DCHPRI8_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI8_REG(base), DMA_DCHPRI8_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI8_DPA(base, value) (DMA_RMW_DCHPRI8(base, DMA_DCHPRI8_DPA_MASK, DMA_DCHPRI8_DPA(value)))
#define DMA_BWR_DCHPRI8_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI8_REG(base), DMA_DCHPRI8_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI8, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI8_ECP field. */
#define DMA_RD_DCHPRI8_ECP(base) ((DMA_DCHPRI8_REG(base) & DMA_DCHPRI8_ECP_MASK) >> DMA_DCHPRI8_ECP_SHIFT)
#define DMA_BRD_DCHPRI8_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI8_REG(base), DMA_DCHPRI8_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI8_ECP(base, value) (DMA_RMW_DCHPRI8(base, DMA_DCHPRI8_ECP_MASK, DMA_DCHPRI8_ECP(value)))
#define DMA_BWR_DCHPRI8_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI8_REG(base), DMA_DCHPRI8_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI15 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI15 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI15 register
 */
/*@{*/
#define DMA_RD_DCHPRI15(base)    (DMA_DCHPRI15_REG(base))
#define DMA_WR_DCHPRI15(base, value) (DMA_DCHPRI15_REG(base) = (value))
#define DMA_RMW_DCHPRI15(base, mask, value) (DMA_WR_DCHPRI15(base, (DMA_RD_DCHPRI15(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI15(base, value) (DMA_WR_DCHPRI15(base, DMA_RD_DCHPRI15(base) |  (value)))
#define DMA_CLR_DCHPRI15(base, value) (DMA_WR_DCHPRI15(base, DMA_RD_DCHPRI15(base) & ~(value)))
#define DMA_TOG_DCHPRI15(base, value) (DMA_WR_DCHPRI15(base, DMA_RD_DCHPRI15(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI15 bitfields
 */

/*!
 * @name Register DMA_DCHPRI15, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI15_CHPRI field. */
#define DMA_RD_DCHPRI15_CHPRI(base) ((DMA_DCHPRI15_REG(base) & DMA_DCHPRI15_CHPRI_MASK) >> DMA_DCHPRI15_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI15_CHPRI(base) (DMA_RD_DCHPRI15_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI15_CHPRI(base, value) (DMA_RMW_DCHPRI15(base, DMA_DCHPRI15_CHPRI_MASK, DMA_DCHPRI15_CHPRI(value)))
#define DMA_BWR_DCHPRI15_CHPRI(base, value) (DMA_WR_DCHPRI15_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI15, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI15_DPA field. */
#define DMA_RD_DCHPRI15_DPA(base) ((DMA_DCHPRI15_REG(base) & DMA_DCHPRI15_DPA_MASK) >> DMA_DCHPRI15_DPA_SHIFT)
#define DMA_BRD_DCHPRI15_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI15_REG(base), DMA_DCHPRI15_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI15_DPA(base, value) (DMA_RMW_DCHPRI15(base, DMA_DCHPRI15_DPA_MASK, DMA_DCHPRI15_DPA(value)))
#define DMA_BWR_DCHPRI15_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI15_REG(base), DMA_DCHPRI15_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI15, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI15_ECP field. */
#define DMA_RD_DCHPRI15_ECP(base) ((DMA_DCHPRI15_REG(base) & DMA_DCHPRI15_ECP_MASK) >> DMA_DCHPRI15_ECP_SHIFT)
#define DMA_BRD_DCHPRI15_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI15_REG(base), DMA_DCHPRI15_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI15_ECP(base, value) (DMA_RMW_DCHPRI15(base, DMA_DCHPRI15_ECP_MASK, DMA_DCHPRI15_ECP(value)))
#define DMA_BWR_DCHPRI15_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI15_REG(base), DMA_DCHPRI15_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI14 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI14 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI14 register
 */
/*@{*/
#define DMA_RD_DCHPRI14(base)    (DMA_DCHPRI14_REG(base))
#define DMA_WR_DCHPRI14(base, value) (DMA_DCHPRI14_REG(base) = (value))
#define DMA_RMW_DCHPRI14(base, mask, value) (DMA_WR_DCHPRI14(base, (DMA_RD_DCHPRI14(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI14(base, value) (DMA_WR_DCHPRI14(base, DMA_RD_DCHPRI14(base) |  (value)))
#define DMA_CLR_DCHPRI14(base, value) (DMA_WR_DCHPRI14(base, DMA_RD_DCHPRI14(base) & ~(value)))
#define DMA_TOG_DCHPRI14(base, value) (DMA_WR_DCHPRI14(base, DMA_RD_DCHPRI14(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI14 bitfields
 */

/*!
 * @name Register DMA_DCHPRI14, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI14_CHPRI field. */
#define DMA_RD_DCHPRI14_CHPRI(base) ((DMA_DCHPRI14_REG(base) & DMA_DCHPRI14_CHPRI_MASK) >> DMA_DCHPRI14_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI14_CHPRI(base) (DMA_RD_DCHPRI14_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI14_CHPRI(base, value) (DMA_RMW_DCHPRI14(base, DMA_DCHPRI14_CHPRI_MASK, DMA_DCHPRI14_CHPRI(value)))
#define DMA_BWR_DCHPRI14_CHPRI(base, value) (DMA_WR_DCHPRI14_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI14, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI14_DPA field. */
#define DMA_RD_DCHPRI14_DPA(base) ((DMA_DCHPRI14_REG(base) & DMA_DCHPRI14_DPA_MASK) >> DMA_DCHPRI14_DPA_SHIFT)
#define DMA_BRD_DCHPRI14_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI14_REG(base), DMA_DCHPRI14_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI14_DPA(base, value) (DMA_RMW_DCHPRI14(base, DMA_DCHPRI14_DPA_MASK, DMA_DCHPRI14_DPA(value)))
#define DMA_BWR_DCHPRI14_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI14_REG(base), DMA_DCHPRI14_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI14, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI14_ECP field. */
#define DMA_RD_DCHPRI14_ECP(base) ((DMA_DCHPRI14_REG(base) & DMA_DCHPRI14_ECP_MASK) >> DMA_DCHPRI14_ECP_SHIFT)
#define DMA_BRD_DCHPRI14_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI14_REG(base), DMA_DCHPRI14_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI14_ECP(base, value) (DMA_RMW_DCHPRI14(base, DMA_DCHPRI14_ECP_MASK, DMA_DCHPRI14_ECP(value)))
#define DMA_BWR_DCHPRI14_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI14_REG(base), DMA_DCHPRI14_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI13 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI13 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI13 register
 */
/*@{*/
#define DMA_RD_DCHPRI13(base)    (DMA_DCHPRI13_REG(base))
#define DMA_WR_DCHPRI13(base, value) (DMA_DCHPRI13_REG(base) = (value))
#define DMA_RMW_DCHPRI13(base, mask, value) (DMA_WR_DCHPRI13(base, (DMA_RD_DCHPRI13(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI13(base, value) (DMA_WR_DCHPRI13(base, DMA_RD_DCHPRI13(base) |  (value)))
#define DMA_CLR_DCHPRI13(base, value) (DMA_WR_DCHPRI13(base, DMA_RD_DCHPRI13(base) & ~(value)))
#define DMA_TOG_DCHPRI13(base, value) (DMA_WR_DCHPRI13(base, DMA_RD_DCHPRI13(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI13 bitfields
 */

/*!
 * @name Register DMA_DCHPRI13, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI13_CHPRI field. */
#define DMA_RD_DCHPRI13_CHPRI(base) ((DMA_DCHPRI13_REG(base) & DMA_DCHPRI13_CHPRI_MASK) >> DMA_DCHPRI13_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI13_CHPRI(base) (DMA_RD_DCHPRI13_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI13_CHPRI(base, value) (DMA_RMW_DCHPRI13(base, DMA_DCHPRI13_CHPRI_MASK, DMA_DCHPRI13_CHPRI(value)))
#define DMA_BWR_DCHPRI13_CHPRI(base, value) (DMA_WR_DCHPRI13_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI13, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI13_DPA field. */
#define DMA_RD_DCHPRI13_DPA(base) ((DMA_DCHPRI13_REG(base) & DMA_DCHPRI13_DPA_MASK) >> DMA_DCHPRI13_DPA_SHIFT)
#define DMA_BRD_DCHPRI13_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI13_REG(base), DMA_DCHPRI13_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI13_DPA(base, value) (DMA_RMW_DCHPRI13(base, DMA_DCHPRI13_DPA_MASK, DMA_DCHPRI13_DPA(value)))
#define DMA_BWR_DCHPRI13_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI13_REG(base), DMA_DCHPRI13_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI13, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI13_ECP field. */
#define DMA_RD_DCHPRI13_ECP(base) ((DMA_DCHPRI13_REG(base) & DMA_DCHPRI13_ECP_MASK) >> DMA_DCHPRI13_ECP_SHIFT)
#define DMA_BRD_DCHPRI13_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI13_REG(base), DMA_DCHPRI13_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI13_ECP(base, value) (DMA_RMW_DCHPRI13(base, DMA_DCHPRI13_ECP_MASK, DMA_DCHPRI13_ECP(value)))
#define DMA_BWR_DCHPRI13_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI13_REG(base), DMA_DCHPRI13_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DCHPRI12 - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief DMA_DCHPRI12 - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
/*!
 * @name Constants and macros for entire DMA_DCHPRI12 register
 */
/*@{*/
#define DMA_RD_DCHPRI12(base)    (DMA_DCHPRI12_REG(base))
#define DMA_WR_DCHPRI12(base, value) (DMA_DCHPRI12_REG(base) = (value))
#define DMA_RMW_DCHPRI12(base, mask, value) (DMA_WR_DCHPRI12(base, (DMA_RD_DCHPRI12(base) & ~(mask)) | (value)))
#define DMA_SET_DCHPRI12(base, value) (DMA_WR_DCHPRI12(base, DMA_RD_DCHPRI12(base) |  (value)))
#define DMA_CLR_DCHPRI12(base, value) (DMA_WR_DCHPRI12(base, DMA_RD_DCHPRI12(base) & ~(value)))
#define DMA_TOG_DCHPRI12(base, value) (DMA_WR_DCHPRI12(base, DMA_RD_DCHPRI12(base) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRI12 bitfields
 */

/*!
 * @name Register DMA_DCHPRI12, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI12_CHPRI field. */
#define DMA_RD_DCHPRI12_CHPRI(base) ((DMA_DCHPRI12_REG(base) & DMA_DCHPRI12_CHPRI_MASK) >> DMA_DCHPRI12_CHPRI_SHIFT)
#define DMA_BRD_DCHPRI12_CHPRI(base) (DMA_RD_DCHPRI12_CHPRI(base))

/*! @brief Set the CHPRI field to a new value. */
#define DMA_WR_DCHPRI12_CHPRI(base, value) (DMA_RMW_DCHPRI12(base, DMA_DCHPRI12_CHPRI_MASK, DMA_DCHPRI12_CHPRI(value)))
#define DMA_BWR_DCHPRI12_CHPRI(base, value) (DMA_WR_DCHPRI12_CHPRI(base, value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI12, field DPA[6] (RW)
 *
 * Values:
 * - 0b0 - Channel n can suspend a lower priority channel
 * - 0b1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI12_DPA field. */
#define DMA_RD_DCHPRI12_DPA(base) ((DMA_DCHPRI12_REG(base) & DMA_DCHPRI12_DPA_MASK) >> DMA_DCHPRI12_DPA_SHIFT)
#define DMA_BRD_DCHPRI12_DPA(base) (BITBAND_ACCESS8(&DMA_DCHPRI12_REG(base), DMA_DCHPRI12_DPA_SHIFT))

/*! @brief Set the DPA field to a new value. */
#define DMA_WR_DCHPRI12_DPA(base, value) (DMA_RMW_DCHPRI12(base, DMA_DCHPRI12_DPA_MASK, DMA_DCHPRI12_DPA(value)))
#define DMA_BWR_DCHPRI12_DPA(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI12_REG(base), DMA_DCHPRI12_DPA_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_DCHPRI12, field ECP[7] (RW)
 *
 * Values:
 * - 0b0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 0b1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
/*! @brief Read current value of the DMA_DCHPRI12_ECP field. */
#define DMA_RD_DCHPRI12_ECP(base) ((DMA_DCHPRI12_REG(base) & DMA_DCHPRI12_ECP_MASK) >> DMA_DCHPRI12_ECP_SHIFT)
#define DMA_BRD_DCHPRI12_ECP(base) (BITBAND_ACCESS8(&DMA_DCHPRI12_REG(base), DMA_DCHPRI12_ECP_SHIFT))

/*! @brief Set the ECP field to a new value. */
#define DMA_WR_DCHPRI12_ECP(base, value) (DMA_RMW_DCHPRI12(base, DMA_DCHPRI12_ECP_MASK, DMA_DCHPRI12_ECP(value)))
#define DMA_BWR_DCHPRI12_ECP(base, value) (BITBAND_ACCESS8(&DMA_DCHPRI12_REG(base), DMA_DCHPRI12_ECP_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_SADDR - TCD Source Address
 ******************************************************************************/

/*!
 * @brief DMA_SADDR - TCD Source Address (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire DMA_SADDR register
 */
/*@{*/
#define DMA_RD_SADDR(base, index) (DMA_SADDR_REG(base, index))
#define DMA_WR_SADDR(base, index, value) (DMA_SADDR_REG(base, index) = (value))
#define DMA_RMW_SADDR(base, index, mask, value) (DMA_WR_SADDR(base, index, (DMA_RD_SADDR(base, index) & ~(mask)) | (value)))
#define DMA_SET_SADDR(base, index, value) (DMA_WR_SADDR(base, index, DMA_RD_SADDR(base, index) |  (value)))
#define DMA_CLR_SADDR(base, index, value) (DMA_WR_SADDR(base, index, DMA_RD_SADDR(base, index) & ~(value)))
#define DMA_TOG_SADDR(base, index, value) (DMA_WR_SADDR(base, index, DMA_RD_SADDR(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * DMA_SOFF - TCD Signed Source Address Offset
 ******************************************************************************/

/*!
 * @brief DMA_SOFF - TCD Signed Source Address Offset (RW)
 *
 * Reset value: 0x0000U
 */
/*!
 * @name Constants and macros for entire DMA_SOFF register
 */
/*@{*/
#define DMA_RD_SOFF(base, index) (DMA_SOFF_REG(base, index))
#define DMA_WR_SOFF(base, index, value) (DMA_SOFF_REG(base, index) = (value))
#define DMA_RMW_SOFF(base, index, mask, value) (DMA_WR_SOFF(base, index, (DMA_RD_SOFF(base, index) & ~(mask)) | (value)))
#define DMA_SET_SOFF(base, index, value) (DMA_WR_SOFF(base, index, DMA_RD_SOFF(base, index) |  (value)))
#define DMA_CLR_SOFF(base, index, value) (DMA_WR_SOFF(base, index, DMA_RD_SOFF(base, index) & ~(value)))
#define DMA_TOG_SOFF(base, index, value) (DMA_WR_SOFF(base, index, DMA_RD_SOFF(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * DMA_ATTR - TCD Transfer Attributes
 ******************************************************************************/

/*!
 * @brief DMA_ATTR - TCD Transfer Attributes (RW)
 *
 * Reset value: 0x0000U
 */
/*!
 * @name Constants and macros for entire DMA_ATTR register
 */
/*@{*/
#define DMA_RD_ATTR(base, index) (DMA_ATTR_REG(base, index))
#define DMA_WR_ATTR(base, index, value) (DMA_ATTR_REG(base, index) = (value))
#define DMA_RMW_ATTR(base, index, mask, value) (DMA_WR_ATTR(base, index, (DMA_RD_ATTR(base, index) & ~(mask)) | (value)))
#define DMA_SET_ATTR(base, index, value) (DMA_WR_ATTR(base, index, DMA_RD_ATTR(base, index) |  (value)))
#define DMA_CLR_ATTR(base, index, value) (DMA_WR_ATTR(base, index, DMA_RD_ATTR(base, index) & ~(value)))
#define DMA_TOG_ATTR(base, index, value) (DMA_WR_ATTR(base, index, DMA_RD_ATTR(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_ATTR bitfields
 */

/*!
 * @name Register DMA_ATTR, field DSIZE[2:0] (RW)
 *
 * See the SSIZE definition
 */
/*@{*/
/*! @brief Read current value of the DMA_ATTR_DSIZE field. */
#define DMA_RD_ATTR_DSIZE(base, index) ((DMA_ATTR_REG(base, index) & DMA_ATTR_DSIZE_MASK) >> DMA_ATTR_DSIZE_SHIFT)
#define DMA_BRD_ATTR_DSIZE(base, index) (DMA_RD_ATTR_DSIZE(base, index))

/*! @brief Set the DSIZE field to a new value. */
#define DMA_WR_ATTR_DSIZE(base, index, value) (DMA_RMW_ATTR(base, index, DMA_ATTR_DSIZE_MASK, DMA_ATTR_DSIZE(value)))
#define DMA_BWR_ATTR_DSIZE(base, index, value) (DMA_WR_ATTR_DSIZE(base, index, value))
/*@}*/

/*!
 * @name Register DMA_ATTR, field DMOD[7:3] (RW)
 *
 * See the SMOD definition
 */
/*@{*/
/*! @brief Read current value of the DMA_ATTR_DMOD field. */
#define DMA_RD_ATTR_DMOD(base, index) ((DMA_ATTR_REG(base, index) & DMA_ATTR_DMOD_MASK) >> DMA_ATTR_DMOD_SHIFT)
#define DMA_BRD_ATTR_DMOD(base, index) (DMA_RD_ATTR_DMOD(base, index))

/*! @brief Set the DMOD field to a new value. */
#define DMA_WR_ATTR_DMOD(base, index, value) (DMA_RMW_ATTR(base, index, DMA_ATTR_DMOD_MASK, DMA_ATTR_DMOD(value)))
#define DMA_BWR_ATTR_DMOD(base, index, value) (DMA_WR_ATTR_DMOD(base, index, value))
/*@}*/

/*!
 * @name Register DMA_ATTR, field SSIZE[10:8] (RW)
 *
 * The attempted use of a Reserved encoding causes a configuration error.
 *
 * Values:
 * - 0b000 - 8-bit
 * - 0b001 - 16-bit
 * - 0b010 - 32-bit
 * - 0b011 - Reserved
 * - 0b100 - 16-byte
 * - 0b101 - 32-byte
 * - 0b110 - Reserved
 * - 0b111 - Reserved
 */
/*@{*/
/*! @brief Read current value of the DMA_ATTR_SSIZE field. */
#define DMA_RD_ATTR_SSIZE(base, index) ((DMA_ATTR_REG(base, index) & DMA_ATTR_SSIZE_MASK) >> DMA_ATTR_SSIZE_SHIFT)
#define DMA_BRD_ATTR_SSIZE(base, index) (DMA_RD_ATTR_SSIZE(base, index))

/*! @brief Set the SSIZE field to a new value. */
#define DMA_WR_ATTR_SSIZE(base, index, value) (DMA_RMW_ATTR(base, index, DMA_ATTR_SSIZE_MASK, DMA_ATTR_SSIZE(value)))
#define DMA_BWR_ATTR_SSIZE(base, index, value) (DMA_WR_ATTR_SSIZE(base, index, value))
/*@}*/

/*!
 * @name Register DMA_ATTR, field SMOD[15:11] (RW)
 *
 * Values:
 * - 0b00000 - Source address modulo feature is disabled
 */
/*@{*/
/*! @brief Read current value of the DMA_ATTR_SMOD field. */
#define DMA_RD_ATTR_SMOD(base, index) ((DMA_ATTR_REG(base, index) & DMA_ATTR_SMOD_MASK) >> DMA_ATTR_SMOD_SHIFT)
#define DMA_BRD_ATTR_SMOD(base, index) (DMA_RD_ATTR_SMOD(base, index))

/*! @brief Set the SMOD field to a new value. */
#define DMA_WR_ATTR_SMOD(base, index, value) (DMA_RMW_ATTR(base, index, DMA_ATTR_SMOD_MASK, DMA_ATTR_SMOD(value)))
#define DMA_BWR_ATTR_SMOD(base, index, value) (DMA_WR_ATTR_SMOD(base, index, value))
/*@}*/

/*******************************************************************************
 * DMA_NBYTES_MLOFFYES - TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled)
 ******************************************************************************/

/*!
 * @brief DMA_NBYTES_MLOFFYES - TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) (RW)
 *
 * Reset value: 0x00000000U
 *
 * One of three registers (this register, TCD_NBYTES_MLNO, or
 * TCD_NBYTES_MLOFFNO), defines the number of bytes to transfer per request. Which register to use
 * depends on whether minor loop mapping is disabled, enabled but not used for
 * this channel, or enabled and used. TCD word 2 is defined as follows if: Minor
 * loop mapping is enabled (CR[EMLM] = 1) and Minor loop offset is enabled (SMLOE
 * or DMLOE = 1) If minor loop mapping is enabled and SMLOE and DMLOE are cleared,
 * then refer to the TCD_NBYTES_MLOFFNO register description. If minor loop
 * mapping is disabled, then refer to the TCD_NBYTES_MLNO register description.
 */
/*!
 * @name Constants and macros for entire DMA_NBYTES_MLOFFYES register
 */
/*@{*/
#define DMA_RD_NBYTES_MLOFFYES(base, index) (DMA_NBYTES_MLOFFYES_REG(base, index))
#define DMA_WR_NBYTES_MLOFFYES(base, index, value) (DMA_NBYTES_MLOFFYES_REG(base, index) = (value))
#define DMA_RMW_NBYTES_MLOFFYES(base, index, mask, value) (DMA_WR_NBYTES_MLOFFYES(base, index, (DMA_RD_NBYTES_MLOFFYES(base, index) & ~(mask)) | (value)))
#define DMA_SET_NBYTES_MLOFFYES(base, index, value) (DMA_WR_NBYTES_MLOFFYES(base, index, DMA_RD_NBYTES_MLOFFYES(base, index) |  (value)))
#define DMA_CLR_NBYTES_MLOFFYES(base, index, value) (DMA_WR_NBYTES_MLOFFYES(base, index, DMA_RD_NBYTES_MLOFFYES(base, index) & ~(value)))
#define DMA_TOG_NBYTES_MLOFFYES(base, index, value) (DMA_WR_NBYTES_MLOFFYES(base, index, DMA_RD_NBYTES_MLOFFYES(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_NBYTES_MLOFFYES bitfields
 */

/*!
 * @name Register DMA_NBYTES_MLOFFYES, field NBYTES[9:0] (RW)
 *
 * Number of bytes to be transferred in each service request of the channel. As
 * a channel activates, the appropriate TCD contents load into the eDMA engine,
 * and the appropriate reads and writes perform until the minor byte transfer
 * count has transferred. This is an indivisible operation and cannot be halted.
 * (Although, it may be stalled by using the bandwidth control field, or via
 * preemption.) After the minor count is exhausted, the SADDR and DADDR values are
 * written back into the TCD memory, the major iteration count is decremented and
 * restored to the TCD memory. If the major iteration count is completed, additional
 * processing is performed.
 */
/*@{*/
/*! @brief Read current value of the DMA_NBYTES_MLOFFYES_NBYTES field. */
#define DMA_RD_NBYTES_MLOFFYES_NBYTES(base, index) ((DMA_NBYTES_MLOFFYES_REG(base, index) & DMA_NBYTES_MLOFFYES_NBYTES_MASK) >> DMA_NBYTES_MLOFFYES_NBYTES_SHIFT)
#define DMA_BRD_NBYTES_MLOFFYES_NBYTES(base, index) (DMA_RD_NBYTES_MLOFFYES_NBYTES(base, index))

/*! @brief Set the NBYTES field to a new value. */
#define DMA_WR_NBYTES_MLOFFYES_NBYTES(base, index, value) (DMA_RMW_NBYTES_MLOFFYES(base, index, DMA_NBYTES_MLOFFYES_NBYTES_MASK, DMA_NBYTES_MLOFFYES_NBYTES(value)))
#define DMA_BWR_NBYTES_MLOFFYES_NBYTES(base, index, value) (DMA_WR_NBYTES_MLOFFYES_NBYTES(base, index, value))
/*@}*/

/*!
 * @name Register DMA_NBYTES_MLOFFYES, field MLOFF[29:10] (RW)
 */
/*@{*/
/*! @brief Read current value of the DMA_NBYTES_MLOFFYES_MLOFF field. */
#define DMA_RD_NBYTES_MLOFFYES_MLOFF(base, index) ((DMA_NBYTES_MLOFFYES_REG(base, index) & DMA_NBYTES_MLOFFYES_MLOFF_MASK) >> DMA_NBYTES_MLOFFYES_MLOFF_SHIFT)
#define DMA_BRD_NBYTES_MLOFFYES_MLOFF(base, index) (DMA_RD_NBYTES_MLOFFYES_MLOFF(base, index))

/*! @brief Set the MLOFF field to a new value. */
#define DMA_WR_NBYTES_MLOFFYES_MLOFF(base, index, value) (DMA_RMW_NBYTES_MLOFFYES(base, index, DMA_NBYTES_MLOFFYES_MLOFF_MASK, DMA_NBYTES_MLOFFYES_MLOFF(value)))
#define DMA_BWR_NBYTES_MLOFFYES_MLOFF(base, index, value) (DMA_WR_NBYTES_MLOFFYES_MLOFF(base, index, value))
/*@}*/

/*!
 * @name Register DMA_NBYTES_MLOFFYES, field DMLOE[30] (RW)
 *
 * Selects whether the minor loop offset is applied to the destination address
 * upon minor loop completion.
 *
 * Values:
 * - 0b0 - The minor loop offset is not applied to the DADDR
 * - 0b1 - The minor loop offset is applied to the DADDR
 */
/*@{*/
/*! @brief Read current value of the DMA_NBYTES_MLOFFYES_DMLOE field. */
#define DMA_RD_NBYTES_MLOFFYES_DMLOE(base, index) ((DMA_NBYTES_MLOFFYES_REG(base, index) & DMA_NBYTES_MLOFFYES_DMLOE_MASK) >> DMA_NBYTES_MLOFFYES_DMLOE_SHIFT)
#define DMA_BRD_NBYTES_MLOFFYES_DMLOE(base, index) (BITBAND_ACCESS32(&DMA_NBYTES_MLOFFYES_REG(base, index), DMA_NBYTES_MLOFFYES_DMLOE_SHIFT))

/*! @brief Set the DMLOE field to a new value. */
#define DMA_WR_NBYTES_MLOFFYES_DMLOE(base, index, value) (DMA_RMW_NBYTES_MLOFFYES(base, index, DMA_NBYTES_MLOFFYES_DMLOE_MASK, DMA_NBYTES_MLOFFYES_DMLOE(value)))
#define DMA_BWR_NBYTES_MLOFFYES_DMLOE(base, index, value) (BITBAND_ACCESS32(&DMA_NBYTES_MLOFFYES_REG(base, index), DMA_NBYTES_MLOFFYES_DMLOE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_NBYTES_MLOFFYES, field SMLOE[31] (RW)
 *
 * Selects whether the minor loop offset is applied to the source address upon
 * minor loop completion.
 *
 * Values:
 * - 0b0 - The minor loop offset is not applied to the SADDR
 * - 0b1 - The minor loop offset is applied to the SADDR
 */
/*@{*/
/*! @brief Read current value of the DMA_NBYTES_MLOFFYES_SMLOE field. */
#define DMA_RD_NBYTES_MLOFFYES_SMLOE(base, index) ((DMA_NBYTES_MLOFFYES_REG(base, index) & DMA_NBYTES_MLOFFYES_SMLOE_MASK) >> DMA_NBYTES_MLOFFYES_SMLOE_SHIFT)
#define DMA_BRD_NBYTES_MLOFFYES_SMLOE(base, index) (BITBAND_ACCESS32(&DMA_NBYTES_MLOFFYES_REG(base, index), DMA_NBYTES_MLOFFYES_SMLOE_SHIFT))

/*! @brief Set the SMLOE field to a new value. */
#define DMA_WR_NBYTES_MLOFFYES_SMLOE(base, index, value) (DMA_RMW_NBYTES_MLOFFYES(base, index, DMA_NBYTES_MLOFFYES_SMLOE_MASK, DMA_NBYTES_MLOFFYES_SMLOE(value)))
#define DMA_BWR_NBYTES_MLOFFYES_SMLOE(base, index, value) (BITBAND_ACCESS32(&DMA_NBYTES_MLOFFYES_REG(base, index), DMA_NBYTES_MLOFFYES_SMLOE_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_NBYTES_MLNO - TCD Minor Byte Count (Minor Loop Disabled)
 ******************************************************************************/

/*!
 * @brief DMA_NBYTES_MLNO - TCD Minor Byte Count (Minor Loop Disabled) (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register, or one of the next two registers (TCD_NBYTES_MLOFFNO,
 * TCD_NBYTES_MLOFFYES), defines the number of bytes to transfer per request. Which
 * register to use depends on whether minor loop mapping is disabled, enabled but not
 * used for this channel, or enabled and used. TCD word 2 is defined as follows
 * if: Minor loop mapping is disabled (CR[EMLM] = 0) If minor loop mapping is
 * enabled, see the TCD_NBYTES_MLOFFNO and TCD_NBYTES_MLOFFYES register descriptions
 * for TCD word 2's definition.
 */
/*!
 * @name Constants and macros for entire DMA_NBYTES_MLNO register
 */
/*@{*/
#define DMA_RD_NBYTES_MLNO(base, index) (DMA_NBYTES_MLNO_REG(base, index))
#define DMA_WR_NBYTES_MLNO(base, index, value) (DMA_NBYTES_MLNO_REG(base, index) = (value))
#define DMA_RMW_NBYTES_MLNO(base, index, mask, value) (DMA_WR_NBYTES_MLNO(base, index, (DMA_RD_NBYTES_MLNO(base, index) & ~(mask)) | (value)))
#define DMA_SET_NBYTES_MLNO(base, index, value) (DMA_WR_NBYTES_MLNO(base, index, DMA_RD_NBYTES_MLNO(base, index) |  (value)))
#define DMA_CLR_NBYTES_MLNO(base, index, value) (DMA_WR_NBYTES_MLNO(base, index, DMA_RD_NBYTES_MLNO(base, index) & ~(value)))
#define DMA_TOG_NBYTES_MLNO(base, index, value) (DMA_WR_NBYTES_MLNO(base, index, DMA_RD_NBYTES_MLNO(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * DMA_NBYTES_MLOFFNO - TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled)
 ******************************************************************************/

/*!
 * @brief DMA_NBYTES_MLOFFNO - TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) (RW)
 *
 * Reset value: 0x00000000U
 *
 * One of three registers (this register, TCD_NBYTES_MLNO, or
 * TCD_NBYTES_MLOFFYES), defines the number of bytes to transfer per request. Which register to use
 * depends on whether minor loop mapping is disabled, enabled but not used for
 * this channel, or enabled and used. TCD word 2 is defined as follows if: Minor
 * loop mapping is enabled (CR[EMLM] = 1) and SMLOE = 0 and DMLOE = 0 If minor
 * loop mapping is enabled and SMLOE or DMLOE is set, then refer to the
 * TCD_NBYTES_MLOFFYES register description. If minor loop mapping is disabled, then refer to
 * the TCD_NBYTES_MLNO register description.
 */
/*!
 * @name Constants and macros for entire DMA_NBYTES_MLOFFNO register
 */
/*@{*/
#define DMA_RD_NBYTES_MLOFFNO(base, index) (DMA_NBYTES_MLOFFNO_REG(base, index))
#define DMA_WR_NBYTES_MLOFFNO(base, index, value) (DMA_NBYTES_MLOFFNO_REG(base, index) = (value))
#define DMA_RMW_NBYTES_MLOFFNO(base, index, mask, value) (DMA_WR_NBYTES_MLOFFNO(base, index, (DMA_RD_NBYTES_MLOFFNO(base, index) & ~(mask)) | (value)))
#define DMA_SET_NBYTES_MLOFFNO(base, index, value) (DMA_WR_NBYTES_MLOFFNO(base, index, DMA_RD_NBYTES_MLOFFNO(base, index) |  (value)))
#define DMA_CLR_NBYTES_MLOFFNO(base, index, value) (DMA_WR_NBYTES_MLOFFNO(base, index, DMA_RD_NBYTES_MLOFFNO(base, index) & ~(value)))
#define DMA_TOG_NBYTES_MLOFFNO(base, index, value) (DMA_WR_NBYTES_MLOFFNO(base, index, DMA_RD_NBYTES_MLOFFNO(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_NBYTES_MLOFFNO bitfields
 */

/*!
 * @name Register DMA_NBYTES_MLOFFNO, field NBYTES[29:0] (RW)
 *
 * Number of bytes to be transferred in each service request of the channel. As
 * a channel activates, the appropriate TCD contents load into the eDMA engine,
 * and the appropriate reads and writes perform until the minor byte transfer
 * count has transferred. This is an indivisible operation and cannot be halted;
 * although, it may be stalled by using the bandwidth control field, or via
 * preemption. After the minor count is exhausted, the SADDR and DADDR values are written
 * back into the TCD memory, the major iteration count is decremented and
 * restored to the TCD memory. If the major iteration count is completed, additional
 * processing is performed.
 */
/*@{*/
/*! @brief Read current value of the DMA_NBYTES_MLOFFNO_NBYTES field. */
#define DMA_RD_NBYTES_MLOFFNO_NBYTES(base, index) ((DMA_NBYTES_MLOFFNO_REG(base, index) & DMA_NBYTES_MLOFFNO_NBYTES_MASK) >> DMA_NBYTES_MLOFFNO_NBYTES_SHIFT)
#define DMA_BRD_NBYTES_MLOFFNO_NBYTES(base, index) (DMA_RD_NBYTES_MLOFFNO_NBYTES(base, index))

/*! @brief Set the NBYTES field to a new value. */
#define DMA_WR_NBYTES_MLOFFNO_NBYTES(base, index, value) (DMA_RMW_NBYTES_MLOFFNO(base, index, DMA_NBYTES_MLOFFNO_NBYTES_MASK, DMA_NBYTES_MLOFFNO_NBYTES(value)))
#define DMA_BWR_NBYTES_MLOFFNO_NBYTES(base, index, value) (DMA_WR_NBYTES_MLOFFNO_NBYTES(base, index, value))
/*@}*/

/*!
 * @name Register DMA_NBYTES_MLOFFNO, field DMLOE[30] (RW)
 *
 * Selects whether the minor loop offset is applied to the destination address
 * upon minor loop completion.
 *
 * Values:
 * - 0b0 - The minor loop offset is not applied to the DADDR
 * - 0b1 - The minor loop offset is applied to the DADDR
 */
/*@{*/
/*! @brief Read current value of the DMA_NBYTES_MLOFFNO_DMLOE field. */
#define DMA_RD_NBYTES_MLOFFNO_DMLOE(base, index) ((DMA_NBYTES_MLOFFNO_REG(base, index) & DMA_NBYTES_MLOFFNO_DMLOE_MASK) >> DMA_NBYTES_MLOFFNO_DMLOE_SHIFT)
#define DMA_BRD_NBYTES_MLOFFNO_DMLOE(base, index) (BITBAND_ACCESS32(&DMA_NBYTES_MLOFFNO_REG(base, index), DMA_NBYTES_MLOFFNO_DMLOE_SHIFT))

/*! @brief Set the DMLOE field to a new value. */
#define DMA_WR_NBYTES_MLOFFNO_DMLOE(base, index, value) (DMA_RMW_NBYTES_MLOFFNO(base, index, DMA_NBYTES_MLOFFNO_DMLOE_MASK, DMA_NBYTES_MLOFFNO_DMLOE(value)))
#define DMA_BWR_NBYTES_MLOFFNO_DMLOE(base, index, value) (BITBAND_ACCESS32(&DMA_NBYTES_MLOFFNO_REG(base, index), DMA_NBYTES_MLOFFNO_DMLOE_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_NBYTES_MLOFFNO, field SMLOE[31] (RW)
 *
 * Selects whether the minor loop offset is applied to the source address upon
 * minor loop completion.
 *
 * Values:
 * - 0b0 - The minor loop offset is not applied to the SADDR
 * - 0b1 - The minor loop offset is applied to the SADDR
 */
/*@{*/
/*! @brief Read current value of the DMA_NBYTES_MLOFFNO_SMLOE field. */
#define DMA_RD_NBYTES_MLOFFNO_SMLOE(base, index) ((DMA_NBYTES_MLOFFNO_REG(base, index) & DMA_NBYTES_MLOFFNO_SMLOE_MASK) >> DMA_NBYTES_MLOFFNO_SMLOE_SHIFT)
#define DMA_BRD_NBYTES_MLOFFNO_SMLOE(base, index) (BITBAND_ACCESS32(&DMA_NBYTES_MLOFFNO_REG(base, index), DMA_NBYTES_MLOFFNO_SMLOE_SHIFT))

/*! @brief Set the SMLOE field to a new value. */
#define DMA_WR_NBYTES_MLOFFNO_SMLOE(base, index, value) (DMA_RMW_NBYTES_MLOFFNO(base, index, DMA_NBYTES_MLOFFNO_SMLOE_MASK, DMA_NBYTES_MLOFFNO_SMLOE(value)))
#define DMA_BWR_NBYTES_MLOFFNO_SMLOE(base, index, value) (BITBAND_ACCESS32(&DMA_NBYTES_MLOFFNO_REG(base, index), DMA_NBYTES_MLOFFNO_SMLOE_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_SLAST - TCD Last Source Address Adjustment
 ******************************************************************************/

/*!
 * @brief DMA_SLAST - TCD Last Source Address Adjustment (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire DMA_SLAST register
 */
/*@{*/
#define DMA_RD_SLAST(base, index) (DMA_SLAST_REG(base, index))
#define DMA_WR_SLAST(base, index, value) (DMA_SLAST_REG(base, index) = (value))
#define DMA_RMW_SLAST(base, index, mask, value) (DMA_WR_SLAST(base, index, (DMA_RD_SLAST(base, index) & ~(mask)) | (value)))
#define DMA_SET_SLAST(base, index, value) (DMA_WR_SLAST(base, index, DMA_RD_SLAST(base, index) |  (value)))
#define DMA_CLR_SLAST(base, index, value) (DMA_WR_SLAST(base, index, DMA_RD_SLAST(base, index) & ~(value)))
#define DMA_TOG_SLAST(base, index, value) (DMA_WR_SLAST(base, index, DMA_RD_SLAST(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * DMA_DADDR - TCD Destination Address
 ******************************************************************************/

/*!
 * @brief DMA_DADDR - TCD Destination Address (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire DMA_DADDR register
 */
/*@{*/
#define DMA_RD_DADDR(base, index) (DMA_DADDR_REG(base, index))
#define DMA_WR_DADDR(base, index, value) (DMA_DADDR_REG(base, index) = (value))
#define DMA_RMW_DADDR(base, index, mask, value) (DMA_WR_DADDR(base, index, (DMA_RD_DADDR(base, index) & ~(mask)) | (value)))
#define DMA_SET_DADDR(base, index, value) (DMA_WR_DADDR(base, index, DMA_RD_DADDR(base, index) |  (value)))
#define DMA_CLR_DADDR(base, index, value) (DMA_WR_DADDR(base, index, DMA_RD_DADDR(base, index) & ~(value)))
#define DMA_TOG_DADDR(base, index, value) (DMA_WR_DADDR(base, index, DMA_RD_DADDR(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * DMA_DOFF - TCD Signed Destination Address Offset
 ******************************************************************************/

/*!
 * @brief DMA_DOFF - TCD Signed Destination Address Offset (RW)
 *
 * Reset value: 0x0000U
 */
/*!
 * @name Constants and macros for entire DMA_DOFF register
 */
/*@{*/
#define DMA_RD_DOFF(base, index) (DMA_DOFF_REG(base, index))
#define DMA_WR_DOFF(base, index, value) (DMA_DOFF_REG(base, index) = (value))
#define DMA_RMW_DOFF(base, index, mask, value) (DMA_WR_DOFF(base, index, (DMA_RD_DOFF(base, index) & ~(mask)) | (value)))
#define DMA_SET_DOFF(base, index, value) (DMA_WR_DOFF(base, index, DMA_RD_DOFF(base, index) |  (value)))
#define DMA_CLR_DOFF(base, index, value) (DMA_WR_DOFF(base, index, DMA_RD_DOFF(base, index) & ~(value)))
#define DMA_TOG_DOFF(base, index, value) (DMA_WR_DOFF(base, index, DMA_RD_DOFF(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * DMA_CITER_ELINKNO - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
 ******************************************************************************/

/*!
 * @brief DMA_CITER_ELINKNO - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) (RW)
 *
 * Reset value: 0x0000U
 *
 * If TCDn_CITER[ELINK] is cleared, the TCDn_CITER register is defined as
 * follows.
 */
/*!
 * @name Constants and macros for entire DMA_CITER_ELINKNO register
 */
/*@{*/
#define DMA_RD_CITER_ELINKNO(base, index) (DMA_CITER_ELINKNO_REG(base, index))
#define DMA_WR_CITER_ELINKNO(base, index, value) (DMA_CITER_ELINKNO_REG(base, index) = (value))
#define DMA_RMW_CITER_ELINKNO(base, index, mask, value) (DMA_WR_CITER_ELINKNO(base, index, (DMA_RD_CITER_ELINKNO(base, index) & ~(mask)) | (value)))
#define DMA_SET_CITER_ELINKNO(base, index, value) (DMA_WR_CITER_ELINKNO(base, index, DMA_RD_CITER_ELINKNO(base, index) |  (value)))
#define DMA_CLR_CITER_ELINKNO(base, index, value) (DMA_WR_CITER_ELINKNO(base, index, DMA_RD_CITER_ELINKNO(base, index) & ~(value)))
#define DMA_TOG_CITER_ELINKNO(base, index, value) (DMA_WR_CITER_ELINKNO(base, index, DMA_RD_CITER_ELINKNO(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CITER_ELINKNO bitfields
 */

/*!
 * @name Register DMA_CITER_ELINKNO, field CITER[14:0] (RW)
 *
 * This 9-bit (ELINK = 1) or 15-bit (ELINK = 0) count represents the current
 * major loop count for the channel. It is decremented each time the minor loop is
 * completed and updated in the transfer control descriptor memory. After the
 * major iteration count is exhausted, the channel performs a number of operations
 * (e.g., final source and destination address calculations), optionally generating
 * an interrupt to signal channel completion before reloading the CITER field
 * from the beginning iteration count (BITER) field. When the CITER field is
 * initially loaded by software, it must be set to the same value as that contained in
 * the BITER field. If the channel is configured to execute a single service
 * request, the initial values of BITER and CITER should be 0x0001.
 */
/*@{*/
/*! @brief Read current value of the DMA_CITER_ELINKNO_CITER field. */
#define DMA_RD_CITER_ELINKNO_CITER(base, index) ((DMA_CITER_ELINKNO_REG(base, index) & DMA_CITER_ELINKNO_CITER_MASK) >> DMA_CITER_ELINKNO_CITER_SHIFT)
#define DMA_BRD_CITER_ELINKNO_CITER(base, index) (DMA_RD_CITER_ELINKNO_CITER(base, index))

/*! @brief Set the CITER field to a new value. */
#define DMA_WR_CITER_ELINKNO_CITER(base, index, value) (DMA_RMW_CITER_ELINKNO(base, index, DMA_CITER_ELINKNO_CITER_MASK, DMA_CITER_ELINKNO_CITER(value)))
#define DMA_BWR_CITER_ELINKNO_CITER(base, index, value) (DMA_WR_CITER_ELINKNO_CITER(base, index, value))
/*@}*/

/*!
 * @name Register DMA_CITER_ELINKNO, field ELINK[15] (RW)
 *
 * As the channel completes the minor loop, this flag enables linking to another
 * channel, defined by the LINKCH field. The link target channel initiates a
 * channel service request via an internal mechanism that sets the TCDn_CSR[START]
 * bit of the specified channel. If channel linking is disabled, the CITER value
 * is extended to 15 bits in place of a link channel number. If the major loop is
 * exhausted, this link mechanism is suppressed in favor of the MAJORELINK
 * channel linking. This bit must be equal to the BITER[ELINK] bit; otherwise, a
 * configuration error is reported.
 *
 * Values:
 * - 0b0 - The channel-to-channel linking is disabled
 * - 0b1 - The channel-to-channel linking is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_CITER_ELINKNO_ELINK field. */
#define DMA_RD_CITER_ELINKNO_ELINK(base, index) ((DMA_CITER_ELINKNO_REG(base, index) & DMA_CITER_ELINKNO_ELINK_MASK) >> DMA_CITER_ELINKNO_ELINK_SHIFT)
#define DMA_BRD_CITER_ELINKNO_ELINK(base, index) (BITBAND_ACCESS16(&DMA_CITER_ELINKNO_REG(base, index), DMA_CITER_ELINKNO_ELINK_SHIFT))

/*! @brief Set the ELINK field to a new value. */
#define DMA_WR_CITER_ELINKNO_ELINK(base, index, value) (DMA_RMW_CITER_ELINKNO(base, index, DMA_CITER_ELINKNO_ELINK_MASK, DMA_CITER_ELINKNO_ELINK(value)))
#define DMA_BWR_CITER_ELINKNO_ELINK(base, index, value) (BITBAND_ACCESS16(&DMA_CITER_ELINKNO_REG(base, index), DMA_CITER_ELINKNO_ELINK_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_CITER_ELINKYES - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled)
 ******************************************************************************/

/*!
 * @brief DMA_CITER_ELINKYES - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) (RW)
 *
 * Reset value: 0x0000U
 *
 * If TCDn_CITER[ELINK] is set, the TCDn_CITER register is defined as follows.
 */
/*!
 * @name Constants and macros for entire DMA_CITER_ELINKYES register
 */
/*@{*/
#define DMA_RD_CITER_ELINKYES(base, index) (DMA_CITER_ELINKYES_REG(base, index))
#define DMA_WR_CITER_ELINKYES(base, index, value) (DMA_CITER_ELINKYES_REG(base, index) = (value))
#define DMA_RMW_CITER_ELINKYES(base, index, mask, value) (DMA_WR_CITER_ELINKYES(base, index, (DMA_RD_CITER_ELINKYES(base, index) & ~(mask)) | (value)))
#define DMA_SET_CITER_ELINKYES(base, index, value) (DMA_WR_CITER_ELINKYES(base, index, DMA_RD_CITER_ELINKYES(base, index) |  (value)))
#define DMA_CLR_CITER_ELINKYES(base, index, value) (DMA_WR_CITER_ELINKYES(base, index, DMA_RD_CITER_ELINKYES(base, index) & ~(value)))
#define DMA_TOG_CITER_ELINKYES(base, index, value) (DMA_WR_CITER_ELINKYES(base, index, DMA_RD_CITER_ELINKYES(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CITER_ELINKYES bitfields
 */

/*!
 * @name Register DMA_CITER_ELINKYES, field CITER[8:0] (RW)
 *
 * This 9-bit (ELINK = 1) or 15-bit (ELINK = 0) count represents the current
 * major loop count for the channel. It is decremented each time the minor loop is
 * completed and updated in the transfer control descriptor memory. After the
 * major iteration count is exhausted, the channel performs a number of operations
 * (e.g., final source and destination address calculations), optionally generating
 * an interrupt to signal channel completion before reloading the CITER field
 * from the beginning iteration count (BITER) field. When the CITER field is
 * initially loaded by software, it must be set to the same value as that contained in
 * the BITER field. If the channel is configured to execute a single service
 * request, the initial values of BITER and CITER should be 0x0001.
 */
/*@{*/
/*! @brief Read current value of the DMA_CITER_ELINKYES_CITER field. */
#define DMA_RD_CITER_ELINKYES_CITER(base, index) ((DMA_CITER_ELINKYES_REG(base, index) & DMA_CITER_ELINKYES_CITER_MASK) >> DMA_CITER_ELINKYES_CITER_SHIFT)
#define DMA_BRD_CITER_ELINKYES_CITER(base, index) (DMA_RD_CITER_ELINKYES_CITER(base, index))

/*! @brief Set the CITER field to a new value. */
#define DMA_WR_CITER_ELINKYES_CITER(base, index, value) (DMA_RMW_CITER_ELINKYES(base, index, DMA_CITER_ELINKYES_CITER_MASK, DMA_CITER_ELINKYES_CITER(value)))
#define DMA_BWR_CITER_ELINKYES_CITER(base, index, value) (DMA_WR_CITER_ELINKYES_CITER(base, index, value))
/*@}*/

/*!
 * @name Register DMA_CITER_ELINKYES, field LINKCH[12:9] (RW)
 *
 * If channel-to-channel linking is enabled (ELINK = 1), then after the minor
 * loop is exhausted, the eDMA engine initiates a channel service request to the
 * channel defined by these four bits by setting that channel's TCDn_CSR[START] bit.
 */
/*@{*/
/*! @brief Read current value of the DMA_CITER_ELINKYES_LINKCH field. */
#define DMA_RD_CITER_ELINKYES_LINKCH(base, index) ((DMA_CITER_ELINKYES_REG(base, index) & DMA_CITER_ELINKYES_LINKCH_MASK) >> DMA_CITER_ELINKYES_LINKCH_SHIFT)
#define DMA_BRD_CITER_ELINKYES_LINKCH(base, index) (DMA_RD_CITER_ELINKYES_LINKCH(base, index))

/*! @brief Set the LINKCH field to a new value. */
#define DMA_WR_CITER_ELINKYES_LINKCH(base, index, value) (DMA_RMW_CITER_ELINKYES(base, index, DMA_CITER_ELINKYES_LINKCH_MASK, DMA_CITER_ELINKYES_LINKCH(value)))
#define DMA_BWR_CITER_ELINKYES_LINKCH(base, index, value) (DMA_WR_CITER_ELINKYES_LINKCH(base, index, value))
/*@}*/

/*!
 * @name Register DMA_CITER_ELINKYES, field ELINK[15] (RW)
 *
 * As the channel completes the minor loop, this flag enables linking to another
 * channel, defined by the LINKCH field. The link target channel initiates a
 * channel service request via an internal mechanism that sets the TCDn_CSR[START]
 * bit of the specified channel. If channel linking is disabled, the CITER value
 * is extended to 15 bits in place of a link channel number. If the major loop is
 * exhausted, this link mechanism is suppressed in favor of the MAJORELINK
 * channel linking. This bit must be equal to the BITER[ELINK] bit; otherwise, a
 * configuration error is reported.
 *
 * Values:
 * - 0b0 - The channel-to-channel linking is disabled
 * - 0b1 - The channel-to-channel linking is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_CITER_ELINKYES_ELINK field. */
#define DMA_RD_CITER_ELINKYES_ELINK(base, index) ((DMA_CITER_ELINKYES_REG(base, index) & DMA_CITER_ELINKYES_ELINK_MASK) >> DMA_CITER_ELINKYES_ELINK_SHIFT)
#define DMA_BRD_CITER_ELINKYES_ELINK(base, index) (BITBAND_ACCESS16(&DMA_CITER_ELINKYES_REG(base, index), DMA_CITER_ELINKYES_ELINK_SHIFT))

/*! @brief Set the ELINK field to a new value. */
#define DMA_WR_CITER_ELINKYES_ELINK(base, index, value) (DMA_RMW_CITER_ELINKYES(base, index, DMA_CITER_ELINKYES_ELINK_MASK, DMA_CITER_ELINKYES_ELINK(value)))
#define DMA_BWR_CITER_ELINKYES_ELINK(base, index, value) (BITBAND_ACCESS16(&DMA_CITER_ELINKYES_REG(base, index), DMA_CITER_ELINKYES_ELINK_SHIFT) = (value))
/*@}*/

/*******************************************************************************
 * DMA_DLAST_SGA - TCD Last Destination Address Adjustment/Scatter Gather Address
 ******************************************************************************/

/*!
 * @brief DMA_DLAST_SGA - TCD Last Destination Address Adjustment/Scatter Gather Address (RW)
 *
 * Reset value: 0x00000000U
 */
/*!
 * @name Constants and macros for entire DMA_DLAST_SGA register
 */
/*@{*/
#define DMA_RD_DLAST_SGA(base, index) (DMA_DLAST_SGA_REG(base, index))
#define DMA_WR_DLAST_SGA(base, index, value) (DMA_DLAST_SGA_REG(base, index) = (value))
#define DMA_RMW_DLAST_SGA(base, index, mask, value) (DMA_WR_DLAST_SGA(base, index, (DMA_RD_DLAST_SGA(base, index) & ~(mask)) | (value)))
#define DMA_SET_DLAST_SGA(base, index, value) (DMA_WR_DLAST_SGA(base, index, DMA_RD_DLAST_SGA(base, index) |  (value)))
#define DMA_CLR_DLAST_SGA(base, index, value) (DMA_WR_DLAST_SGA(base, index, DMA_RD_DLAST_SGA(base, index) & ~(value)))
#define DMA_TOG_DLAST_SGA(base, index, value) (DMA_WR_DLAST_SGA(base, index, DMA_RD_DLAST_SGA(base, index) ^  (value)))
/*@}*/

/*******************************************************************************
 * DMA_CSR - TCD Control and Status
 ******************************************************************************/

/*!
 * @brief DMA_CSR - TCD Control and Status (RW)
 *
 * Reset value: 0x0000U
 */
/*!
 * @name Constants and macros for entire DMA_CSR register
 */
/*@{*/
#define DMA_RD_CSR(base, index)  (DMA_CSR_REG(base, index))
#define DMA_WR_CSR(base, index, value) (DMA_CSR_REG(base, index) = (value))
#define DMA_RMW_CSR(base, index, mask, value) (DMA_WR_CSR(base, index, (DMA_RD_CSR(base, index) & ~(mask)) | (value)))
#define DMA_SET_CSR(base, index, value) (DMA_WR_CSR(base, index, DMA_RD_CSR(base, index) |  (value)))
#define DMA_CLR_CSR(base, index, value) (DMA_WR_CSR(base, index, DMA_RD_CSR(base, index) & ~(value)))
#define DMA_TOG_CSR(base, index, value) (DMA_WR_CSR(base, index, DMA_RD_CSR(base, index) ^  (value)))
/*@}*/

/*
 * Constants & macros for individual DMA_CSR bitfields
 */

/*!
 * @name Register DMA_CSR, field START[0] (RW)
 *
 * If this flag is set, the channel is requesting service. The eDMA hardware
 * automatically clears this flag after the channel begins execution.
 *
 * Values:
 * - 0b0 - The channel is not explicitly started
 * - 0b1 - The channel is explicitly started via a software initiated service
 *     request
 */
/*@{*/
/*! @brief Read current value of the DMA_CSR_START field. */
#define DMA_RD_CSR_START(base, index) ((DMA_CSR_REG(base, index) & DMA_CSR_START_MASK) >> DMA_CSR_START_SHIFT)
#define DMA_BRD_CSR_START(base, index) (BITBAND_ACCESS16(&DMA_CSR_REG(base, index), DMA_CSR_START_SHIFT))

/*! @brief Set the START field to a new value. */
#define DMA_WR_CSR_START(base, index, value) (DMA_RMW_CSR(base, index, DMA_CSR_START_MASK, DMA_CSR_START(value)))
#define DMA_BWR_CSR_START(base, index, value) (BITBAND_ACCESS16(&DMA_CSR_REG(base, index), DMA_CSR_START_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CSR, field INTMAJOR[1] (RW)
 *
 * If this flag is set, the channel generates an interrupt request by setting
 * the appropriate bit in the INT when the current major iteration count reaches
 * zero.
 *
 * Values:
 * - 0b0 - The end-of-major loop interrupt is disabled
 * - 0b1 - The end-of-major loop interrupt is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_CSR_INTMAJOR field. */
#define DMA_RD_CSR_INTMAJOR(base, index) ((DMA_CSR_REG(base, index) & DMA_CSR_INTMAJOR_MASK) >> DMA_CSR_INTMAJOR_SHIFT)
#define DMA_BRD_CSR_INTMAJOR(base, index) (BITBAND_ACCESS16(&DMA_CSR_REG(base, index), DMA_CSR_INTMAJOR_SHIFT))

/*! @brief Set the INTMAJOR field to a new value. */
#define DMA_WR_CSR_INTMAJOR(base, index, value) (DMA_RMW_CSR(base, index, DMA_CSR_INTMAJOR_MASK, DMA_CSR_INTMAJOR(value)))
#define DMA_BWR_CSR_INTMAJOR(base, index, value) (BITBAND_ACCESS16(&DMA_CSR_REG(base, index), DMA_CSR_INTMAJOR_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CSR, field INTHALF[2] (RW)
 *
 * If this flag is set, the channel generates an interrupt request by setting
 * the appropriate bit in the INT register when the current major iteration count
 * reaches the halfway point. Specifically, the comparison performed by the eDMA
 * engine is (CITER == (BITER >> 1)). This halfway point interrupt request is
 * provided to support double-buffered (aka ping-pong) schemes or other types of data
 * movement where the processor needs an early indication of the transfer's
 * progress. If BITER is set, do not use INTHALF. Use INTMAJOR instead.
 *
 * Values:
 * - 0b0 - The half-point interrupt is disabled
 * - 0b1 - The half-point interrupt is enabled
 */
/*@{*/
/*! @brief Read current value of the DMA_CSR_INTHALF field. */
#define DMA_RD_CSR_INTHALF(base, index) ((DMA_CSR_REG(base, index) & DMA_CSR_INTHALF_MASK) >> DMA_CSR_INTHALF_SHIFT)
#define DMA_BRD_CSR_INTHALF(base, index) (BITBAND_ACCESS16(&DMA_CSR_REG(base, index), DMA_CSR_INTHALF_SHIFT))

/*! @brief Set the INTHALF field to a new value. */
#define DMA_WR_CSR_INTHALF(base, index, value) (DMA_RMW_CSR(base, index, DMA_CSR_INTHALF_MASK, DMA_CSR_INTHALF(value)))
#define DMA_BWR_CSR_INTHALF(base, index, value) (BITBAND_ACCESS16(&DMA_CSR_REG(base, index), DMA_CSR_INTHALF_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CSR, field DREQ[3] (RW)
 *
 * If this flag is set, the eDMA hardware automatically clears the corresponding
 * ERQ bit when the current major iteration count reaches zero.
 *
 * Values:
 * - 0b0 - The channel's ERQ bit is not affected
 * - 0b1 - The channel's ERQ bit is cleared when the major loop is complete
 */
/*@{*/
/*! @brief Read current value of the DMA_CSR_DREQ field. */
#define DMA_RD_CSR_DREQ(base, index) ((DMA_CSR_REG(base, index) & DMA_CSR_DREQ_MASK) >> DMA_CSR_DREQ_SHIFT)
#define DMA_BRD_CSR_DREQ(base, index) (BITBAND_ACCESS16(&DMA_CSR_REG(base, index), DMA_CSR_DREQ_SHIFT))

/*! @brief Set the DREQ field to a new value. */
#define DMA_WR_CSR_DREQ(base, index, value) (DMA_RMW_CSR(base, index, DMA_CSR_DREQ_MASK, DMA_CSR_DREQ(value)))
#define DMA_BWR_CSR_DREQ(base, index, value) (BITBAND_ACCESS16(&DMA_CSR_REG(base, index), DMA_CSR_DREQ_SHIFT) = (value))
/*@}*/

/*!
 * @name Register DMA_CSR, field ESG[4] (RW)
 *
 * As the channel completes the major loop, this flag enables scatter/gather
 * processing in the current channel. If enabled, the eDMA engine uses DLASTSGA as a
 * memory pointer to a 0-modulo-32 address containing a 32-byte data structure
 * loaded as the transfer control descriptor into the local memory. To support the
 * dynamic scatter/gather coherency model, this field is forced to zero when
 * written to while the TCDn_CSR[DONE] bit is set.
 *
 * Values:
 * - 0b0 - The current channel's TCD is normal format.
 * - 0b1 - The current channel's TCD specifies a scatter gather format. The
 *     DLASTSGA field provides a memory pointer to the next TCD to be loaded into
 *     this channel after the major loop completes its execution.
 */
/*@{*/
/*! @brief Read current value of the DMA_CSR_E